/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.billingclient.api;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.yy.hiyo.billingclient.api.BillingClientImpl;
import com.yy.hiyo.billingclient.api.BillingClientStateListener;
import com.yy.hiyo.billingclient.api.BillingFlowParams;
import com.yy.hiyo.billingclient.api.ConsumeResponseListener;
import com.yy.hiyo.billingclient.api.Purchase;
import com.yy.hiyo.billingclient.api.PurchaseHistoryResponseListener;
import com.yy.hiyo.billingclient.api.PurchasesUpdatedListener;
import com.yy.hiyo.billingclient.api.SkuDetailsParams;
import com.yy.hiyo.billingclient.api.SkuDetailsResponseListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class BillingClient {
    @UiThread
    public static Builder newBuilder(@NonNull Context context) {
        return new Builder(context);
    }

    @UiThread
    public abstract int isFeatureSupported(String var1);

    @UiThread
    public abstract boolean isReady();

    @UiThread
    public abstract void startConnection(@NonNull BillingClientStateListener var1);

    @UiThread
    public abstract void endConnection();

    @UiThread
    public abstract int launchBillingFlow(Activity var1, BillingFlowParams var2, String var3);

    @UiThread
    public abstract Purchase.PurchasesResult queryPurchases(String var1);

    @UiThread
    public abstract void querySkuDetailsAsync(SkuDetailsParams var1, SkuDetailsResponseListener var2);

    @UiThread
    public abstract void consumeAsync(String var1, ConsumeResponseListener var2);

    @UiThread
    public abstract void queryPurchaseHistoryAsync(String var1, PurchaseHistoryResponseListener var2);

    public static final class Builder {
        private final Context mContext;
        private PurchasesUpdatedListener mListener;

        private Builder(Context context) {
            this.mContext = context;
        }

        @UiThread
        public Builder setListener(PurchasesUpdatedListener listener) {
            this.mListener = listener;
            return this;
        }

        @UiThread
        public BillingClient build() {
            if (this.mContext == null) {
                throw new IllegalArgumentException("Please provide a valid Context.");
            }
            if (this.mListener == null) {
                throw new IllegalArgumentException("Please provide a valid listener for purchases updates.");
            }
            return new BillingClientImpl(this.mContext, this.mListener);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponse {
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int OK = 0;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
        public static final int GP_SERVICE_UNAVAILABLE = 301;
        public static final int ERROR_RESULT_FROM_LOCAL_BRO = 601;
        public static final int ERROR_QUERY_DETAIL_WITHOUT_LIST = 602;
        public static final int ERROR_DECODE_DETAIL_JSON_EXCEPTION = 603;
        public static final int ERROR_PURCHASE_RETURN_NULL = 604;
        public static final int ERROR_PURCHASE_RETURN_WITHOUT_FIELDS = 605;
        public static final int ERROR_PURCHASE_RETURN_NULL_SKUS = 606;
        public static final int ERROR_PURCHASE_RETURN_NULL_DATA = 607;
        public static final int ERROR_PURCHASE_RETURN_NULL_SIGN = 608;
        public static final int ERROR_PURCHASE_DECODE_EXCEPTION = 609;
        public static final int ERROR_INTENT_NULL = 610;
        public static final int ERROR_BUNDLE_NULL = 611;
        public static final int ERROR_BUNDLE_TYPE = 612;
        public static final int ERROR_START_PURCHASE = 613;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        public static final String SUBSCRIPTIONS = "subscriptions";
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        public static final String IN_APP_ITEMS_ON_VR = "inAppItemsOnVr";
        public static final String SUBSCRIPTIONS_ON_VR = "subscriptionsOnVr";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SkuType {
        public static final String INAPP = "inapp";
        public static final String SUBS = "subs";
    }
}

