/*
 * Decompiled with CFR 0.152.
 */
package com.hago.billingclient.api;

import android.os.Bundle;
import com.hago.billingclient.api.BillingResult;
import com.hago.billingclient.api.BillingResults;
import com.hago.billingclient.api.util.BillingHelper;
import java.util.ArrayList;

final class PurchaseApiResponseChecker {
    PurchaseApiResponseChecker() {
    }

    static BillingResult checkPurchasesBundleValidity(Bundle bundle, String logTag, String methodName) {
        BillingResult internalErrorResult = BillingResults.INTERNAL_ERROR;
        if (bundle == null) {
            BillingHelper.logWarn(logTag, String.format("%s got null owned items list", methodName));
            return internalErrorResult;
        }
        int responseCode = BillingHelper.getResponseCodeFromBundle(bundle, logTag);
        String debugMessage = BillingHelper.getDebugMessageFromBundle(bundle, logTag);
        BillingResult billingResult = BillingResult.newBuilder().setResponseCode(responseCode).setDebugMessage(debugMessage).build();
        if (responseCode != 0) {
            BillingHelper.logWarn(logTag, String.format("%s failed. Response code: %s", methodName, responseCode));
            return billingResult;
        }
        if (!(bundle.containsKey("INAPP_PURCHASE_ITEM_LIST") && bundle.containsKey("INAPP_PURCHASE_DATA_LIST") && bundle.containsKey("INAPP_DATA_SIGNATURE_LIST"))) {
            BillingHelper.logWarn(logTag, String.format("Bundle returned from %s doesn't contain required fields.", methodName));
            return internalErrorResult;
        }
        ArrayList ownedSkus = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
        ArrayList purchaseDataList = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
        ArrayList signatureList = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
        if (ownedSkus == null) {
            BillingHelper.logWarn(logTag, String.format("Bundle returned from %s contains null SKUs list.", methodName));
            return internalErrorResult;
        }
        if (purchaseDataList == null) {
            BillingHelper.logWarn(logTag, String.format("Bundle returned from %s contains null purchases list.", methodName));
            return internalErrorResult;
        }
        if (signatureList == null) {
            BillingHelper.logWarn(logTag, String.format("Bundle returned from %s contains null signatures list.", methodName));
            return internalErrorResult;
        }
        return BillingResults.OK;
    }
}

