/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.DR;
import com.yy.hiyo.game.base.R;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.x2c.X2CUtils;
import java.util.ArrayList;
import java.util.List;

public class GameDownloadingView
extends YYFrameLayout {
    private static final String TAG = "GameDownloadingView";
    public static final int TYPE_STRIP = 1;
    public static final int TYPE_DIAMOND = 2;
    public static final int DOWNLOAD_VIEW_NORMAL = 1;
    public static final int DOWNLOAD_VIEW_CIRCLE = 2;
    private static final float MB = 1048576.0f;
    private static final float SHOW_PROGRESS_SIZE_LIMIT = 8388608.0f;
    private RoundImageView mDownloadMark;
    private RelativeLayout mDownloadAnimationLay;
    private ProgressBar mProgressBar;
    private TextView mProgressText;
    private SVGAImageView mProgressBubble;
    private RelativeLayout mScaleContainer;
    private ImageView mDownloadFinishLight;
    private LinearLayout mProgressContainer;
    private LinearLayout mPauseContainer;
    private LinearLayout mProgressTextContainer;
    private TextView mProgressSize;
    private YYImageView mPauseImg;
    private YYTextView mPauseText;
    private TimeInterpolator interpolator;
    private int mDefaultProgressBarWidth;
    private int mDefaultLightWidth;
    private int mProgressBarWidth;
    private int mLightWidth;
    private Interpolator mLightInterpolator;
    private boolean isFinishAnimation = false;
    private float mCurDownloadProgress = 10.0f;
    private int type = 2;
    private boolean mSimpleProgressSize;
    private int downloadViewType = 1;
    private List<ObjectAnimator> mObjectAnimatorCache;
    private GameInfo mGameInfo;
    int mCurMarkColor = 0;
    private IDownloadStateListener mStateListener;
    private IDownloadViewListener mVisibilityListener;
    private boolean isProgressShow = true;
    private boolean needLight = true;
    private boolean needStrongLight = false;
    private boolean hadDetached = false;
    private DResource bubbleSvga = DR.download_bubble;
    private boolean mProgressOnly = false;
    private ObjectAnimator mLightAnim;
    private String progressTips = "";
    private Runnable mPauseTimer = new Runnable(){

        @Override
        public void run() {
            if (GameDownloadingView.this.mPauseContainer != null && GameDownloadingView.this.mPauseContainer.getVisibility() != 8) {
                GameDownloadingView.this.mPauseContainer.setVisibility(8);
            }
            if (GameDownloadingView.this.mDownloadMark != null && GameDownloadingView.this.mDownloadMark.getVisibility() != 8) {
                GameDownloadingView.this.mDownloadMark.setVisibility(8);
            }
            if (GameDownloadingView.this.mGameInfo != null && ((GameDownloadingView)GameDownloadingView.this).mGameInfo.downloadInfo.getState() == GameDownloadInfo.DownloadState.download_pause) {
                ((GameDownloadingView)GameDownloadingView.this).mGameInfo.downloadInfo.setState(GameDownloadInfo.DownloadState.download_not);
            }
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public GameDownloadingView(Context context) {
        super(context);
        this.createView(context);
    }

    public GameDownloadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public GameDownloadingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        X2CUtils.mergeInflate((Context)context, (int)R.layout.layout_game_downloading, (ViewGroup)this);
        this.mDownloadMark = (RoundImageView)this.findViewById(R.id.download_mark);
        this.mDownloadAnimationLay = (RelativeLayout)this.findViewById(R.id.download_animation);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.download_progress_bar);
        this.mProgressText = (TextView)this.findViewById(R.id.progress_text);
        this.mProgressBubble = (SVGAImageView)this.findViewById(R.id.progress_bubble);
        this.mDownloadFinishLight = (ImageView)this.findViewById(R.id.download_finish_light);
        this.mProgressContainer = (LinearLayout)this.findViewById(R.id.progress_container);
        this.mPauseContainer = (LinearLayout)this.findViewById(R.id.pause_container);
        this.mProgressTextContainer = (LinearLayout)this.findViewById(R.id.progress_text_container);
        this.mProgressSize = (TextView)this.findViewById(R.id.progress_size_text);
        this.mPauseImg = (YYImageView)this.findViewById(R.id.pause_icon);
        this.mPauseText = (YYTextView)this.findViewById(R.id.pause_text);
        this.mPauseText.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mProgressText.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mProgressSize.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mDownloadMark.setBorderRadius(ResolutionUtils.dip2Px((float)3.0f));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.needLight) {
            this.setLightSize();
        }
    }

    private void setLightSize() {
        int height = this.getMeasuredHeight();
        this.mLightWidth = (int)((float)height * 1.5f);
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mDownloadFinishLight.getLayoutParams();
        lp.height = height;
        lp.width = this.mLightWidth;
        lp.leftMargin = -(this.mLightWidth + this.getMeasuredWidth());
        lp.setMarginStart(lp.leftMargin);
        this.mDownloadFinishLight.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void setSimpleProgressSize(boolean isSimple) {
        this.mSimpleProgressSize = isSimple;
    }

    public void setProgressOnly(boolean progressOnly) {
        this.mProgressOnly = progressOnly;
    }

    public void setType(int type) {
        this.type = type;
        if (this.mProgressTextContainer != null) {
            int orientation = type == 1 ? 0 : 1;
            this.mProgressTextContainer.setOrientation(orientation);
        }
    }

    public void setNeedStrongLight(boolean needStrongLight) {
        this.needStrongLight = needStrongLight;
    }

    public void setNeedLight(boolean needLight) {
        this.needLight = needLight;
    }

    public void setBorderRadius(int borderRadius) {
        this.mDownloadMark.setBorderRadius(ResolutionUtils.dip2Px((float)borderRadius));
    }

    public void setRadius(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
        this.mDownloadMark.setCornerModel(topLeft, topRight, bottomLeft, bottomRight);
    }

    public void setProgressTextSize(float size) {
        if (this.mProgressText != null) {
            this.mProgressText.setTextSize(2, size);
        }
    }

    public void setProgressSizeTextSize(float size) {
        if (this.mProgressSize != null) {
            this.mProgressSize.setTextSize(2, size);
        }
    }

    public void setDefaultProgressBarWidth(int defaultProgressBarWidth) {
        this.mDefaultProgressBarWidth = defaultProgressBarWidth;
    }

    public void setDefaultLightWidth(int defaultLightWidth) {
        this.mDefaultLightWidth = defaultLightWidth;
    }

    public void setScaleContainer(RelativeLayout scaleContainer) {
        this.mScaleContainer = scaleContainer;
    }

    public void setMarkBackground(int color) {
        if (this.mCurMarkColor != color) {
            this.mDownloadMark.setLoadingColor(color);
        }
        this.mCurMarkColor = color;
    }

    public void setBgSrc(Drawable drawable) {
        this.mDownloadMark.setImageDrawable(drawable);
    }

    public void setProgressBarWidth(int width) {
        if (this.mProgressBar != null) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mProgressBar.getLayoutParams();
            if (lp.width != width) {
                lp.width = width;
                this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }

    public void setProgressBarHeight(int height) {
        if (this.mProgressBar != null) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mProgressBar.getLayoutParams();
            if (lp.height != height) {
                lp.height = height;
                this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }

    public void setGameInfo(GameInfo info) {
        if (info == null) {
            if (this.mGameInfo != null) {
                this.mBinder.clearKvoConnection("GameDownloadInfo");
            } else {
                this.updateProgress(10.0f, 0L, 0.0f);
            }
        } else {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"setGameInfo gid: %s", (Object[])new Object[]{info.getGid()});
            }
            if (info != this.mGameInfo && this.mGameInfo != null) {
                this.mBinder.clearKvoConnection("GameDownloadInfo");
            }
            this.mGameInfo = info;
            this.mBinder.singleBindSourceTo("GameDownloadInfo", (KvoSource)this.mGameInfo.downloadInfo);
            this.handleState(info.downloadInfo);
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class, thread=1)
    public void onUpdateProgress(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUpdateProgress gid: %s, state: %s, cur: %s, total: %s, type: %s", (Object[])new Object[]{this.gameId(), info.getState(), info.getProgress(), info.getTotalBytes(), info.downloadType});
        }
        if (info.getState() != GameDownloadInfo.DownloadState.downloading || this.isSilentDownload(info)) {
            return;
        }
        this.updateProgress(info);
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public void onState(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onState gid: %s,  state: %s, type: %s", (Object[])new Object[]{this.gameId(), event.newValue(), info.downloadType});
        }
        if (this.mStateListener != null) {
            this.mStateListener.onStateChange((GameDownloadInfo.DownloadState)((Object)event.newValue()));
        }
        if (this.isSilentDownload(info)) {
            this.updateProgress(10.0f, 0L, 0.0f);
            return;
        }
        this.checkGameInfo(info);
        this.handleState(info);
    }

    public String getGid() {
        return this.mGameInfo == null ? "" : this.mGameInfo.getGid();
    }

    private void handleState(GameDownloadInfo info) {
        if (this.isSilentDownload(this.mGameInfo.downloadInfo)) {
            this.updateProgress(10.0f, 0L, 0.0f);
        } else {
            switch (info.getState()) {
                case download_start: {
                    YYTaskExecutor.removeTask((Runnable)this.mPauseTimer);
                    if (info.getProgress() > 0L) {
                        this.updateProgress(info);
                        break;
                    }
                    this.updateProgress(0.0f, 0L, info.randomInitProgress);
                    break;
                }
                case download_wait: {
                    YYTaskExecutor.removeTask((Runnable)this.mPauseTimer);
                    this.updateProgress(-1.0f, 0L, 0.0f);
                    break;
                }
                case download_pause: {
                    this.onPause();
                    break;
                }
                case downloading: {
                    YYTaskExecutor.removeTask((Runnable)this.mPauseTimer);
                    this.updateProgress(info);
                    break;
                }
                default: {
                    this.updateProgress(10.0f, 0L, 0.0f);
                }
            }
            this.checkDownloadViewType(info.getState());
        }
    }

    private void updateProgress(GameDownloadInfo info) {
        this.checkGameInfo(info);
        float p = (float)info.getProgress() / ((float)info.getTotalBytes() * 1.0f);
        this.updateProgress(p, info.getTotalBytes(), info.randomInitProgress);
    }

    private void checkGameInfo(GameDownloadInfo info) {
        if (this.mGameInfo != null && info != this.mGameInfo.downloadInfo) {
            this.mBinder.clearKvoConnection("GameDownloadInfo");
            this.mBinder.singleBindSourceTo("GameDownloadInfo", (KvoSource)this.mGameInfo.downloadInfo);
        }
    }

    private boolean isSilentDownload(GameDownloadInfo info) {
        return info.downloadType == GameDownloadInfo.DownloadType.silent || info.downloadType == GameDownloadInfo.DownloadType.none;
    }

    private void updateProgress(float progress, long total, float initProgress) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"updateProgress gid: %s, progress: %s, total: %s, initProgress: %s", (Object[])new Object[]{this.gameId(), Float.valueOf(progress), total, Float.valueOf(initProgress)});
        }
        float originalProgress = progress;
        if (progress == 10.0f) {
            this.mCurDownloadProgress = 10.0f;
            this.hideDownloadLay();
            return;
        }
        progress = GameDownloadInfo.downloadInterpolation(progress);
        if (initProgress > 0.0f && progress < initProgress) {
            progress = initProgress;
        }
        if (progress < 0.995f) {
            this.beginDownload();
        }
        this.setProgressSize(progress, total);
        if (this.mDownloadMark.getVisibility() != 0) {
            this.mDownloadMark.setVisibility(0);
        }
        if (this.mPauseContainer.getVisibility() != 8) {
            this.mPauseContainer.setVisibility(8);
        }
        if (this.mProgressContainer.getVisibility() != 0) {
            this.mProgressContainer.setVisibility(0);
        }
        if (this.mProgressBubble.getVisibility() != 0) {
            this.mProgressBubble.setVisibility(0);
        }
        int p = (int)(progress * 100.0f);
        this.mProgressBar.setProgress(p);
        if (FP.empty((CharSequence)this.progressTips)) {
            if (originalProgress < 0.0f) {
                this.mProgressText.setText((CharSequence)ResourceUtils.getString((int)R.string.downloading_waiting));
            } else if ((float)total > 8388608.0f) {
                this.mProgressText.setText((CharSequence)ResourceUtils.getString((int)R.string.short_summary_downloading));
            } else {
                this.mProgressText.setText((CharSequence)ResourceUtils.getString((int)R.string.downloading_progress, (Object[])new Object[]{p + "%"}));
            }
        } else {
            this.mProgressText.setText((CharSequence)this.progressTips);
        }
        int pbw = this.mProgressBarWidth <= 0 ? this.mDefaultProgressBarWidth : this.mProgressBarWidth;
        float tx = progress * (float)pbw;
        tx = tx < 0.0f ? 1.0f : tx;
        tx = LanguageUtils.isRtl() ? (float)pbw - tx : tx;
        this.mProgressBubble.setTranslationX(tx);
        if (!this.mProgressBubble.isAnimating()) {
            this.mProgressBubble.startAnimation();
        }
        this.mCurDownloadProgress = progress;
        if (progress > 0.995f) {
            this.finishDownload();
            this.hideDownloadLay();
            this.mCurDownloadProgress = 10.0f;
        }
    }

    public void setProgressTips(String text) {
        this.progressTips = text;
        this.mProgressText.setText((CharSequence)text);
    }

    private void checkDownloadViewType(GameDownloadInfo.DownloadState state) {
        if (this.downloadViewType == 2) {
            this.mProgressTextContainer.setVisibility(state.getValue() == GameDownloadInfo.DownloadState.download_wait.getValue() ? 0 : 8);
            this.mProgressBar.setVisibility(state.getValue() != GameDownloadInfo.DownloadState.download_wait.getValue() ? 0 : 8);
            if (state.getValue() == GameDownloadInfo.DownloadState.download_wait.getValue() || state.getValue() == GameDownloadInfo.DownloadState.download_pause.getValue()) {
                this.mProgressBubble.setVisibility(8);
            } else {
                this.mProgressBubble.setVisibility(0);
            }
        }
    }

    private void setProgressSize(float progress, long total) {
        if (this.mProgressOnly) {
            this.mProgressText.setVisibility(0);
            this.mProgressSize.setVisibility(8);
        } else if ((float)total < 8388608.0f) {
            this.mProgressText.setVisibility(0);
            if (this.mProgressSize.getVisibility() != 8) {
                this.mProgressSize.setVisibility(8);
            }
        } else {
            if (this.mProgressSize.getVisibility() != 0) {
                this.mProgressSize.setVisibility(0);
            }
            float tm = (float)total / 1048576.0f;
            float cur = tm * progress;
            if (this.mSimpleProgressSize) {
                this.mProgressText.setVisibility(8);
                this.mProgressSize.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%.1fm/%.1fm", (Object[])new Object[]{Float.valueOf(cur), Float.valueOf(tm)}));
            } else {
                this.mProgressText.setVisibility(0);
                this.mProgressSize.setText((CharSequence)StringUtils.formatWitUSLocal((String)"(%.1fm/%.1fm)", (Object[])new Object[]{Float.valueOf(cur), Float.valueOf(tm)}));
            }
        }
    }

    private void onPause() {
        this.mProgressBubble.setVisibility(8);
        this.mProgressContainer.setVisibility(8);
        this.mPauseContainer.setVisibility(0);
        YYTaskExecutor.removeTask((Runnable)this.mPauseTimer);
        YYTaskExecutor.postToMainThread((Runnable)this.mPauseTimer, (long)2000L);
    }

    private String gameId() {
        return this.mGameInfo == null ? "" : this.mGameInfo.getGid();
    }

    public boolean isDownloading() {
        return this.mGameInfo != null && (this.mGameInfo.downloadInfo.isDownloading() || this.mGameInfo.downloadInfo.isPause());
    }

    public boolean isDownloadingAndNotPause() {
        return this.mGameInfo != null && this.mGameInfo.downloadInfo.isDownloading();
    }

    public void canStartAnimation() {
        if (this.mCurDownloadProgress < 1.0f && this.mDownloadAnimationLay.getVisibility() == 0 && !this.mProgressBubble.isAnimating()) {
            this.mProgressBubble.startAnimation();
        }
        this.checkStrongLight();
        this.hadDetached = false;
    }

    public void stopAllAnimation() {
        if (this.mLightAnim != null) {
            this.mLightAnim.cancel();
        }
    }

    private void beginDownload() {
        if (this.mDownloadAnimationLay.getVisibility() == 0) {
            return;
        }
        if (this.mObjectAnimatorCache == null) {
            this.mObjectAnimatorCache = new ArrayList<ObjectAnimator>(8);
        }
        this.mDownloadAnimationLay.setVisibility(0);
        if (this.mVisibilityListener != null) {
            this.mVisibilityListener.onVisibilityleChange(true);
        }
        this.mDownloadMark.setVisibility(0);
        if (this.mProgressBarWidth <= 0) {
            this.mProgressBar.post(new Runnable(){

                @Override
                public void run() {
                    GameDownloadingView.this.mProgressBarWidth = GameDownloadingView.this.mProgressBar.getWidth();
                }
            });
        }
        DyResLoader.INSTANCE.loadSvga(this.mProgressBubble, this.bubbleSvga, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                if (GameDownloadingView.this.mProgressBubble != null) {
                    GameDownloadingView.this.mProgressBubble.startAnimation();
                }
            }

            public void onFailed(Exception e) {
                MLog.error((Object)GameDownloadingView.TAG, (Throwable)e);
            }
        });
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.mDownloadAnimationLay, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alpha.setDuration(120L);
        alpha.setInterpolator(this.getInterpolator());
        alpha.start();
        this.mObjectAnimatorCache.add(alpha);
        ObjectAnimator alphaMark = ObjectAnimator.ofFloat((Object)this.mDownloadMark, (String)"alpha", (float[])new float[]{0.0f, 0.9f});
        alphaMark.setDuration(120L);
        alphaMark.setInterpolator(this.getInterpolator());
        alphaMark.start();
        this.mObjectAnimatorCache.add(alphaMark);
        if (this.mScaleContainer != null) {
            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)this.mScaleContainer, (String)"scaleX", (float[])new float[]{1.0f, 0.9f});
            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)this.mScaleContainer, (String)"scaleY", (float[])new float[]{1.0f, 0.9f});
            scaleX.setInterpolator(this.interpolator);
            scaleY.setInterpolator(this.interpolator);
            scaleX.setDuration(250L);
            scaleY.setDuration(250L);
            scaleX.start();
            scaleY.start();
            this.mObjectAnimatorCache.add(scaleX);
            this.mObjectAnimatorCache.add(scaleY);
        }
    }

    public void finishDownload() {
        if (this.mDownloadAnimationLay.getVisibility() == 8 || this.isFinishAnimation) {
            return;
        }
        if (this.mObjectAnimatorCache == null) {
            this.mObjectAnimatorCache = new ArrayList<ObjectAnimator>(8);
        }
        this.isFinishAnimation = true;
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.mDownloadAnimationLay, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        alpha.setDuration(180L);
        alpha.setInterpolator(this.getInterpolator());
        alpha.start();
        this.mObjectAnimatorCache.add(alpha);
        ObjectAnimator alphaMark = ObjectAnimator.ofFloat((Object)this.mDownloadMark, (String)"alpha", (float[])new float[]{0.9f, 0.0f});
        alphaMark.setDuration(180L);
        alphaMark.setInterpolator(this.getInterpolator());
        alphaMark.start();
        this.mObjectAnimatorCache.add(alphaMark);
        alphaMark.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                GameDownloadingView.this.isFinishAnimation = false;
                GameDownloadingView.this.hideDownloadLay();
            }
        });
        if (this.mScaleContainer != null) {
            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)this.mScaleContainer, (String)"scaleX", (float[])new float[]{0.9f, 1.0f});
            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)this.mScaleContainer, (String)"scaleY", (float[])new float[]{0.9f, 1.0f});
            scaleX.setInterpolator(this.interpolator);
            scaleY.setInterpolator(this.interpolator);
            scaleX.setDuration(180L);
            scaleY.setDuration(180L);
            scaleX.start();
            scaleY.start();
            this.mObjectAnimatorCache.add(scaleX);
            this.mObjectAnimatorCache.add(scaleY);
        }
        if (this.needLight) {
            this.mDownloadFinishLight.setTranslationX(0.0f);
            this.mDownloadFinishLight.setVisibility(0);
            this.mDownloadFinishLight.post(new Runnable(){

                @Override
                public void run() {
                    GameDownloadingView.this.lightAnimation(1000L, 0, null);
                }
            });
        }
    }

    private void lightAnimation(long duration, int repeat, Animator.AnimatorListener listener) {
        if (this.mDownloadFinishLight == null) {
            return;
        }
        if (this.mLightAnim != null) {
            this.mLightAnim.cancel();
        }
        this.mLightAnim = ObjectAnimator.ofFloat((Object)this.mDownloadFinishLight, (String)"translationX", (float[])new float[]{0.0f, this.getMeasuredWidth() + this.mLightWidth * 2});
        this.mLightAnim.setDuration(duration);
        this.mLightAnim.setRepeatCount(repeat);
        if (this.mLightInterpolator == null) {
            this.mLightInterpolator = new DecelerateInterpolator(1.5f);
        }
        this.mLightAnim.setInterpolator((TimeInterpolator)this.mLightInterpolator);
        if (listener != null) {
            this.mLightAnim.addListener(listener);
        }
        this.mLightAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                GameDownloadingView.this.mDownloadFinishLight.setTranslationX(0.0f);
                GameDownloadingView.this.mDownloadFinishLight.setVisibility(8);
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                GameDownloadingView.this.mDownloadFinishLight.setTranslationX(0.0f);
                GameDownloadingView.this.mDownloadFinishLight.setVisibility(8);
            }
        });
        this.mLightAnim.start();
    }

    public void hideDownloadLay() {
        if (this.mDownloadAnimationLay.getVisibility() == 8 || this.isFinishAnimation) {
            return;
        }
        if (!FP.empty(this.mObjectAnimatorCache)) {
            for (ObjectAnimator oa : this.mObjectAnimatorCache) {
                if (oa == null || !oa.isRunning()) continue;
                oa.cancel();
            }
            this.mObjectAnimatorCache.clear();
        }
        this.mDownloadAnimationLay.setVisibility(8);
        if (this.mVisibilityListener != null) {
            this.mVisibilityListener.onVisibilityleChange(false);
        }
        this.mDownloadMark.setVisibility(8);
        ViewCompat.animate((View)this.mDownloadAnimationLay).cancel();
        ViewCompat.animate((View)this.mDownloadMark).cancel();
        this.mProgressBubble.stopAnimation();
        this.mProgressBubble.setTranslationX(0.0f);
        if (this.mScaleContainer != null) {
            ViewCompat.animate((View)this.mScaleContainer).cancel();
            this.mScaleContainer.setScaleX(1.0f);
            this.mScaleContainer.setScaleY(1.0f);
        }
    }

    public void pause() {
        if (this.mGameInfo != null) {
            this.mGameInfo.downloadInfo.pause();
        }
    }

    public void setPauseImgSize(int size) {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mPauseImg.getLayoutParams();
        if (lp.width != size) {
            lp.width = size;
            lp.height = size;
            this.mPauseImg.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }

    public void setDownloadViewType(int type) {
        this.downloadViewType = type;
        if (this.downloadViewType == 2) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mProgressTextContainer.getLayoutParams();
            params.topMargin = 0;
            this.mProgressTextContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public void setProgressTextContainerMarginTop(int marginTop) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mProgressTextContainer.getLayoutParams();
        params.topMargin = marginTop;
        this.mProgressTextContainer.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setPauseTextVisibility(int visibility) {
        this.mPauseText.setVisibility(visibility);
    }

    public void setProgressBarDrawable(int drawableId) {
        this.mProgressBar.setProgressDrawable(ResourceUtils.getDrawable((int)drawableId));
    }

    public void setProgressBarLP(RelativeLayout.LayoutParams lp) {
        if (lp != null) {
            this.mProgressContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }

    public void setBubbleSvga(DResource svga) {
        this.bubbleSvga = svga;
    }

    private TimeInterpolator getInterpolator() {
        if (this.interpolator == null) {
            this.interpolator = new AccelerateDecelerateInterpolator();
        }
        return this.interpolator;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mGameInfo != null) {
            this.mBinder.singleBindSourceTo("GameDownloadInfo", (KvoSource)this.mGameInfo.downloadInfo);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBinder.clearAllKvoConnections();
        this.hadDetached = true;
    }

    public void setDownloadStateListener(IDownloadStateListener stateListener) {
        this.mStateListener = stateListener;
    }

    public void setDownloadViewListener(IDownloadViewListener stateListener) {
        this.mVisibilityListener = stateListener;
    }

    public void setProgressShow(boolean progressShow) {
        this.isProgressShow = progressShow;
        if (this.isProgressShow) {
            this.mProgressTextContainer.setVisibility(0);
        } else {
            this.mProgressTextContainer.setVisibility(8);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDraw(canvas);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void checkStrongLight() {
        if (!this.hadDetached || !this.needStrongLight || this.mGameInfo == null || this.mDownloadFinishLight == null) {
            return;
        }
        boolean show = this.mGameInfo.downloadInfo.getExt("needSplashLight", false);
        if (show) {
            this.mDownloadFinishLight.setTranslationX(0.0f);
            this.mDownloadFinishLight.setVisibility(0);
            this.mDownloadFinishLight.post(new Runnable(){

                @Override
                public void run() {
                    GameDownloadingView.this.lightAnimation(1000L, 1, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationStart(Animator animation) {
                            super.onAnimationStart(animation);
                            ((GameDownloadingView)GameDownloadingView.this).mGameInfo.downloadInfo.removeExt("needSplashLight");
                        }
                    });
                }
            });
        }
    }

    public void checkStartHighLight(final int times, final long duration) {
        if (this.mDownloadFinishLight == null) {
            return;
        }
        this.mDownloadFinishLight.setTranslationX(0.0f);
        this.mDownloadFinishLight.setVisibility(0);
        this.mDownloadFinishLight.post(new Runnable(){

            @Override
            public void run() {
                GameDownloadingView.this.lightAnimation(duration, times, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationStart(Animator animation) {
                        super.onAnimationStart(animation);
                    }

                    public void onAnimationCancel(Animator animation) {
                        super.onAnimationCancel(animation);
                    }

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                    }
                });
            }
        });
    }

    public static interface IDownloadViewListener {
        public void onVisibilityleChange(boolean var1);
    }

    public static interface IDownloadStateListener {
        public void onStateChange(GameDownloadInfo.DownloadState var1);
    }
}

