/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.teamgame;

import android.content.Context;
import com.yy.appbase.R;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;

public class TeamInviteResCodeHelper {
    private static String getStringByCode(long code) {
        switch (new Long(code).intValue()) {
            case 2000: {
                return ResourceUtils.getString((int)R.string.error_team_game_full);
            }
            case 2001: {
                return ResourceUtils.getString((int)R.string.error_team_game_invalid);
            }
            case 2002: {
                return ResourceUtils.getString((int)R.string.error_team_game_has_begun);
            }
            case 2003: {
                return ResourceUtils.getString((int)R.string.error_team_game_user_gaming);
            }
            case 2004: {
                return ResourceUtils.getString((int)R.string.team_invalid);
            }
            case 2005: {
                return ResourceUtils.getString((int)R.string.error_team_game_in_team);
            }
            case 2010: {
                return ResourceUtils.getString((int)R.string.team_in_matching);
            }
        }
        return "";
    }

    public static void showToast(long code) {
        String toastStr = TeamInviteResCodeHelper.getStringByCode(code);
        if (!StringUtils.isEmpty((String)toastStr)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)toastStr, (int)1);
        }
    }

    public static void handleResCode(long code, Context mContext, final GameInfo gameInfo) {
        if (code == 2003L) {
            DialogLinkManager mDialogLinkManager = new DialogLinkManager(mContext);
            OkCancelDialog tipsDialog = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.team_game_game_in_team), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, new OkCancelDialogListener(){

                public void onCancel() {
                }

                public void onOk() {
                    GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_IM);
                    teamMatchContext.setGameInfo(gameInfo);
                    teamMatchContext.setBackToGame(true);
                    ((IGameCenterService)ServiceManagerProxy.getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
                }
            });
            mDialogLinkManager.showDialog((BaseDialog)tipsDialog);
        } else {
            TeamInviteResCodeHelper.showToast(code);
        }
    }
}

