/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.streakwin;

import com.yy.base.utils.DontProguardClass;
import ikxd.gameresult.PKWinStreakContext;
import ikxd.gameresult.PKWinStreakGameInfo;
import ikxd.gameresult.PKWinStreakPush;
import java.util.ArrayList;
import java.util.List;

@DontProguardClass
public class StreakWinData {
    private int count;
    private String remarkIconUrl;
    private List<StreakGameInfo> streakGameInfoList;

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getRemarkIconUrl() {
        return this.remarkIconUrl;
    }

    public void setRemarkIconUrl(String remarkIconUrl) {
        this.remarkIconUrl = remarkIconUrl;
    }

    public List<StreakGameInfo> getStreakGameInfoList() {
        return this.streakGameInfoList;
    }

    public void setStreakGameInfoList(List<StreakGameInfo> streakGameInfoList) {
        this.streakGameInfoList = streakGameInfoList;
    }

    public static StreakWinData fromPKWinStreakPush(PKWinStreakPush data) {
        if (data == null) {
            return null;
        }
        StreakWinData streakWinData = new StreakWinData();
        streakWinData.count = data.win_streak_count.intValue();
        int winStreakCount = streakWinData.count + 1;
        String remarkIconUrl = "";
        List list = data.win_streak_context;
        if (list != null) {
            int streakContextSize = list.size();
            for (int i = streakContextSize - 1; i >= 0; --i) {
                PKWinStreakContext pkWinStreakContext = (PKWinStreakContext)list.get(i);
                if (i == streakContextSize - 1) {
                    if ((long)winStreakCount < pkWinStreakContext.win_streak_count) continue;
                    remarkIconUrl = pkWinStreakContext.win_streak_context;
                    break;
                }
                if ((long)winStreakCount != pkWinStreakContext.win_streak_count) continue;
                remarkIconUrl = pkWinStreakContext.win_streak_context;
                break;
            }
        }
        streakWinData.remarkIconUrl = remarkIconUrl;
        List urlList = data.win_streak_game_infos;
        if (urlList != null) {
            ArrayList<StreakGameInfo> streakGameInfoList = new ArrayList<StreakGameInfo>();
            for (int i = 0; i < urlList.size(); ++i) {
                StreakGameInfo gameInfo = new StreakGameInfo();
                gameInfo.setIconUrl(((PKWinStreakGameInfo)urlList.get((int)i)).game_icon_url);
                gameInfo.setName(((PKWinStreakGameInfo)urlList.get((int)i)).game_name);
                streakGameInfoList.add(gameInfo);
            }
            streakWinData.streakGameInfoList = streakGameInfoList;
        }
        return streakWinData;
    }

    @DontProguardClass
    public static class StreakGameInfo {
        private String name;
        private String iconUrl;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }
    }
}

