/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.config;

import androidx.annotation.Nullable;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.config.GangupInviteConfigData;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class GangupInviteConfig
extends AConfigData {
    private static final String TAG = "GangupInviteConfig";
    private LinkedHashMap<String, GangupInviteConfigData> mMap = new LinkedHashMap();

    public BssCode getBssCode() {
        return BssCode.GANGUP_INVITE_INFO;
    }

    public void parseConfig(String configs) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"configs %s", (Object[])new Object[]{configs});
        }
        if (FP.empty((CharSequence)configs)) {
            MLog.error((Object)TAG, (String)"configs empty", (Object[])new Object[0]);
            return;
        }
        try {
            JSONArray array = new JSONArray(configs);
            this.mMap.clear();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject item = array.optJSONObject(i);
                if (null == item) continue;
                this.parseItem(item);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)"parseConfig %s", (Object[])new Object[]{configs});
        }
    }

    private void parseItem(JSONObject data) {
        if (null == data) {
            return;
        }
        try {
            GangupInviteConfigData item = (GangupInviteConfigData)JsonParser.parseJsonObject((String)data.toString(), GangupInviteConfigData.class);
            this.mMap.put(item.getKeyword(), item);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            MLog.info((Object)TAG, (String)"parseItem value %s", (Object[])new Object[]{data});
        }
    }

    public LinkedHashMap<String, GangupInviteConfigData> getmMap() {
        return this.mMap;
    }

    @Nullable
    public GangupInviteConfigData getInviteInfo(String url) {
        if (FP.empty((CharSequence)url)) {
            return null;
        }
        for (Map.Entry<String, GangupInviteConfigData> entry : this.mMap.entrySet()) {
            if (!url.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public boolean packageInConfig(String packageName) {
        if (FP.empty((CharSequence)packageName)) {
            return false;
        }
        for (Map.Entry<String, GangupInviteConfigData> entry : this.mMap.entrySet()) {
            if (!packageName.equals(entry.getValue().getPackagename())) continue;
            return true;
        }
        return false;
    }
}

