/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.audio;

import android.media.MediaPlayer;
import android.text.TextUtils;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import java.io.IOException;

public class Mp3PlayHelper {
    private static final String TAG = "Mp3PlayHelper";
    private MediaPlayer mMediaPlayer = null;
    private static volatile Mp3PlayHelper instance = null;
    private static volatile Mp3PlayHelper secondInstance = null;
    private static volatile Mp3PlayHelper thirdInstance = null;
    private volatile boolean mIsPreparing = false;
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mp3PlayHelper getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<Mp3PlayHelper> clazz = Mp3PlayHelper.class;
        synchronized (Mp3PlayHelper.class) {
            if (instance == null) {
                instance = new Mp3PlayHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mp3PlayHelper getSecondInstance() {
        if (secondInstance != null) {
            return secondInstance;
        }
        Class<Mp3PlayHelper> clazz = Mp3PlayHelper.class;
        synchronized (Mp3PlayHelper.class) {
            if (secondInstance == null) {
                secondInstance = new Mp3PlayHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return secondInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mp3PlayHelper getThirdInstance() {
        if (thirdInstance != null) {
            return thirdInstance;
        }
        Class<Mp3PlayHelper> clazz = Mp3PlayHelper.class;
        synchronized (Mp3PlayHelper.class) {
            if (thirdInstance == null) {
                thirdInstance = new Mp3PlayHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return thirdInstance;
        }
    }

    public void playMp3WithPath(final String filePath) {
        this.mQueueTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                Mp3PlayHelper.this.playMp3WithPath(filePath, 1.0f, false);
            }
        }, 0L);
    }

    public void playMp3WithPath(final String filePath, final float volume) {
        this.mQueueTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                Mp3PlayHelper.this.playMp3WithPath(filePath, volume, false);
            }
        }, 0L);
    }

    public void playMp3WithPath(final String filePath, final float volume, final boolean needCompleteNotify) {
        this.mQueueTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                Mp3PlayHelper.this.playMp3WithPath(filePath, volume, needCompleteNotify, null);
            }
        }, 0L);
    }

    public void playMp3WithPath(final String filePath, final float volume, final boolean needCompleteNotify, final AudioCompleteListener audioCompleteListener) {
        this.mQueueTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                Mp3PlayHelper.this.playMp3WithPath(filePath, volume, needCompleteNotify, audioCompleteListener, false);
            }
        }, 0L);
    }

    public void playMp3WithPath(final String filePath, final float volume, final boolean needCompleteNotify, final AudioCompleteListener audioCompleteListener, final boolean isLoop) {
        this.mQueueTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                if (TextUtils.isEmpty((CharSequence)filePath)) {
                    MLog.error((Object)Mp3PlayHelper.TAG, (String)"playMp3WithPath filePath is empty", (Object[])new Object[0]);
                    Mp3PlayHelper.this.mMediaPlayer = null;
                    Mp3PlayHelper.this.mIsPreparing = false;
                    return;
                }
                boolean initSuccess = false;
                Mp3PlayHelper.this.mMediaPlayer = new MediaPlayer();
                try {
                    Mp3PlayHelper.this.mMediaPlayer.setDataSource(filePath);
                    initSuccess = true;
                }
                catch (IOException ioe) {
                    MLog.error((Object)Mp3PlayHelper.TAG, (String)"[playMp3WithPath], setDataSource exception", (Throwable)ioe, (Object[])new Object[0]);
                }
                if (!initSuccess) {
                    Mp3PlayHelper.this.mMediaPlayer = null;
                    return;
                }
                try {
                    Mp3PlayHelper.this.mIsPreparing = true;
                    Mp3PlayHelper.this.mMediaPlayer.prepareAsync();
                    Mp3PlayHelper.this.mMediaPlayer.setVolume(volume, volume);
                    Mp3PlayHelper.this.mMediaPlayer.setLooping(isLoop);
                    Mp3PlayHelper.this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                        public void onCompletion(MediaPlayer mp) {
                            if (needCompleteNotify) {
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.AUDIO_PLAY_CONPLETE));
                                    }
                                });
                            }
                            if (audioCompleteListener != null) {
                                audioCompleteListener.onAudioComplete(filePath);
                            }
                        }
                    });
                    Mp3PlayHelper.this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer mp) {
                            Mp3PlayHelper.this.mIsPreparing = false;
                            if (Mp3PlayHelper.this.mMediaPlayer != null) {
                                try {
                                    Mp3PlayHelper.this.mMediaPlayer.start();
                                }
                                catch (Exception e) {
                                    MLog.error((Object)"MpsPlayHelper", (Throwable)e);
                                }
                            }
                        }
                    });
                }
                catch (IllegalStateException e) {
                    Mp3PlayHelper.this.mIsPreparing = false;
                    Mp3PlayHelper.this.mMediaPlayer = null;
                    MLog.error((Object)Mp3PlayHelper.TAG, (Throwable)e);
                }
                catch (Exception ignored) {
                    Mp3PlayHelper.this.mIsPreparing = false;
                    MLog.error((Object)Mp3PlayHelper.TAG, (Throwable)ignored);
                }
            }
        }, 0L);
    }

    public void stopPlayers() {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Mp3PlayHelper.this.mIsPreparing = false;
                try {
                    if (Mp3PlayHelper.this.mMediaPlayer != null) {
                        Mp3PlayHelper.this.mMediaPlayer.stop();
                        Mp3PlayHelper.this.mMediaPlayer.release();
                        Mp3PlayHelper.this.mMediaPlayer = null;
                    }
                }
                catch (Exception ignored) {
                    MLog.error((Object)Mp3PlayHelper.TAG, (Throwable)ignored);
                }
            }
        }, 0L);
    }

    public void isPlaying(final IAudioPlayFlagCallBack callBack) {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                boolean isPlaying;
                if (Mp3PlayHelper.this.mMediaPlayer != null && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)Mp3PlayHelper.TAG, (String)"media player is playing: %b, is preparing: %b", (Object[])new Object[]{Mp3PlayHelper.this.mMediaPlayer.isPlaying(), Mp3PlayHelper.this.mIsPreparing});
                }
                boolean bl = isPlaying = Mp3PlayHelper.this.mMediaPlayer != null && (Mp3PlayHelper.this.mMediaPlayer.isPlaying() || Mp3PlayHelper.this.mIsPreparing);
                if (callBack != null) {
                    callBack.onPlayCallBack(isPlaying);
                }
            }
        }, 0L);
    }

    public static interface IAudioPlayFlagCallBack {
        public void onPlayCallBack(boolean var1);
    }

    public static interface AudioCompleteListener {
        public void onAudioComplete(String var1);
    }
}

