/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.wrapper;

import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.module.jscallappmodule.IComGameCallAppCallBack;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameComponentContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.IComponentGameFunc;
import com.yy.hiyo.game.service.callback.IGameViewCallback;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.game.service.callback.IRoomGameBridge;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.voice.base.bean.GameUserSpeakStatus;
import com.yy.hiyo.voice.base.bean.MicStatusBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ComponentGameWrapper {
    private static final String TAG = "ComponentGameWrapper";
    private final IServiceManager serviceManager;
    private IComponentGameFunc componentGameFunc;
    private GameComponentContext context;
    private boolean hasUserLeftGame = false;
    private boolean hasShowBackgroundLog = false;
    private boolean hasShowNotGamingLog = false;
    private boolean hasShowViewHideLog = false;
    private boolean isShowing = false;
    private GameLifeWrapper gameLifeWrapper = new GameLifeWrapper(){

        @Override
        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            if (ComponentGameWrapper.this.context == context) {
                ComponentGameWrapper.this.onDetach(context);
                FeatureLog.i((String)"FTVoiceRoom", (String)"need rejoin game:%b", (Object[])new Object[]{ComponentGameWrapper.this.hasUserLeftGame});
                if (ComponentGameWrapper.this.hasUserLeftGame) {
                    MsgDispatcher.getInstance().sendMessage(BaseMsgDef.REJOIN_VOICE_ROOM_AFTER_LEAVE_GAME);
                    ComponentGameWrapper.this.hasUserLeftGame = false;
                }
            }
        }

        @Override
        public void onPreloadGame(GamePlayContext context) {
            super.onPreloadGame(context);
            if (ComponentGameWrapper.this.context == context && RuntimeContext.sIsForeground) {
                ComponentGameWrapper.this.isShowing = true;
            }
        }
    };
    private IGameFuncRegister funcRegister = null;
    private IGameViewCallback gameViewCallback = null;

    public ComponentGameWrapper(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        if (serviceManager == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("service manager can not be null");
            }
            MLog.error((Object)TAG, (String)"service manager can not be null", (Object[])new Object[0]);
        }
    }

    public synchronized boolean startGame(final @NotNull YYFrameLayout gameContainer, GameInfo info, String gameUrl, String roomId, IRoomGameBridge roomGameBridge, String windowTag, String extend, boolean isTrans) {
        boolean success = false;
        if (this.serviceManager == null) {
            return success;
        }
        if (this.serviceManager.getService(IGameCenterService.class) != null) {
            ((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).registerGameLifecycle(this.gameLifeWrapper);
        }
        this.context = new GameComponentContext(GameContextDef.JoinFrom.FROM_VOICE_ROOM);
        this.context.setGameInfo(info);
        this.context.setGameUrl(gameUrl);
        this.context.setRoomId(roomId);
        this.context.setTrans(isTrans);
        this.context.addExtendValue("extend_from_h5", extend);
        this.context.windowTag = windowTag;
        if (this.funcRegister == null) {
            this.funcRegister = new IGameFuncRegister(){

                @Override
                public void registerGameFunc(IComponentGameFunc componentGameFunc) {
                    ComponentGameWrapper.this.componentGameFunc = componentGameFunc;
                }
            };
        }
        this.context.gameFuncRegister = this.funcRegister;
        if (this.gameViewCallback == null) {
            this.gameViewCallback = new IGameViewCallback(){

                @Override
                public YYFrameLayout getGameViewContainer() {
                    return gameContainer;
                }
            };
        }
        this.context.gameViewCallback = this.gameViewCallback;
        this.context.roomGameBridge = roomGameBridge;
        if (((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).joinGame(info, this.context) == 0) {
            success = true;
        }
        MLog.info((Object)TAG, (String)"join game ,game info:%s, gameurl: %s, success:%b", (Object[])new Object[]{info, gameUrl, success});
        return success;
    }

    public void exitGame(ILeaveGameCallback callback) {
        if (this.serviceManager != null && this.serviceManager.getService(IGameCenterService.class) != null) {
            ((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).leaveCurrentGame(callback);
        } else {
            MLog.error((Object)TAG, (String)"exit game error!!!!!!!", (Object[])new Object[0]);
            if (callback != null) {
                callback.onGameLeaved(null, null);
            }
        }
    }

    public void onUserSpeakStatus(Map<Long, Boolean> datas) {
        if (!this.canCallEvent2Game()) {
            return;
        }
        ArrayList<GameUserSpeakStatus> speakStatusesList = new ArrayList<GameUserSpeakStatus>();
        if (datas != null && !datas.isEmpty()) {
            HashMap<Long, Boolean> cacheData = new HashMap<Long, Boolean>(datas);
            for (Map.Entry entry : cacheData.entrySet()) {
                GameUserSpeakStatus gameUserSpeakStatus = new GameUserSpeakStatus(((Long)entry.getKey()).longValue(), (Boolean)entry.getValue() != false ? 1 : 0);
                speakStatusesList.add(gameUserSpeakStatus);
            }
        }
        if (this.componentGameFunc != null) {
            this.componentGameFunc.appNotityGame(this.context.getRoomId(), CocosProxyType.appStateSpeaking.getEvent(), speakStatusesList);
        }
    }

    public void callGameFun(long seqId, CocosProxyType type, Object jsonObject) {
        if (this.componentGameFunc != null) {
            this.componentGameFunc.appCallGame(this.context.getRoomId(), seqId, type, jsonObject);
        }
    }

    private boolean canCallEvent2Game() {
        if (this.context == null || this.serviceManager == null) {
            MLog.error((Object)TAG, (String)"params error,context:%s, manager:%s", (Object[])new Object[]{this.context, this.serviceManager});
            return false;
        }
        if (!((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).isPlaying()) {
            if (!this.hasShowNotGamingLog) {
                MLog.info((Object)TAG, (String)"speak status not call to game because app is not playing", (Object[])new Object[0]);
                this.hasShowNotGamingLog = true;
            }
            return false;
        }
        this.hasShowNotGamingLog = false;
        if (!RuntimeContext.sIsForeground) {
            if (!this.hasShowBackgroundLog) {
                MLog.info((Object)TAG, (String)"speak status not call to game because app is at background", (Object[])new Object[0]);
                this.hasShowBackgroundLog = true;
            }
            return false;
        }
        this.hasShowBackgroundLog = false;
        if (!this.isShowing) {
            if (!this.hasShowViewHideLog) {
                MLog.info((Object)TAG, (String)"speak status not call to game because current window is hide", (Object[])new Object[0]);
                this.hasShowViewHideLog = true;
            }
            return false;
        }
        this.hasShowViewHideLog = false;
        return true;
    }

    public void onMicListStatusChange(List<MicStatusBean> micStatusBeanList) {
        if (this.componentGameFunc != null && micStatusBeanList != null && !micStatusBeanList.isEmpty()) {
            this.componentGameFunc.appNotityGame(this.context.getRoomId(), CocosProxyType.onMicStatusChange.getEvent(), micStatusBeanList);
        }
    }

    public void onMicListStatusCallback(List<MicStatusBean> micStatusBeanList, IComGameCallAppCallBack callBack) {
        if (this.componentGameFunc != null && micStatusBeanList != null && !micStatusBeanList.isEmpty()) {
            callBack.callGame(micStatusBeanList);
        }
    }

    public void registerGameLifecycle(IGameLifecycle gameLifecycle) {
        if (gameLifecycle != null && this.serviceManager != null && this.serviceManager.getService(IGameCenterService.class) != null) {
            ((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).registerGameLifecycle(gameLifecycle);
        }
    }

    public void onShow() {
        this.isShowing = true;
        if (this.componentGameFunc != null && this.componentGameFunc.gameUiCallback() != null) {
            this.componentGameFunc.gameUiCallback().onShow();
        }
    }

    public void onHide() {
        this.isShowing = false;
        if (this.componentGameFunc != null && this.componentGameFunc.gameUiCallback() != null) {
            this.componentGameFunc.gameUiCallback().onHide();
        }
    }

    public void onDetach(GamePlayContext context) {
        if (this.componentGameFunc != null && this.componentGameFunc.gameUiCallback() != null) {
            this.componentGameFunc.gameUiCallback().onDetach(context);
        }
        this.componentGameFunc = null;
        this.gameViewCallback = null;
        this.funcRegister = null;
        if (this.serviceManager != null && this.serviceManager.getService(IGameCenterService.class) != null) {
            ((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).unRegisterGameLifecycle(this.gameLifeWrapper);
        }
    }

    public void setUserHasLeftGame() {
        this.hasUserLeftGame = true;
    }

    public static interface IGameFuncRegister {
        public void registerGameFunc(IComponentGameFunc var1);
    }
}

