/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import org.json.JSONException;
import org.json.JSONObject;

public class GameWebSockectConfig
extends AConfigData {
    public static final int WEB_SOCKECT_TYPE_USE_APP_CLIENT = 1;
    public static final int WEB_SOCKECT_TYPE_USE_ENGINE_DIRECT_CONNECT = 2;
    private static final String KEY_TYPE = "type";
    private static JSONObject sData;

    public BssCode getBssCode() {
        return BssCode.GAME_WEBSOCKET_CONFIG;
    }

    public void parseConfig(final String configs) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    GameWebSockectConfig.parseConfigInner(configs);
                    GameWebSockectConfig.this.testData();
                }
            });
        } else {
            GameWebSockectConfig.parseConfigInner(configs);
            this.testData();
        }
    }

    private static synchronized void parseConfigInner(String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            sData = null;
        } else {
            try {
                sData = JsonParser.obtainJSONObject((String)configs);
            }
            catch (JSONException e) {
                MLog.error((Object)"GameWebSockectConfig", (Throwable)e);
            }
        }
    }

    public static synchronized int getWebSockectType(String gameId) {
        try {
            int type;
            JSONObject item;
            if (sData != null && StringUtils.isNotEmpty((String)gameId) && sData.has(gameId) && (item = sData.getJSONObject(gameId)) != null && item.has(KEY_TYPE) && ((type = item.getInt(KEY_TYPE)) == 1 || type == 2)) {
                MLog.info((Object)"GameWebSockectConfig", (String)"game:%s configType:%d", (Object[])new Object[]{gameId, type});
                return type;
            }
        }
        catch (Exception e) {
            MLog.error((Object)"GameWebSockectConfig", (Throwable)e);
        }
        MLog.info((Object)"GameWebSockectConfig", (String)"game:%s defaultType:%d", (Object[])new Object[]{gameId, 1});
        return 1;
    }

    private void testData() {
        if (RuntimeContext.sIsDebuggable) {
            GameWebSockectConfig.getWebSockectType("yumaoqiu_yn_dj");
            GameWebSockectConfig.getWebSockectType("lianliankan_yn");
            GameWebSockectConfig.getWebSockectType("llllllllll");
        }
    }
}

