/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.config;

import android.os.Build;
import android.text.TextUtils;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@DontProguardClass
public class GameCrashBlackConfig
extends AConfigData {
    private static List<String> mBlacks = new CopyOnWriteArrayList<String>();
    private static String deviceType;
    private static boolean hasGetBlack;
    private static boolean isBlack;

    public BssCode getBssCode() {
        return BssCode.GAME_CRASH_BLACK;
    }

    public void parseConfig(String configs) {
        mBlacks.clear();
        if (!StringUtils.isEmpty((String)configs)) {
            try {
                List datas = JsonParser.parseJsonList((String)configs, String.class);
                if (datas != null && !datas.isEmpty()) {
                    mBlacks.addAll(datas);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getBlacks() {
        return mBlacks;
    }

    public static boolean isGameBlackDevice() {
        if (!hasGetBlack) {
            hasGetBlack = true;
            for (String black : mBlacks) {
                if (!StringUtils.isNotEmpty((String)black) || !black.equalsIgnoreCase(GameCrashBlackConfig.getDeviceType())) continue;
                isBlack = true;
                return true;
            }
        }
        return isBlack;
    }

    public static String getDeviceType() {
        if (TextUtils.isEmpty((CharSequence)deviceType)) {
            deviceType = GameCrashBlackConfig.encodeHeadInfo(Build.MANUFACTURER + " " + Build.MODEL);
        }
        return deviceType != null ? deviceType : "";
    }

    private static String encodeHeadInfo(String headInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        int length = headInfo.length();
        for (int i = 0; i < length; ++i) {
            char c = headInfo.charAt(i);
            if (c <= '\u001f' || c >= '\u007f') {
                stringBuffer.append(String.format("\\u%04x", c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static {
        hasGetBlack = false;
        isBlack = false;
    }
}

