/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.svga.request;

import com.yy.framework.core.ui.svga.request.SingleRequestTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0006\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00060\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0005J<\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u0006\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u00102\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00060\u000bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/yy/framework/core/ui/svga/request/SingleRequestManager;", "", "()V", "requestTaskMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/yy/framework/core/ui/svga/request/SingleRequestTask;", "createNewTask", "T", "url", "createTaskBlock", "Lkotlin/Function0;", "onComplete", "", "startRequest", "callback", "Lcom/yy/framework/core/ui/svga/request/SingleRequestTask$SingleReqCallback;", "framework-ui_release"})
public final class SingleRequestManager {
    private static final ConcurrentHashMap<String, SingleRequestTask<?>> requestTaskMap;
    public static final SingleRequestManager INSTANCE;

    @NotNull
    public final synchronized <T> SingleRequestTask<T> createNewTask(@NotNull String url, @NotNull Function0<? extends SingleRequestTask<T>> createTaskBlock) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(createTaskBlock, (String)"createTaskBlock");
        SingleRequestTask task = requestTaskMap.get(url);
        if (task == null || task.checkNeedStartNewRequest()) {
            task = (SingleRequestTask)createTaskBlock.invoke();
            ((Map)requestTaskMap).put(url, task);
        }
        if (task == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.framework.core.ui.svga.request.SingleRequestTask<T>");
        }
        return task;
    }

    @NotNull
    public final <T> SingleRequestTask<T> startRequest(@NotNull String url, @NotNull SingleRequestTask.SingleReqCallback<T> callback, @NotNull Function0<? extends SingleRequestTask<T>> createTaskBlock) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Intrinsics.checkParameterIsNotNull(createTaskBlock, (String)"createTaskBlock");
        SingleRequestTask<T> task = this.createNewTask(url, createTaskBlock);
        task.addCallbackAndDoReq(callback);
        return task;
    }

    public final void onComplete(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        requestTaskMap.remove(url);
    }

    private SingleRequestManager() {
    }

    static {
        SingleRequestManager singleRequestManager;
        INSTANCE = singleRequestManager = new SingleRequestManager();
        requestTaskMap = new ConcurrentHashMap();
    }
}

