/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.svga;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGADynamicEntity;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.ViewSetTagRunnable;
import com.yy.base.utils.SettingFlags;
import org.jetbrains.annotations.Nullable;

public class YYSvgaImageView
extends SVGAImageView
implements IRecycleView {
    private static final String TAG = "YYSvgaImageView";
    private static final int TAG_KEY_RECYCLE_FLAG_ID = -1313134;
    private static final int TAG_KEY_IMAGE_SVGA_VIDEOENTITY = -1313131;
    private static final int TAG_KEY_IMAGE_SVGA_DYNAMICENTITY = -1313132;
    private SVGADrawable mSVGADrawable;
    private boolean mIsAttachToWindow;
    private static volatile boolean sSwitch = SettingFlags.hasInited() ? SettingFlags.getBoolean((String)"key_auto_recycle_svga", (boolean)false) : false;

    public YYSvgaImageView(@Nullable Context context) {
        super(context);
    }

    public YYSvgaImageView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public YYSvgaImageView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public YYSvgaImageView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setSVGADrawable(SVGADrawable svgaDrawable) {
        this.mSVGADrawable = svgaDrawable;
    }

    protected void onAttachedToWindow() {
        this.mIsAttachToWindow = true;
        super.onAttachedToWindow();
        if (this.mSVGADrawable != null) {
            this.setImageDrawable((Drawable)this.mSVGADrawable);
            this.startAnimation();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.mSVGADrawable = null;
    }

    public void setImageURI(@androidx.annotation.Nullable Uri uri) {
        super.setImageURI(uri);
        this.mSVGADrawable = null;
    }

    public void setImageDrawable(@androidx.annotation.Nullable Drawable drawable) {
        super.setImageDrawable(drawable);
        if (!(drawable instanceof SVGADrawable)) {
            this.mSVGADrawable = null;
        }
    }

    public void startAnimation() {
        if (this.isAttachToWindow()) {
            super.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        this.mIsAttachToWindow = false;
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void setTag(int key, Object tag) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            super.setTag(key, tag);
        } else {
            this.post((Runnable)new ViewSetTagRunnable((View)this, key, tag));
        }
    }

    public Object getTag(int key) {
        try {
            return super.getTag(key);
        }
        catch (Exception e) {
            MLog.error((Object)"YYImageView", (Throwable)e);
            return null;
        }
    }

    public void setBackgroundToNull() {
        super.setBackgroundDrawable(null);
    }

    public Drawable getBackgroundInner() {
        return super.getBackground();
    }

    public boolean isAttachToWindow() {
        return this.mIsAttachToWindow;
    }

    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    public void onWindowRealVisible() {
        this.recoveryViewDrawable();
    }

    public void onWindowInvisible() {
        if (this.isAttachToWindow()) {
            this.recycleViewDrawable();
        }
    }

    public void recoveryViewDrawable() {
        if (!sSwitch) {
            MLog.info((Object)TAG, (String)"recoveryViewDrawable cancel switch is off", (Object[])new Object[0]);
            return;
        }
        Object recycled = this.getTag(-1313134);
        if (recycled instanceof Boolean && ((Boolean)recycled).booleanValue()) {
            Object videoItem;
            this.setTag(-1313134, false);
            if (this.getDrawable() == null && (videoItem = this.getTag(-1313131)) instanceof SVGAVideoEntity) {
                Object dynamicItem = this.getTag(-1313132);
                if (dynamicItem instanceof SVGADynamicEntity) {
                    this.setVideoItem((SVGAVideoEntity)videoItem, (SVGADynamicEntity)dynamicItem);
                } else {
                    this.setVideoItem((SVGAVideoEntity)videoItem);
                }
                this.setTag(-1313131, null);
                this.setTag(-1313132, null);
                if (this.isAttachToWindow()) {
                    this.startAnimation();
                }
                MLog.debug((Object)TAG, (String)"recovery svgAimage from view:", (Object[])new Object[0]);
            }
        }
    }

    public int recycleViewDrawable() {
        if (!sSwitch) {
            MLog.info((Object)TAG, (String)"recycleViewDrawableInner cancel switch is off", (Object[])new Object[0]);
            return 0;
        }
        int recycleSize = 0;
        if (this.closeAutoRecycleDrawables()) {
            return recycleSize;
        }
        boolean recycle = false;
        Drawable drawable = this.getDrawable();
        if (drawable instanceof SVGADrawable) {
            SVGAVideoEntity videoItem = ((SVGADrawable)drawable).getVideoItem();
            SVGADynamicEntity dynamicItem = ((SVGADrawable)drawable).getDynamicItem();
            this.setTag(-1313131, videoItem);
            this.setTag(-1313132, dynamicItem);
            this.stopAnimation();
            this.setImageDrawable(null);
            recycle = true;
        }
        if (recycle) {
            this.setTag(-1313134, recycle);
        }
        return recycleSize;
    }
}

