/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.svga;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.bumptech.glide.util.LruCache;
import com.yy.base.env.RuntimeContext;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class SvgaLruCache<T> {
    private LruCache<String, WeakReferenceEntry<T>> mSvgaCache;
    private ReferenceQueue<T> mQueue;
    private int mSvgaCacheSize = RuntimeContext.getPhoneType() == 1 ? 15 : 20;

    public void put(String id, T drawable) {
        if (TextUtils.isEmpty((CharSequence)id) || drawable == null) {
            return;
        }
        if (this.mSvgaCache == null) {
            this.mSvgaCache = new LruCache((long)this.mSvgaCacheSize);
            this.mQueue = new ReferenceQueue();
        }
        this.mSvgaCache.put((Object)id, new WeakReferenceEntry<T>(id, drawable, this.mQueue));
    }

    @Nullable
    public T get(String id) {
        Object r;
        if (TextUtils.isEmpty((CharSequence)id) || this.mSvgaCache == null) {
            return null;
        }
        WeakReferenceEntry entry = (WeakReferenceEntry)this.mSvgaCache.get((Object)id);
        if (entry != null && (r = entry.get()) != null) {
            return r;
        }
        this.clearNull();
        return null;
    }

    private void clearNull() {
        WeakReferenceEntry entry;
        if (this.mQueue == null || this.mSvgaCache == null) {
            return;
        }
        while ((entry = (WeakReferenceEntry)this.mQueue.poll()) != null) {
            this.mSvgaCache.remove((Object)entry.id);
        }
    }

    private static class WeakReferenceEntry<T>
    extends WeakReference<T> {
        String id;

        WeakReferenceEntry(String id, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.id = id;
        }
    }
}

