/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.svga;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.core.view.ViewCompat;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAParser;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaCache;
import com.yy.framework.core.ui.svga.SvgaDownloader;
import com.yy.framework.core.ui.svga.SvgaLoadListener;
import com.yy.framework.core.ui.svga.SvgaLruCache;
import com.yy.framework.core.ui.svga.SvgaMemoryOptSwitch;
import com.yy.framework.core.ui.svga.SvgaParseCompletionDelegate;
import com.yy.framework.core.ui.svga.SvgaReqTask;
import com.yy.framework.core.ui.svga.SvgaSingleRequestCallback;
import com.yy.framework.core.ui.svga.YYSvgaImageView;
import com.yy.framework.core.ui.svga.request.SingleRequestManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class SvgaLoader {
    private static final String TAG = "SvgaLoader";
    private static SvgaCache<SVGAVideoEntity> mSvgaCache;
    private static SvgaLruCache<SVGAVideoEntity> mSvgaLruCache;
    private static volatile SVGAParser shareParse;
    private static SvgaDownloader svgaDownloader;
    private static SvgaLoadListener sLoadListener;
    private static SvgaLoaderProvider loaderProvider;

    public static void load(SVGAImageView svgaImageView, String url) {
        SvgaLoader.load(svgaImageView, url, false, 0, 0, null, null, null);
    }

    public static void load(SVGAImageView svgaImageView, String url, boolean autoPlaySvga) {
        SvgaLoader.load(svgaImageView, url, autoPlaySvga, 0, 0, null, null, null);
    }

    public static void load(SVGAImageView svgaImageView, String url, boolean autoPlaySvga, int placeholderId, int errorId) {
        SvgaLoader.load(svgaImageView, url, autoPlaySvga, placeholderId, errorId, null, null, null);
    }

    public static void load(SVGAImageView svgaImageView, String url, ISvgaLoadCallback callback) {
        SvgaLoader.load(svgaImageView, url, false, 0, 0, null, null, callback);
    }

    public static void load(SVGAImageView svgaImageView, String url, @DrawableRes int placeholderId) {
        SvgaLoader.load(svgaImageView, url, false, placeholderId, 0, null, null, null);
    }

    public static void load(final SVGAImageView svgaImageView, final String url, final boolean autoPlaySvga, final int placeholderId, final int errorId, final Drawable placeholderDrawable, final Drawable errorDrawable, final ISvgaLoadCallback callback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"url=%s", (Object[])new Object[]{url});
        }
        if (svgaImageView == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new NullPointerException("SVGAImageView is null");
            }
            if (callback != null) {
                callback.onFailed(new NullPointerException("SVGAImageView is null"));
            }
        }
        if (SettingFlagBaseKeys.enableSvg()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    SvgaLoader.loadAsync(svgaImageView, url, autoPlaySvga, placeholderId, errorId, placeholderDrawable, errorDrawable, callback);
                }
            });
        }
    }

    private static void load(final SVGAImageView svgaImageView, final String url, final boolean autoPlaySvga, final int placeholderId, final int errorId, final Drawable placeholderDrawable, final Drawable errorDrawable, final ISvgaLoadCallback callback, boolean isWhite) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"url=%s", (Object[])new Object[]{url});
        }
        if (svgaImageView == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new NullPointerException("SVGAImageView is null");
            }
            if (callback != null) {
                callback.onFailed(new NullPointerException("SVGAImageView is null"));
            }
        }
        if (SettingFlagBaseKeys.enableSvg()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    SvgaLoader.loadAsync(svgaImageView, url, autoPlaySvga, placeholderId, errorId, placeholderDrawable, errorDrawable, callback);
                }
            });
        }
    }

    private static void loadAsync(final SVGAImageView svgaImageView, String url, boolean autoPlaySvga, final int placeholderId, final int errorId, final Drawable placeholderDrawable, final Drawable errorDrawable, final ISvgaLoadCallback callback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"loadAsync url=%s", (Object[])new Object[]{url});
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            SvgaLoader.setErrorImage(svgaImageView, placeholderId, errorId, placeholderDrawable, errorDrawable);
            SvgaLoader.onSvgaLoadFailed(callback, new IllegalArgumentException("argument is illegal with url " + url));
        } else if (url.endsWith(".svga") || SvgaLoader.isFilePath(url)) {
            SvgaLoader.loadSvga(svgaImageView, url, autoPlaySvga, placeholderId, errorId, placeholderDrawable, errorDrawable, callback);
        } else if (url.startsWith("http")) {
            SvgaLoader.setPlaceholder(svgaImageView, placeholderId, placeholderDrawable);
            String thumbUrl = url + YYImageUtils.getThumb((View)svgaImageView, (boolean)true, (String)url);
            ImageLoader.loadBitmap((Context)svgaImageView.getContext(), (String)thumbUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                    MLog.error((Object)SvgaLoader.TAG, (Throwable)e);
                    SvgaLoader.setErrorImage(svgaImageView, placeholderId, errorId, placeholderDrawable, errorDrawable);
                    SvgaLoader.onSvgaLoadFailed(callback, e);
                }

                public void onResourceReady(Bitmap bitmap) {
                    BitmapDrawable drawable = new BitmapDrawable(bitmap);
                    SvgaLoader.setImageDrawable(svgaImageView, (Drawable)drawable);
                    SvgaLoader.onSvgaLoadFinished(callback, null);
                }
            });
        } else {
            SvgaLoader.setErrorImage(svgaImageView, placeholderId, errorId, placeholderDrawable, errorDrawable);
            SvgaLoader.onSvgaLoadFailed(callback, new IllegalArgumentException("argument is illegal with url " + url));
        }
    }

    private static boolean isFilePath(String url) {
        return YYFileUtils.isPathExist((String)url);
    }

    private static void loadSvga(final SVGAImageView svgaImageView, final String url, final boolean autoPlaySvga, final int placeholderId, final int errorId, final Drawable placeholderDrawable, final Drawable errorDrawable, final ISvgaLoadCallback callback) {
        SVGAVideoEntity entity;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"loadSvga url=%s", (Object[])new Object[]{url});
        }
        if ((entity = SvgaLoader.getFromCache(url)) != null) {
            SVGADrawable drawable = new SVGADrawable(entity);
            SvgaLoader.setSvgaDrawable(svgaImageView, drawable, autoPlaySvga);
            SvgaLoader.onSvgaLoadFinished(callback, entity);
            return;
        }
        SvgaLoader.setPlaceholder(svgaImageView, placeholderId, placeholderDrawable);
        final SVGAParser parser = new SVGAParser(svgaImageView.getContext());
        final SVGAParser.ParseCompletion listener = new SVGAParser.ParseCompletion(){

            public void onComplete(@NotNull SVGAVideoEntity videoItem) {
                SvgaLoader.putToCache(url, videoItem);
                SVGADrawable drawable = new SVGADrawable(videoItem);
                SvgaLoader.setSvgaDrawable(svgaImageView, drawable, autoPlaySvga);
                SvgaLoader.onSvgaLoadFinished(callback, videoItem);
            }

            public void onError() {
                MLog.info((Object)SvgaLoader.TAG, (String)"load svga error: %s", (Object[])new Object[]{url});
                SvgaLoader.setErrorImage(svgaImageView, placeholderId, errorId, placeholderDrawable, errorDrawable);
                SvgaLoader.onSvgaLoadFailed(callback, new Exception("parse svga failed"));
            }
        };
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SvgaLoader.parseUriInSubThread(url, parser, listener);
            }
        });
    }

    private static void parseUriInSubThread(String url, SVGAParser parser, final SVGAParser.ParseCompletion listener) {
        if (url.startsWith("http")) {
            SvgaLoader.loadSvgaFromNet(url, parser, listener);
        } else if (SvgaLoader.isFilePath(url)) {
            try {
                final FileInputStream in = new FileInputStream(url);
                parser.parse((InputStream)in, url, new SVGAParser.ParseCompletion(){

                    public void onError() {
                        if (listener != null) {
                            listener.onError();
                        }
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            MLog.error((Object)SvgaLoader.TAG, (Throwable)e);
                        }
                    }

                    public void onComplete(SVGAVideoEntity svgaVideoEntity) {
                        if (listener != null) {
                            listener.onComplete(svgaVideoEntity);
                        }
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            MLog.error((Object)SvgaLoader.TAG, (Throwable)e);
                        }
                    }
                }, false);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                parser.parse(url, listener);
            }
        } else {
            parser.parse(url, listener);
        }
    }

    public static void load(final Context context, final String url, final ISvgaLoadCallback callback) {
        SVGAVideoEntity entity;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"loadSvga url=%s", (Object[])new Object[]{url});
        }
        if ((entity = SvgaLoader.getFromCache(url)) != null) {
            SvgaLoader.onSvgaLoadFinished(callback, entity);
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SVGAParser parser = new SVGAParser(context);
                SVGAParser.ParseCompletion listener = new SVGAParser.ParseCompletion(){

                    public void onComplete(@NotNull SVGAVideoEntity videoItem) {
                        SvgaLoader.onSvgaLoadFinished(callback, videoItem);
                    }

                    public void onError() {
                        SvgaLoader.onSvgaLoadFailed(callback, new Exception("parse svga failed"));
                    }
                };
                SvgaLoader.parseUriInSubThread(url, parser, listener);
            }
        });
    }

    private static void setSvgaDrawable(final SVGAImageView svgaImageView, final SVGADrawable drawable, final boolean autoPlaySvga) {
        if (svgaImageView == null) {
            MLog.error((Object)TAG, (String)"setSvgaDrawable svgaImageView is null", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            SvgaLoader.setInnerImageDrawable(svgaImageView, drawable);
            if (autoPlaySvga && ViewCompat.isAttachedToWindow((View)svgaImageView)) {
                svgaImageView.startAnimation();
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SvgaLoader.setInnerImageDrawable(svgaImageView, drawable);
                    if (autoPlaySvga && ViewCompat.isAttachedToWindow((View)svgaImageView)) {
                        svgaImageView.startAnimation();
                    }
                }
            });
        }
    }

    private static void setInnerImageDrawable(SVGAImageView svgaImageView, SVGADrawable drawable) {
        if (svgaImageView instanceof YYSvgaImageView) {
            ((YYSvgaImageView)svgaImageView).setSVGADrawable(drawable);
            ((YYSvgaImageView)svgaImageView).setImageDrawable((Drawable)drawable);
        } else {
            svgaImageView.setImageDrawable((Drawable)drawable);
        }
    }

    private static void setImageDrawable(final SVGAImageView svgaImageView, final Drawable drawable) {
        if (svgaImageView == null) {
            MLog.error((Object)TAG, (String)"setImageDrawable svgaImageView is null", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            svgaImageView.setImageDrawable(drawable);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    svgaImageView.setImageDrawable(drawable);
                }
            });
        }
    }

    private static void setImageRes(final SVGAImageView svgaImageView, final int id2) {
        if (svgaImageView == null) {
            MLog.error((Object)TAG, (String)"setImageRes svgaImageView is null", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            svgaImageView.setImageResource(id2);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    svgaImageView.setImageResource(id2);
                }
            });
        }
    }

    private static void setErrorImage(SVGAImageView svgaImageView, int placeholderId, int errorId, Drawable placeholderDrawable, Drawable errorDrawable) {
        if (errorDrawable != null) {
            SvgaLoader.setImageDrawable(svgaImageView, errorDrawable);
        } else if (errorId > 0) {
            SvgaLoader.setImageRes(svgaImageView, errorId);
        } else if (placeholderDrawable != null) {
            SvgaLoader.setImageDrawable(svgaImageView, placeholderDrawable);
        } else if (placeholderId > 0) {
            SvgaLoader.setImageRes(svgaImageView, placeholderId);
        }
    }

    private static void setPlaceholder(SVGAImageView svgaImageView, int placeholderId, Drawable placeholderDrawable) {
        if (placeholderDrawable != null) {
            SvgaLoader.setImageDrawable(svgaImageView, placeholderDrawable);
        } else if (placeholderId > 0) {
            SvgaLoader.setImageRes(svgaImageView, placeholderId);
        }
    }

    private static SVGAVideoEntity getFromCache(String url) {
        if (SvgaMemoryOptSwitch.isEnable()) {
            if (mSvgaLruCache == null) {
                return null;
            }
            return mSvgaLruCache.get(url);
        }
        if (mSvgaCache == null) {
            return null;
        }
        return mSvgaCache.get(url);
    }

    private static void putToCache(String url, SVGAVideoEntity drawable) {
        if (SvgaMemoryOptSwitch.isEnable()) {
            if (mSvgaLruCache == null) {
                mSvgaLruCache = new SvgaLruCache();
            }
            mSvgaLruCache.put(url, drawable);
        } else {
            if (mSvgaCache == null) {
                mSvgaCache = new SvgaCache();
            }
            mSvgaCache.put(url, drawable);
        }
    }

    private static void onSvgaLoadFinished(final ISvgaLoadCallback callback, final SVGAVideoEntity entity) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFinished(entity);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onFinished(entity);
                }
            });
        }
    }

    private static void onSvgaLoadFailed(final ISvgaLoadCallback callback, final Exception e) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFailed(e);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onFailed(e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SVGAParser getShareParser() {
        if (shareParse != null) return shareParse;
        Class<SvgaLoader> clazz = SvgaLoader.class;
        synchronized (SvgaLoader.class) {
            if (shareParse != null) return shareParse;
            shareParse = new SVGAParser(RuntimeContext.sApplicationContext);
            svgaDownloader = new SvgaDownloader();
            if (sLoadListener != null) {
                svgaDownloader.setSvgaLoadListener(sLoadListener);
            }
            shareParse.setFileDownloader((SVGAParser.FileDownloader)svgaDownloader);
            // ** MonitorExit[var0] (shouldn't be in output)
            return shareParse;
        }
    }

    private static void loadSvgaFromNet(String url, SVGAParser parser, SVGAParser.ParseCompletion listener) {
        if (SvgaLoader.getProvider().useV2Loader()) {
            SingleRequestManager.INSTANCE.startRequest(url, new SvgaSingleRequestCallback(listener), () -> new SvgaReqTask(url, sLoadListener));
        } else {
            SVGAParser.ParseCompletion l = sLoadListener != null ? new SvgaParseCompletionDelegate(listener, url, sLoadListener) : listener;
            try {
                String replaceUrl = URLUtils.replaceUrl((String)url);
                parser.decodeFromURL(new URL(replaceUrl), l);
            }
            catch (MalformedURLException e) {
                MLog.error((Object)TAG, (Throwable)e);
                parser.parse(url, l);
            }
        }
    }

    public static void setLoadMetric(SvgaLoadListener metric) {
        sLoadListener = metric;
        if (svgaDownloader != null) {
            svgaDownloader.setSvgaLoadListener(metric);
        }
    }

    public static void setLoaderProvider(SvgaLoaderProvider provider) {
        loaderProvider = provider;
    }

    private static SvgaLoaderProvider getProvider() {
        if (loaderProvider == null) {
            loaderProvider = () -> false;
        }
        return loaderProvider;
    }

    public static interface SvgaLoaderProvider {
        public boolean useV2Loader();
    }
}

