/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.svga;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public class SvgaCache<T> {
    private ConcurrentHashMap<String, WeakReferenceEntry<T>> mSvgaCache;
    private ReferenceQueue<T> mQueue;

    public void put(String id2, T drawable) {
        if (TextUtils.isEmpty((CharSequence)id2) || drawable == null) {
            return;
        }
        if (this.mSvgaCache == null) {
            this.mSvgaCache = new ConcurrentHashMap();
            this.mQueue = new ReferenceQueue();
        }
        this.mSvgaCache.put(id2, new WeakReferenceEntry<T>(id2, drawable, this.mQueue));
    }

    @Nullable
    public T get(String id2) {
        Object r;
        if (TextUtils.isEmpty((CharSequence)id2) || this.mSvgaCache == null) {
            return null;
        }
        WeakReferenceEntry<T> entry = this.mSvgaCache.get(id2);
        if (entry != null && (r = entry.get()) != null) {
            return r;
        }
        this.clearNull();
        return null;
    }

    private void clearNull() {
        WeakReferenceEntry entry;
        if (this.mQueue == null || this.mSvgaCache == null) {
            return;
        }
        while ((entry = (WeakReferenceEntry)this.mQueue.poll()) != null) {
            this.mSvgaCache.remove(entry.id);
        }
    }

    private static class WeakReferenceEntry<T>
    extends WeakReference<T> {
        String id;

        WeakReferenceEntry(String id2, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.id = id2;
        }
    }
}

