/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.recyclerview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.framework.core.ui.recyclerview.BaseViewHolder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J$\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J$\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u001e\u0010 \u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0006H\u0016J\u0016\u0010&\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010'\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010(\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J,\u0010)\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\u0014\u0010+\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0011J\u0014\u0010,\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\tJ$\u0010-\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J$\u0010.\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u0010\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0016R \u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000e\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/yy/framework/core/ui/recyclerview/BaseAdapter;", "T", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/yy/framework/core/ui/recyclerview/BaseViewHolder;", "mTypeFunction", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "mList", "", "getMList", "()Ljava/util/List;", "setMList", "(Ljava/util/List;)V", "mTypeHolders", "", "Lkotlin/Pair;", "Ljava/lang/Class;", "getItem", "position", "(I)Ljava/lang/Object;", "getItemCount", "getItemId", "", "getItemViewType", "insertData", "", "list", "count", "moveData", "from", "length", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewAttachedToWindow", "onViewDetachedFromWindow", "onViewRecycled", "register", "layoutRes", "holderClass", "reloadData", "removeData", "replaceData", "setHasStableIds", "hasStableIds", "", "framework-ui_release"})
public class BaseAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder<T>> {
    @NotNull
    private List<? extends T> mList;
    private final Map<Integer, Pair<Integer, Class<? extends BaseViewHolder<T>>>> mTypeHolders;
    private final Function1<Integer, Integer> mTypeFunction;

    @NotNull
    protected final List<T> getMList() {
        return this.mList;
    }

    protected final void setMList(@NotNull List<? extends T> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.mList = list;
    }

    public final void register(int viewType, int layoutRes, @NotNull Class<? extends BaseViewHolder<T>> holderClass) {
        Intrinsics.checkParameterIsNotNull(holderClass, (String)"holderClass");
        this.mTypeHolders.put(viewType, new Pair((Object)layoutRes, holderClass));
    }

    public void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
    }

    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @NotNull
    public BaseViewHolder<T> onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Pair<Integer, Class<? extends BaseViewHolder<T>>> pair;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Pair<Integer, Class<? extends BaseViewHolder<T>>> pair2 = pair = this.mTypeHolders.get(viewType);
        if (pair2 == null) {
            Intrinsics.throwNpe();
        }
        Object t = ((Class)pair2.getSecond()).getConstructor(View.class).newInstance(LayoutInflater.from((Context)parent.getContext()).inflate(((Number)pair.getFirst()).intValue(), parent, false));
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"pair!!.second.getConstru\u2026ir.first, parent, false))");
        return (BaseViewHolder)((Object)t);
    }

    public void onBindViewHolder(@NotNull BaseViewHolder<T> holder, int position) {
        Intrinsics.checkParameterIsNotNull(holder, (String)"holder");
        holder.update(position, this.getItem(position));
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public final T getItem(int position) {
        return this.mList.get(position);
    }

    public final int getItemViewType(int position) {
        return ((Number)this.mTypeFunction.invoke((Object)position)).intValue();
    }

    public void onViewRecycled(@NotNull BaseViewHolder<T> holder) {
        Intrinsics.checkParameterIsNotNull(holder, (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onViewRecycled();
    }

    public void onViewAttachedToWindow(@NotNull BaseViewHolder<T> holder) {
        Intrinsics.checkParameterIsNotNull(holder, (String)"holder");
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.onViewAttachedToWindow();
    }

    public void onViewDetachedFromWindow(@NotNull BaseViewHolder<T> holder) {
        Intrinsics.checkParameterIsNotNull(holder, (String)"holder");
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onViewDetachedFromWindow();
    }

    public final void insertData(@NotNull List<? extends T> list, int position, int count) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.mList = list;
        this.notifyItemRangeInserted(position, count);
    }

    public final void removeData(@NotNull List<? extends T> list, int position, int count) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.mList = list;
        this.notifyItemRangeRemoved(position, count);
    }

    public final void replaceData(@NotNull List<? extends T> list, int position, int count) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.mList = list;
        this.notifyItemRangeChanged(position, count);
    }

    public final void moveData(@NotNull List<? extends T> list, int from, int length) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.mList = list;
        this.notifyItemMoved(from, from + length);
    }

    public final void reloadData(@NotNull List<? extends T> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.mList = list;
        this.notifyDataSetChanged();
    }

    public BaseAdapter(@NotNull Function1<? super Integer, Integer> mTypeFunction) {
        Intrinsics.checkParameterIsNotNull(mTypeFunction, (String)"mTypeFunction");
        this.mTypeFunction = mTypeFunction;
        BaseAdapter baseAdapter = this;
        boolean bl = false;
        Object object = new ArrayList();
        baseAdapter.mList = object;
        baseAdapter = this;
        bl = false;
        baseAdapter.mTypeHolders = object = (Map)new LinkedHashMap();
    }

    public /* synthetic */ BaseAdapter(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super Integer, Integer>)function1);
    }

    public BaseAdapter() {
        this(null, 1, null);
    }
}

