/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.dialog.frame.YYDialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ImeUtil;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class YYDialog
extends Dialog {
    private static final String TAG = "YYDialog";
    private static DialogInterface.OnCancelListener sCancelListener;
    private static DialogInterface.OnDismissListener sDismissListener;
    private static OnDialogShowCallback sOnDialogShowCallback;
    private static ArrayList<WeakReference<Dialog>> sDialogs;
    private static boolean sOtherPopShowing;
    private DialogInterface.OnDismissListener mDismissListener;
    private DialogInterface.OnCancelListener mCancelListener;
    private int dialogId = -1;

    public static void setOtherPopShowing(boolean showing) {
        sOtherPopShowing = showing;
    }

    public YYDialog(@NonNull Context context) {
        super(context);
        this.removeWindowBackground();
    }

    public YYDialog(@NonNull Context context, @StyleRes int themeResId) {
        super(context, themeResId);
        this.removeWindowBackground();
    }

    protected YYDialog(@NonNull Context context, boolean cancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.removeWindowBackground();
    }

    private void removeWindowBackground() {
        if (this.getWindow() != null) {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.getWindow().setGravity(17);
        }
    }

    public void setOnCancelListener(final @Nullable DialogInterface.OnCancelListener listener) {
        this.mCancelListener = listener;
        super.setOnCancelListener((DialogInterface.OnCancelListener)new MyOnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (sCancelListener != null) {
                    sCancelListener.onCancel(dialog);
                }
                if (listener != null) {
                    listener.onCancel(dialog);
                }
                YYDialog.this.mCancelListener = null;
            }
        });
    }

    public DialogInterface.OnDismissListener getDismisslistener() {
        return this.mDismissListener;
    }

    public DialogInterface.OnCancelListener getCancellistener() {
        return this.mCancelListener;
    }

    public void setOnDismissListener(final @Nullable DialogInterface.OnDismissListener listener) {
        this.mDismissListener = listener;
        super.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                YYDialog.deleteShowDialog(YYDialog.this);
                if (sDismissListener != null) {
                    sDismissListener.onDismiss(dialog);
                }
                if (listener != null) {
                    listener.onDismiss(dialog);
                }
                YYDialog.this.mDismissListener = null;
                NotificationCenter.getGlobalInstance().notify(Notification.obtain(NotificationDef.N_DIALOG_DISMISS));
            }
        });
    }

    public void show() {
        YYDialog.addShowDialog(this);
        if (this.mDismissListener == null) {
            this.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                }
            });
        }
        if (this.mCancelListener == null) {
            this.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                }
            });
        }
        try {
            super.show();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public static void setGlobalDialogCancelListener(DialogInterface.OnCancelListener listener) {
        sCancelListener = listener;
    }

    public static void setGlobalDialogDismissListener(DialogInterface.OnDismissListener listener) {
        sDismissListener = listener;
    }

    public static void setOnDialogShowCallback(OnDialogShowCallback listener) {
        sOnDialogShowCallback = listener;
    }

    public static DialogInterface.OnCancelListener getGlobalListener() {
        return sCancelListener;
    }

    public static DialogInterface.OnDismissListener getGlobalDismissListener() {
        return sDismissListener;
    }

    public static synchronized void addShowDialog(Dialog dialog) {
        Dialog itemDialog = null;
        boolean exist = false;
        for (WeakReference<Dialog> item : sDialogs) {
            itemDialog = (Dialog)item.get();
            if (itemDialog == null || itemDialog != dialog) continue;
            exist = true;
            break;
        }
        if (!exist) {
            sDialogs.add(new WeakReference<Dialog>(dialog));
        }
        if (sOnDialogShowCallback != null) {
            sOnDialogShowCallback.onDialogShow(dialog);
        }
    }

    public static synchronized void deleteShowDialog(Dialog dialog) {
        Dialog itemDialog = null;
        for (WeakReference<Dialog> item : sDialogs) {
            itemDialog = (Dialog)item.get();
            if (itemDialog == null || itemDialog != dialog) continue;
            sDialogs.remove(item);
            break;
        }
        if (sOnDialogShowCallback != null) {
            sOnDialogShowCallback.onDialogHide(dialog);
        }
    }

    public static synchronized boolean hasDialogShowing() {
        if (sOtherPopShowing) {
            MLog.info((Object)TAG, (String)"has other popWindow showing", (Object[])new Object[0]);
            return true;
        }
        Dialog itemDialog = null;
        for (WeakReference<Dialog> item : sDialogs) {
            itemDialog = (Dialog)item.get();
            if (itemDialog == null || !itemDialog.isShowing()) continue;
            return true;
        }
        return false;
    }

    public static synchronized void hideAllDialog() {
        Dialog itemDialog = null;
        for (WeakReference<Dialog> item : sDialogs) {
            itemDialog = (Dialog)item.get();
            if (itemDialog == null || !itemDialog.isShowing()) continue;
            itemDialog.dismiss();
        }
    }

    public void dismiss() {
        View view = this.getCurrentFocus();
        if (view instanceof EditText) {
            ImeUtil.hideIME((Context)this.getContext(), (View)view);
        }
        super.dismiss();
    }

    public void setDialogID(int id2) {
        this.dialogId = id2;
    }

    public int getDialogId() {
        return this.dialogId;
    }

    static {
        sDialogs = new ArrayList();
        sOtherPopShowing = false;
    }

    public static interface OnDialogShowCallback {
        public void onDialogShow(Dialog var1);

        public void onDialogHide(Dialog var1);
    }

    public static interface MyOnCancelListener
    extends DialogInterface.OnCancelListener {
    }
}

