/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.dialog.frame.YYDialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ImeUtil;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;

public class YYAlertDialog
extends AlertDialog {
    private static final String TAG = "YYAlertDialog";
    private DialogInterface.OnDismissListener mDismissListener;
    private DialogInterface.OnCancelListener mCancelListener;

    public YYAlertDialog(@NonNull Context context) {
        super(context);
        this.removeWindowBackground();
    }

    public YYAlertDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        this.removeWindowBackground();
    }

    private void removeWindowBackground() {
        if (this.getWindow() != null) {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.getWindow().setGravity(17);
        }
    }

    public void setOnCancelListener(final @Nullable DialogInterface.OnCancelListener listener) {
        this.mCancelListener = listener;
        super.setOnCancelListener((DialogInterface.OnCancelListener)new YYDialog.MyOnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                DialogInterface.OnCancelListener sCancelListener = YYDialog.getGlobalListener();
                if (sCancelListener != null) {
                    sCancelListener.onCancel(dialog);
                }
                if (listener != null) {
                    listener.onCancel(dialog);
                }
                YYAlertDialog.this.mCancelListener = null;
            }
        });
    }

    public void show() {
        YYDialog.addShowDialog((Dialog)this);
        if (this.mDismissListener == null) {
            this.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                }
            });
        }
        if (this.mCancelListener == null) {
            this.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                }
            });
        }
        try {
            super.show();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void setOnDismissListener(final @Nullable DialogInterface.OnDismissListener listener) {
        this.mDismissListener = listener;
        super.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                YYDialog.deleteShowDialog((Dialog)YYAlertDialog.this);
                if (YYDialog.getGlobalDismissListener() != null) {
                    YYDialog.getGlobalDismissListener().onDismiss(dialog);
                }
                if (listener != null) {
                    listener.onDismiss(dialog);
                }
                YYAlertDialog.this.mDismissListener = null;
            }
        });
    }

    public void dismiss() {
        View view = this.getCurrentFocus();
        if (view instanceof EditText) {
            ImeUtil.hideIME((Context)this.getContext(), (View)view);
        }
        super.dismiss();
    }
}

