/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui.dialog.frame;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.R;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.SkipDialogKt;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYAlertDialog;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYFullScreenAlertDialog;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.framework.core.ui.dialog.popmenu.CommonPopupDialog;
import com.yy.framework.core.ui.dialog.popmenu.MenuItemListAdapter;
import com.yy.framework.core.ui.dialog.popmenu.OnItemClickListener;
import java.lang.ref.WeakReference;
import java.util.List;

public class DialogLinkManager {
    private static final String TAG = "DialogLinkManager";
    public Dialog mDialog;
    public WeakReference<Context> mContext;
    private boolean mReCreate = true;
    private static int sShowingDialogId = Integer.MIN_VALUE;

    public DialogLinkManager(Context context) {
        this.mContext = new WeakReference<Context>(context);
    }

    public void updateContext(Context context) {
        this.mContext = new WeakReference<Context>(context);
    }

    private YYAlertDialog createDialog() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            context = RuntimeContext.sApplicationContext;
        }
        YYAlertDialog dialog = new YYAlertDialog(context){

            public void setContentView(int layoutResID) {
                YYFrameLayout parent = new YYFrameLayout(this.getContext());
                View view = LayoutInflater.from((Context)this.getContext()).inflate(layoutResID, (ViewGroup)parent, true);
                if (view.getLayoutParams() instanceof FrameLayout.LayoutParams) {
                    FrameLayout.LayoutParams temp = (FrameLayout.LayoutParams)view.getLayoutParams();
                    temp.gravity = DialogLinkManager.this.makeCenterHorizon(temp.gravity);
                }
                this.setContentView((View)parent, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }

            public void setContentView(@NonNull View view) {
                this.setContentView(view, view.getLayoutParams());
            }

            public void setContentView(@NonNull View view, @Nullable ViewGroup.LayoutParams params) {
                DialogLinkManager.this.makeCenter(view, params);
                super.setContentView(view, view.getLayoutParams());
            }
        };
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private YYAlertDialog createFullScreenDialog() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            context = RuntimeContext.sApplicationContext;
        }
        YYFullScreenAlertDialog dialog = new YYFullScreenAlertDialog(context);
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private void makeCenter(@NonNull View view, @Nullable ViewGroup.LayoutParams params) {
        FrameLayout.LayoutParams temp;
        if (params == null) {
            if (view.getLayoutParams() == null) {
                temp = new FrameLayout.LayoutParams(-1, -1);
                temp.gravity = 17;
                view.setLayoutParams((ViewGroup.LayoutParams)temp);
            }
        } else {
            view.setLayoutParams(params);
        }
        if (view.getLayoutParams() instanceof FrameLayout.LayoutParams) {
            temp = (FrameLayout.LayoutParams)view.getLayoutParams();
            temp.gravity = this.makeCenterHorizon(temp.gravity);
        }
        if (view instanceof ViewGroup && ((ViewGroup)view).getChildCount() == 1) {
            View child = ((ViewGroup)view).getChildAt(0);
            ViewGroup.LayoutParams childParam = child.getLayoutParams();
            if (childParam instanceof FrameLayout.LayoutParams) {
                ((FrameLayout.LayoutParams)child.getLayoutParams()).gravity = this.makeCenterHorizon(((FrameLayout.LayoutParams)childParam).gravity);
            } else if (childParam instanceof RelativeLayout.LayoutParams) {
                ((RelativeLayout.LayoutParams)child.getLayoutParams()).addRule(14);
            } else if (childParam instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)child.getLayoutParams()).leftToLeft = 0;
                ((ConstraintLayout.LayoutParams)child.getLayoutParams()).rightToRight = 0;
            }
        }
    }

    private int makeCenterHorizon(int from) {
        if (from == -1) {
            return 1;
        }
        return from | 1;
    }

    @TargetApi(value=17)
    public boolean checkActivityValid() {
        if (this.mContext == null || this.mContext.get() == null) {
            MLog.warn((Object)TAG, (String)("Fragment " + this + " not attached to Activity"), (Object[])new Object[0]);
            return false;
        }
        if (this.mDialog != null && this.mDialog.getWindow() == null) {
            MLog.warn((Object)TAG, (String)"window null", (Object[])new Object[0]);
            return false;
        }
        if (this.mContext.get() instanceof Activity && ((Activity)this.mContext.get()).isFinishing()) {
            MLog.warn((Object)TAG, (String)"activity is finishing", (Object[])new Object[0]);
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && this.mContext.get() instanceof Activity && ((Activity)this.mContext.get()).isDestroyed()) {
            MLog.warn((Object)TAG, (String)"activity is isDestroyed", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public static void onMainActivityWindowFocusChanged(boolean hasFocus) {
        MLog.info((Object)TAG, (String)"onMainActivityWindowFocusChanged hasFocus: %b, sShowingDialogId: %d", (Object[])new Object[]{hasFocus, sShowingDialogId});
        if (hasFocus) {
            sShowingDialogId = Integer.MIN_VALUE;
        }
    }

    public static boolean isGlobalDialogShowing() {
        return sShowingDialogId != Integer.MIN_VALUE;
    }

    public static int getGlobalDialogId() {
        return sShowingDialogId;
    }

    public boolean isDialogShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }

    public int getShowingDialogId() {
        if (this.mDialog != null && this.mDialog.isShowing() && this.mDialog instanceof CommonPopupDialog) {
            return ((CommonPopupDialog)this.mDialog).getId();
        }
        if (this.mDialog != null && this.mDialog.isShowing() && this.mDialog instanceof BaseDialog) {
            return ((BaseDialog)this.mDialog).getId();
        }
        return 0;
    }

    public void dismissDialog() {
        if (this.mContext != null && this.mContext.get() != null && this.mDialog != null && this.mDialog.getWindow() != null) {
            if (this.mContext.get() instanceof Activity) {
                Activity activity = (Activity)this.mContext.get();
                if (!activity.isFinishing()) {
                    this.dismissDialog(this.mDialog);
                }
            } else {
                this.dismissDialog(this.mDialog);
            }
        }
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener listener) {
        this.mDialog.setOnDismissListener(listener);
    }

    public PopupWindow showPopupMenuDialog(View anchor, String[] items, int[] txtColors, boolean showImmediately, final OnItemClickListener listener) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showPopupMenuDialog ActivityInvalid....", (Object[])new Object[0]);
            return null;
        }
        int maxWidth = ResolutionUtils.dip2Px((float)150.0f);
        for (String item : items) {
            if (!(this.getTextWidth(RuntimeContext.sApplicationContext, item, 13) + (float)ResolutionUtils.dip2Px((float)60.0f) > (float)maxWidth)) continue;
            maxWidth = (int)(this.getTextWidth(RuntimeContext.sApplicationContext, item, 13) + (float)ResolutionUtils.dip2Px((float)60.0f));
        }
        Context context = (Context)this.mContext.get();
        View contentView = LayoutInflater.from((Context)context).inflate(R.layout.layout_items_dialog, null, false);
        final PopupWindow popupWindow = new PopupWindow(context);
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        popupWindow.setOutsideTouchable(true);
        popupWindow.setTouchable(true);
        popupWindow.setFocusable(true);
        popupWindow.setContentView(contentView);
        popupWindow.setWidth(maxWidth);
        popupWindow.setHeight(ResourceUtils.getDimen((int)R.dimen.popup_menu_height) * items.length + 66);
        ListView listView = (ListView)contentView.findViewById(R.id.list_view);
        listView.setAdapter((ListAdapter)new MenuItemListAdapter(context, items, txtColors));
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                popupWindow.dismiss();
                if (listener != null) {
                    listener.onItemClick(popupWindow, position);
                }
            }
        });
        if (showImmediately) {
            popupWindow.showAsDropDown(anchor);
        }
        return popupWindow;
    }

    public float getTextWidth(Context context, String text, int textSize) {
        TextPaint paint = new TextPaint();
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        paint.setTextSize(scaledDensity * (float)textSize);
        return paint.measureText(text);
    }

    public void showInputDialog(@LayoutRes int layoutResID, CharSequence message, CharSequence desc, CharSequence defaultInput, CharSequence inputHint, String okBtnText, boolean cancelable, boolean autoShowIme, final boolean autoHideIme, final InputDialogListener listener, boolean showClose) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showInputDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.hide();
        }
        this.mDialog = this.createDialog();
        this.mDialog.setCancelable(cancelable);
        this.showDialog(this.mDialog);
        Window window = this.mDialog.getWindow();
        window.setContentView(layoutResID == 0 ? R.layout.layout_link_input_dialog : layoutResID);
        window.clearFlags(131072);
        window.setSoftInputMode(4);
        TextView tvTitle = (TextView)window.findViewById(R.id.tv_title);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            tvTitle.setText(message);
        }
        final EditText etInput = (EditText)window.findViewById(R.id.et_input_text);
        if (autoShowIme) {
            etInput.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (etInput.isFocused()) {
                        if (DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null && DialogLinkManager.this.mContext.get() instanceof Activity) {
                            DeviceManager.showInputMethod((Activity)DialogLinkManager.this.mContext.get(), (View)etInput);
                        }
                        if (Build.VERSION.SDK_INT >= 16) {
                            etInput.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            etInput.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)inputHint)) {
            etInput.setHint(inputHint);
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            TextView tvDesc = (TextView)window.findViewById(R.id.tv_description);
            tvDesc.setText(desc);
            tvDesc.setVisibility(0);
        }
        View closeView = window.findViewById(R.id.exit_dismiss);
        if (showClose) {
            closeView.setVisibility(0);
            closeView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (listener != null) {
                        listener.onExit();
                    }
                    if (autoHideIme && DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null) {
                        DeviceManager.hideInputMethod((Context)((Activity)DialogLinkManager.this.mContext.get()), (View)etInput);
                    }
                    DialogLinkManager.this.dismissDialog();
                }
            });
        } else if (closeView != null) {
            closeView.setVisibility(8);
        }
        final TextView btnOk = (TextView)window.findViewById(R.id.btn_ok);
        if (okBtnText != null) {
            btnOk.setText((CharSequence)okBtnText);
        }
        if (defaultInput != null) {
            etInput.setText(defaultInput);
            btnOk.setEnabled(true);
        }
        etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (StringUtils.isEmpty((String)s.toString())) {
                    btnOk.setEnabled(false);
                } else {
                    btnOk.setEnabled(true);
                }
            }
        });
        btnOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean confirmResult = true;
                if (listener != null) {
                    String input = etInput.getText().toString();
                    confirmResult = listener.confirm(input);
                }
                if (autoHideIme && DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null) {
                    DeviceManager.hideInputMethod((Context)((Activity)DialogLinkManager.this.mContext.get()), (View)etInput);
                }
                if (confirmResult) {
                    DialogLinkManager.this.dismissDialog();
                }
            }
        });
        window.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.cancel();
                }
                if (autoHideIme && DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null) {
                    DeviceManager.hideInputMethod((Context)((Activity)DialogLinkManager.this.mContext.get()), (View)etInput);
                }
                DialogLinkManager.this.dismissDialog();
            }
        });
    }

    public void showInputDialog(CharSequence message, CharSequence desc, CharSequence defaultInput, CharSequence inputHint, String okBtnText, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(0, message, desc, defaultInput, inputHint, okBtnText, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, String desc, String defaultInput, String inputHint, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(message, desc, defaultInput, inputHint, null, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, String desc, String inputHint, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(message, desc, null, inputHint, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, String desc, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(message, desc, null, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(message, null, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener) {
        this.showInputDialog(message, null, cancelable, autoShowIme, autoHideIme, listener, false);
    }

    public void showCommonPopupDialog(List<ButtonItem> btnItems, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(null, btnItems, "", cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(int id2, List<ButtonItem> btnItems, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(id2, null, btnItems, "", cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(String cancelBtnText, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(null, null, cancelBtnText, cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(ButtonItem bottomButton, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(null, null, bottomButton, cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(String title, List<ButtonItem> btnItems, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(title, btnItems, "", cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(List<ButtonItem> btnItems, String cancelBtnText, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(null, btnItems, cancelBtnText, cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(List<ButtonItem> btnItems, ButtonItem bottomButton, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(null, btnItems, bottomButton, cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(int id2, String title, List<ButtonItem> btnItems, ButtonItem bottomButton, boolean cancelable, boolean outsideCancelable) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showCommonPopupDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.hide();
        }
        this.mDialog = new CommonPopupDialog(id2, (Context)this.mContext.get(), title, btnItems, bottomButton);
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.showDialog(this.mDialog);
    }

    public void showCommonPopupDialog(String title, List<ButtonItem> btnItems, ButtonItem bottomButton, boolean cancelable, boolean outsideCancelable) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showCommonPopupDialog ActivityInvalid.", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.hide();
        }
        this.mDialog = new CommonPopupDialog((Context)this.mContext.get(), title, btnItems, bottomButton);
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.showDialog(this.mDialog);
    }

    public void showCommonPopupDialog(String title, List<ButtonItem> btnItems, String cancelBtnText, boolean cancelable, boolean outsideCancelable) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showCommonPopupDialog ActivityInvalid..", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.hide();
        }
        if (this.mContext == null || this.mContext.get() == null) {
            return;
        }
        this.mDialog = new CommonPopupDialog((Context)this.mContext.get(), title, btnItems, cancelBtnText);
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.showDialog(this.mDialog);
    }

    public void showCommonPopupDialog(int id2, String title, List<ButtonItem> btnItems, String cancelBtnText, boolean cancelable, boolean outsideCancelable) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showCommonPopupDialog ActivityInvalid..", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.hide();
        }
        if (this.mContext == null || this.mContext.get() == null) {
            return;
        }
        this.mDialog = new CommonPopupDialog(id2, (Context)this.mContext.get(), title, btnItems, cancelBtnText);
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.showDialog(this.mDialog);
    }

    public boolean showDialog(BaseDialog baseDialog) {
        if (SkipDialogKt.shouldSkip(baseDialog)) {
            return false;
        }
        return this.innerShowDialog(baseDialog, false);
    }

    private boolean innerShowDialog(BaseDialog baseDialog, Boolean fullScreen) {
        block4: {
            if (!this.checkActivityValid()) {
                MLog.info((Object)TAG, (String)"showTitleMessageClickableOkCancelDialog ActivityInvalid....", (Object[])new Object[0]);
                return false;
            }
            if (this.mDialog != null && this.mDialog.isShowing()) {
                this.dismissDialog(this.mDialog);
            }
            this.mDialog = fullScreen != false ? this.createFullScreenDialog() : this.createDialog();
            this.showDialog(this.mDialog);
            baseDialog.init(this.mDialog);
            try {
                ViewGroup parent = (ViewGroup)this.mDialog.getWindow().findViewById(0x1020002);
                this.makeCenter(parent.getChildAt(0), parent.getChildAt(0).getLayoutParams());
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                if (!RuntimeContext.sIsDebuggable) break block4;
                throw e;
            }
        }
        sShowingDialogId = baseDialog.getId();
        return true;
    }

    public boolean showFullscreenDialog(BaseDialog baseDialog) {
        return this.innerShowDialog(baseDialog, true);
    }

    public void showTransparentDialog(BaseDialog baseDialog) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showTransparentDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.dismissDialog(this.mDialog);
        }
        this.mDialog = new YYDialog((Context)this.mContext.get(), R.style.CusTransparentDialog);
        this.showDialog(this.mDialog);
        baseDialog.init(this.mDialog);
    }

    private void showDialog(Dialog dialog) {
        if (dialog == null) {
            return;
        }
        YYDialog.addShowDialog(dialog);
        dialog.show();
    }

    private void dismissDialog(Dialog dialog) {
        if (dialog == null) {
            return;
        }
        dialog.dismiss();
    }

    public static interface TipTextListener {
        public void onClick();
    }

    public static interface OkDialogListener {
        public void onOk();
    }

    public static interface InputDialogListener {
        public void cancel();

        public boolean confirm(String var1);

        public void onExit();
    }

    public static interface OkCancelDialogListener {
        public void onCancel();

        public void onOk();
    }
}

