/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import com.yy.base.memoryrecycle.views.YYTextView;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class XQJustifyTextView
extends YYTextView {
    private static final String TAG = XQJustifyTextView.class.getSimpleName();
    private static final int GRAVITY_START = 1001;
    private static final int GRAVITY_END = 1002;
    private static final int GRAVITY_CENTER = 1003;
    private float mLineY;
    private int mViewWidth;
    private int paragraphSpacing = XQJustifyTextView.dipToPx(this.getContext(), 15.0f);
    private int lineSpacing = XQJustifyTextView.dipToPx(this.getContext(), 2.0f);
    private ArrayList<List<List<String>>> mParagraphLineList;
    private int mLineCount;
    private ArrayList<List<String>> mParagraphWordList;
    private static final String BLANK = " ";
    private String[] vowel = new String[]{"a", "e", "i", "o", "u"};
    private List<String> vowels = Arrays.asList(this.vowel);
    private int measuredWidth;
    private int paddingStart;
    private int paddingEnd;
    private int paddingTop;
    private int paddingBottom;
    private int textGravity;

    public XQJustifyTextView(Context context) {
        this(context, null);
    }

    public XQJustifyTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XQJustifyTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isSpan()) {
            return;
        }
        this.mParagraphLineList = null;
        this.mParagraphWordList = null;
        this.mLineY = 0.0f;
        this.measuredWidth = this.getMeasuredWidth();
        this.paddingStart = this.getPaddingStart();
        this.paddingEnd = this.getPaddingEnd();
        this.paddingTop = this.getPaddingTop();
        this.paddingBottom = this.getPaddingBottom();
        this.mViewWidth = this.measuredWidth - this.paddingStart - this.paddingEnd;
        this.getParagraphList();
        for (List<String> frontList : this.mParagraphWordList) {
            this.mParagraphLineList.add(this.getLineList(frontList));
        }
        this.setMeasuredDimension(this.measuredWidth, (this.mParagraphLineList.size() - 1) * this.paragraphSpacing + this.mLineCount * (this.getLineHeight() + this.lineSpacing) + this.paddingTop + this.paddingBottom);
    }

    protected void onDraw(Canvas canvas) {
        if (this.isSpan()) {
            super.onDraw(canvas);
            return;
        }
        TextPaint paint = this.getPaint();
        paint.setColor(this.getCurrentTextColor());
        paint.drawableState = this.getDrawableState();
        this.mLineY = 0.0f;
        float textSize = this.getTextSize();
        this.mLineY += textSize + (float)this.paddingTop;
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return;
        }
        this.textGravity = this.getTextGravity();
        this.adjust(canvas, paint);
    }

    private synchronized List<List<String>> getLineList(List<String> frontList) {
        Log.i((String)TAG, (String)"getLineList ");
        StringBuilder sb = new StringBuilder();
        ArrayList<List<String>> lineLists = new ArrayList<List<String>>();
        ArrayList<String> lineList = new ArrayList<String>();
        float width = 0.0f;
        String temp = "";
        String front = "";
        for (int i = 0; i < frontList.size(); ++i) {
            front = frontList.get(i);
            if (!TextUtils.isEmpty((CharSequence)temp)) {
                sb.append(temp);
                lineList.add(temp);
                if (!this.isCN(temp)) {
                    sb.append(BLANK);
                }
                temp = "";
            }
            if (this.isCN(front)) {
                sb.append(front);
            } else if (i + 1 < frontList.size()) {
                String nextFront = frontList.get(i + 1);
                if (this.isCN(nextFront)) {
                    sb.append(front);
                } else {
                    sb.append(front).append(BLANK);
                }
            } else {
                sb.append(front);
            }
            lineList.add(front);
            width = StaticLayout.getDesiredWidth((CharSequence)sb.toString(), (TextPaint)this.getPaint());
            if (width > (float)this.mViewWidth) {
                int lastIndex = lineList.size() - 1;
                String lastWord = (String)lineList.get(lastIndex);
                String lastTemp = "";
                lineList.remove(lastIndex);
                if (this.isCN(lastWord)) {
                    this.addLines(lineLists, lineList);
                    lastTemp = lastWord;
                } else {
                    String substring = sb.substring(0, sb.length() - lastWord.length() - 1);
                    sb.delete(0, sb.toString().length());
                    sb.append(substring).append(BLANK);
                    String tempLastWord = "";
                    int length = lastWord.length();
                    if (length <= 3) {
                        this.addLines(lineLists, lineList);
                        lastTemp = lastWord;
                    } else {
                        int cutoffIndex = 0;
                        for (int j = 0; j < length; ++j) {
                            tempLastWord = String.valueOf(lastWord.charAt(j));
                            sb.append(tempLastWord);
                            if (this.vowels.contains(tempLastWord)) {
                                if (j + 1 < length) {
                                    String nextTempLastWord = String.valueOf(lastWord.charAt(j + 1));
                                    sb.append(nextTempLastWord);
                                    width = StaticLayout.getDesiredWidth((CharSequence)sb.toString(), (TextPaint)this.getPaint());
                                    cutoffIndex = j;
                                    if (width > (float)this.mViewWidth) {
                                        if (j > 2 && j <= length - 2) {
                                            String lastFinalWord = lastWord.substring(0, cutoffIndex + 2) + "-";
                                            lineList.add(lastFinalWord);
                                            this.addLines(lineLists, lineList);
                                            lastTemp = lastWord.substring(cutoffIndex + 2, length);
                                            break;
                                        }
                                        this.addLines(lineLists, lineList);
                                        lastTemp = lastWord;
                                        break;
                                    }
                                } else {
                                    this.addLines(lineLists, lineList);
                                    lastTemp = lastWord;
                                    break;
                                }
                            }
                            if (!((width = StaticLayout.getDesiredWidth((CharSequence)sb.toString(), (TextPaint)this.getPaint())) > (float)this.mViewWidth)) continue;
                            if (j > 2 && j <= length - 2) {
                                String lastFinalWord = lastWord.substring(0, j) + "-";
                                lineList.add(lastFinalWord);
                                this.addLines(lineLists, lineList);
                                lastTemp = lastWord.substring(j, length);
                                break;
                            }
                            this.addLines(lineLists, lineList);
                            lastTemp = lastWord;
                            break;
                        }
                    }
                }
                sb.delete(0, sb.toString().length());
                temp = lastTemp;
            }
            if (lineList.size() <= 0 || i != frontList.size() - 1) continue;
            this.addLines(lineLists, lineList);
        }
        if (!TextUtils.isEmpty((CharSequence)temp)) {
            lineList.add(temp);
            this.addLines(lineLists, lineList);
        }
        this.mLineCount += lineLists.size();
        return lineLists;
    }

    private void addLines(List<List<String>> lineLists, List<String> lineList) {
        if (lineLists == null || lineList == null) {
            return;
        }
        ArrayList<String> tempLines = new ArrayList<String>(lineList);
        lineLists.add(tempLines);
        lineList.clear();
    }

    private void getParagraphList() {
        CharSequence charSequence = this.getText();
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return;
        }
        String text = charSequence.toString().replaceAll("  ", "").replaceAll("   ", "").replaceAll("\\r", "").trim();
        this.mLineCount = 0;
        String[] items = text.split("\\n");
        this.mParagraphLineList = new ArrayList();
        this.mParagraphWordList = new ArrayList();
        for (String item : items) {
            if (item.length() == 0) continue;
            this.mParagraphWordList.add(this.getWordList(item));
        }
    }

    private synchronized List<String> getWordList(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return new ArrayList<String>();
        }
        Log.i((String)TAG, (String)"getWordList ");
        ArrayList<String> frontList = new ArrayList<String>();
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String charAt = String.valueOf(text.charAt(i));
            if (!Objects.equals(charAt, BLANK)) {
                if (this.checkIsSymbol(charAt)) {
                    boolean isEmptyStr = str.length() == 0;
                    str.append(charAt);
                    if (isEmptyStr) continue;
                    frontList.add(str.toString());
                    str.delete(0, str.length());
                    continue;
                }
                if (this.isCN(str.toString())) {
                    frontList.add(str.toString());
                    str.delete(0, str.length());
                }
                str.append(charAt);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)str.toString())) continue;
            frontList.add(str.toString().replaceAll(BLANK, ""));
            str.delete(0, str.length());
        }
        if (str.length() != 0) {
            frontList.add(str.toString());
            str.delete(0, str.length());
        }
        return frontList;
    }

    private synchronized void adjust(Canvas canvas, TextPaint paint) {
        int size = this.mParagraphWordList.size();
        for (int j = 0; j < size; ++j) {
            List<List<String>> lineList = this.mParagraphLineList.get(j);
            for (int i = 0; i < lineList.size(); ++i) {
                List<String> lineWords = lineList.get(i);
                if (i == lineList.size() - 1) {
                    this.drawScaledEndText(canvas, lineWords, paint);
                } else {
                    this.drawScaledText(canvas, lineWords, paint);
                }
                this.mLineY += (float)(this.getLineHeight() + this.lineSpacing);
            }
            this.mLineY += (float)this.paragraphSpacing;
        }
    }

    private void drawScaledEndText(Canvas canvas, List<String> lineWords, TextPaint paint) {
        if (canvas == null || lineWords == null || paint == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String aSplit : lineWords) {
            if (this.isCN(aSplit)) {
                sb.append(aSplit);
                continue;
            }
            sb.append(aSplit).append(BLANK);
        }
        if (1001 == this.textGravity) {
            canvas.drawText(sb.toString(), (float)this.paddingStart, this.mLineY, (Paint)paint);
        } else if (1002 == this.textGravity) {
            float width = StaticLayout.getDesiredWidth((CharSequence)sb.toString(), (TextPaint)this.getPaint());
            canvas.drawText(sb.toString(), (float)this.measuredWidth - width - (float)this.paddingStart, this.mLineY, (Paint)paint);
        } else {
            float width = StaticLayout.getDesiredWidth((CharSequence)sb.toString(), (TextPaint)this.getPaint());
            canvas.drawText(sb.toString(), ((float)this.mViewWidth - width) / 2.0f, this.mLineY, (Paint)paint);
        }
    }

    private int getTextGravity() {
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity((int)this.getGravity(), (int)layoutDirection);
        int lastGravity = absoluteGravity & 7;
        int textAlignment = this.getTextAlignment();
        if (2 == textAlignment || 5 == textAlignment || 3 == lastGravity) {
            return 1001;
        }
        if (3 == textAlignment || 6 == textAlignment || 5 == lastGravity) {
            return 1002;
        }
        return 1003;
    }

    private void drawScaledText(Canvas canvas, List<String> line, TextPaint paint) {
        if (canvas == null || line == null || paint == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String aSplit : line) {
            sb.append(aSplit);
        }
        float lineWidth = StaticLayout.getDesiredWidth((CharSequence)sb, (TextPaint)this.getPaint());
        float cw = 0.0f;
        cw = 1001 == this.textGravity ? (float)this.paddingStart : (1002 == this.textGravity ? (float)this.paddingEnd : (float)this.paddingStart);
        float d = ((float)this.mViewWidth - lineWidth) / (float)(line.size() - 1);
        for (String aSplit : line) {
            canvas.drawText(aSplit, cw, this.mLineY, (Paint)this.getPaint());
            cw += StaticLayout.getDesiredWidth((CharSequence)(aSplit + ""), (TextPaint)paint) + d;
        }
    }

    public boolean isCN(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        return bytes.length != str.length();
    }

    public static int dipToPx(Context var0, float var1) {
        float var2 = var0.getResources().getDisplayMetrics().density;
        return (int)(var1 * var2 + 0.5f);
    }

    public boolean checkIsSymbol(String s) {
        boolean b = false;
        String tmp = s;
        tmp = tmp.replaceAll("\\p{P}", "");
        if (s.length() != tmp.length()) {
            b = true;
        }
        return b;
    }

    public boolean isSpan() {
        CharSequence charSequence = this.getText();
        return charSequence instanceof Spanned;
    }
}

