/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.HandlEx;
import com.yy.framework.core.ui.ILeftSwipe;
import com.yy.framework.core.ui.UICallBacks;

public class WindowSwipeHelper {
    private final String TAG = "WindowSwipeHelper-" + this.hashCode();
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INDICATOR = false;
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_SCROLLING = 1;
    private static final int TOUCH_STATE_SETTLLING = 2;
    private static final int DEFAULT_SCROLL_DURATION = 450;
    private static final int MAX_SCROLL_DURATION = 600;
    private static final int MAX_ALPHA = 255;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final int CLOSE_ENOUGH = 2;
    private static final int COLOR_SHADOW_START = 0x14000000;
    private static final int COLOR_SHADOW_END = 0;
    private static final int COLOR_DIM_MASK = 0x14000000;
    private static final int SHADOW_WIDTH = 25;
    private static final int SCREEN_WIDTH_DIVISION_FACTOR = 2;
    private static final float XDIFF_REDUCE_FACTOR = 0.75f;
    private static final int MAX_EDGE_X_POSITION = ResolutionUtils.dip2Px((float)8.0f);
    private static final int SLIDE_LEFT = 0;
    private static final int SLIDE_RIGHT = 1;
    private static final Interpolator INTERPOLATOR = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };
    private View mHost;
    private UICallBacks mHostCallbacks;
    private View mViewBehind;
    private View mPossibleTargetView;
    private Scroller mScroller;
    private VelocityTracker mVelocityTracker;
    private HandlEx mHandler;
    private int mTouchState = 0;
    private int mTouchSlop;
    private int mScrollDuration = 450;
    private int mTotalScrollXHolder;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mFlingDistance;
    private int mCloseEnough;
    private float mTouchDownX;
    private float mTouchDownY;
    private float mLastTouchX;
    private boolean mIsBeingDragged = false;
    private boolean mIsUnableToDrag = false;
    private boolean mIsDragFromEdge = false;
    private boolean mIsTouchingIScrollable = false;
    private boolean mIsIScrollableOnLeftEdge = false;
    private boolean mIsExiting = false;
    private SwipeEffect mSwipeEffect;
    private float mScrollPercentage;
    private int[] mShadowColor = new int[]{0x14000000, 0};
    private int mShadowWidth;
    private GradientDrawable mShadowDrawable;
    private Drawable mDimMaskDrawable;
    private float mIndicatorPercentage;
    private Drawable mIndicatorDrawable;
    private int mSlideDirection = 1;

    public WindowSwipeHelper(View host, UICallBacks hostCallbacks) {
        this.mHost = host;
        this.mHostCallbacks = hostCallbacks;
        this.mHandler = new HandlEx(this.getClass().getName(), Looper.getMainLooper());
        ViewConfiguration configuration = ViewConfiguration.get((Context)host.getContext());
        float density = host.getContext().getResources().getDisplayMetrics().density;
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = (int)(400.0f * density);
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mFlingDistance = (int)(25.0f * density);
        this.mCloseEnough = (int)(2.0f * density);
        this.mScroller = new Scroller(host.getContext(), INTERPOLATOR);
        this.mSwipeEffect = SwipeEffect.SCROLL_WINDOW;
        this.mShadowWidth = (int)(25.0f * density);
        this.mShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, this.mShadowColor);
        this.mShadowDrawable.setGradientType(0);
        this.mDimMaskDrawable = new ColorDrawable(0x14000000);
    }

    public void computeScroll() {
        if (this.mSwipeEffect == SwipeEffect.SCROLL_WINDOW) {
            if (this.mScroller.computeScrollOffset()) {
                this.mHost.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
                this.mHost.postInvalidate();
            } else if (this.mTouchState == 2) {
                this.onFinishScroll();
            }
        }
    }

    public void setSwipeLeftGesture(boolean swipeLeftGesture) {
        this.mSlideDirection = swipeLeftGesture ? 0 : 1;
    }

    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (this.mSwipeEffect == SwipeEffect.SCROLL_WINDOW) {
            this.mScrollPercentage = (float)Math.abs(l) / (float)this.mHost.getMeasuredWidth();
        }
    }

    public int getScrollX() {
        return this.mScroller.getCurrX();
    }

    public int getScrollY() {
        return this.mScroller.getCurrY();
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mSwipeEffect == SwipeEffect.SCROLL_WINDOW) {
            this.checkViewBehind(w, h);
        }
    }

    private void checkViewBehind(int newWidth, int newHeight) {
        if (this.mViewBehind != null && this.mViewBehind.getVisibility() == 8) {
            if (newWidth != this.mViewBehind.getMeasuredWidth() || newHeight != this.mViewBehind.getMeasuredHeight()) {
                this.mViewBehind.measure(View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000));
                this.mViewBehind.layout(0, 0, newWidth, newHeight);
                this.mViewBehind.invalidate();
            }
        } else if (this.mViewBehind != null) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 3 || action == 1) {
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        if (action != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        float x = ev.getX();
        float y = ev.getY();
        switch (action) {
            case 0: {
                this.mTouchDownX = x;
                this.mTouchDownY = y;
                this.mLastTouchX = x;
                this.mIsDragFromEdge = this.mTouchDownX < (float)MAX_EDGE_X_POSITION;
                if (this.mTouchState == 2) {
                    this.mScroller.computeScrollOffset();
                    if (Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) <= this.mCloseEnough) {
                        this.onFinishScroll();
                        return false;
                    }
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    this.mIsBeingDragged = true;
                    this.mTouchState = 1;
                } else {
                    this.mIsBeingDragged = false;
                }
                this.mIsUnableToDrag = false;
                break;
            }
            case 2: {
                this.mLastTouchX = x;
                float deltaX = x - this.mTouchDownX;
                float xDiff = Math.abs(deltaX);
                float yDiff = Math.abs(y - this.mTouchDownY);
                if (this.mSlideDirection == 1 && deltaX > 0.0f || this.mSlideDirection == 0 && deltaX < 0.0f) {
                    if (this.checkIfCanBeDragged(this.mHost, false, (int)x, (int)y)) {
                        float touchSlop = this.mIsDragFromEdge ? (float)this.mTouchSlop : (float)(this.mTouchSlop * 2);
                        if (xDiff > touchSlop && xDiff * 0.75f > yDiff) {
                            this.onBeginDrag();
                            this.mIsBeingDragged = true;
                            this.mTouchState = 1;
                            break;
                        }
                        if (!(yDiff > (float)this.mTouchSlop)) break;
                        this.mIsUnableToDrag = true;
                        break;
                    }
                    this.mIsUnableToDrag = true;
                    break;
                }
                if (!(this.mSlideDirection == 1 && deltaX < 0.0f) && (this.mSlideDirection != 0 || !(deltaX > 0.0f))) break;
                this.mIsUnableToDrag = true;
                break;
            }
        }
        if (this.mIsBeingDragged) {
            this.notifyChildTouchCanceled();
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsBeingDragged;
    }

    private boolean checkIfCanBeDragged(View viewToCheck, boolean checkSelf, int x, int y) {
        if (this.mTotalScrollXHolder != 0) {
            this.mTotalScrollXHolder = 0;
        }
        if (checkSelf) {
            this.mPossibleTargetView = viewToCheck;
            if (viewToCheck instanceof IScrollable) {
                this.mIsTouchingIScrollable = true;
                this.mIsIScrollableOnLeftEdge = ((IScrollable)viewToCheck).isLeftEdge();
                return this.mIsIScrollableOnLeftEdge;
            }
            if (viewToCheck instanceof ILeftSwipe) {
                this.mIsTouchingIScrollable = true;
                boolean isSwipeEnd = ((ILeftSwipe)viewToCheck).isSwipeEnd();
                if (!isSwipeEnd) {
                    ++this.mTotalScrollXHolder;
                }
                if (this.mTotalScrollXHolder > 0) {
                    return false;
                }
            } else {
                this.mIsTouchingIScrollable = false;
                this.mTotalScrollXHolder += viewToCheck.getScrollX();
                if (this.mTotalScrollXHolder > 0) {
                    return false;
                }
            }
        }
        if (viewToCheck instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)viewToCheck;
            int scrollX = viewToCheck.getScrollX();
            int scrollY = viewToCheck.getScrollY();
            int realX = x + scrollX;
            int realY = y + scrollY;
            int count = group.getChildCount();
            Rect hitRect = new Rect();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                child.getHitRect(hitRect);
                if (!hitRect.contains(realX, realY)) continue;
                this.checkIfCanBeDragged(child, true, realX - child.getLeft(), realY - child.getTop());
                if (this.mIsTouchingIScrollable && !this.mIsIScrollableOnLeftEdge) {
                    return false;
                }
                if (this.mTotalScrollXHolder <= 0) continue;
                return false;
            }
            return true;
        }
        return checkSelf && this.mTotalScrollXHolder <= 0;
    }

    private void notifyChildTouchCanceled() {
        if (this.mPossibleTargetView != null) {
            MotionEvent ev = MotionEvent.obtain((long)0L, (long)0L, (int)3, (float)0.0f, (float)0.0f, (int)0);
            this.mPossibleTargetView.dispatchTouchEvent(ev);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        float x = ev.getX();
        float y = ev.getY();
        switch (action) {
            case 0: {
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mTouchDownX = x;
                this.mTouchDownY = y;
                this.mLastTouchX = x;
                if (this.mTouchDownX < (float)MAX_EDGE_X_POSITION) {
                    this.mIsDragFromEdge = true;
                    break;
                }
                this.mIsDragFromEdge = false;
                break;
            }
            case 2: {
                float deltaX;
                if (!this.mIsBeingDragged) {
                    deltaX = x - this.mTouchDownX;
                    float xDiff = Math.abs(deltaX);
                    float yDiff = Math.abs(y - this.mTouchDownY);
                    float touchSlop = this.mIsDragFromEdge ? (float)this.mTouchSlop : (float)(this.mTouchSlop * 2);
                    if (deltaX > 0.0f && xDiff > touchSlop && xDiff * 0.75f > yDiff) {
                        this.mLastTouchX = x;
                        this.mIsBeingDragged = true;
                        this.mTouchState = 1;
                        this.onBeginDrag();
                    }
                }
                if (!this.mIsBeingDragged) break;
                deltaX = this.mLastTouchX - x;
                this.mLastTouchX = x;
                float currentX = this.mHost.getScrollX();
                float targetX = currentX + deltaX;
                float leftLimit = 0.0f;
                float rightLimit = -this.mHost.getMeasuredWidth();
                if (this.mSlideDirection == 1) {
                    if (targetX > leftLimit) {
                        deltaX = leftLimit - currentX;
                        targetX = leftLimit;
                    } else if (targetX < rightLimit) {
                        deltaX = rightLimit - currentX;
                        targetX = rightLimit;
                    }
                }
                this.onDrag((int)deltaX);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                float deltaX = x - this.mTouchDownX;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int velocity = (int)this.mVelocityTracker.getXVelocity();
                this.onFinishDrag(deltaX, velocity, false);
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                float deltaX = x - this.mTouchDownX;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int velocity = (int)this.mVelocityTracker.getXVelocity();
                this.onFinishDrag(deltaX, velocity, true);
                break;
            }
        }
        return true;
    }

    private void onBeginDrag() {
        this.mIsExiting = false;
        if (this.mSwipeEffect == SwipeEffect.SCROLL_WINDOW) {
            this.mViewBehind = this.mHostCallbacks.onGetViewBehind(this.mHost);
            if (this.mViewBehind == this.mHost) {
                this.mViewBehind = null;
            } else {
                this.checkViewBehind(this.mHost.getMeasuredWidth(), this.mHost.getMeasuredHeight());
            }
        } else {
            this.mIndicatorPercentage = 0.0f;
        }
    }

    private void onDrag(int deltaX) {
        if (this.mSlideDirection == 1) {
            if (this.mSwipeEffect == SwipeEffect.SCROLL_WINDOW) {
                if (deltaX != 0) {
                    this.mHost.scrollBy(deltaX, 0);
                }
            } else {
                this.mIndicatorPercentage = Math.abs(this.mLastTouchX - this.mTouchDownX) / (float)this.mHost.getMeasuredWidth();
            }
            this.mHost.invalidate();
        } else {
            this.mHostCallbacks.onDrag(deltaX);
        }
    }

    public void onXDrag(int deltaX) {
        if (deltaX != 0) {
            this.onBeginDrag();
            this.mHost.scrollBy(deltaX, 0);
            this.mHost.invalidate();
        }
    }

    private void onFinishDrag(float deltaX, int velocity, boolean forceSnapToDefault) {
        this.mPossibleTargetView = null;
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mSwipeEffect == SwipeEffect.SCROLL_WINDOW) {
            if (this.mSlideDirection == 1) {
                this.snapToDestinationForScrollWindow(deltaX, velocity, forceSnapToDefault);
            } else {
                this.mHostCallbacks.dealWithNewPage(deltaX, velocity);
            }
        } else {
            this.snapToDestinationForShowIndicator(deltaX, velocity, forceSnapToDefault);
        }
    }

    private void onFinishScroll() {
        this.mTouchState = 0;
        if (!this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        if (this.mIsExiting) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    WindowSwipeHelper.this.mHostCallbacks.onWindowExitEvent(WindowSwipeHelper.this.mSwipeEffect == SwipeEffect.SHOW_INDICATOR);
                }
            });
        }
    }

    private void snapToDestinationForScrollWindow(float deltaX, int velocity, boolean forceSnapToDefault) {
        int newScrollX;
        boolean snapToDefaultPosition = true;
        if (!forceSnapToDefault) {
            if (Math.abs(deltaX) > (float)this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity) {
                snapToDefaultPosition = velocity < 0;
            } else if (Math.abs(this.mHost.getScrollX()) > this.mHost.getMeasuredWidth() / 2) {
                snapToDefaultPosition = false;
            }
        }
        this.mIsExiting = !snapToDefaultPosition;
        int currentScrollX = this.mHost.getScrollX();
        int n = newScrollX = snapToDefaultPosition ? 0 : -this.mHost.getMeasuredWidth();
        if (!this.mScroller.isFinished()) {
            return;
        }
        int deltaScrollX = newScrollX - currentScrollX;
        int duration = this.calculateDuration(deltaScrollX);
        this.mTouchState = 2;
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mTouchState == 2) {
                this.mScroller.startScroll(currentScrollX, 0, deltaScrollX, 0, duration);
            }
        });
        this.mHost.invalidate();
    }

    public void snapToDestinationForLeftScrollWindow(float deltaX, int velocity) {
        int newScrollX;
        boolean snapToDefaultPosition = true;
        if (Math.abs(deltaX) > (float)ResolutionUtils.dip2Px((float)5.0f) && Math.abs(velocity) > this.mMinimumVelocity / 2) {
            snapToDefaultPosition = velocity < 0;
        } else if (Math.abs(this.mHost.getScrollX()) > ResolutionUtils.getScreenWidth() * 2 / 3) {
            snapToDefaultPosition = false;
        }
        this.mIsExiting = !snapToDefaultPosition;
        int currentScrollX = this.mHost.getScrollX();
        int n = newScrollX = snapToDefaultPosition ? 0 : -ResolutionUtils.getScreenWidth();
        if (!this.mScroller.isFinished()) {
            return;
        }
        int deltaScrollX = newScrollX - currentScrollX;
        int duration = this.calculateDuration(deltaScrollX);
        this.mTouchState = 2;
        this.mScroller.startScroll(currentScrollX, 0, deltaScrollX, 0, duration);
        this.mHost.invalidate();
    }

    private int calculateDuration(int deltaDistance) {
        float duration = this.mScrollDuration;
        float width = this.mHost.getMeasuredWidth();
        if (width > 0.0f) {
            duration = ((float)Math.abs(deltaDistance) / width + 1.0f) * (float)this.mScrollDuration / 2.0f;
            duration = Math.min(duration, 600.0f);
        }
        return (int)duration;
    }

    private void snapToDestinationForShowIndicator(float deltaX, int velocity, boolean forceSnapToDefault) {
        int newLeft;
        boolean snapToDefaultPosition = true;
        if (!forceSnapToDefault) {
            if (Math.abs(deltaX) > (float)this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity) {
                snapToDefaultPosition = velocity < 0;
            } else if (this.mIndicatorPercentage > 0.5f) {
                snapToDefaultPosition = false;
            }
        }
        this.mIsExiting = !snapToDefaultPosition;
        int imageWidth = this.mIndicatorDrawable.getIntrinsicWidth();
        int currentLeft = (int)(-(1.0f - this.mIndicatorPercentage * 2.0f) * (float)imageWidth);
        int n = newLeft = snapToDefaultPosition ? -imageWidth : 0;
        if (!this.mScroller.isFinished()) {
            return;
        }
        int deltaScrollX = newLeft - currentLeft;
        int duration = snapToDefaultPosition ? this.calculateDuration(deltaScrollX) : 50;
        this.mTouchState = 2;
        this.mScroller.startScroll(currentLeft, 0, deltaScrollX, 0, duration);
        this.mHost.invalidate();
    }

    public void draw(Canvas canvas, Rect dst) {
        if (this.mSwipeEffect == SwipeEffect.SCROLL_WINDOW) {
            this.drawForScrollWindow(canvas, dst);
        } else {
            this.drawForShowIndicator(canvas);
        }
    }

    private void drawForScrollWindow(Canvas canvas, Rect dst) {
        int hostScrollX = this.mHost.getScrollX();
        if (hostScrollX < 0) {
            int alpha = (int)((1.0f - this.mScrollPercentage) * 255.0f);
            int hostHeight = this.mHost.getMeasuredHeight();
            if (alpha < 0) {
                alpha = 0;
            }
            if (this.mViewBehind != null) {
                canvas.save();
                canvas.translate((float)hostScrollX, 0.0f);
                canvas.clipRect(0, 0, -hostScrollX, hostHeight);
                this.mViewBehind.draw(canvas);
                this.mDimMaskDrawable.setAlpha(alpha);
                this.mDimMaskDrawable.setBounds(0, 0, -hostScrollX, hostHeight);
                this.mDimMaskDrawable.draw(canvas);
                canvas.restore();
            }
            this.mShadowDrawable.setAlpha(alpha);
            this.mShadowDrawable.setBounds(-this.mShadowWidth, 0, 0, hostHeight);
            this.mShadowDrawable.draw(canvas);
        }
    }

    private void drawForShowIndicator(Canvas canvas) {
        if (this.mTouchState == 1) {
            int imageWidth = this.mIndicatorDrawable.getIntrinsicWidth();
            int imageHeight = this.mIndicatorDrawable.getIntrinsicHeight();
            int left = (int)(-(1.0f - this.mIndicatorPercentage * 2.0f) * (float)imageWidth);
            if (left > 0) {
                left = 0;
            }
            int top = (this.mHost.getMeasuredHeight() - imageHeight) / 2;
            this.mIndicatorDrawable.setBounds(left, top, left + imageWidth, top + imageHeight);
            this.mIndicatorDrawable.draw(canvas);
        } else if (this.mTouchState == 2) {
            if (this.mScroller.computeScrollOffset()) {
                int imageWidth = this.mIndicatorDrawable.getIntrinsicWidth();
                int imageHeight = this.mIndicatorDrawable.getIntrinsicHeight();
                int left = this.mScroller.getCurrX();
                if (left > 0) {
                    left = 0;
                }
                int top = (this.mHost.getMeasuredHeight() - imageHeight) / 2;
                this.mIndicatorDrawable.setBounds(left, top, left + imageWidth, top + imageHeight);
                this.mIndicatorDrawable.draw(canvas);
                this.mHost.postInvalidate();
            } else {
                this.onFinishScroll();
            }
        }
    }

    public static interface IScrollable {
        public boolean isLeftEdge();
    }

    private static enum SwipeEffect {
        SCROLL_WINDOW,
        SHOW_INDICATOR;

    }
}

