/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import com.yy.base.bridge.IStatusBarBridge;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.R;
import com.yy.framework.core.ui.AbstractWindow;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@SuppressLint(value={"colorParseUsage"})
public enum StatusBarManager {
    INSTANCE;

    private static final String TAG = "StatusBarManager";
    private boolean isMIUIMode = false;
    public static final int COLOR_MAIN;
    public static final int COLOR_WHITE = -1;
    public static final int COLOR_GREEN;
    public static final int COLOR_BLACK = -16777216;
    public static final int COLOR_TRANSPARENT = 0;
    public static final int COLOR_TRANSLUCENT;
    public static final int STATUS_BAR_UNKNOW = 0;
    public static final int STATUS_BAR_MIUI = 1;
    public static final int STATUS_BAR_OTHER = 2;
    public static final int TAG_KEY_HAVE_SET_OFFSET = -123;
    private static final int FAKE_TRANSLUCENT_VIEW_ID;
    private IStatusBarBridge mBridge;
    private static Boolean mIsSwitchOn;
    private static Boolean mIsInBlack;
    private static Boolean mEnvSwitch;
    private static boolean isMIUIStatusBarModeNotUsable;

    @RequiresApi(value=23)
    public boolean setInitTransparentState(Activity activity, boolean isFirstStart, boolean isMIUIMode) {
        if (isFirstStart) {
            boolean result = this.setMIUIStatusBarLightMode(activity, true);
            if (result) {
                this.isMIUIMode = true;
            } else {
                this.isMIUIMode = false;
                this.setNotMIUITransparentState(activity, true);
            }
        } else {
            this.isMIUIMode = isMIUIMode;
            this.setTransparentState(activity);
        }
        return this.isMIUIMode;
    }

    @Deprecated
    public boolean isTranslucent() {
        return this.mBridge == null ? this.isTranslucentConfigEnable() && this.isSupportStatusBar() : this.mBridge.isTranslucentBarEnable() && this.mBridge.isWindowAskTranslucentBar() && this.isSupportStatusBar();
    }

    public boolean isTranslucent(AbstractWindow window) {
        return this.isTranslucentConfigEnable() && (window == null || window.isTranslucentBar()) && this.isSupportStatusBar();
    }

    private boolean isTranslucentConfigEnable() {
        boolean forceEnable;
        if (mIsSwitchOn == null) {
            mIsSwitchOn = SettingFlags.getBoolean((String)"key_translucent_bar_switch", (boolean)true);
        }
        if (mIsInBlack == null) {
            mIsInBlack = SettingFlags.getBoolean((String)"key_is_translucent_bar_black_device", (boolean)false);
        }
        if (mEnvSwitch == null) {
            mEnvSwitch = SettingFlags.getBoolean((String)"key_translucent_switch_env_setting", (boolean)true);
        }
        return (forceEnable = true) && mIsSwitchOn != false && mIsInBlack == false;
    }

    public void setBridge(IStatusBarBridge bridge) {
        this.mBridge = bridge;
    }

    @RequiresApi(value=23)
    public void setTransparentState(Activity activity) {
        if (this.isSupportStatusBar()) {
            if (this.isMIUIMode) {
                this.setMIUIStatusBarLightMode(activity, true);
            } else {
                this.setNotMIUITransparentState(activity, true);
            }
        }
    }

    @TargetApi(value=19)
    private void translucentStatusBar(Activity activity, boolean isDarkMode, @ColorInt int color) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.getDecorView().setSystemUiVisibility(1280);
            if (Build.VERSION.SDK_INT >= 23) {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(color);
            } else {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                if (color != 0) {
                    this.addTranslucentView(activity, color);
                } else {
                    window.setStatusBarColor(color);
                    StatusBarManager.clearPreviousSetting(activity);
                }
            }
        } else {
            window.setFlags(0x4000000, 0x4000000);
        }
    }

    public void reset(Activity activity, boolean isDark, AbstractWindow curWindow) {
        if (!this.isTranslucent(curWindow)) {
            Window window = activity.getWindow();
            window.getDecorView().setSystemUiVisibility(0);
            window.clearFlags(1024);
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            if (Build.VERSION.SDK_INT >= 23) {
                if (isDark) {
                    window.setStatusBarColor(-1);
                    window.getDecorView().setSystemUiVisibility(8192);
                } else {
                    window.setStatusBarColor(-16777216);
                    window.getDecorView().setSystemUiVisibility(0);
                }
            }
            StatusBarManager.clearPreviousSetting(activity);
        }
    }

    @RequiresApi(value=23)
    public void setTransparentState(Activity activity, boolean dark) {
        try {
            if (this.isSupportStatusBar()) {
                if (this.isMIUIMode) {
                    this.setMIUIStatusBarLightMode(activity, dark);
                } else {
                    this.setNotMIUITransparentState(activity, dark);
                }
            }
        }
        catch (Exception error) {
            MLog.info((Object)TAG, (String)"setTransparentState error: %s", (Object[])new Object[]{error});
        }
    }

    @RequiresApi(value=23)
    public void setNotMIUITransparentState(Activity activity, boolean dark) {
        try {
            if (this.isSupportStatusBar()) {
                Window window = activity.getWindow();
                window.clearFlags(1024);
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                if (dark) {
                    window.setStatusBarColor(-1);
                    window.getDecorView().setSystemUiVisibility(8192);
                } else {
                    window.setStatusBarColor(-16777216);
                    window.getDecorView().setSystemUiVisibility(0);
                }
                StatusBarManager.clearPreviousSetting(activity);
            }
        }
        catch (Exception error) {
            MLog.error((Object)TAG, (String)"setNotMIUITransparentState error: %s", (Throwable)error, (Object[])new Object[0]);
        }
    }

    public void setTranslucent(Activity activity, boolean isDarkMode, @ColorInt int color, View needOffsetView) {
        this.setTranslucent(activity, isDarkMode, color, needOffsetView, false);
    }

    public void setTranslucent(Activity activity, AbstractWindow window, boolean isDarkMode, @ColorInt int color, View needOffsetView) {
        if (!this.isTranslucent(window)) {
            return;
        }
        this.translucentStatusBar(activity, isDarkMode, color);
        this.setStatusBarMode(activity, isDarkMode);
        this.offsetView((Context)activity, needOffsetView, window);
    }

    public void setTranslucent(Activity activity, boolean isDarkMode, @ColorInt int color, View needOffsetView, boolean isTransparent) {
        if (!this.isTranslucent() && !isTransparent) {
            return;
        }
        this.translucentStatusBar(activity, isDarkMode, color);
        this.setStatusBarMode(activity, isDarkMode);
        this.offsetView((Context)activity, needOffsetView);
    }

    private void setStatusBarMode(Activity activity, boolean isDarkMode) {
        if (Build.BRAND.equals("Xiaomi")) {
            this.setMIUIStatusBarMode(activity, isDarkMode);
        }
        if (Build.BRAND.equals("Meizu")) {
            this.setFlymeStatusBarMode(activity, isDarkMode);
        }
        Window window = activity.getWindow();
        View decorView = window.getDecorView();
        int systemVisibility = decorView.getSystemUiVisibility();
        decorView.setSystemUiVisibility(systemVisibility | (isDarkMode ? 8192 : 256));
    }

    private int changeStatusBarModeRetainFlag(Window window, int out) {
        out = this.retainSystemUiFlag(window, out, 1024);
        out = this.retainSystemUiFlag(window, out, 4);
        out = this.retainSystemUiFlag(window, out, 2);
        out = this.retainSystemUiFlag(window, out, 4096);
        out = this.retainSystemUiFlag(window, out, 1024);
        out = this.retainSystemUiFlag(window, out, 512);
        return out;
    }

    private int retainSystemUiFlag(Window window, int out, int type) {
        int now = window.getDecorView().getSystemUiVisibility();
        if ((now & type) == type) {
            out |= type;
        }
        return out;
    }

    public void offsetView(Context context, View needOffsetView) {
        if (needOffsetView != null && this.isTranslucent()) {
            this.offsetViewInner(context, needOffsetView);
        }
    }

    public void offsetView(Context activity, View needOffsetView, boolean isTransparent) {
        if (needOffsetView != null && (isTransparent || this.isTranslucent())) {
            this.offsetViewInner(activity, needOffsetView);
        }
    }

    public void offsetView(Context activity, View needOffsetView, AbstractWindow window) {
        if (needOffsetView != null && this.isTranslucent(window)) {
            this.offsetViewInner(activity, needOffsetView);
        }
    }

    private void offsetViewInner(Context activity, View needOffsetView) {
        Object haveSetOffset = needOffsetView.getTag(-123);
        if (haveSetOffset != null && ((Boolean)haveSetOffset).booleanValue()) {
            return;
        }
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)needOffsetView.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin + this.getStatusBarHeightWithDefault(activity), layoutParams.rightMargin, layoutParams.bottomMargin);
            needOffsetView.setTag(-123, (Object)true);
            needOffsetView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void addTopPadding(Activity activity, View needOffsetView, AbstractWindow window) {
        if (needOffsetView != null && (window == null ? this.isTranslucent() : this.isTranslucent(window))) {
            Object haveSetOffset = needOffsetView.getTag(-123);
            if (haveSetOffset != null && ((Boolean)haveSetOffset).booleanValue()) {
                return;
            }
            needOffsetView.setPadding(needOffsetView.getPaddingLeft(), needOffsetView.getPaddingTop() + this.getStatusBarHeightWithDefault((Context)activity), needOffsetView.getPaddingRight(), needOffsetView.getPaddingBottom());
            needOffsetView.setTag(-123, (Object)true);
        }
    }

    public void addTopPadding(Activity activity, View needOffsetView) {
        this.addTopPadding(activity, needOffsetView, null);
    }

    public void resetView(Activity activity, View needOffsetView) {
        if (needOffsetView != null && this.isSupportStatusBar()) {
            Object haveSetOffset = needOffsetView.getTag(-123);
            if (haveSetOffset == null || !((Boolean)haveSetOffset).booleanValue()) {
                return;
            }
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)needOffsetView.getLayoutParams();
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin - this.getStatusBarHeightWithDefault((Context)activity), layoutParams.rightMargin, layoutParams.bottomMargin);
            needOffsetView.setTag(-123, (Object)false);
        }
    }

    public void addTranslucentView(Activity activity, @ColorInt int color) {
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View fakeTranslucentView = contentView.findViewById(FAKE_TRANSLUCENT_VIEW_ID);
        if (fakeTranslucentView != null) {
            if (fakeTranslucentView.getVisibility() != 0) {
                fakeTranslucentView.setVisibility(0);
            }
            fakeTranslucentView.setBackgroundColor(color);
        } else {
            contentView.addView(this.createTranslucentStatusBarView(activity, color));
        }
    }

    private View createTranslucentStatusBarView(Activity activity, @ColorInt int color) {
        YYView statusBarView = new YYView((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.getStatusBarHeightWithDefault((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(color);
        statusBarView.setId(FAKE_TRANSLUCENT_VIEW_ID);
        return statusBarView;
    }

    @TargetApi(value=19)
    public static void clearPreviousSetting(Activity activity) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View fakeStatusBarView = decorView.findViewById(FAKE_TRANSLUCENT_VIEW_ID);
        if (fakeStatusBarView != null && fakeStatusBarView.getParent() != null) {
            ((ViewGroup)fakeStatusBarView.getParent()).removeView(fakeStatusBarView);
        }
    }

    public void setStatusBarColor(Activity activity, int color) {
        if (this.isSupportStatusBar()) {
            activity.getWindow().setStatusBarColor(color);
        }
    }

    private boolean setMIUIStatusBarMode(Activity activity, boolean isDark) {
        boolean result = false;
        Window window = activity.getWindow();
        if (window != null && !isMIUIStatusBarModeNotUsable) {
            Class<?> clazz = window.getClass();
            try {
                int darkModeFlag = 0;
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (isDark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                isMIUIStatusBarModeNotUsable = true;
            }
        }
        return result;
    }

    private boolean setFlymeStatusBarMode(Activity activity, boolean dark) {
        boolean result = false;
        Window window = activity.getWindow();
        if (window != null) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"%s", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return result;
    }

    public boolean setMIUIStatusBarLightMode(Activity activity, boolean dark) {
        boolean result = false;
        Window window = activity.getWindow();
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                if (clazz.getName().toLowerCase().contains("miui")) {
                    Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                    Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                    int darkModeFlag = field.getInt(layoutParams);
                    Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                    if (dark) {
                        extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                    } else {
                        extraFlagField.invoke((Object)window, 0, darkModeFlag);
                    }
                }
                result = true;
                if (Build.VERSION.SDK_INT >= 23) {
                    window.clearFlags(1024);
                    window.clearFlags(0x4000000);
                    window.addFlags(Integer.MIN_VALUE);
                    if (dark) {
                        window.setStatusBarColor(-1);
                        activity.getWindow().getDecorView().setSystemUiVisibility(8192);
                    } else {
                        window.setStatusBarColor(-16777216);
                        activity.getWindow().getDecorView().setSystemUiVisibility(0);
                    }
                }
                StatusBarManager.clearPreviousSetting(activity);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"%s", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return result;
    }

    public int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public int getStatusBarHeightWithDefault(Context context) {
        int result = this.getStatusBarHeight(context);
        if (result == 0) {
            result = context.getResources().getDimensionPixelOffset(R.dimen.dist_24dp);
        }
        return result;
    }

    public boolean isSupportStatusBar() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static {
        COLOR_MAIN = Color.parseColor((String)"#F3F3F3");
        COLOR_GREEN = Color.parseColor((String)"#01a38e");
        COLOR_TRANSLUCENT = Color.parseColor((String)"#33000000");
        FAKE_TRANSLUCENT_VIEW_ID = R.id.statusbarutil_translucent_view;
        mIsSwitchOn = null;
        mIsInBlack = null;
        mEnvSwitch = null;
        isMIUIStatusBarModeNotUsable = false;
    }
}

