/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.View;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;

public class PanelLayer
extends YYFrameLayout {
    public static final String TAG = "PanelLayer";
    private boolean mEnableTouchThrough = true;

    public PanelLayer(Context context) {
        super(context);
        this.setVisibility(8);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
    }

    public void onViewRemoved(View child) {
        super.onViewRemoved(child);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 ? !this.checkCanTouchThrough() : event.getAction() == 1 && !this.checkCanTouchThrough() && this.hideTopPanelOutsize(this.getChildCount())) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    private boolean checkCanShow() {
        if (this.hasPanelShowing()) {
            return false;
        }
        return !YYDialog.hasDialogShowing();
    }

    private boolean checkCanTouchThrough() {
        int childIndex = this.getChildCount();
        for (int i = 0; i < childIndex; ++i) {
            BasePanel p;
            View view = this.getChildAt(i);
            if (!(view instanceof BasePanel) || (p = (BasePanel)view).isEnableTouchThrough()) continue;
            return false;
        }
        return true;
    }

    private boolean hideTopPanelOutsize(int childIndex) {
        if (childIndex >= 0) {
            View view = this.getChildAt(childIndex);
            if (view instanceof BasePanel) {
                BasePanel p = (BasePanel)view;
                if (!p.isEnableTouchThrough()) {
                    p.hide(p.isOutHideAnim());
                    return true;
                }
                return this.hideTopPanelOutsize(childIndex - 1);
            }
            return this.hideTopPanelOutsize(childIndex - 1);
        }
        return false;
    }

    public void showPanelWithoutHide(BasePanel abstractPanel) {
        if (abstractPanel == null) {
            return;
        }
        this.setVisibility(0);
        abstractPanel.setPanelLayer(this);
        abstractPanel.show(true);
        MLog.debug((Object)"onCreate BasePanel", (String)("panel name :" + abstractPanel.getClass().getName()), (Object[])new Object[0]);
    }

    public void showPanel(BasePanel abstractPanel, boolean anim2) {
        if (abstractPanel == null) {
            return;
        }
        this.hideShowingPanel(false);
        this.setVisibility(0);
        abstractPanel.setPanelLayer(this);
        abstractPanel.show(anim2);
        if (RuntimeContext.sIsDebuggable) {
            String className = abstractPanel.getClass().getName();
            if (className.contains("BasePanel")) {
                MLog.info((Object)"onCreate BasePanel", (String)("panel name :" + abstractPanel.getChildAt(0).getClass().getName()), (Object[])new Object[0]);
            } else {
                MLog.info((Object)"onCreate BasePanel", (String)("panel name :" + className), (Object[])new Object[0]);
            }
        }
    }

    public void hidePanel(BasePanel abstractPanel, boolean anim2) {
        if (abstractPanel == null) {
            return;
        }
        abstractPanel.hide(anim2);
    }

    public boolean hideShowingPanel() {
        return this.hideShowingPanel(true);
    }

    private boolean hideShowingPanel(boolean ani) {
        boolean ret = false;
        int count = this.getChildCount();
        View child = null;
        BasePanel ap = null;
        for (int i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof BasePanel) || !(ap = (BasePanel)child).isShowing() && ap.isShowAnimating()) continue;
            ap.hide(ani);
            ret = true;
        }
        return ret;
    }

    private boolean hideShowingPanelOutside(boolean ani) {
        boolean ret = false;
        int count = this.getChildCount();
        View child = null;
        BasePanel ap = null;
        for (int i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof BasePanel)) continue;
            ap = (BasePanel)child;
            if (!ap.canHideOutside()) {
                ret = true;
                continue;
            }
            if (!ap.isShowing() && ap.isShowAnimating()) continue;
            ap.hide(ap.isOutHideAnim());
            ret = true;
        }
        return ret;
    }

    private boolean hideShowingPanelKeyBack(boolean ani) {
        boolean ret = false;
        int count = this.getChildCount();
        View child = null;
        BasePanel ap = null;
        for (int i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof BasePanel)) continue;
            ap = (BasePanel)child;
            if (!ap.canKeyback()) {
                ret = true;
                continue;
            }
            if (!ap.isShowing() && ap.isShowAnimating()) continue;
            ap.hide(ani);
            ret = true;
        }
        return ret;
    }

    void onPanelHidden(BasePanel abstractPanel) {
        if (!this.hasPanelShowing()) {
            this.setVisibility(8);
        }
    }

    public boolean onBackKeyEvent() {
        if (!this.isInterceptorBackKeyEvent()) {
            return false;
        }
        return this.hideShowingPanelKeyBack(true);
    }

    private boolean isInterceptorBackKeyEvent() {
        int count = this.getChildCount();
        View child = null;
        BasePanel ap = null;
        boolean ret = false;
        for (int i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof BasePanel) || !(ap = (BasePanel)child).isShowing() || !ap.isInterceptorBackKeyEvent()) continue;
            ret = true;
        }
        return ret;
    }

    public boolean hasPanelShowing() {
        boolean ret = false;
        int count = this.getChildCount();
        View child = null;
        BasePanel ap = null;
        for (int i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof BasePanel) || !(ap = (BasePanel)child).isShowing()) continue;
            return true;
        }
        return ret;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }
}

