/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.RequiresApi;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ReflectionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.StatusBarManager;
import java.lang.reflect.Method;

public class DeviceManager {
    public static final int SYSTEM_UI_FLAG_HIDE_NAVIGATION = 2;
    public static final int SYSTEM_UI_FLAG_FULLSCREEN = 4;
    public static final int SYSTEM_UI_FLAG_LAYOUT_STABLE = 256;
    public static final int SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION = 512;
    public static final int SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN = 1024;
    public static final int SYSTEM_UI_FLAG_IMMERSIVE = 2048;
    public static final int SYSTEM_UI_FLAG_IMMERSIVE_STICKY = 4096;
    public static final int LAYER_TYPE_NONE = 0;
    public static final int LAYER_TYPE_SOFTWARE = 1;
    public static final int LAYER_TYPE_HARDWARE = 2;
    public static final int NAV_BAR_COLOR_INVALID = -2;
    private static final String TAG = "DeviceManager";
    private static final int CLEAR_LAYOUT_NO_LIMITS_FLAGS_DURING = 1500;
    private static final String[] gModelListOfDeviceNotCallAddLayoutNoLimitsFlagTemporary = new String[]{"GT-N7100", "GT-9300", "GT-I9300"};
    private static final String[] gModelListOfDeviceNeedClearBufferBeforeDraw = new String[]{"GT-N7100"};
    private static final String[] gBrandListOfDeviceNeedClearBufferBeforeDraw = new String[]{"Xiaomi", "Meizu"};
    private static boolean mSupportNavitationBar = false;
    private static boolean gHasCheckDeviceNotCallAddLayoutNoLimitsFlagTemporary = false;
    private static boolean gIsDeviceNotCallAddLayoutNoLimitsFlagTemporary = false;
    private static boolean gHasCheckDeviceNeedClearBufferBeforeDraw = false;
    private static boolean gIsDeviceNeedClearBufferBeforeDraw = false;
    private Context mContext;
    private final Runnable mClearLayoutNoLimitsFlagRunnable = new Runnable(){

        @Override
        public void run() {
            DeviceManager.this.clearLayoutNoLimitsFlag();
        }
    };
    static volatile boolean isSetShortcut;
    public static final int TAG_KEY_HAVE_SET_SHORTCUT_OFFSET = -124;

    public DeviceManager(Context activity) {
        this.mContext = activity;
    }

    public void updateActivity(Activity activity) {
        this.mContext = activity;
    }

    private static boolean isSysStatusBarShowing(Context context) {
        if (context instanceof Activity) {
            int val = ((Activity)context).getWindow().getAttributes().flags;
            return (val & 0x400) != 1024;
        }
        return false;
    }

    private static final boolean hasWindowFlag(Window window, int flag) {
        WindowManager.LayoutParams lp = window.getAttributes();
        return lp != null && (lp.flags & flag) != 0;
    }

    public static void showInputMethod(Context context) {
        SystemServiceUtils.getInputMethodManager((Context)context).toggleSoftInput(0, 1);
    }

    public static void showInputMethod(Activity activity, View view) {
        if (null == view && null == (view = activity.getCurrentFocus())) {
            return;
        }
        SystemServiceUtils.getInputMethodManager((Context)activity).showSoftInput(view, 2);
    }

    public static void hideInputMethod(Context context, View view) {
        if (context == null || view == null) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new InputRunable().setParams(context, view));
    }

    public static boolean isColorDeth16Device(Context context) {
        Display screenRes = ((Activity)context).getWindowManager().getDefaultDisplay();
        boolean boolVal = screenRes.getPixelFormat() == 4 || screenRes.getPixelFormat() == 3 || screenRes.getPixelFormat() == 2 || screenRes.getPixelFormat() == 6 || screenRes.getPixelFormat() == 7;
        return boolVal;
    }

    public static boolean setLayerType(View view, int type) {
        try {
            Method setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
            setLayerTypeMethod.invoke((Object)view, type, null);
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
    }

    public static void pushAndroidWindow(Context context, View view, ViewGroup.LayoutParams lp) {
        if (context instanceof Activity && view != null && view.getParent() == null) {
            if (SystemUtils.isMeizuMXSeries()) {
                ScreenUtils.hideNavigationBar((View)view);
            }
            DeviceManager.decorateWindowLayoutParams(context, lp);
            WindowManager windowManager = ((Activity)context).getWindowManager();
            try {
                windowManager.addView(view, lp);
            }
            catch (Throwable t) {
                MLog.error((Object)TAG, (Throwable)t);
            }
        }
    }

    public static void popAndroidWindow(Context context, View view) {
        if (context instanceof Activity && view != null && view.getParent() != null) {
            WindowManager windowManager = ((Activity)context).getWindowManager();
            windowManager.removeView(view);
        }
    }

    public static void popAndroidWindowNow(Context context, View view) {
        if (context instanceof Activity && view != null && view.getParent() != null) {
            WindowManager windowManager = ((Activity)context).getWindowManager();
            windowManager.removeViewImmediate(view);
        }
    }

    public static void updateAndroidWindowLP(Context context, View view, ViewGroup.LayoutParams lp) {
        if (context instanceof Activity && view != null && view.getParent() != null) {
            DeviceManager.decorateWindowLayoutParams(context, lp);
            WindowManager windowManager = ((Activity)context).getWindowManager();
            windowManager.updateViewLayout(view, lp);
        }
    }

    public static void decorateWindowLayoutParams(Context context, ViewGroup.LayoutParams lp) {
        if (lp instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams winLP = (WindowManager.LayoutParams)lp;
            if (winLP.type >= 1 && winLP.type <= 99) {
                winLP.token = null;
            }
            if (winLP.type == 2) {
                if (!DeviceManager.isSysStatusBarShowing(context)) {
                    winLP.flags &= 0xFFFFF7FF;
                    winLP.flags |= 0x400;
                } else {
                    winLP.flags &= 0xFFFFFBFF;
                    winLP.flags |= 0x800;
                }
            }
        }
    }

    public static boolean isDeviceNeedClearBufferBeforeDraw() {
        String brand;
        if (gHasCheckDeviceNeedClearBufferBeforeDraw) {
            return gIsDeviceNeedClearBufferBeforeDraw;
        }
        gHasCheckDeviceNeedClearBufferBeforeDraw = true;
        String model = Build.MODEL;
        if (model != null && model.length() > 0) {
            for (String name : gModelListOfDeviceNeedClearBufferBeforeDraw) {
                if (name == null || !name.contains(model)) continue;
                gIsDeviceNeedClearBufferBeforeDraw = true;
                break;
            }
        }
        if (!gIsDeviceNeedClearBufferBeforeDraw && (brand = Build.BRAND) != null && brand.length() > 0) {
            for (String name : gBrandListOfDeviceNeedClearBufferBeforeDraw) {
                if (name == null || !name.contains(brand)) continue;
                gIsDeviceNeedClearBufferBeforeDraw = true;
                break;
            }
        }
        return gIsDeviceNeedClearBufferBeforeDraw;
    }

    public static boolean isDeviceNotCallAddLayoutNoLimitsFlag() {
        if (gHasCheckDeviceNotCallAddLayoutNoLimitsFlagTemporary) {
            return gIsDeviceNotCallAddLayoutNoLimitsFlagTemporary;
        }
        gHasCheckDeviceNotCallAddLayoutNoLimitsFlagTemporary = true;
        String model = Build.MODEL;
        int version = Build.VERSION.SDK_INT;
        if (version == 16 && model != null && model.length() > 0) {
            for (String name : gModelListOfDeviceNotCallAddLayoutNoLimitsFlagTemporary) {
                if (name == null || !name.equalsIgnoreCase(model.trim())) continue;
                gIsDeviceNotCallAddLayoutNoLimitsFlagTemporary = true;
                break;
            }
        }
        return gIsDeviceNotCallAddLayoutNoLimitsFlagTemporary;
    }

    public static boolean supportNavigationBar() {
        return mSupportNavitationBar;
    }

    public static void findIfSupportNavigationBar() {
        int apiLevel = Build.VERSION.SDK_INT;
        if (apiLevel < 19) {
            mSupportNavitationBar = false;
        }
    }

    public boolean isSysStatusBarShowing() {
        int val = this.getWindow().getAttributes().flags;
        return (val & 0x400) != 1024;
    }

    public void showSysStatusBar() {
        if (this.isSysStatusBarShowing()) {
            return;
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain(NotificationDef.N_FULL_SCREEN_MODE_CHANGE));
        Window window = this.getWindow();
        window.clearFlags(1024);
        window.addFlags(2048);
        if (DeviceManager.hasWindowFlag(window, 512)) {
            this.clearLayoutNoLimitsFlag();
        }
    }

    public void hideSysStatusBar() {
        if (!this.isSysStatusBarShowing()) {
            return;
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain(NotificationDef.N_FULL_SCREEN_MODE_CHANGE));
        Window window = this.getWindow();
        window.clearFlags(2048);
        window.addFlags(1024);
        if (SystemUtils.getStatusBarHeight((Context)this.mContext) != 0 || SystemUtils.isTransparentStatusBarEnable()) {
            this.addLayoutNoLimitsFlagTemporary();
        }
    }

    void setFullCutMode(Activity activity) {
        if (isSetShortcut) {
            return;
        }
        isSetShortcut = true;
        if (Build.VERSION.SDK_INT >= 28) {
            if (this.isCutmodeEdge(activity)) {
                return;
            }
            NotificationCenter.getGlobalInstance().notify(Notification.obtain(NotificationDef.N_FULL_SCREEN_SHORTCUT_MODE_CHANGE, true));
            this.setCutOutMode(activity, 1);
        } else {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain(NotificationDef.N_FULL_SCREEN_SHORTCUT_MODE_CHANGE, true));
        }
    }

    @RequiresApi(api=28)
    boolean isCutmodeEdge(Activity activity) {
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        return lp.layoutInDisplayCutoutMode == 1;
    }

    void setNotFullCutMode(Activity activity) {
        if (!isSetShortcut) {
            return;
        }
        isSetShortcut = false;
        if (Build.VERSION.SDK_INT >= 28) {
            if (!this.isCutmodeEdge(activity)) {
                return;
            }
            NotificationCenter.getGlobalInstance().notify(Notification.obtain(NotificationDef.N_FULL_SCREEN_SHORTCUT_MODE_CHANGE, false));
            this.setCutOutMode(activity, 0);
        } else {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain(NotificationDef.N_FULL_SCREEN_SHORTCUT_MODE_CHANGE, true));
        }
    }

    void setCutOutMode(Activity activity, int layoutInDisplayCutoutMode) {
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = layoutInDisplayCutoutMode;
            activity.getWindow().setAttributes(lp);
        }
    }

    public static void fullScreenOffsetView(Activity context, View view) {
        if (!DeviceManager.isSysStatusBarShowing((Context)context) && ScreenUtils.getInstance().hasNotch(context) && ScreenUtils.getScreenOrientation() != 2 || StatusBarManager.INSTANCE.isTranslucent()) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin + SystemUtils.getStatusBarHeight((Context)context), layoutParams.rightMargin, layoutParams.bottomMargin);
        }
    }

    public static void fullScreenOffsetViewWithTag(Activity context, View view) {
        if (!DeviceManager.isSysStatusBarShowing((Context)context) && ScreenUtils.getInstance().hasNotch(context) && ScreenUtils.getScreenOrientation() != 2 || StatusBarManager.INSTANCE.isTranslucent()) {
            Object haveSetOffset = view.getTag(-124);
            if (haveSetOffset != null && ((Boolean)haveSetOffset).booleanValue()) {
                return;
            }
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            view.setTag(-124, (Object)true);
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin + SystemUtils.getStatusBarHeight((Context)context), layoutParams.rightMargin, layoutParams.bottomMargin);
        }
    }

    public void resetOffestViewWithTag(Activity activity, View view) {
        if (view != null) {
            Object haveSetOffset = view.getTag(-124);
            if (haveSetOffset == null || !((Boolean)haveSetOffset).booleanValue()) {
                return;
            }
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin - SystemUtils.getStatusBarHeight((Context)activity), layoutParams.rightMargin, layoutParams.bottomMargin);
            view.setTag(-124, (Object)false);
        }
    }

    public void onPause() {
        if (DeviceManager.hasWindowFlag(this.getWindow(), 1024)) {
            this.addLayoutNoLimitsFlag();
        }
    }

    public void onResume() {
        if (DeviceManager.hasWindowFlag(this.getWindow(), 512)) {
            this.clearLayoutNoLimitsFlagDelay();
        }
    }

    private void addLayoutNoLimitsFlagTemporary() {
        this.addLayoutNoLimitsFlag();
        this.clearLayoutNoLimitsFlagDelay();
    }

    private void addLayoutNoLimitsFlag() {
        if (!DeviceManager.isDeviceNotCallAddLayoutNoLimitsFlag()) {
            Window window = this.getWindow();
            if (DeviceManager.hasWindowFlag(window, 512)) {
                window.getDecorView().removeCallbacks(this.mClearLayoutNoLimitsFlagRunnable);
            } else {
                window.addFlags(512);
            }
        }
    }

    private void clearLayoutNoLimitsFlag() {
        this.clearLayoutNoLimitsFlag(false);
    }

    private void clearLayoutNoLimitsFlagDelay() {
        this.clearLayoutNoLimitsFlag(true);
    }

    private void clearLayoutNoLimitsFlag(boolean delay) {
        Window window = this.getWindow();
        View decorView = window.getDecorView();
        decorView.removeCallbacks(this.mClearLayoutNoLimitsFlagRunnable);
        if (delay) {
            decorView.postDelayed(this.mClearLayoutNoLimitsFlagRunnable, 1500L);
        } else {
            window.clearFlags(512);
        }
    }

    public void removeClearLayoutNoLimitsFlagRunnable() {
        Window window = this.getWindow();
        View decorView = window.getDecorView();
        decorView.removeCallbacks(this.mClearLayoutNoLimitsFlagRunnable);
    }

    public void setSysOrientation(Activity activity, int orientationInfo) {
        activity.setRequestedOrientation(orientationInfo);
    }

    public void lockScreenOrientation(Activity activity) {
        boolean handled = false;
        try {
            int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
            if (rotation == 3) {
                int orientation = -1;
                orientation = ActivityInfo.class.getField("SCREEN_ORIENTATION_REVERSE_LANDSCAPE").getInt(null);
                this.setSysOrientation(activity, orientation);
                handled = true;
            }
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, (Throwable)t);
            handled = false;
        }
        if (!handled) {
            int ori = ScreenUtils.getScreenOrientation();
            if (ori == 2) {
                this.setSysOrientation(activity, 0);
            } else if (ori == 1) {
                this.setSysOrientation(activity, 1);
            }
        }
    }

    public void resetSysDefaultOrientation(Activity activity) {
        activity.setRequestedOrientation(-1);
    }

    public boolean isInputMethodShow(Activity activity) {
        return SystemServiceUtils.getInputMethodManager((Context)activity).isActive();
    }

    public void showInputMethod(Activity activity) {
        SystemServiceUtils.getInputMethodManager((Context)activity).toggleSoftInput(0, 1);
    }

    public void hideInputMethod(Activity activity) {
        this.hideInputMethodInner(activity, this.getWindow().getDecorView());
    }

    private void hideInputMethodInner(Activity activity, View view) {
        DeviceManager.hideInputMethod((Context)activity, view);
    }

    public boolean isColorDepth16Device() {
        return DeviceManager.isColorDeth16Device(this.mContext);
    }

    public void setWindowBgTransparent() {
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
    }

    public void setWindowBgNotTransparent() {
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(-16777216));
    }

    public void hideNavigationBar(boolean immersiveSticky) {
        if (mSupportNavitationBar) {
            Window win = this.getWindow();
            if (win == null) {
                return;
            }
            View view = win.getDecorView();
            int visibility = 3846;
            if (immersiveSticky) {
                visibility |= 0x1000;
            }
            try {
                ReflectionUtils.invokeObjectMethod((Object)view, (String)"setSystemUiVisibility", (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{visibility});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void hideNavigationBar() {
        this.hideNavigationBar(false);
    }

    public void showNavigationBar(boolean immerge) {
        if (mSupportNavitationBar) {
            Window win = this.getWindow();
            if (win == null) {
                return;
            }
            View view = win.getDecorView();
            int visibility = 0;
            if (immerge) {
                visibility = 1792;
            }
            try {
                ReflectionUtils.invokeObjectMethod((Object)view, (String)"setSystemUiVisibility", (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{visibility});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyStringToClipboard(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            SystemServiceUtils.getClipboardManager2((Context)RuntimeContext.sApplicationContext).setPrimaryClip(ClipData.newPlainText((CharSequence)"content", (CharSequence)url));
        } else {
            SystemServiceUtils.getClipboardManager((Context)RuntimeContext.sApplicationContext).setText((CharSequence)url);
        }
    }

    public void hideNavigationBarAndFull() {
        Window win = this.getWindow();
        if (win == null) {
            return;
        }
        View view = win.getDecorView();
        if (Build.VERSION.SDK_INT < 19) {
            view.setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            win.getDecorView().setSystemUiVisibility(5894);
        }
    }

    public void showNavigationBarAndFull(int color) {
        Window win = this.getWindow();
        if (win == null) {
            return;
        }
        View view = win.getDecorView();
        if (Build.VERSION.SDK_INT < 19) {
            view.setSystemUiVisibility(0);
        } else {
            if (Build.VERSION.SDK_INT >= 21 && color != -2) {
                win.clearFlags(0x8000000);
                win.addFlags(Integer.MIN_VALUE);
                win.setNavigationBarColor(color);
            }
            int uiOptions = 0;
            view.setSystemUiVisibility(uiOptions);
        }
    }

    public void setImmersiveSticky() {
        Window win = this.getWindow();
        if (Build.VERSION.SDK_INT >= 19) {
            int systemUiVisibility = win.getDecorView().getSystemUiVisibility();
            systemUiVisibility = systemUiVisibility | 0x100 | 0x400 | 0x1000;
            win.getDecorView().setSystemUiVisibility(systemUiVisibility);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = win.getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            win.setAttributes(lp);
        }
        if (Build.VERSION.SDK_INT <= 21 && Build.VERSION.SDK_INT >= 19) {
            win.addFlags(0x4000000);
        }
    }

    public void darkModeForM(boolean dark) {
        Window window = this.getWindow();
        if (Build.VERSION.SDK_INT >= 23) {
            int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
            systemUiVisibility = dark ? (systemUiVisibility |= 0x2000) : (systemUiVisibility &= 0xFFFFDFFF);
            window.getDecorView().setSystemUiVisibility(systemUiVisibility);
            window.setStatusBarColor(0);
        }
    }

    private Window getWindow() {
        if (this.mContext instanceof Activity) {
            return ((Activity)this.mContext).getWindow();
        }
        return null;
    }

    static {
        try {
            DeviceManager.findIfSupportNavigationBar();
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, (Throwable)t);
        }
        isSetShortcut = false;
    }

    private static class InputRunable
    implements Runnable {
        private Context mContext;
        private View mView;

        private InputRunable() {
        }

        private InputRunable setParams(Context context, View view) {
            this.mContext = context;
            this.mView = view;
            return this;
        }

        @Override
        public void run() {
            Context ct = this.mContext;
            final InputMethodManager inputMethodManager = SystemServiceUtils.getInputMethodManager((Context)ct);
            this.mContext = null;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (inputMethodManager != null && inputMethodManager.isActive()) {
                            inputMethodManager.hideSoftInputFromWindow(mView.getWindowToken(), 0);
                            mView = null;
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)"Devicemanage", (Throwable)e);
                    }
                }
            });
        }
    }
}

