/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.BigPicRecycler;
import com.yy.base.imageloader.GifHandler;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.sword.SwordHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.timing.TimingTracer;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import java.util.concurrent.CopyOnWriteArrayList;

@SuppressLint(value={"ViewConstructor"})
public class DefaultWindow
extends AbstractWindow {
    private DialogLinkManager mDialogLinkManager;
    private PanelLayer mPanelLayer;
    private int mLastSoftInputMode = 32;
    private int mCurSoftInputMode = -1;
    private final WindowMonitor mMonitor = new WindowMonitor();
    private static final CopyOnWriteArrayList<IGlobalWindowMonitor> sGlobalMonitors = new CopyOnWriteArrayList();
    private boolean mIsNeedDetachWatch = true;
    protected boolean mCurWindowShow = false;
    protected boolean mIsWindowInForeground;
    private int usableHeightPrevious;
    private FrameLayout.LayoutParams frameLayoutParams;
    private boolean isfirst = true;
    private int statusBarHeight;
    private int navigatorBarHeight;
    private boolean mIsAssisted = false;
    private ViewTreeObserver.OnGlobalLayoutListener mListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (DefaultWindow.this.isfirst) {
                DefaultWindow.this.statusBarHeight = StatusBarManager.INSTANCE.getStatusBarHeight(DefaultWindow.this.getContext());
                DefaultWindow.this.navigatorBarHeight = SystemUtils.getNavigationBarHeight((Context)DefaultWindow.this.getContext());
                DefaultWindow.this.usableHeightPrevious = DefaultWindow.this.getHeight();
                DefaultWindow.this.isfirst = false;
            }
            DefaultWindow.this.possiblyResizeChildOfContent();
        }
    };

    public DefaultWindow(Context context, UICallBacks callBacks, String name) {
        super(context, callBacks, AbstractWindow.WindowLayerType.USE_BASE_AND_BAR_LAYER, name);
        TimingTracer.beginTrace((String)this.getClass().getSimpleName());
        if (Build.VERSION.SDK_INT >= 29 || RuntimeContext.sIsAppStartFinished) {
            TimingTracer.addSplit((String)this.getClass().getSimpleName(), (String)"onCreate");
        }
        this.onMonitorCreate();
    }

    public DefaultWindow(Context context, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType, String name) {
        super(context, callBacks, useLayerType, name);
        if (Build.VERSION.SDK_INT >= 29 || RuntimeContext.sIsAppStartFinished) {
            TimingTracer.beginTrace((String)this.getClass().getSimpleName());
            TimingTracer.addSplit((String)this.getClass().getSimpleName(), (String)"onCreate");
        }
        this.onMonitorCreate();
    }

    public DialogLinkManager getDialogLinkManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.getContext());
        }
        return this.mDialogLinkManager;
    }

    @Override
    public boolean isTranslucentBar() {
        return "BbsChannelMix".equals(this.getName());
    }

    @Override
    public boolean isDarkMode() {
        return "BbsChannelMix".equals(this.getName());
    }

    @Override
    protected void onWindowStateChange(byte stateFlag) {
        super.onWindowStateChange(stateFlag);
        switch (stateFlag) {
            case 0: 
            case 6: {
                if (Build.VERSION.SDK_INT >= 29 || RuntimeContext.sIsAppStartFinished) {
                    TimingTracer.addSplit((String)this.getClass().getSimpleName(), (String)"beforeShow");
                }
                this.beforeShow();
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                this.mMonitor.onShown();
                this.onMonitorShown();
                if (Build.VERSION.SDK_INT >= 29 || RuntimeContext.sIsAppStartFinished) {
                    TimingTracer.addSplit((String)this.getClass().getSimpleName(), (String)"onShown");
                }
                this.onShown();
                if (Build.VERSION.SDK_INT < 29 && !RuntimeContext.sIsAppStartFinished) break;
                TimingTracer.stopTrace((String)this.getClass().getSimpleName());
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                this.mMonitor.onHidden();
                this.onMonitorHidden();
                this.onHidden();
                break;
            }
            case 3: 
            case 9: {
                this.beforeHide();
                break;
            }
            case 13: {
                this.onDetached();
                this.onMonitorDetach();
                break;
            }
            case 12: {
                if (Build.VERSION.SDK_INT >= 29 || RuntimeContext.sIsAppStartFinished) {
                    TimingTracer.addSplit((String)this.getClass().getSimpleName(), (String)"onAttach");
                }
                this.onAttach();
                break;
            }
        }
    }

    public void beforeShow() {
        if (this.mCallBacks != null) {
            this.mCallBacks.beforeWindowShow(this);
        }
        for (IGlobalWindowMonitor monitor : sGlobalMonitors) {
            monitor.beforeShow(this);
        }
        if (StatusBarManager.INSTANCE.isTranslucent(this)) {
            this.assistWindow((View)this);
        }
    }

    public void onShown() {
        this.mCurWindowShow = true;
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)("WindowLifeCycle_" + this.toString()), (String)"onShown", (Object[])new Object[0]);
        } else {
            MLog.info((Object)("WindowLifeCycle_" + this.getName()), (String)"onShown", (Object[])new Object[0]);
        }
        if (this.mCallBacks != null) {
            this.mCallBacks.onWindowShown(this);
        }
        RuntimeContext.sCurWin = this.getName();
        if (this.mCurSoftInputMode > 0) {
            this.setSoftInputMode(this.mCurSoftInputMode);
        }
        if (StatusBarManager.INSTANCE.isTranslucent(this)) {
            this.assistWindow((View)this);
        }
        GifHandler.restartGif((ViewGroup)this);
        BigPicRecycler.recoveryBigPicIfNeed((ViewGroup)this);
    }

    public void beforeHide() {
        if (this.mCallBacks != null) {
            this.mCallBacks.beforeWindowHide(this);
        }
        if (StatusBarManager.INSTANCE.isTranslucent(this)) {
            this.resetAssist();
        }
    }

    public void onHidden() {
        this.mCurWindowShow = false;
        MLog.info((Object)("WindowLifeCycle_" + this.getName()), (String)"onHidden", (Object[])new Object[0]);
        if (this.mCallBacks != null) {
            this.mCallBacks.onWindowHidden(this);
        }
        if (StatusBarManager.INSTANCE.isTranslucent(this)) {
            this.resetAssist();
        }
        GifHandler.stopGif((ViewGroup)this);
    }

    public void onDetached() {
        MLog.info((Object)("WindowLifeCycle_" + this.getName()), (String)"onDetached", (Object[])new Object[0]);
        if (this.mCallBacks != null) {
            this.mCallBacks.onWindowDetach(this);
        }
        this.resetSoftInputMode();
        if (this.mIsNeedDetachWatch) {
            SwordHelper.leakWatch((Object)this, (String)"Window detached");
        }
    }

    protected void setIsNeedDetachWatch(boolean isNeedDetachWatch) {
        this.mIsNeedDetachWatch = isNeedDetachWatch;
    }

    public void onAttach() {
        MLog.info((Object)("WindowLifeCycle_" + this.getName()), (String)"onAttach", (Object[])new Object[0]);
        if (this.mCallBacks != null) {
            this.mCallBacks.onWindowAttach(this);
        }
        this.storeLastSoftInputMode();
    }

    public PanelLayer getPanelLayer() {
        if (this.mPanelLayer == null) {
            this.mPanelLayer = new PanelLayer(this.getContext());
            this.getBarLayer().addView((View)this.mPanelLayer, new ViewGroup.LayoutParams(-1, -1));
        }
        return this.mPanelLayer;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean interceptor;
        if (event == null) {
            return super.dispatchKeyEvent(event);
        }
        if (event.getKeyCode() == 4 && event.getAction() == 1 && this.mPanelLayer != null && (interceptor = this.mPanelLayer.onBackKeyEvent())) {
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    public void setSoftInputMode(int mode) {
        int cur;
        this.mCurSoftInputMode = mode;
        if (!this.isAnimating() && (cur = this.getSoftInputMode()) != mode && this.getContext() instanceof Activity) {
            ((Activity)this.getContext()).getWindow().setSoftInputMode(mode);
        }
    }

    private void resetSoftInputMode() {
        int cur = this.getSoftInputMode();
        if (cur == this.mCurSoftInputMode && cur != this.mLastSoftInputMode && this.getContext() instanceof Activity) {
            ((Activity)this.getContext()).getWindow().setSoftInputMode(this.mLastSoftInputMode);
        }
    }

    public IWindowMonitor getWindowMonitor() {
        return this.mMonitor;
    }

    public static void addGlobalMonitor(IGlobalWindowMonitor globalMonitor) {
        if (globalMonitor == null) {
            return;
        }
        if (!sGlobalMonitors.contains(globalMonitor)) {
            sGlobalMonitors.add(globalMonitor);
        }
    }

    public static void removeGlobalMonitor(IGlobalWindowMonitor globalMonitor) {
        if (globalMonitor == null) {
            return;
        }
        sGlobalMonitors.remove(globalMonitor);
    }

    private void storeLastSoftInputMode() {
        if (this.getContext() instanceof Activity) {
            this.mLastSoftInputMode = this.getSoftInputMode();
        }
    }

    private int getSoftInputMode() {
        if (this.getContext() instanceof Activity) {
            return ((Activity)this.getContext()).getWindow().getAttributes().softInputMode;
        }
        return 32;
    }

    private void onMonitorCreate() {
        for (IGlobalWindowMonitor monitor : sGlobalMonitors) {
            monitor.onWindowCreate(this);
        }
    }

    private void onMonitorShown() {
        for (IGlobalWindowMonitor monitor : sGlobalMonitors) {
            monitor.onShown(this);
        }
    }

    private void onMonitorHidden() {
        for (IGlobalWindowMonitor monitor : sGlobalMonitors) {
            monitor.onHidden(this);
        }
    }

    private void onMonitorDetach() {
        for (IGlobalWindowMonitor monitor : sGlobalMonitors) {
            monitor.onDetach(this);
        }
    }

    @Override
    protected void onLayout(final boolean changed, final int left, final int top, final int right, final int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ScreenUtils.getInstance().getHeightPixels() <= bottom) {
                    if (DefaultWindow.this.mDialogLinkManager != null && DefaultWindow.this.mDialogLinkManager.isDialogShowing()) {
                        return;
                    }
                    for (IGlobalWindowMonitor monitor : sGlobalMonitors) {
                        monitor.onLayout(changed, left, top, right, bottom);
                    }
                }
            }
        });
    }

    public void assistWindow(View window) {
        if (this.mIsAssisted) {
            return;
        }
        this.mIsAssisted = true;
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.mListener);
        this.frameLayoutParams = (FrameLayout.LayoutParams)this.getLayoutParams();
    }

    private void resetAssist() {
        this.mIsAssisted = false;
        this.getViewTreeObserver().removeOnGlobalLayoutListener(this.mListener);
    }

    public void possiblyResizeChildOfContent() {
        int usableHeightNow = this.computeUsableHeight();
        if (usableHeightNow != this.usableHeightPrevious) {
            int usableHeightSansKeyboard = this.getRootView().getHeight();
            int heightDifference = usableHeightSansKeyboard - usableHeightNow;
            if (heightDifference > usableHeightSansKeyboard / 4) {
                this.frameLayoutParams.height = usableHeightNow;
            } else {
                int height = this.computeOriginalHeight(usableHeightNow, usableHeightSansKeyboard);
                if (!StatusBarManager.INSTANCE.isTranslucent(this)) {
                    height -= this.statusBarHeight;
                }
                this.frameLayoutParams.height = height;
            }
            this.setLayoutParams((ViewGroup.LayoutParams)this.frameLayoutParams);
            this.usableHeightPrevious = usableHeightNow;
        }
    }

    private int computeUsableHeight() {
        Rect r = new Rect();
        this.getWindowVisibleDisplayFrame(r);
        if (Build.VERSION.SDK_INT >= 19) {
            return r.bottom - r.top + this.statusBarHeight;
        }
        return r.bottom - r.top;
    }

    private int computeOriginalHeight(int usableHeightNow, int usableHeightSansKeyboard) {
        int height = 0;
        height = Build.VERSION.SDK_INT >= 19 ? (usableHeightSansKeyboard == usableHeightNow + this.navigatorBarHeight ? (this.isNeedHideNavigationBar() ? usableHeightSansKeyboard : usableHeightSansKeyboard - this.navigatorBarHeight) : usableHeightSansKeyboard) : (usableHeightSansKeyboard == usableHeightNow + this.navigatorBarHeight + this.statusBarHeight ? usableHeightSansKeyboard - this.navigatorBarHeight : usableHeightSansKeyboard);
        return height;
    }

    public static boolean isHisWindowRealVisble(IRecycleView recycleView) {
        if (recycleView instanceof DefaultWindow) {
            return ((DefaultWindow)recycleView).mIsWindowInForeground;
        }
        if (recycleView instanceof View) {
            ViewParent parent = ((View)recycleView).getParent();
            do {
                if (!(parent instanceof DefaultWindow)) continue;
                return ((DefaultWindow)parent).mIsWindowInForeground;
            } while ((parent = parent.getParent()) != null);
        }
        return false;
    }

    public void onWindowRealVisible() {
        MLog.info((Object)this.getName(), (String)"onWindowRealVisible oldFlag:%d", (Object[])new Object[]{this.mIsWindowInForeground ? 1 : 0});
        this.mIsWindowInForeground = true;
        super.onWindowRealVisible();
    }

    public void onWindowInvisible() {
        MLog.info((Object)this.getName(), (String)"onWindowInvisble oldFlag:%d", (Object[])new Object[]{this.mIsWindowInForeground ? 1 : 0});
        this.mIsWindowInForeground = false;
        super.onWindowInvisible();
    }

    public boolean getCurWindowShow() {
        return this.mCurWindowShow;
    }

    private static class WindowMonitor
    implements IWindowMonitor {
        private long mShowStartTime;
        private long mShowTime;

        private WindowMonitor() {
        }

        void onShown() {
            this.mShowStartTime = SystemClock.uptimeMillis();
        }

        void onHidden() {
            this.mShowTime = SystemClock.uptimeMillis() - this.mShowStartTime;
        }

        @Override
        public long getShowStartTime() {
            return this.mShowStartTime;
        }

        @Override
        public long getShowTime() {
            return this.mShowTime;
        }
    }

    public static interface IWindowMonitor {
        public long getShowStartTime();

        public long getShowTime();
    }

    public static interface IGlobalWindowMonitor {
        default public void beforeShow(DefaultWindow window) {
        }

        public void onWindowCreate(DefaultWindow var1);

        public void onShown(DefaultWindow var1);

        public void onHidden(DefaultWindow var1);

        default public void onDetach(DefaultWindow window) {
        }

        public void onLayout(boolean var1, int var2, int var3, int var4, int var5);
    }
}

