/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.framework.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CollapsedTextView
extends YYTextView
implements View.OnClickListener {
    private static final String ELLIPSE = "...";
    public static final int COLLAPSED_LINES = 4;
    private static final String EXPANDED_TEXT = "";
    private static final String COLLAPSED_TEXT = "";
    public static final int END = 0;
    public static final int BOTTOM = 1;
    private int mCollapsedLines;
    private String mExpandedText;
    private String mCollapsedText;
    private Drawable mExpandedDrawable;
    private Drawable mCollapsedDrawable;
    private CharSequence mOriginalText;
    private int mShowWidth;
    private boolean mIsExpanded;
    private int mTipsGravity;
    private int mTipsColor;
    private boolean mTipsUnderline;
    private boolean mTipsClickable;
    private ExpandedClickableSpan mClickableSpan = new ExpandedClickableSpan();
    private View.OnClickListener mListener;
    private boolean mIsResponseListener = true;
    private String mEllipseText;

    public CollapsedTextView(Context context) {
        this(context, null);
    }

    public CollapsedTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CollapsedTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typed = context.obtainStyledAttributes(attrs, R.styleable.CollapsedTextView);
            this.mCollapsedLines = typed.getInt(R.styleable.CollapsedTextView_collapsedLines, 4);
            this.setExpandedText(typed.getString(R.styleable.CollapsedTextView_expandedText));
            this.setCollapsedText(typed.getString(R.styleable.CollapsedTextView_collapsedText));
            this.setExpandedDrawable(typed.getDrawable(R.styleable.CollapsedTextView_expandedDrawable));
            this.setEllipseText(typed.getString(R.styleable.CollapsedTextView_ellipseText));
            this.setCollapsedDrawable(typed.getDrawable(R.styleable.CollapsedTextView_collapsedDrawable));
            this.mTipsGravity = typed.getInt(R.styleable.CollapsedTextView_tipsGravity, 0);
            this.mTipsColor = typed.getColor(R.styleable.CollapsedTextView_tipsColor, 0);
            this.mTipsUnderline = typed.getBoolean(R.styleable.CollapsedTextView_tipsUnderline, false);
            this.mTipsClickable = typed.getBoolean(R.styleable.CollapsedTextView_tipsClickable, true);
            typed.recycle();
        }
    }

    public void setCollapsedLines(@IntRange(from=0L) int collapsedLines) {
        this.mCollapsedLines = collapsedLines;
    }

    public void setExpandedText(String expandedText) {
        this.mExpandedText = TextUtils.isEmpty((CharSequence)expandedText) ? "" : expandedText;
    }

    public void setCollapsedText(String collapsedText) {
        this.mCollapsedText = TextUtils.isEmpty((CharSequence)collapsedText) ? "" : collapsedText;
    }

    public void setEllipseText(String ellipseText) {
        this.mEllipseText = ellipseText == null ? ELLIPSE : ellipseText;
    }

    public void setExpandedDrawableRes(@DrawableRes int resId) {
        this.setExpandedDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setExpandedDrawable(Drawable expandedDrawable) {
        if (expandedDrawable != null) {
            this.mExpandedDrawable = expandedDrawable;
            this.mExpandedDrawable.setBounds(0, 0, this.mExpandedDrawable.getIntrinsicWidth(), this.mExpandedDrawable.getIntrinsicHeight());
        }
    }

    public void setCollapsedDrawableRes(@DrawableRes int resId) {
        this.setCollapsedDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setCollapsedDrawable(Drawable collapsedDrawable) {
        if (collapsedDrawable != null) {
            this.mCollapsedDrawable = collapsedDrawable;
            this.mCollapsedDrawable.setBounds(0, 0, this.mCollapsedDrawable.getIntrinsicWidth(), this.mCollapsedDrawable.getIntrinsicHeight());
        }
    }

    public void setTipsGravity(int tipsGravity) {
        this.mTipsGravity = tipsGravity;
    }

    public void setTipsColor(@ColorInt int tipsColor) {
        this.mTipsColor = tipsColor;
    }

    public void setTipsUnderline(boolean tipsUnderline) {
        this.mTipsUnderline = tipsUnderline;
    }

    public void setTipsClickable(boolean tipsClickable) {
        this.mTipsClickable = tipsClickable;
    }

    public void setText(final CharSequence text, final TextView.BufferType type) {
        if (TextUtils.isEmpty((CharSequence)text) || this.mCollapsedLines == 0) {
            super.setText(text, type);
        } else if (this.mIsExpanded) {
            this.mOriginalText = CharUtil.trimFrom(text);
            this.formatExpandedText(type);
        } else if (this.mShowWidth == 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    CollapsedTextView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    CollapsedTextView.this.mShowWidth = CollapsedTextView.this.getWidth() - CollapsedTextView.this.getPaddingLeft() - CollapsedTextView.this.getPaddingRight();
                    CollapsedTextView.this.formatCollapsedText(type, text);
                }
            });
        } else {
            this.formatCollapsedText(type, text);
        }
    }

    private void formatCollapsedText(TextView.BufferType type, CharSequence text) {
        this.mOriginalText = CharUtil.trimFrom(text);
        Layout layout = this.getLayout();
        if (layout == null || !layout.getText().equals(this.mOriginalText)) {
            super.setText(this.mOriginalText, type);
            layout = this.getLayout();
        }
        if (layout == null) {
            return;
        }
        TextPaint paint = this.getPaint();
        int line = layout.getLineCount();
        if (line <= this.mCollapsedLines) {
            super.setText(this.mOriginalText, type);
        } else {
            int lastLineStart = layout.getLineStart(this.mCollapsedLines - 1);
            int lastLineEnd = layout.getLineVisibleEnd(this.mCollapsedLines - 1);
            int expandedTextWidth = this.mTipsGravity == 0 ? (int)paint.measureText(this.mEllipseText + " " + this.mExpandedText) : (int)paint.measureText(this.mEllipseText + " ");
            float lastLineWidth = layout.getLineWidth(this.mCollapsedLines - 1);
            if (lastLineWidth + (float)expandedTextWidth > (float)this.mShowWidth) {
                int cutCount = paint.breakText(this.mOriginalText, lastLineStart, lastLineEnd, false, (float)expandedTextWidth, null);
                lastLineEnd -= cutCount;
            }
            SpannableStringBuilder spannable = new SpannableStringBuilder();
            CharSequence ellipsizeText = this.mOriginalText.subSequence(0, lastLineEnd);
            spannable.append(ellipsizeText);
            spannable.append((CharSequence)this.mEllipseText);
            this.setSpan(spannable);
            super.setText((CharSequence)spannable, type);
        }
    }

    private void formatExpandedText(TextView.BufferType type) {
        SpannableStringBuilder spannable = new SpannableStringBuilder(this.mOriginalText);
        this.setSpan(spannable);
        super.setText((CharSequence)spannable, type);
    }

    private void setSpan(SpannableStringBuilder spannable) {
        int tipsLen;
        Drawable drawable;
        if (this.mTipsGravity == 0) {
            spannable.append((CharSequence)" ");
        } else {
            spannable.append((CharSequence)"\n");
        }
        if (this.mIsExpanded) {
            spannable.append((CharSequence)this.mCollapsedText);
            drawable = this.mCollapsedDrawable;
            tipsLen = this.mCollapsedText.length();
        } else {
            spannable.append((CharSequence)this.mExpandedText);
            drawable = this.mExpandedDrawable;
            tipsLen = this.mExpandedText.length();
        }
        spannable.setSpan((Object)this.mClickableSpan, spannable.length() - tipsLen, spannable.length(), 17);
        if (drawable != null) {
            spannable.setSpan((Object)new ImageSpan(drawable, 1), spannable.length() - tipsLen, spannable.length(), 17);
            spannable.append((CharSequence)" ");
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.mListener = l;
        super.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (!this.mIsResponseListener) {
            this.mIsResponseListener = true;
        } else if (this.mListener != null) {
            this.mListener.onClick(v);
        }
    }

    public static class CharUtil {
        public static CharSequence trimFrom(CharSequence sequence) {
            int last;
            int len = sequence.length();
            int first = 0;
            for (last = len - 1; last > first && CharUtil.matches(sequence.charAt(last)); --last) {
            }
            return sequence.subSequence(first, last + 1);
        }

        private static boolean matches(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': {
                    return true;
                }
                case '\u2007': {
                    return false;
                }
            }
            return c >= '\u2000' && c <= '\u200a';
        }
    }

    private class ExpandedClickableSpan
    extends ClickableSpan {
        private ExpandedClickableSpan() {
        }

        public void onClick(View widget) {
            if (CollapsedTextView.this.mTipsClickable) {
                CollapsedTextView.this.mIsResponseListener = false;
                CollapsedTextView.this.mIsExpanded = !CollapsedTextView.this.mIsExpanded;
                CollapsedTextView.this.setText(CollapsedTextView.this.mOriginalText);
            }
        }

        public void updateDrawState(TextPaint ds) {
            ds.setColor(CollapsedTextView.this.mTipsColor == 0 ? ds.linkColor : CollapsedTextView.this.mTipsColor);
            ds.setUnderlineText(CollapsedTextView.this.mTipsUnderline);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TipsGravityMode {
    }
}

