/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.PanelLayer;

public class BasePanel
extends YYRelativeLayout
implements INotify,
Animation.AnimationListener {
    public static final String TAG = "AbstractPanel";
    public static final boolean DEBUG = false;
    public static final int POPUP_ANI_DURATION = 300;
    public static final int POPDOWN_ANI_DURATION = 300;
    public static final Interpolator mPopUpAnimInterpolator = new Interpolator(){

        public float getInterpolation(float input) {
            return (float)((double)input == 1.0 ? 1.0 : 1.001 * (-Math.pow(2.0, -10.0f * input) + 1.0));
        }
    };
    protected PanelLayer mWrapper;
    protected Animation mShowAnim = this.createLeftShowAnimation();
    protected Animation mHideAnim = this.createLeftHideAnimation();
    protected IPanelListener mListener;
    protected Context mContext;
    private View mContent;
    private boolean mIsShowing = false;
    private boolean mShowAnimating = false;
    private boolean mCanHideOutside = true;
    private boolean mCanKeyback = true;
    private boolean mEnableTouchThrough = false;
    private IInterceptorBackKeyEventCallback mInterceptorBackKeyEventCallback;
    private boolean mOutHideAnim = true;

    public BasePanel(Context context) {
        super(context);
        this.mContext = context;
        this.init();
        this.setVisibility(4);
    }

    void setPanelLayer(PanelLayer panelLayer) {
        this.mWrapper = panelLayer;
    }

    private void init() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ORIENTATION_CHANGE, this);
    }

    public void setContent(View v) {
        this.setContent(v, null);
    }

    public void setContent(View v, RelativeLayout.LayoutParams params) {
        if (v == null) {
            return;
        }
        if (v.getParent() != null) {
            ((ViewGroup)v.getParent()).removeView(v);
        }
        if (this.mContent != null && this.mContent.getParent() != null) {
            this.removeViewInLayout(this.mContent);
        }
        this.mContent = v;
        if (params != null) {
            this.addView(v, (ViewGroup.LayoutParams)params);
        } else {
            this.addView(v);
        }
    }

    public void setListener(IPanelListener listener) {
        this.mListener = listener;
    }

    public Animation createLeftShowAnimation() {
        AnimationSet aniSet = new AnimationSet(false);
        TranslateAnimation tranAni = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        tranAni.setDuration(300L);
        tranAni.setInterpolator(mPopUpAnimInterpolator);
        aniSet.addAnimation((Animation)tranAni);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }

    public Animation createLeftHideAnimation() {
        AnimationSet aniSet = new AnimationSet(false);
        TranslateAnimation tranAni = new TranslateAnimation(1, 0.0f, 1, -1.0f, 1, 0.0f, 1, 0.0f);
        tranAni.setDuration(300L);
        tranAni.setInterpolator(mPopUpAnimInterpolator);
        aniSet.addAnimation((Animation)tranAni);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }

    public Animation createRightShowAnimation() {
        AnimationSet aniSet = new AnimationSet(false);
        TranslateAnimation tranAni = new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        tranAni.setDuration(300L);
        tranAni.setInterpolator(mPopUpAnimInterpolator);
        aniSet.addAnimation((Animation)tranAni);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }

    public Animation createRightHideAnimation() {
        AnimationSet aniSet = new AnimationSet(false);
        TranslateAnimation tranAni = new TranslateAnimation(1, 0.0f, 1, 1.0f, 1, 0.0f, 1, 0.0f);
        tranAni.setDuration(300L);
        tranAni.setInterpolator(mPopUpAnimInterpolator);
        aniSet.addAnimation((Animation)tranAni);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }

    public Animation createBottomShowAnimation() {
        AnimationSet aniSet = new AnimationSet(false);
        TranslateAnimation tranAni = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        tranAni.setDuration(300L);
        tranAni.setInterpolator(mPopUpAnimInterpolator);
        aniSet.addAnimation((Animation)tranAni);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }

    public Animation createBottomHideAnimation() {
        AnimationSet aniSet = new AnimationSet(false);
        TranslateAnimation tranAni = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        tranAni.setDuration(300L);
        tranAni.setInterpolator((Interpolator)new DecelerateInterpolator());
        aniSet.addAnimation((Animation)tranAni);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        return aniSet;
    }

    public void setShowAnim(Animation anim) {
        if (this.mShowAnim != null) {
            this.mShowAnim.setAnimationListener(null);
        }
        this.mShowAnim = anim;
        this.mShowAnim.setFillAfter(true);
        this.mShowAnim.setAnimationListener((Animation.AnimationListener)this);
    }

    public void setHideAnim(Animation anim) {
        if (this.mHideAnim != null) {
            this.mHideAnim.setAnimationListener(null);
        }
        this.mHideAnim = anim;
        this.mHideAnim.setFillAfter(true);
        this.mHideAnim.setAnimationListener((Animation.AnimationListener)this);
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isShowAnimating() {
        return this.mShowAnimating;
    }

    public void showBalckMask(boolean show) {
        if (show) {
            this.setBackgroundColor(-16777216);
            this.getBackground().setAlpha(127);
        } else {
            this.setBackgroundDrawable(null);
        }
    }

    protected void show(boolean animated) {
        if (this.mContent.getAnimation() != null) {
            this.mContent.getAnimation().cancel();
        }
        if (this.getParent() != null && this.getParent() != this.mWrapper) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (this.getParent() == null) {
            this.mWrapper.addView((View)this);
        }
        this.onShow();
        this.mIsShowing = true;
        if (this.mListener != null) {
            this.mListener.onPanelShow(this, animated);
        }
        this.setVisibility(0);
        if (animated) {
            this.mShowAnimating = true;
            this.mContent.startAnimation(this.mShowAnim);
        } else {
            this.onShown();
            if (this.mListener != null) {
                this.mListener.onPanelShown(this);
            }
        }
    }

    protected void onShow() {
    }

    protected void onShown() {
    }

    protected void hide(boolean animated) {
        if (this.mWrapper == null) {
            return;
        }
        if (this.mContent.getAnimation() != null) {
            this.mContent.getAnimation().cancel();
            this.mShowAnimating = false;
        }
        if (!animated && this.getParent() == this.mWrapper && this.mWrapper != null) {
            this.mWrapper.removeView((View)this);
        }
        this.mIsShowing = false;
        this.onHide();
        if (this.mListener != null) {
            this.mListener.onPanelHide(this, animated);
        }
        if (animated) {
            this.mContent.startAnimation(this.mHideAnim);
        } else {
            this.setVisibility(8);
            this.onHidden();
            if (this.mListener != null) {
                this.mListener.onPanelHidden(this);
            }
        }
    }

    public void terminate() {
        if (this.isShown()) {
            this.setVisibility(8);
            if (this.mHideAnim != null) {
                this.mHideAnim.cancel();
            }
            this.onHidden();
            this.onTerminate();
        }
    }

    public void onTerminate() {
    }

    protected void onHide() {
    }

    protected void onHidden() {
        if (this.mWrapper != null) {
            this.mWrapper.onPanelHidden(this);
        }
    }

    void toggle(boolean animated) {
        if (this.isShowing()) {
            this.hide(animated);
        } else {
            this.show(animated);
        }
    }

    public void onAnimationEnd(Animation animation) {
        if (animation == this.mHideAnim) {
            if (!this.mShowAnimating && this.getParent() == this.mWrapper && this.mWrapper != null) {
                this.mWrapper.removeView((View)this);
            }
            this.onHidden();
            if (this.mListener != null) {
                this.mListener.onPanelHidden(this);
            }
        } else if (animation == this.mShowAnim) {
            this.mShowAnimating = false;
            this.onShown();
            if (this.mListener != null) {
                this.mListener.onPanelShown(this);
            }
        }
        this.mContent.setAnimation(null);
    }

    public void setCanHideOutside(boolean mCanHideOutside) {
        this.mCanHideOutside = mCanHideOutside;
    }

    public boolean canHideOutside() {
        return this.mCanHideOutside;
    }

    public void setCanKeyback(boolean canKeyback) {
        this.mCanKeyback = canKeyback;
    }

    public boolean canKeyback() {
        return this.mCanKeyback;
    }

    public void setInterceptorBackKeyEventCallback(IInterceptorBackKeyEventCallback callback) {
        this.mInterceptorBackKeyEventCallback = callback;
    }

    public boolean isIgnoreDispatchKeyEvent() {
        return this.mCanKeyback;
    }

    public boolean isInterceptorBackKeyEvent() {
        if (this.mInterceptorBackKeyEventCallback != null) {
            return this.mInterceptorBackKeyEventCallback.isInterceptorBackKeyEvent();
        }
        return true;
    }

    public boolean isEnableTouchThrough() {
        return this.mEnableTouchThrough;
    }

    public void setEnableTouchThrough(boolean mEnableTouchThrough) {
        this.mEnableTouchThrough = mEnableTouchThrough;
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationStart(Animation animation) {
    }

    @Override
    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_ORIENTATION_CHANGE) {
            this.hide(false);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDraw(canvas);
        }
        catch (Throwable e) {
            if (RuntimeContext.isInGray()) {
                throw new RuntimeException(e);
            }
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public boolean isOutHideAnim() {
        return this.mOutHideAnim;
    }

    public void setOutHideAnim(boolean outHideAnim) {
        this.mOutHideAnim = outHideAnim;
    }

    public static interface IInterceptorBackKeyEventCallback {
        public boolean isInterceptorBackKeyEvent();
    }

    public static class SimplePanelListener
    implements IPanelListener {
        @Override
        public void onPanelShow(BasePanel panel, boolean animated) {
        }

        @Override
        public void onPanelHide(BasePanel panel, boolean animated) {
        }

        @Override
        public void onPanelShown(BasePanel panel) {
        }

        @Override
        public void onPanelHidden(BasePanel panel) {
        }
    }

    public static interface IPanelListener {
        public void onPanelShow(BasePanel var1, boolean var2);

        public void onPanelHide(BasePanel var1, boolean var2);

        public void onPanelShown(BasePanel var1);

        public void onPanelHidden(BasePanel var1);
    }
}

