/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.SystemUtils;
import java.util.ArrayList;
import java.util.List;

public class BaseLayerLayout
extends ViewGroup {
    public static final int TYPE_UNSPECIFIED = 0;
    public static final int TYPE_CONTENT_VIEW = 1;
    public static final int TYPE_TITLE_BAR = 2;
    public static final int TYPE_TOOL_BAR = 3;
    private List<View> mTitleBars = new ArrayList<View>();
    private List<View> mToolBars = new ArrayList<View>();
    private List<View> mContentViews = new ArrayList<View>();
    private List<View> mUnspecifiedViews = new ArrayList<View>();
    private int mTitleBarMaxHeight = 0;
    private int mToolBarMaxHeight = 0;

    public BaseLayerLayout(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childMarginVertical;
        this.mTitleBars.clear();
        this.mToolBars.clear();
        this.mContentViews.clear();
        this.mUnspecifiedViews.clear();
        this.mTitleBarMaxHeight = 0;
        this.mToolBarMaxHeight = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            this.findSpecifiedView(child, lp);
        }
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        int horizontalPadding = this.getPaddingLeft() + this.getPaddingRight();
        int maxWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - horizontalPadding;
        int maxHeight = View.MeasureSpec.getSize((int)heightMeasureSpec) - verticalPadding;
        int titleBarCount = this.mTitleBars.size();
        for (int i = 0; i < titleBarCount; ++i) {
            View child = this.mTitleBars.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childMarginHorizontal = lp.leftMargin + lp.rightMargin;
            int childMaxWidth = maxWidth - childMarginHorizontal;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childMaxWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
            int childMarginVertical2 = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + childMarginVertical2;
            if (this.mTitleBarMaxHeight >= childHeight) continue;
            this.mTitleBarMaxHeight = childHeight;
        }
        int toolBarCount = this.mToolBars.size();
        if (toolBarCount == 0) {
            this.mToolBarMaxHeight = 0;
        } else {
            for (int i = 0; i < toolBarCount; ++i) {
                View child = this.mToolBars.get(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                int childMarginHorizontal = lp.leftMargin + lp.rightMargin;
                int childMaxWidth = maxWidth - childMarginHorizontal;
                child.measure(View.MeasureSpec.makeMeasureSpec((int)childMaxWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
                childMarginVertical = lp.topMargin + lp.bottomMargin;
                int childHeight = child.getMeasuredHeight() + childMarginVertical;
                if (this.mToolBarMaxHeight >= childHeight) continue;
                this.mToolBarMaxHeight = childHeight;
            }
        }
        int contentCount = this.mContentViews.size();
        for (int i = 0; i < contentCount; ++i) {
            View child = this.mContentViews.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childMarginHorizontal = lp.leftMargin + lp.rightMargin;
            childMarginVertical = lp.topMargin + lp.bottomMargin;
            int childMaxWidth = maxWidth - childMarginHorizontal;
            int childMaxHeight = maxHeight - this.mTitleBarMaxHeight - this.mToolBarMaxHeight - childMarginVertical;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childMaxWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childMaxHeight, (int)0x40000000));
        }
        int unspecifiedCount = this.mUnspecifiedViews.size();
        try {
            for (int i = 0; i < unspecifiedCount; ++i) {
                View child = this.mUnspecifiedViews.get(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                int childMarginHorizontal = lp.leftMargin + lp.rightMargin;
                int childMarginVertical3 = lp.topMargin + lp.bottomMargin;
                int childMaxWidth = maxWidth - childMarginHorizontal;
                int childMaxHeight = maxHeight - childMarginVertical3;
                child.measure(View.MeasureSpec.makeMeasureSpec((int)childMaxWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childMaxHeight, (int)0x40000000));
            }
        }
        catch (Exception e) {
            if (SystemUtils.isShowEnvSetting() && RuntimeContext.sIsDebuggable) {
                throw e;
            }
            e.printStackTrace();
        }
        this.setMeasuredDimension(BaseLayerLayout.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), BaseLayerLayout.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childTop;
        int childLeft;
        int childTop2;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int contentTop = paddingTop + this.mTitleBarMaxHeight;
        int contentBottom = b - t - paddingBottom - this.mToolBarMaxHeight;
        int titleBarCount = this.mTitleBars.size();
        for (int i = 0; i < titleBarCount; ++i) {
            View child = this.mTitleBars.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childLeft2 = paddingLeft + lp.leftMargin;
            int childRight = childLeft2 + child.getMeasuredWidth();
            childTop2 = paddingTop + lp.topMargin;
            int childBottom = childTop2 + child.getMeasuredHeight();
            child.layout(childLeft2, childTop2, childRight, childBottom);
        }
        int toolBarCount = this.mToolBars.size();
        for (int i = 0; i < toolBarCount; ++i) {
            View child = this.mToolBars.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childBottom = b - t - paddingBottom - lp.bottomMargin;
            childTop2 = childBottom - child.getMeasuredHeight();
            childLeft = paddingLeft + lp.leftMargin;
            int childRight = childLeft + child.getMeasuredWidth();
            child.layout(childLeft, childTop2, childRight, childBottom);
        }
        int contentCount = this.mContentViews.size();
        for (int i = 0; i < contentCount; ++i) {
            View child = this.mContentViews.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childLeft3 = paddingLeft + lp.leftMargin;
            int childRight = childLeft3 + child.getMeasuredWidth();
            childTop = contentTop + lp.topMargin;
            int childBottom = contentBottom - lp.bottomMargin;
            child.layout(childLeft3, childTop, childRight, childBottom);
        }
        int unspecifiedCount = this.mUnspecifiedViews.size();
        for (int i = 0; i < unspecifiedCount; ++i) {
            View child = this.mUnspecifiedViews.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            childLeft = paddingLeft + lp.leftMargin;
            childTop = paddingTop + lp.topMargin;
            int childRight = childLeft + child.getMeasuredWidth();
            int childBottom = b - t - paddingBottom - lp.bottomMargin;
            child.layout(childLeft, childTop, childRight, childBottom);
        }
    }

    private void findSpecifiedView(View child, LayoutParams lp) {
        switch (lp.type) {
            case 2: {
                this.mTitleBars.add(child);
                break;
            }
            case 3: {
                this.mToolBars.add(child);
                break;
            }
            case 1: {
                this.mContentViews.add(child);
                break;
            }
            default: {
                this.mUnspecifiedViews.add(child);
            }
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int type = 0;

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int type) {
            super(width, height);
            this.type = type;
        }
    }
}

