/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.animation.LinearInterpolator;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.framework.core.ui.HandlEx;
import com.yy.framework.core.ui.IRendererCallBack;
import com.yy.framework.core.ui.PanelLayer;

public class AnimationLayer
extends YYView
implements ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener,
IRendererCallBack {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_FPS = false;
    private static final String TAG = "AnimationLayer";
    private static final int IS_PANEL_LAYER_HARDWARE_ACCELERATED_NOT_INIT = 0;
    private static final int IS_PANEL_LAYER_HARDWARE_ACCELERATED = 1;
    private static final int IS_PANEL_LAYER_NOT_HARDWARE_ACCELERATED = -1;
    private static boolean sIsAnimating;
    private static int sPanelLayerLastVisibility;
    private int mFrameCount = 0;
    private AnimationRenderer mRenderer;
    private ValueAnimator mAnimator;
    private Rect mInvalidateRect = new Rect();
    private int mIsPanelLayerHardwareAccelerated = 0;
    private PanelLayer mPanelLayer = null;

    public AnimationLayer(Context context) {
        super(context);
    }

    public static void setPanelLayerLastVisibility(int visibility) {
        sPanelLayerLastVisibility = visibility;
    }

    public static boolean isAnimating() {
        return sIsAnimating;
    }

    private static void setIsAnimating(boolean isAnimating) {
        sIsAnimating = isAnimating;
    }

    public void setPanelLayer(PanelLayer panelLayer) {
        if (panelLayer == null) {
            throw new IllegalArgumentException("panelLayer can't be null!");
        }
        this.mPanelLayer = panelLayer;
    }

    public void start(AnimationRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("Argument renderer can't be null!");
        }
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
        }
        this.mRenderer = renderer;
        this.mRenderer.setRendererCallBack(this);
        if (this.mAnimator == null) {
            this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.mAnimator.addListener((Animator.AnimatorListener)this);
        }
        this.mPanelLayer.setVisibility(0);
        this.setVisibility(0);
        this.mAnimator.setDuration(this.mRenderer.getDuration());
        this.mAnimator.start();
    }

    public void draw(Canvas canvas) {
        if (this.mRenderer == null) {
            return;
        }
        this.mRenderer.render(canvas);
        if (this.mIsPanelLayerHardwareAccelerated == 0) {
            this.mIsPanelLayerHardwareAccelerated = 1;
        }
    }

    public void onAnimationUpdate(ValueAnimator animator) {
        if (this.mRenderer == null) {
            return;
        }
        this.mRenderer.onAnimationUpdate(animator);
        if (this.mIsPanelLayerHardwareAccelerated == -1) {
            this.mRenderer.getInvalidateRect(this.mInvalidateRect);
            this.invalidate(this.mInvalidateRect);
        } else {
            this.invalidate();
        }
    }

    public void onAnimationStart(Animator animation) {
        if (this.mRenderer != null) {
            this.mRenderer.onAnimationStart(animation);
        }
        AnimationLayer.setPanelLayerLastVisibility(4);
        AnimationLayer.setIsAnimating(true);
    }

    public void onAnimationEnd(Animator animation) {
        AnimationLayer.setIsAnimating(false);
        if (this.mRenderer != null) {
            this.mRenderer.onAnimationEnd(animation);
        }
    }

    public void onAnimationCancel(Animator animation) {
        if (this.mRenderer != null) {
            this.mRenderer.onAnimationCancel(animation);
        }
    }

    public void onAnimationRepeat(Animator animation) {
        if (this.mRenderer != null) {
            this.mRenderer.onAnimationCancel(animation);
        }
    }

    @Override
    public void hide() {
        this.setVisibility(4);
        if (this.mRenderer != null) {
            this.mRenderer.setRendererCallBack(null);
            this.mRenderer = null;
        }
        if (this.mPanelLayer != null) {
            this.mPanelLayer.setVisibility(sPanelLayerLastVisibility);
        }
    }

    public static abstract class AnimationRenderer
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        protected Paint mPaint;
        private IRendererCallBack mCallBack = null;
        protected Runnable mHideAnimationLayerAction = new Runnable(){

            @Override
            public void run() {
                this.hideAnimationLayer();
            }
        };
        private Handler mHandler;

        public AnimationRenderer() {
            this.mPaint = new Paint();
            this.mHandler = new HandlEx(((Object)((Object)this)).getClass().getName() + 267);
        }

        protected static float computeFrameValueByFraction(float[][] frames, float fraction) {
            if (frames.length < 1) {
                return 0.0f;
            }
            for (int i = 1; i < frames.length; ++i) {
                if (frames[i].length < 2 || !(fraction <= frames[i][0])) continue;
                float fromFraction = frames[i - 1][0];
                float toFraction = frames[i][0];
                float fromValue = frames[i - 1][1];
                float toValue = frames[i][1];
                return fromValue + (toValue - fromValue) * (fraction - fromFraction) / (toFraction - fromFraction);
            }
            return 0.0f;
        }

        protected static void applyRectByLeftTopWidthHeight(Rect out, float left, float top, float width, float height) {
            if (out == null) {
                return;
            }
            out.left = (int)left;
            out.top = (int)top;
            out.right = (int)(left + width);
            out.bottom = (int)(top + height);
        }

        protected static void union(Rect out, Rect rect1, Rect rect2) {
            if (out == null || rect1 == null || rect2 == null) {
                return;
            }
            out.set(rect1);
            out.union(rect2);
        }

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
        }

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
        }

        protected void render(Canvas canvas) {
        }

        protected abstract long getDuration();

        protected abstract void getInvalidateRect(Rect var1);

        protected void hideAnimationLayer() {
            if (this.mCallBack != null) {
                this.mCallBack.hide();
            }
        }

        public void setRendererCallBack(IRendererCallBack callBack) {
            this.mCallBack = callBack;
        }

        protected final void post(Runnable r) {
            this.mHandler.post(r);
        }

        protected final void postDelayed(Runnable r, long delay) {
            this.mHandler.postDelayed(r, delay);
        }

        protected final void removeAction(Runnable r) {
            this.mHandler.removeCallbacks(r);
        }
    }
}

