/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.app.Activity;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.OnTouchEventInterceptor;

public abstract class AbstractWindowManager
implements INotify {
    public static final int DEFAULT_WINDOW_ANIMATION_DURATION = 300;
    private static final byte MAX_WINDOW_COUNT = 20;
    protected final WindowManager.LayoutParams mPanelLayerLP = new WindowManager.LayoutParams();
    protected Context mContext;
    protected boolean mPanelLayerFocused = false;

    public void setContext(Context context) {
        this.mContext = context;
        this.mPanelLayerLP.width = -1;
        this.mPanelLayerLP.height = -1;
        this.mPanelLayerLP.format = -3;
        this.mPanelLayerLP.type = 1003;
        this.mPanelLayerLP.flags |= 8;
        this.mPanelLayerLP.flags |= 0x20000;
        this.mPanelLayerLP.flags &= 0xFFFFFF7F;
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FULL_SCREEN_MODE_CHANGE, this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, this);
    }

    public static void notifyTabStateChange(AbstractWindow window, byte state) {
        if (window != null) {
            window.onWindowStateChange(state);
        }
    }

    public boolean isReachMaxWindowStackCount() {
        return this.getWindowStackCount() >= 20;
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public abstract boolean isWinInStack(AbstractWindow var1);

    public void addStatusBarPaddingIfUsingTransparentStatusBar() {
    }

    public abstract void blockAllRequestLayoutTemporary();

    public abstract boolean dispatchTouchEvent(MotionEvent var1);

    public abstract void pushWindow(int var1, AbstractWindow var2, boolean var3);

    public abstract void pushWindow(AbstractWindow var1, boolean var2);

    public abstract void insertWindowAfter(AbstractWindow var1, AbstractWindow var2);

    public abstract void pushWindow(AbstractWindow var1, boolean var2, boolean var3);

    public abstract void pushSingleTopWindow(AbstractWindow var1, boolean var2);

    public abstract void popWindow(boolean var1);

    public abstract boolean popToWindow(AbstractWindow var1, boolean var2);

    public abstract void popToRootWindow(boolean var1);

    public abstract void popToRootWindow(int var1, boolean var2);

    public abstract AbstractWindow getCurrentWindow();

    public abstract AbstractWindow getWindowBehind(AbstractWindow var1);

    public abstract AbstractWindow getWindowAfter(AbstractWindow var1);

    public abstract AbstractWindow getWindowBehind(int var1, AbstractWindow var2);

    public abstract AbstractWindow getWindowTop(int var1, AbstractWindow var2);

    public abstract AbstractWindow getRootWindowAt(int var1);

    public abstract AbstractWindow getTopWindowAt(int var1);

    public abstract boolean removeWindow(AbstractWindow var1, boolean var2);

    public abstract void popWindow(boolean var1, AbstractWindow var2);

    public abstract int getRootWindowIndex(AbstractWindow var1);

    public abstract AbstractWindow getCurrentRootWindow();

    public abstract boolean replaceRootWindow(AbstractWindow var1);

    public abstract void disableWindowAnimation(AbstractWindow var1);

    public abstract int getWindowStackCount();

    public abstract int getCurrentWindowStatckIndex();

    public abstract boolean createWindowStack(AbstractWindow var1);

    public abstract boolean createWindowStack(AbstractWindow var1, int var2);

    public abstract boolean createAndSwitchToWindowStack(AbstractWindow var1, int var2);

    public abstract void switchToWindowStack(int var1);

    public abstract boolean destroyWindowStack(int var1);

    public abstract void addBackgroundLayerContent(View var1);

    public abstract void invalidateBackgroundLayerContent();

    public abstract void removeBackgroundLayerContent(View var1);

    public abstract void addExtLayerContent(View var1);

    public abstract void removeExtLayerContent(View var1);

    public abstract void setFullScreen(boolean var1);

    public abstract AbstractWindow getCurStackTopWindow();

    public abstract void hideWallpaper();

    public abstract void showWallpaper();

    public abstract void hideWindowLayer();

    public abstract void showWindowLayer();

    public abstract void setBlockWindowLayerDispatchDraw(boolean var1);

    public abstract void setBlockWallpaperDisplay(boolean var1);

    public abstract void setOnWindowTouchInterceptor(OnTouchEventInterceptor var1);

    public abstract boolean isHardwareAccelerated();

    public void forceHandleTransparentStatusBarBgColor(AbstractWindow aWindow) {
    }

    public void clearHandleTransparentStatusBarBgColor() {
    }

    @Override
    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_FULL_SCREEN_MODE_CHANGE) {
            this.setFullScreen(SystemUtils.isSystemFullScreen((Activity)((Activity)this.mContext)));
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            this.notifyCurrentWindowForegroundChanged();
        }
    }

    public abstract void notifyCurrentWindowForegroundChanged();

    public abstract boolean isWindowValid();
}

