/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import com.yy.base.crash.CrashMonitor;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.AbstractAcrossAnimateHandler;
import com.yy.framework.core.ui.AbstractWindowInfo;
import com.yy.framework.core.ui.AnimateHandlerFactory;
import com.yy.framework.core.ui.BaseLayerLayout;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.WindowConfigure;
import com.yy.framework.core.ui.WindowSwipeHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWindow
extends YYFrameLayout
implements INotify {
    public static final String TAG = "AbstractWindow";
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_DRAW = false;
    public static final boolean DEBUG_MEASURE_LAYOUT_EFFICIENCY = false;
    public static final int WINDOW_ANIMATOR_DURATION = 300;
    public static final int COLOR_WHITE = -1;
    private int navBarColor = -2;
    public static final byte STATE_BEFORE_PUSH_IN = 0;
    public static final byte STATE_AFTER_PUSH_IN = 1;
    public static final byte STATE_ON_SHOW = 2;
    public static final byte STATE_BEFORE_POP_OUT = 3;
    public static final byte STATE_AFTER_POP_OUT = 4;
    public static final byte STATE_ON_HIDE = 5;
    public static final byte STATE_BEFORE_SWITCH_IN = 6;
    public static final byte STATE_AFTER_SWITCH_IN = 7;
    public static final byte STATE_ON_SWITCH_IN = 8;
    public static final byte STATE_BEFORE_SWITCH_OUT = 9;
    public static final byte STATE_AFTER_SWITCH_OUT = 10;
    public static final byte STATE_ON_SWITCH_OUT = 11;
    public static final byte STATE_ON_ATTACH = 12;
    public static final byte STATE_ON_DETACH = 13;
    public static final byte STATE_ON_WIN_STACK_CREATE = 14;
    public static final byte STATE_ON_WIN_STACK_DESTROY = 15;
    public static final int WINDOW_TYPE_NOTSPECIFIED = -1;
    public static final int STATUS_BAR_FULLSCREEN = 1;
    public static final int STATUS_BAR_WITH_PADDING_FLAG = 2;
    public static final int STATUS_BAR_WITH_MASK_FLAG = 4;
    public static final FrameLayout.LayoutParams WINDOW_LP = new FrameLayout.LayoutParams(-1, -1);
    private static final int[] colors = new int[]{Color.argb((int)64, (int)255, (int)0, (int)0), Color.argb((int)64, (int)0, (int)255, (int)0), Color.argb((int)64, (int)0, (int)0, (int)255)};
    static int sWindowWidth = -1;
    static int sWindowHeight = -1;
    private static boolean sIsHaveKeyDownEvent = false;
    private static List<Object> sBlurWindows = new ArrayList<Object>();
    private static boolean sNeedDrawFakeStatusBarBgOnWindow = true;
    private static int colorPicker = 0;
    public static final int ANIMATION_TYPE_DEFAULT = -1;
    public static final int ANIMATION_TYPE_EXTENTION = 1;
    public static final int ANIMATION_TYPE_SCALE_IN_CUT_OUT = 2;
    public static final int ANIMATION_TYPE_ALPHA_IN_ALPHA_OUT = 3;
    public static WindowConfigure mWindowConfigure = new WindowConfigure();
    private int mPushAnimationType = -1;
    protected int mWindowStatusBarType = 2;
    protected UICallBacks mCallBacks;
    protected Rect mWindowRect;
    protected Paint mStatusBarPaint = new Paint();
    protected AbstractWindowInfo mWindowInfo = new AbstractWindowInfo();
    private ViewGroup mBaseLayer;
    private RelativeLayout mBtnLayer;
    private RelativeLayout mExtLayer;
    private RelativeLayout mBarLayer;
    private WindowSwipeHelper mSwipeHelper;
    private String mName;
    private MutableLiveData<View[]> mNeedOffsetViewLiveData = new MutableLiveData();

    public AbstractWindow(Context context, UICallBacks callBacks, String name) {
        this(context, callBacks, WindowLayerType.ONLY_USE_BASE_LAYER, name);
    }

    public AbstractWindow(Context context, UICallBacks callBacks, WindowLayerType useLayerType, String name) {
        super(context);
        MLog.debug((Object)TAG, (String)"current window: %s", (Object[])new Object[]{this.getClass().getName()});
        this.mCallBacks = callBacks;
        this.mWindowRect = new Rect();
        this.mWindowInfo.setUseLayerType(useLayerType);
        this.mSwipeHelper = new WindowSwipeHelper((View)this, callBacks);
        this.mName = name;
        this.setWillNotDraw(false);
        this.initLayer();
        this.initialWindowStatusBar();
        if (TextUtils.isEmpty((CharSequence)name) && RuntimeContext.sIsDebuggable) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"debug!! window name \u4e3a\u7a7a\uff01\uff01\uff0c\u8bf7\u68c0\u67e5\u5f53\u524dwindow", (int)0);
        }
        this.initNavBarColor(context);
    }

    private void initNavBarColor(Context context) {
        if (context instanceof Activity) {
            int navigationBarColor;
            Activity activity = (Activity)context;
            if (Build.VERSION.SDK_INT >= 21 && (navigationBarColor = activity.getWindow().getNavigationBarColor()) != 0) {
                this.navBarColor = navigationBarColor;
            }
        }
    }

    public static void cleanUpOnExit() {
        sBlurWindows.clear();
    }

    public static boolean isHaveKeyDownEvent() {
        return sIsHaveKeyDownEvent;
    }

    public static int getWindowWidth() {
        return sWindowWidth;
    }

    public static int getWindowHeight() {
        return sWindowHeight;
    }

    public String getName() {
        return this.mName == null ? "" : this.mName;
    }

    private static boolean needDrawFakeStatusBarBgOnWindow() {
        return sNeedDrawFakeStatusBarBgOnWindow;
    }

    private static void setNeedDrawFakeStatusBarBgOnWindow(boolean b) {
        sNeedDrawFakeStatusBarBgOnWindow = b;
    }

    private static int getFakeRamdomColor() {
        return colors[colorPicker++ % colors.length];
    }

    public ViewGroup getBaseLayer() {
        return this.mBaseLayer;
    }

    public RelativeLayout getBtnLayer() {
        return this.mBtnLayer;
    }

    public RelativeLayout getExtLayer() {
        return this.mExtLayer;
    }

    public RelativeLayout getBarLayer() {
        return this.mBarLayer;
    }

    public Bitmap toSnapShot(Canvas snapShotCanvas, Bitmap outBitmap, boolean isWithWallPaper) {
        if (null == outBitmap && null == (outBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888))) {
            return null;
        }
        boolean lastState = this.isEnableBackground();
        this.setEnableBackground(isWithWallPaper);
        snapShotCanvas.setBitmap(outBitmap);
        this.draw(snapShotCanvas);
        this.setEnableBackground(lastState);
        return outBitmap;
    }

    public Bitmap toSnapShot(Bitmap outBitmap, boolean isWithWallPaper) {
        return this.toSnapShot(new Canvas(), outBitmap, isWithWallPaper);
    }

    public void printWindowInfo() {
    }

    public boolean isTransparent() {
        return this.mWindowInfo.isTransparent();
    }

    public void setTransparent(boolean transparent) {
        this.mWindowInfo.setTransparent(transparent);
    }

    public boolean isSupportHardwareAni() {
        return this.mWindowInfo.isSupportHardwareAni();
    }

    public boolean isCanPopByBackKey() {
        return this.mWindowInfo.isCanPopByBackKey();
    }

    public int getPushAniLength() {
        return this.mWindowInfo.getOpenAniLength();
    }

    public boolean isWindowTransparent() {
        return this.mWindowInfo.isWindowTransparent();
    }

    public void setWindowTransparent(boolean transparent) {
        this.mWindowInfo.setWindowTransparent(transparent);
    }

    public boolean isSingleTop() {
        return this.mWindowInfo.isSingleTop();
    }

    public void setSingleTop(boolean singleTop) {
        this.mWindowInfo.setSingleTop(singleTop);
    }

    public WindowLayerType getUseLayerType() {
        return this.mWindowInfo.getUseLayerType();
    }

    public int getWindowType() {
        return this.mWindowInfo.getWindowType();
    }

    public void setWindowType(int type) {
        this.mWindowInfo.setWindowType(type);
    }

    public boolean getUseContextMenu() {
        return this.mWindowInfo.getUseContextMenu();
    }

    public void setUseContextMenu(boolean useContextMenu) {
        this.mWindowInfo.setUseContextMenu(useContextMenu);
    }

    public boolean isEnableHardwareAcceleration() {
        return this.mWindowInfo.isEnableHardwareAcceleration();
    }

    public void setEnableHardwareAcceleration(boolean enableHardwareAcceleration) {
        this.mWindowInfo.setEnableHardwareAcceleration(enableHardwareAcceleration);
    }

    public boolean isEnableBackground() {
        return this.mWindowInfo.isEnableBackground();
    }

    public void setEnableBackground(boolean enable2) {
        this.mWindowInfo.setEnableBackground(enable2);
    }

    public boolean isRootWindowNeedFinish() {
        return this.mWindowInfo.isRootWindowNeedFinish();
    }

    public void setRootWindowNeedFinish(boolean finish) {
        this.mWindowInfo.setRootWindowNeedFinish(finish);
    }

    public boolean isEnableSwipeGesture() {
        if (!mWindowConfigure.getSwipeGestureSwitch()) {
            return false;
        }
        return this.mWindowInfo.isEnableSwipeGesture();
    }

    public void setEnableSwipeGesture(boolean enable2) {
        if (!mWindowConfigure.getSwipeGestureSwitch()) {
            return;
        }
        this.mWindowInfo.setEnableSwipeGesture(enable2);
    }

    public boolean isSwipeLeftGesture() {
        return this.mWindowInfo.isSwipeLeftGesture();
    }

    public void setSwipeLeftGesture(boolean swipeLeftGesture) {
        this.mWindowInfo.setSwipeLeftGesture(swipeLeftGesture);
        this.mSwipeHelper.setSwipeLeftGesture(swipeLeftGesture);
    }

    public boolean isEnableBlurBackground() {
        return this.mWindowInfo.isEnableBlurBackground();
    }

    public void setEnableBlurBackground(boolean enable2) {
        this.mWindowInfo.setEnableBlurBackground(enable2);
    }

    public boolean isAnimating() {
        return this.mWindowInfo.isAnimating();
    }

    public void setActAsAndroidWindow(boolean flag) {
        this.mWindowInfo.setActAsAndroidWindow(flag);
    }

    public boolean actAsAndroidWindow() {
        return this.mWindowInfo.actAsAndroidWindow();
    }

    public int getAndroidWindowAnimation() {
        return this.mWindowInfo.getAndroidWindowAnimation();
    }

    public void setAndroidWindowAnimation(int animationStyle) {
        this.mWindowInfo.setAndroidWindowAnimation(animationStyle);
    }

    public Animation getPushAnimation() {
        return this.mWindowInfo.getPushAnimation();
    }

    public void setPushAnimation(int animationStyle) {
        this.mWindowInfo.setPushAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationStyle));
    }

    public void setPushAnimation(Animation animation) {
        this.mWindowInfo.setPushAnimation(animation);
    }

    public Animation getPopAnimation() {
        return this.mWindowInfo.getPopAnimation();
    }

    public void setPopAnimation(int animationStyle) {
        this.mWindowInfo.setPopAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationStyle));
    }

    public void setPopAnimation(Animation animation) {
        this.mWindowInfo.setPopAnimation(animation);
    }

    public Animation getUnderPushAnimation() {
        return this.mWindowInfo.getUnderPushAnimation();
    }

    public void setUnderPushAnimation(int animationStyle) {
        this.mWindowInfo.setUnderPushAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationStyle));
    }

    public Animation getUnderPopAnimation() {
        return this.mWindowInfo.getUnderPopAnimation();
    }

    public void setUnderPopAnimation(int animationStyle) {
        this.mWindowInfo.setUnderPopAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationStyle));
    }

    public int getPushAnimationType() {
        return this.mPushAnimationType;
    }

    public void setPushAnimationType(int pushAnimationType) {
        this.mPushAnimationType = pushAnimationType;
    }

    public AnimatorSet getPushAnimator(AbstractWindow backWindow) {
        return null;
    }

    public AbstractAcrossAnimateHandler getAcrossAnimateHandler() {
        return this.mWindowInfo.getAcrossAnimateHandler();
    }

    public void setAcrossAnimateHandler(int animationType) {
        if (this.isAnimating() && this.mWindowInfo.getAcrossAnimateHandler() != null) {
            this.mWindowInfo.getAcrossAnimateHandler().cancel();
        }
        this.mWindowInfo.setAcrossAnimateHandler(AnimateHandlerFactory.create(animationType));
    }

    public void setNeedFullScreen(boolean fullScreen) {
        this.setNeedFullScreen(fullScreen, false);
    }

    public void setNeedFullScreen(boolean fullScreen, boolean cutMode) {
        this.mWindowInfo.setNeedFullScreen(fullScreen);
        this.mWindowInfo.setNeedFullScreenCutMode(cutMode);
    }

    public boolean isNeedFullScreen() {
        return this.mWindowInfo.isNeedFullScreen();
    }

    public boolean isNeedFullScreenCutMode() {
        return this.mWindowInfo.isNeedFullScreenCutMode();
    }

    public boolean isNeedHideNavigationBar() {
        return this.mWindowInfo.issNeedHideNavigationBar();
    }

    public void setScreenOrientationType(int orientationType) {
        this.mWindowInfo.setScreenOrientationType(orientationType);
    }

    public int getScreenOrientationType() {
        return this.mWindowInfo.getScreenOrientationType();
    }

    protected UICallBacks getUICallbacks() {
        return this.mCallBacks;
    }

    protected void onThemeChange() {
    }

    protected void onWallpaperChange() {
        this.invalidate();
    }

    protected void onWindowStateChange(byte stateFlag) {
        if (stateFlag == 0 || stateFlag == 3) {
            this.mWindowInfo.setIsAnimating(true);
            this.mWindowInfo.setEnableBackground(true);
            this.invalidate();
        }
        if (stateFlag == 0 || stateFlag == 2) {
            this.scrollTo(0, 0);
        }
        if (stateFlag == 1 || stateFlag == 4) {
            this.mWindowInfo.setIsAnimating(false);
        }
        if (stateFlag == 5 || stateFlag == 4) {
            if (this.isEnableBlurBackground()) {
                sBlurWindows.remove(this);
            }
        } else if ((stateFlag == 2 || stateFlag == 1 || stateFlag == 7 || stateFlag == 8) && this.isEnableBlurBackground() && !sBlurWindows.contains(this)) {
            sBlurWindows.add(this);
        }
        if (stateFlag == 3 || stateFlag == 5) {
            DeviceManager.hideInputMethod(this.getContext(), (View)this);
        }
        if (stateFlag == 0 || stateFlag == 2) {
            this.invalidateWindowStatusBar();
        }
    }

    protected void initLayer() {
        this.mBaseLayer = this.onCreateBaseLayer();
        this.addViewInLayout((View)this.mBaseLayer, 0, (ViewGroup.LayoutParams)WINDOW_LP);
        if (WindowLayerType.USE_ALL_LAYER == this.mWindowInfo.getUseLayerType()) {
            this.mExtLayer = this.onCreateExtLayer();
            this.addViewInLayout((View)this.mExtLayer, -1, (ViewGroup.LayoutParams)WINDOW_LP);
            this.mBtnLayer = this.onCreateButtonLayer();
            this.addViewInLayout((View)this.mBtnLayer, -1, (ViewGroup.LayoutParams)WINDOW_LP);
            this.mBarLayer = this.onCreateBarLayer();
            this.addViewInLayout((View)this.mBarLayer, -1, (ViewGroup.LayoutParams)WINDOW_LP);
        } else if (WindowLayerType.USE_BASE_AND_BAR_LAYER == this.mWindowInfo.getUseLayerType()) {
            this.mBarLayer = this.onCreateBarLayer();
            this.addViewInLayout((View)this.mBarLayer, -1, (ViewGroup.LayoutParams)WINDOW_LP);
        }
    }

    protected ViewGroup onCreateBaseLayer() {
        return this.createDefaultBaseLayer();
    }

    protected RelativeLayout onCreateButtonLayer() {
        return this.createDefaultLayer();
    }

    protected RelativeLayout onCreateBarLayer() {
        return this.createDefaultLayer();
    }

    protected RelativeLayout onCreateExtLayer() {
        return this.createDefaultLayer();
    }

    protected FrameLayout createDefaultStatusLayer() {
        return new YYFrameLayout(this.getContext());
    }

    protected RelativeLayout createDefaultLayer() {
        return new YYRelativeLayout(this.getContext());
    }

    protected BaseLayerLayout createDefaultBaseLayer() {
        return new BaseLayerLayout(this.getContext());
    }

    protected BaseLayerLayout.LayoutParams getBaseLayerLP() {
        BaseLayerLayout.LayoutParams lp = new BaseLayerLayout.LayoutParams(-1, -1);
        return lp;
    }

    private void disableWallPaperOnFirstTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && this.mWindowInfo.isEnableBackground()) {
            this.mWindowInfo.setEnableBackground(false);
        }
    }

    private String resolveLayerName(int index) {
        switch (index) {
            case 0: {
                return "BaseLayer";
            }
            case 1: {
                return "BtnLayer";
            }
            case 2: {
                return "ExtLayer";
            }
            case 3: {
                return "BarLayer";
            }
        }
        throw new IllegalStateException("AbstractWindow state illegal:" + index);
    }

    @Deprecated
    public int getStatusBarColor() {
        return -1;
    }

    public int getStatusBarBackgroundColor() {
        return 0;
    }

    public boolean isTranslucentBar() {
        return false;
    }

    public boolean isDarkMode() {
        return false;
    }

    @Nullable
    public View getNeedOffsetView() {
        return null;
    }

    public void draw(Canvas canvas) {
        try {
            super.draw(canvas);
            this.getDrawingRect(this.mWindowRect);
            this.mSwipeHelper.draw(canvas, this.mWindowRect);
        }
        catch (Throwable e) {
            CrashMonitor.tryCatch((Object)this, (String)"com.yy.framework.core.ui.AbstractWindow#draw", (Throwable)e);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDraw(canvas);
            this.drawWindowStatusBarBackground(canvas);
        }
        catch (Throwable e) {
            CrashMonitor.tryCatch((Object)this, (String)"com.yy.framework.core.ui.AbstractWindow#dispatchDraw", (Throwable)e);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        try {
            boolean result;
            if (event.getAction() == 0) {
                sIsHaveKeyDownEvent = true;
            }
            boolean bl = result = this.mCallBacks.onWindowKeyEvent(event.getKeyCode(), event) || super.dispatchKeyEvent(event);
            if (event.getAction() == 1) {
                sIsHaveKeyDownEvent = false;
            }
            return result;
        }
        catch (Throwable e) {
            CrashMonitor.tryCatch((Object)this, (String)"com.yy.framework.core.ui.AbstractWindow#dispatchKeyEvent", (Throwable)e);
            return super.dispatchKeyEvent(event);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.disableWallPaperOnFirstTouchEvent(ev);
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isAnimating() || !this.isEnableSwipeGesture()) {
            return super.onInterceptTouchEvent(ev);
        }
        return this.mSwipeHelper.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isAnimating() || !this.isEnableSwipeGesture()) {
            return super.onTouchEvent(ev);
        }
        return this.mSwipeHelper.onTouchEvent(ev);
    }

    public void computeScroll() {
        if (this.isAnimating() || !this.isEnableSwipeGesture()) {
            super.computeScroll();
        } else {
            this.mSwipeHelper.computeScroll();
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (this.isAnimating() || !this.isEnableSwipeGesture()) {
            super.onScrollChanged(l, t, oldl, oldt);
        } else {
            this.mSwipeHelper.onScrollChanged(l, t, oldl, oldt);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.isAnimating() || !this.isEnableSwipeGesture()) {
            super.onSizeChanged(w, h, oldw, oldh);
        } else {
            this.mSwipeHelper.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void addView(View child) {
        throw new UnsupportedOperationException("Cannot add view from outside.");
    }

    public void addView(View child, int index) {
        throw new UnsupportedOperationException("Cannot add view from outside.");
    }

    public void addView(View child, int width, int height) {
        throw new UnsupportedOperationException("Cannot add view from outside.");
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Cannot add view from outside.");
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Cannot add view from outside.");
    }

    public void bringChildToFront(View child) {
        throw new UnsupportedOperationException("Cannot adjust layer index.");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        catch (Throwable e) {
            CrashMonitor.tryCatch((Object)this, (String)"com.yy.framework.core.ui.AbstractWindow#onMeasure", (Throwable)e);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        try {
            super.onLayout(changed, left, top, right, bottom);
            if (changed) {
                this.printWindowInfo();
            }
        }
        catch (Throwable e) {
            CrashMonitor.tryCatch((Object)this, (String)"com.yy.framework.core.ui.AbstractWindow#onLayout", (Throwable)e);
        }
    }

    public void requestLayout() {
        super.requestLayout();
    }

    @Override
    public void notify(Notification notification) {
    }

    public void notifyGetEditorContent() {
    }

    public boolean getTransparentStatusBarFontLight() {
        return false;
    }

    public void invalidateWindowStatusBar() {
    }

    protected void setWindowStatusBarFlag(int statusBarType) {
        this.mWindowStatusBarType = statusBarType;
        this.invalidateWindowStatusBar();
    }

    protected void clearWindowStatusBarFlag() {
        this.mWindowStatusBarType = 0;
        this.invalidateWindowStatusBar();
    }

    protected void initialWindowStatusBar() {
    }

    public void adjustStatusBar(Activity activity, DeviceManager deviceManager) {
        if (this.isNeedFullScreen()) {
            StatusBarManager.clearPreviousSetting(activity);
            this.hideStatusBarAndFull(activity, deviceManager);
        } else {
            StatusBarManager.clearPreviousSetting(activity);
            this.showStatusBarAndFull(activity, deviceManager, this.navBarColor);
            if (StatusBarManager.INSTANCE.isSupportStatusBar()) {
                if (StatusBarManager.INSTANCE.isTranslucent(this)) {
                    StatusBarManager.INSTANCE.setTranslucent(activity, this, this.isDarkMode(), this.getStatusBarBackgroundColor(), this.getNeedOffsetView());
                    this.hideNavBar(activity);
                } else if (this.isTranslucentBar() && this.isSpecialTranslucentEnable()) {
                    StatusBarManager.INSTANCE.setTranslucent(activity, this.isDarkMode(), this.getStatusBarBackgroundColor(), this.getNeedOffsetView(), true);
                } else if (this.getStatusBarColor() == -16777216) {
                    StatusBarManager.INSTANCE.setTransparentState(activity, false);
                } else {
                    if (this.getStatusBarColor() == StatusBarManager.COLOR_GREEN) {
                        StatusBarManager.INSTANCE.setTransparentState(activity, false);
                    } else {
                        StatusBarManager.INSTANCE.setTransparentState(activity, true);
                    }
                    MLog.info((Object)TAG, (String)("setStatusBarColor " + this.getStatusBarColor()), (Object[])new Object[0]);
                    StatusBarManager.INSTANCE.setStatusBarColor(activity, this.getStatusBarColor());
                }
            }
        }
    }

    public void hideNavBar(Activity activity) {
        if (this.isNeedHideNavigationBar() && Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setNavigationBarColor(0);
            int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
            window.getDecorView().setSystemUiVisibility(systemUiVisibility |= 0x1702);
        }
    }

    public boolean isSpecialTranslucentEnable() {
        return false;
    }

    private void hideStatusBarAndFull(Activity activity, DeviceManager deviceManager) {
        if (deviceManager != null) {
            if (deviceManager.isSysStatusBarShowing()) {
                deviceManager.hideSysStatusBar();
            }
            if (this.isNeedFullScreenCutMode()) {
                deviceManager.setFullCutMode(activity);
            } else {
                deviceManager.setNotFullCutMode(activity);
            }
            deviceManager.hideNavigationBarAndFull();
        }
    }

    private void showStatusBarAndFull(Activity activity, DeviceManager mDeviceManager, int color) {
        if (mDeviceManager != null) {
            if (!mDeviceManager.isSysStatusBarShowing()) {
                mDeviceManager.showSysStatusBar();
                mDeviceManager.setNotFullCutMode(activity);
            }
            if (!this.isNeedHideNavigationBar()) {
                mDeviceManager.showNavigationBarAndFull(color);
            }
            if (StatusBarManager.INSTANCE.isSupportStatusBar()) {
                StatusBarManager.INSTANCE.setTransparentState(activity);
            }
        }
    }

    private void drawWindowStatusBarBackground(Canvas canvas) {
        if (!SystemUtils.isTransparentStatusBarEnable()) {
            return;
        }
        if ((this.mWindowStatusBarType & 1) > 0) {
            return;
        }
        if (SystemUtils.isChangeStatusBarFontColorEnable()) {
            canvas.drawRect((float)this.getLeft(), (float)this.getTop(), (float)this.getRight(), (float)SystemUtils.getStatusBarHeight((Context)this.getContext()), this.mStatusBarPaint);
        }
        if ((this.mWindowStatusBarType & 4) == 0 && SystemUtils.isChangeStatusBarFontColorEnable()) {
            return;
        }
        canvas.drawRect((float)this.getLeft(), (float)this.getTop(), (float)this.getRight(), (float)SystemUtils.getStatusBarHeight((Context)this.getContext()), this.mStatusBarPaint);
    }

    public void onXDrag(int deltaX) {
        this.mSwipeHelper.onXDrag(deltaX);
    }

    public void snapToDestinationForLeftScrollWindow(float deltaX, int velocity) {
        this.mSwipeHelper.snapToDestinationForLeftScrollWindow(deltaX, velocity);
    }

    public static enum WindowLayerType {
        ONLY_USE_BASE_LAYER,
        USE_BASE_AND_BAR_LAYER,
        USE_ALL_LAYER;

    }
}

