/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.BigPicRecycler;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DeviceManager;
import java.util.ArrayList;
import java.util.Stack;

@TargetApi(value=12)
public class ACWindowStack
extends YYFrameLayout
implements INotify {
    public static final String TAG = "ACWindowStack";
    public static final boolean DEBUG = true;
    private static final int GC_DELAY = 100;
    private static final int ANIMATOR_DURATION = 300;
    private AbstractWindow mRootWindow;
    private AbstractWindow mFrontWin;
    private AbstractWindow mBackWin;
    private Stack<AbstractWindow> mViewsStack = new Stack();
    private boolean mIsPushing;
    private boolean mIsPoping;
    private ViewGroup.OnHierarchyChangeListener mHierarchyChangeListener;
    private ArrayList<Runnable> mRunnables = new ArrayList();
    private AnimatorSet mDefaultAnimatorSet = new AnimatorSet();
    private long mLastTrimTime = -1L;
    private boolean mIsDispatchDrawing = false;
    private Runnable mCleanUpAnimationRunnable = new Runnable(){

        @Override
        public void run() {
            ACWindowStack.this.cleanUpAnimation();
        }
    };
    private boolean mBolckMeasureLayout = false;
    private boolean mAttachEventAdjust = true;

    public ACWindowStack(Context context) {
        super(context);
    }

    public ACWindowStack(Context context, AbstractWindow rootWindow) {
        super(context);
        assert (null != rootWindow);
        this.mFrontWin = this.mRootWindow = rootWindow;
        this.addView((View)rootWindow);
        this.notifiWindowContentChanged();
        this.mViewsStack.push(this.mFrontWin);
        this.mAttachEventAdjust = SettingFlags.getBoolean((String)"windowattacheventadjust", (boolean)true);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FULL_SCREEN_MODE_CHANGE, this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ORIENTATION_CHANGE, this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, this);
        this.mHierarchyChangeListener = new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewRemoved(View parent, View child) {
            }

            public void onChildViewAdded(View parent, View child) {
                if (RuntimeContext.sIsDebuggable && ACWindowStack.this.mIsDispatchDrawing) {
                    MLog.error((Object)ACWindowStack.TAG, (String)"ACWindowStack onChildViewAdded, is in dispatch drawing", (Object[])new Object[0]);
                }
            }
        };
        this.setOnHierarchyChangeListener(this.mHierarchyChangeListener);
    }

    private void notifiWindowContentChanged() {
    }

    AbstractWindow getRootWindow() {
        return this.mRootWindow;
    }

    void replaceRootWindow(AbstractWindow newRootWindow) {
        this.removeView((View)this.mRootWindow);
        this.mRootWindow = newRootWindow;
        this.mRootWindow.onWindowStateChange((byte)2);
        this.mViewsStack.set(0, this.mRootWindow);
        this.addView((View)newRootWindow, 0);
        this.notifiWindowContentChanged();
        this.mFrontWin = null;
        this.mBackWin = null;
    }

    public AbstractWindow getStackTopWindow() {
        return this.mViewsStack.peek();
    }

    public boolean removeStackView(AbstractWindow window) {
        return this.mViewsStack.remove(window);
    }

    public AbstractWindow getWindow(int index) {
        return (AbstractWindow)this.mViewsStack.elementAt(index);
    }

    public int getWindowCount() {
        return this.mViewsStack.size();
    }

    void pushSingleTopWindow(AbstractWindow w, boolean animated) {
        AbstractWindow frontWin = w;
        AbstractWindow backWin = this.mViewsStack.peek();
        if (frontWin.getClass().equals(backWin.getClass())) {
            return;
        }
        for (AbstractWindow window : this.mViewsStack) {
            if (!window.getClass().equals(w.getClass())) continue;
            if (!YYTaskExecutor.isMainThread()) {
                MLog.error((Object)TAG, (String)"pushSingleTopWindow:%s not in MainThread!", (Object[])new Object[]{window.getName()});
            } else {
                MLog.info((Object)TAG, (String)"pushSingleTopWindow:%s in MainThread!", (Object[])new Object[]{window.getName()});
            }
            this.mViewsStack.remove(window);
            this.removeView((View)window);
            this.notifiWindowContentChanged();
            break;
        }
        this.pushWindow(w, animated);
    }

    void pushWindow(AbstractWindow w, boolean animated) {
        this.pushWindow(w, animated, true, true);
    }

    void pushWindow(AbstractWindow w, boolean animated, boolean notifyFrontWindow, boolean notifyBackWindow) {
        this.pushWindow(w, animated, notifyFrontWindow, true, notifyBackWindow);
    }

    void pushWindow(AbstractWindow w, boolean animated, boolean notifyFrontWindow, boolean notifyFrontWindowTtachEvent, boolean notifyBackWindow) {
        this.pushWindow(w, animated, notifyFrontWindow, notifyFrontWindowTtachEvent, notifyBackWindow, false);
    }

    void pushWindow(AbstractWindow w, boolean animated, boolean notifyFrontWindow, boolean notifyFrontWindowTtachEvent, boolean notifyBackWindow, boolean isBackWindowVisible) {
        if (w.getParent() != null) {
            return;
        }
        if (!YYTaskExecutor.isMainThread()) {
            MLog.error((Object)TAG, (String)"pushWindow:%s not in MainThread, ViewsStack size:%d!", (Object[])new Object[]{w.getName(), this.mViewsStack.size()});
        } else {
            MLog.info((Object)TAG, (String)"pushWindow:%s in MainThread, ViewsStack size:%d!", (Object[])new Object[]{w.getName(), this.mViewsStack.size()});
        }
        this.ensureAnimationFinished();
        this.mFrontWin = w;
        if (this.mViewsStack.size() == 0 && SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("ViewStack Empty!");
        }
        AbstractWindow abstractWindow = this.mBackWin = this.mViewsStack.size() > 0 ? this.mViewsStack.peek() : null;
        if (!w.isTransparent() && animated) {
            w.setEnableBackground(true);
        }
        if (w.getVisibility() != 0) {
            w.setVisibility(0);
        }
        this.addView((View)w);
        this.notifiWindowContentChanged();
        this.resetAniProperty(w);
        this.resetAniProperty(this.mBackWin);
        if (this.mBackWin == null && SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException();
        }
        if (animated && this.mBackWin != null) {
            if (notifyFrontWindow) {
                w.onWindowStateChange((byte)0);
            }
            if (notifyBackWindow && this.mBackWin != null) {
                this.mBackWin.onWindowStateChange((byte)3);
            }
            this.mViewsStack.push(w);
            if (notifyFrontWindowTtachEvent) {
                w.onWindowStateChange((byte)12);
            }
            this.startPushAnimation();
        } else {
            if (this.mDefaultAnimatorSet != null && this.mDefaultAnimatorSet.isRunning()) {
                this.mDefaultAnimatorSet.cancel();
            }
            this.mViewsStack.push(w);
            if (notifyFrontWindowTtachEvent && this.mAttachEventAdjust) {
                w.onWindowStateChange((byte)12);
            }
            if (notifyFrontWindow) {
                w.onWindowStateChange((byte)2);
            }
            if (notifyBackWindow && this.mBackWin != null) {
                this.mBackWin.onWindowStateChange((byte)5);
            }
            if (!isBackWindowVisible) {
                if (!w.isTransparent() && this.mBackWin != null) {
                    this.mBackWin.setVisibility(4);
                }
                if (w.isSingleTop() && this.mBackWin != null) {
                    this.mBackWin.setVisibility(8);
                }
            }
            if (notifyFrontWindowTtachEvent && !this.mAttachEventAdjust) {
                w.onWindowStateChange((byte)12);
            }
            this.mFrontWin = null;
            this.mBackWin = null;
        }
        MLog.info((Object)TAG, (String)"pushWindow:%s, ViewsStack size:%d!", (Object[])new Object[]{w.getName(), this.mViewsStack.size()});
    }

    void insertWindowAfter(AbstractWindow windowToInsert, AbstractWindow windowUp) {
        if (windowToInsert.getParent() != null) {
            return;
        }
        if (!YYTaskExecutor.isMainThread()) {
            MLog.error((Object)TAG, (String)"insertWindowAfter:%s not in MainThread, ViewsStack size:%d!", (Object[])new Object[]{windowToInsert.getName(), this.mViewsStack.size()});
        } else {
            MLog.info((Object)TAG, (String)"insertWindowAfter:%s in MainThread, ViewsStack size:%d!", (Object[])new Object[]{windowToInsert.getName(), this.mViewsStack.size()});
        }
        int atIndex = this.mViewsStack.indexOf(windowUp);
        if (atIndex < 0) {
            MLog.error((Object)TAG, (String)"insertWindowAfter error :%s not find!", (Object[])new Object[]{windowUp.getName()});
            return;
        }
        int indexInParent = this.indexOfChild((View)windowUp);
        if (indexInParent < 0) {
            MLog.error((Object)TAG, (String)"insertWindowAfter error :%s not find!", (Object[])new Object[]{windowUp.getName()});
            return;
        }
        this.mViewsStack.add(atIndex, windowToInsert);
        this.addView((View)windowToInsert, indexInParent);
        if (windowToInsert.getVisibility() != 4) {
            windowToInsert.setVisibility(4);
        }
        windowToInsert.onWindowStateChange((byte)12);
        MLog.info((Object)TAG, (String)"insertWindowAfter:%s, ViewsStack size:%d!", (Object[])new Object[]{windowToInsert.getName(), this.mViewsStack.size()});
    }

    boolean popToWindow(AbstractWindow w, boolean animated) {
        AbstractWindow topWin = null;
        ArrayList<AbstractWindow> toPop = new ArrayList<AbstractWindow>(3);
        if (this.mViewsStack.contains(w)) {
            int count = this.mViewsStack.size();
            for (int i = count - 1; i > 0; --i) {
                AbstractWindow window = null;
                window = (AbstractWindow)this.mViewsStack.get(i);
                if (window == w) break;
                if (topWin != null || !animated) {
                    toPop.add(window);
                }
                if (!animated || topWin != null) continue;
                topWin = window;
            }
            if (toPop.size() > 0) {
                for (AbstractWindow window : toPop) {
                    this.mViewsStack.remove(window);
                    if (!YYTaskExecutor.isMainThread()) {
                        MLog.error((Object)TAG, (String)"popToWindow:%s not in MainThread, stack Size:%d!", (Object[])new Object[]{window.getName(), this.mViewsStack.size()});
                    } else {
                        MLog.info((Object)TAG, (String)"popToWindow:%s in MainThread, stack size:%d!", (Object[])new Object[]{window.getName(), this.mViewsStack.size()});
                    }
                    this.removeView((View)window);
                    this.notifiWindowContentChanged();
                    window.onWindowStateChange((byte)13);
                }
            }
            if (topWin != null) {
                this.popWindow(animated);
            }
            if (w != null) {
                MLog.info((Object)TAG, (String)"popToWindow:%s, ViewsStack size:%d!", (Object[])new Object[]{w.getName(), this.mViewsStack.size()});
            }
            return true;
        }
        return false;
    }

    void popWindow(boolean animated) {
        this.ensureAnimationFinished();
        if (this.mViewsStack.size() <= 1) {
            return;
        }
        this.mFrontWin = this.mViewsStack.pop();
        this.mBackWin = this.mViewsStack.peek();
        if (this.mFrontWin == this.mRootWindow || this.mFrontWin == null) {
            return;
        }
        if (this.mBackWin == null && SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException();
        }
        if (!YYTaskExecutor.isMainThread()) {
            MLog.error((Object)TAG, (String)"popWindow:%s not in MainThread, ViewsStack.size:%d!", (Object[])new Object[]{this.mFrontWin.getName(), this.mViewsStack.size()});
        } else {
            MLog.info((Object)TAG, (String)"popWindow:%s in MainThread, ViewsStack.size:%d!", (Object[])new Object[]{this.mFrontWin.getName(), this.mViewsStack.size()});
        }
        if (RuntimeContext.sIsDebuggable) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("PopWindow: " + this.mFrontWin + " ani:" + animated), (Object[])new Object[0]);
            }
        } else {
            MLog.info((Object)TAG, (String)"PopWindow: front %s back %s", (Object[])new Object[]{this.mFrontWin.getName(), this.mBackWin == null ? "" : this.mBackWin.getName()});
        }
        this.resetAniProperty(this.mFrontWin);
        this.resetAniProperty(this.mBackWin);
        if (!this.mFrontWin.isTransparent() && animated) {
            this.mFrontWin.setEnableBackground(true);
            this.mFrontWin.invalidate();
        }
        if (this.mBackWin != null && this.mBackWin.getVisibility() != 0) {
            this.mBackWin.setVisibility(0);
        }
        if (animated && this.mBackWin != null) {
            this.mFrontWin.onWindowStateChange((byte)3);
            this.mBackWin.onWindowStateChange((byte)0);
            this.startPopAnimation();
        } else {
            ViewGroup.LayoutParams lp = this.mFrontWin.getLayoutParams();
            if (lp != null && lp instanceof WindowManager.LayoutParams) {
                ((WindowManager.LayoutParams)lp).windowAnimations = 0;
                if (this.mFrontWin.getParent() != null) {
                    DeviceManager.updateAndroidWindowLP(this.getContext(), (View)this.mFrontWin, lp);
                }
            }
            this.mFrontWin.onWindowStateChange((byte)5);
            if (this.mBackWin != null) {
                this.mBackWin.onWindowStateChange((byte)2);
            }
            String lastWinLog = "";
            this.removeView((View)this.mFrontWin);
            this.notifiWindowContentChanged();
            this.mFrontWin.onWindowStateChange((byte)13);
            MLog.info((Object)TAG, (String)"popWindow:%s, ViewsStack.size:%d!", (Object[])new Object[]{this.mFrontWin.getName(), this.mViewsStack.size()});
            final AbstractWindow fBackWin = this.mBackWin;
            this.mFrontWin = null;
            this.mBackWin = null;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ACWindowStack.this.mIsPushing && !ACWindowStack.this.mIsPoping && fBackWin != null) {
                        ACWindowStack.this.resetAniProperty(fBackWin);
                    }
                }
            }, (long)300L);
        }
    }

    void popToRootWindow(boolean animated) {
        int count;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"===PopToRootWindow", (Object[])new Object[0]);
        }
        if ((count = this.mViewsStack.size()) == 1) {
            return;
        }
        for (int i = count - 2; i > 0; --i) {
            AbstractWindow w = (AbstractWindow)this.mViewsStack.remove(i);
            if (w != null) {
                if (!YYTaskExecutor.isMainThread()) {
                    MLog.error((Object)TAG, (String)"popToRootWindow:%s not in MainThread!", (Object[])new Object[]{w.getName()});
                } else {
                    MLog.info((Object)TAG, (String)"popToRootWindow:%s in MainThread!", (Object[])new Object[]{w.getName()});
                }
            }
            this.removeView((View)w);
            this.notifiWindowContentChanged();
            w.onWindowStateChange((byte)13);
        }
        this.popWindow(animated);
    }

    private void resetAniProperty(AbstractWindow window) {
        if (window == null) {
            return;
        }
        window.setTranslationX(0.0f);
        window.setScaleX(1.0f);
        window.setScaleY(1.0f);
        window.setAlpha(1.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mBolckMeasureLayout && this.getVisibility() == 4) {
            this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
            return;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mBolckMeasureLayout && this.getVisibility() == 4) {
            return;
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.mBolckMeasureLayout = true;
    }

    protected void dispatchDraw(Canvas canvas) {
        this.mIsDispatchDrawing = true;
        super.dispatchDraw(canvas);
        this.mBolckMeasureLayout = true;
        this.mIsDispatchDrawing = false;
    }

    @Override
    public void notify(Notification notification) {
        long curTime;
        if (notification.id == NotificationDef.N_FULL_SCREEN_MODE_CHANGE) {
            this.mBolckMeasureLayout = false;
        } else if (notification.id == NotificationDef.N_ORIENTATION_CHANGE) {
            this.mBolckMeasureLayout = false;
        } else if (notification.id == NotificationDef.N_ON_TRIM_MEMORY && (curTime = SystemClock.uptimeMillis()) - this.mLastTrimTime > 5000L) {
            this.mLastTrimTime = curTime;
            AbstractWindow curWin = this.getStackTopWindow();
            if (curWin != null && curWin.isTransparent() || this.mFrontWin != null && this.mFrontWin.isTransparent()) {
                return;
            }
            for (AbstractWindow window : this.mViewsStack) {
                if (window == null || window == this.mFrontWin || window == curWin) continue;
                BigPicRecycler.recycleBigPicIfNeedWhenMemoryWarning((ViewGroup)window);
            }
            MLog.info((Object)TAG, (String)"recycleBigPicIfNeed", (Object[])new Object[0]);
        }
    }

    private void startPushAnimation() {
        AbstractWindow fBackWindow;
        Animation pushAnimation = this.mFrontWin.getPushAnimation();
        final AbstractWindow fWindow = RuntimeContext.sIsDebuggable ? this.mFrontWin : null;
        AbstractWindow abstractWindow = fBackWindow = RuntimeContext.sIsDebuggable ? this.mBackWin : null;
        if (pushAnimation != null) {
            pushAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    Runnable runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.debug((Object)ACWindowStack.TAG, (String)"startPushAnimation front %s back %s end", (Object[])new Object[]{fWindow, fBackWindow});
                            }
                            ACWindowStack.this.dealWithWindowAfterPush();
                            ACWindowStack.this.mRunnables.remove(this);
                        }
                    };
                    ACWindowStack.this.mRunnables.add(runnable2);
                    ACWindowStack.this.post(runnable2);
                }
            });
            this.mIsPushing = true;
            this.mFrontWin.startAnimation(pushAnimation);
        } else if (this.mFrontWin.getPushAnimationType() == 3) {
            this.mIsPushing = true;
            if (this.mDefaultAnimatorSet != null) {
                this.mDefaultAnimatorSet.cancel();
            }
            this.mFrontWin.setTranslationX(0.0f);
            this.mFrontWin.setAlpha(0.0f);
            this.mFrontWin.setScaleY(1.2f);
            ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)this.mFrontWin, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator scaleXIn = null;
            ObjectAnimator scaleYIn = ObjectAnimator.ofFloat((Object)this.mFrontWin, (String)"scaleY", (float[])new float[]{1.2f, 1.0f});
            ObjectAnimator alphaOut = null;
            ObjectAnimator scaleYOut = null;
            ObjectAnimator scaleXOut = null;
            if (this.mBackWin != null && this.mBackWin.getWindowType() == 103 || this.mBackWin.getWindowType() == 106) {
                this.mFrontWin.setScaleX(1.0f);
                scaleXIn = ObjectAnimator.ofFloat((Object)this.mFrontWin, (String)"scaleX", (float[])new float[]{1.0f, 1.0f});
            } else {
                this.mFrontWin.setScaleX(1.2f);
                scaleXIn = ObjectAnimator.ofFloat((Object)this.mFrontWin, (String)"scaleX", (float[])new float[]{1.2f, 1.0f});
                if (this.mBackWin != null) {
                    alphaOut = ObjectAnimator.ofFloat((Object)this.mBackWin, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
                    scaleYOut = ObjectAnimator.ofFloat((Object)this.mBackWin, (String)"scaleY", (float[])new float[]{1.0f, 1.2f});
                    scaleXOut = ObjectAnimator.ofFloat((Object)this.mBackWin, (String)"scaleX", (float[])new float[]{1.0f, 1.2f});
                }
            }
            this.mDefaultAnimatorSet = new AnimatorSet();
            this.mDefaultAnimatorSet.setDuration((long)this.mFrontWin.getPushAniLength());
            this.mDefaultAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mDefaultAnimatorSet.removeAllListeners();
            this.mDefaultAnimatorSet.addListener(new Animator.AnimatorListener(){
                boolean isCanceled = false;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCanceled) {
                        Runnable runnable2 = new Runnable(){

                            @Override
                            public void run() {
                                if (RuntimeContext.sIsDebuggable) {
                                    MLog.debug((Object)ACWindowStack.TAG, (String)"startPushAnimation front %s back %s end", (Object[])new Object[]{fWindow.toString(), fBackWindow.toString()});
                                }
                                if (ACWindowStack.this.mFrontWin != null && ACWindowStack.this.mFrontWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mFrontWin, (int)0);
                                }
                                if (ACWindowStack.this.mBackWin != null && ACWindowStack.this.mBackWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mBackWin, (int)0);
                                }
                                ACWindowStack.this.dealWithWindowAfterPush();
                                ACWindowStack.this.mRunnables.remove(this);
                            }
                        };
                        ACWindowStack.this.mRunnables.add(runnable2);
                        ACWindowStack.this.post(runnable2);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    if (!this.isCanceled) {
                        this.isCanceled = true;
                        if (RuntimeContext.sIsDebuggable) {
                            MLog.debug((Object)ACWindowStack.TAG, (String)"startPushAnimation front %s back %s cancle", (Object[])new Object[]{fWindow.toString(), fBackWindow.toString()});
                        }
                        ACWindowStack.this.post(ACWindowStack.this.mCleanUpAnimationRunnable);
                    }
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            if (alphaOut != null && scaleXOut != null && scaleYOut != null) {
                this.mDefaultAnimatorSet.playTogether(new Animator[]{alphaIn, alphaOut, scaleYIn, scaleYOut, scaleXIn, scaleXOut});
            } else {
                this.mDefaultAnimatorSet.playTogether(new Animator[]{alphaIn, scaleYIn, scaleXIn});
            }
            if (this.mFrontWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mFrontWin, (int)2);
                HardwareUtils.buildLayer((View)this.mFrontWin);
            }
            if (this.mBackWin != null && this.mBackWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mBackWin, (int)2);
                HardwareUtils.buildLayer((View)this.mBackWin);
            }
            this.mDefaultAnimatorSet.start();
        } else {
            this.mIsPushing = true;
            if (this.mDefaultAnimatorSet != null) {
                this.mDefaultAnimatorSet.cancel();
            }
            this.mDefaultAnimatorSet = new AnimatorSet();
            this.mFrontWin.setTranslationX(this.getWidth());
            ObjectAnimator in = ObjectAnimator.ofFloat((Object)this.mFrontWin, (String)"translationX", (float[])new float[]{this.getWidth(), 0.0f});
            ObjectAnimator out = ObjectAnimator.ofFloat((Object)this.mBackWin, (String)"translationX", (float[])new float[]{0.0f, -0.3f * (float)this.getWidth()});
            this.mDefaultAnimatorSet.setDuration((long)this.mFrontWin.getPushAniLength());
            this.mDefaultAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mDefaultAnimatorSet.removeAllListeners();
            this.mDefaultAnimatorSet.addListener(new Animator.AnimatorListener(){
                boolean isCanceled = false;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCanceled) {
                        Runnable runnable2 = new Runnable(){

                            @Override
                            public void run() {
                                if (RuntimeContext.sIsDebuggable) {
                                    MLog.debug((Object)ACWindowStack.TAG, (String)"startPushAnimation front %s back %s end", (Object[])new Object[]{fWindow, fBackWindow});
                                }
                                if (ACWindowStack.this.mFrontWin != null && ACWindowStack.this.mFrontWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mFrontWin, (int)0);
                                }
                                if (ACWindowStack.this.mBackWin != null && ACWindowStack.this.mBackWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mBackWin, (int)0);
                                }
                                ACWindowStack.this.dealWithWindowAfterPush();
                                ACWindowStack.this.mRunnables.remove(this);
                            }
                        };
                        ACWindowStack.this.mRunnables.add(runnable2);
                        ACWindowStack.this.post(runnable2);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    if (!this.isCanceled) {
                        this.isCanceled = true;
                        if (RuntimeContext.sIsDebuggable) {
                            MLog.debug((Object)ACWindowStack.TAG, (String)"startPushAnimation front %s back %s cancel", (Object[])new Object[]{fWindow.toString(), fBackWindow});
                        }
                        ACWindowStack.this.post(ACWindowStack.this.mCleanUpAnimationRunnable);
                    }
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mDefaultAnimatorSet.playTogether(new Animator[]{in, out});
            if (this.mFrontWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mFrontWin, (int)2);
                HardwareUtils.buildLayer((View)this.mFrontWin);
            }
            if (this.mBackWin != null && this.mBackWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mBackWin, (int)2);
                HardwareUtils.buildLayer((View)this.mBackWin);
            }
            this.mDefaultAnimatorSet.start();
        }
    }

    private void startPopAnimation() {
        AbstractWindow fBacktWin;
        Animation popAnimation = this.mFrontWin.getPopAnimation();
        final AbstractWindow fFrontWin = RuntimeContext.sIsDebuggable ? this.mFrontWin : null;
        AbstractWindow abstractWindow = fBacktWin = RuntimeContext.sIsDebuggable ? this.mBackWin : null;
        if (popAnimation != null) {
            popAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    Runnable runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.debug((Object)ACWindowStack.TAG, (String)"startPopAnimation front %s back %s end", (Object[])new Object[]{fFrontWin.toString(), fBacktWin.toString()});
                            }
                            ACWindowStack.this.dealWithWindowAfterPop();
                            ACWindowStack.this.mRunnables.remove(this);
                        }
                    };
                    ACWindowStack.this.mRunnables.add(runnable2);
                    ACWindowStack.this.post(runnable2);
                }
            });
            this.mIsPoping = true;
            this.mFrontWin.startAnimation(popAnimation);
        } else if (this.mFrontWin.getPushAnimationType() == 3) {
            this.mIsPoping = true;
            if (this.mDefaultAnimatorSet != null) {
                this.mDefaultAnimatorSet.cancel();
            }
            this.mDefaultAnimatorSet = new AnimatorSet();
            ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)this.mFrontWin, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            ObjectAnimator alphaOut = ObjectAnimator.ofFloat((Object)this.mBackWin, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"setX -0.3f%s", (Object[])new Object[]{this.mBackWin.toString()});
            }
            this.mDefaultAnimatorSet.setDuration(300L);
            this.mDefaultAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mDefaultAnimatorSet.removeAllListeners();
            this.mDefaultAnimatorSet.addListener(new Animator.AnimatorListener(){
                boolean isCanceled = false;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCanceled) {
                        Runnable runnable2 = new Runnable(){

                            @Override
                            public void run() {
                                if (RuntimeContext.sIsDebuggable) {
                                    MLog.debug((Object)ACWindowStack.TAG, (String)"startPopAnimation front %s back %s end", (Object[])new Object[]{fFrontWin.toString(), fBacktWin.toString()});
                                }
                                if (ACWindowStack.this.mFrontWin != null && ACWindowStack.this.mFrontWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mFrontWin, (int)0);
                                }
                                if (ACWindowStack.this.mBackWin != null && ACWindowStack.this.mBackWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mBackWin, (int)0);
                                }
                                ACWindowStack.this.dealWithWindowAfterPop();
                                ACWindowStack.this.mRunnables.remove(this);
                            }
                        };
                        ACWindowStack.this.mRunnables.add(runnable2);
                        ACWindowStack.this.post(runnable2);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    if (!this.isCanceled) {
                        this.isCanceled = true;
                        if (RuntimeContext.sIsDebuggable) {
                            MLog.debug((Object)ACWindowStack.TAG, (String)"startPopAnimation front %s back %s cancel", (Object[])new Object[]{fFrontWin.toString(), fBacktWin.toString()});
                        }
                        ACWindowStack.this.post(ACWindowStack.this.mCleanUpAnimationRunnable);
                    }
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mDefaultAnimatorSet.playTogether(new Animator[]{alphaIn, alphaOut});
            if (this.mFrontWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mFrontWin, (int)2);
                HardwareUtils.buildLayer((View)this.mFrontWin);
            }
            if (this.mBackWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mBackWin, (int)2);
                HardwareUtils.buildLayer((View)this.mBackWin);
            }
            this.mDefaultAnimatorSet.start();
        } else {
            this.mIsPoping = true;
            if (this.mDefaultAnimatorSet != null) {
                this.mDefaultAnimatorSet.cancel();
            }
            this.mDefaultAnimatorSet = new AnimatorSet();
            this.mFrontWin.setTranslationX(0.0f);
            ObjectAnimator in = ObjectAnimator.ofFloat((Object)this.mFrontWin, (String)"translationX", (float[])new float[]{0.0f, this.getWidth()});
            ObjectAnimator out = ObjectAnimator.ofFloat((Object)this.mBackWin, (String)"translationX", (float[])new float[]{(float)(-this.getWidth()) * 0.3f, 0.0f});
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"setX -0.3f%s", (Object[])new Object[]{this.mBackWin.toString()});
            }
            this.mDefaultAnimatorSet.setDuration(300L);
            this.mDefaultAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mDefaultAnimatorSet.removeAllListeners();
            this.mDefaultAnimatorSet.addListener(new Animator.AnimatorListener(){
                boolean isCanceled = false;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCanceled) {
                        Runnable runnable2 = new Runnable(){

                            @Override
                            public void run() {
                                if (RuntimeContext.sIsDebuggable) {
                                    MLog.debug((Object)ACWindowStack.TAG, (String)"startPopAnimation front %s back %s end", (Object[])new Object[]{fFrontWin.toString(), fBacktWin.toString()});
                                }
                                if (ACWindowStack.this.mFrontWin != null && ACWindowStack.this.mFrontWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mFrontWin, (int)0);
                                }
                                if (ACWindowStack.this.mBackWin != null && ACWindowStack.this.mBackWin.isSupportHardwareAni()) {
                                    HardwareUtils.setLayerType((View)ACWindowStack.this.mBackWin, (int)0);
                                }
                                ACWindowStack.this.dealWithWindowAfterPop();
                                ACWindowStack.this.mRunnables.remove(this);
                            }
                        };
                        ACWindowStack.this.mRunnables.add(runnable2);
                        ACWindowStack.this.post(runnable2);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    if (!this.isCanceled) {
                        if (RuntimeContext.sIsDebuggable) {
                            MLog.debug((Object)ACWindowStack.TAG, (String)"startPopAnimation front %s back %s cancel", (Object[])new Object[]{fFrontWin.toString(), fBacktWin.toString()});
                        }
                        this.isCanceled = true;
                        ACWindowStack.this.post(ACWindowStack.this.mCleanUpAnimationRunnable);
                    }
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mDefaultAnimatorSet.playTogether(new Animator[]{in, out});
            if (this.mFrontWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mFrontWin, (int)2);
                HardwareUtils.buildLayer((View)this.mFrontWin);
            }
            if (this.mBackWin.isSupportHardwareAni()) {
                HardwareUtils.setLayerType((View)this.mBackWin, (int)2);
                HardwareUtils.buildLayer((View)this.mBackWin);
            }
            this.mDefaultAnimatorSet.start();
        }
    }

    private void dealWithWindowAfterPush() {
        this.cleanUpAnimation();
        if (this.mFrontWin != null && this.mBackWin != null) {
            if (!this.mFrontWin.isTransparent()) {
                this.mBackWin.setVisibility(4);
            }
            this.mBackWin.onWindowStateChange((byte)4);
            this.mFrontWin.onWindowStateChange((byte)1);
            if (this.mFrontWin.isSingleTop()) {
                this.mBackWin.setVisibility(8);
            }
        }
        this.mIsPushing = false;
        this.mFrontWin = null;
        this.mBackWin = null;
        if (this.mDefaultAnimatorSet != null) {
            this.mDefaultAnimatorSet.removeAllListeners();
        }
    }

    private void dealWithWindowAfterPop() {
        this.cleanUpAnimation();
        if (this.mFrontWin != null && this.mBackWin != null) {
            this.mBackWin.onWindowStateChange((byte)1);
            this.mFrontWin.onWindowStateChange((byte)4);
            String lastWinLog = "";
            try {
                this.removeView((View)this.mFrontWin);
            }
            catch (NullPointerException e) {
                MLog.error((Object)TAG, (String)"startPopAnimation", (Throwable)e, (Object[])new Object[0]);
                throw e;
            }
            this.notifiWindowContentChanged();
            this.mFrontWin.onWindowStateChange((byte)13);
        }
        this.mIsPoping = false;
        this.mFrontWin = null;
        this.mBackWin = null;
        if (this.mDefaultAnimatorSet != null) {
            this.mDefaultAnimatorSet.removeAllListeners();
        }
    }

    private void ensureAnimationFinished() {
        if (this.mRunnables.size() > 0) {
            for (Runnable runnable2 : this.mRunnables) {
                this.removeCallbacks(runnable2);
            }
            this.mRunnables.clear();
        }
        if (!this.mIsPushing && !this.mIsPoping) {
            this.cleanUpAnimation();
        }
        if (this.mIsPushing) {
            this.dealWithWindowAfterPush();
        }
        if (this.mIsPoping) {
            this.dealWithWindowAfterPop();
        }
        SystemUtils.cancelGc();
    }

    private void cleanUpAnimation() {
        if (this.mFrontWin != null) {
            this.mFrontWin.setAnimation(null);
            this.mFrontWin.animate().cancel();
            this.resetAniProperty(this.mFrontWin);
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"reset front %s", (Object[])new Object[]{this.mFrontWin.toString()});
            }
        }
        if (this.mBackWin != null) {
            this.mBackWin.setAnimation(null);
            this.mBackWin.animate().cancel();
            this.resetAniProperty(this.mBackWin);
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"reset back %s", (Object[])new Object[]{this.mBackWin.toString()});
            }
        }
        this.removeCallbacks(this.mCleanUpAnimationRunnable);
    }

    public void replaceWindow(AbstractWindow window, AbstractWindow replaceWindow) {
        if (window == null || replaceWindow == null) {
            return;
        }
        for (int index = 0; index < this.getChildCount(); ++index) {
            View view = this.getChildAt(index);
            if (view != window) continue;
            this.addView((View)replaceWindow, index);
            this.removeView((View)window);
            this.notifiWindowContentChanged();
            return;
        }
    }

    public boolean isWindowAnimating() {
        return this.mIsPushing || this.mIsPoping;
    }

    public boolean isWinInStack(AbstractWindow window) {
        return this.mViewsStack.contains(window);
    }
}

