/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.ACWindowEnvironment;
import com.yy.framework.core.ui.ACWindowStack;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.OnTouchEventInterceptor;

public class ACWindowManager
extends AbstractWindowManager {
    private ACWindowEnvironment mWinEnvironment;
    private View mTargetView;
    private OnTouchEventInterceptor mOnTouchEventInterceptor;
    private boolean mTouchEventIntercepted;
    private AbstractWindow mForceHandleTransparentStatusBarBgColorAbsWindow;
    private DeviceManager mDeviceManager;
    private Activity mActivity;
    private Runnable mCheckFinishTask = null;
    private static final String TAG = "ACWindowManager";

    public void setActivity(Activity context) {
        this.setActivity(context, -1);
    }

    public void setActivity(Activity context, int backgroundColor) {
        if (context == this.mActivity) {
            return;
        }
        if (this.mActivity != null) {
            this.clear();
        }
        if (context != null) {
            super.setContext((Context)context);
            this.mActivity = context;
            this.setupWindowEnvironment((Context)context, backgroundColor);
            this.initialWindowStatusBar(context);
            this.mDeviceManager = new DeviceManager((Context)context);
            this.mDeviceManager.updateActivity(context);
        } else {
            this.clear();
        }
    }

    private void clear() {
        if (this.mWinEnvironment != null && this.mWinEnvironment.getParent() instanceof ViewGroup) {
            if (this.mWinEnvironment.getCurrentWindowStack() != null) {
                this.mWinEnvironment.getCurrentWindowStack().popToRootWindow(false);
            }
            ((ViewGroup)this.mWinEnvironment.getParent()).removeView((View)this.mWinEnvironment);
        }
        this.mWinEnvironment = null;
        this.mDeviceManager.updateActivity(null);
        this.mActivity = null;
    }

    private void setupWindowEnvironment(Context context, int backgroundColor) {
        if (null == this.mWinEnvironment) {
            this.mWinEnvironment = new ACWindowEnvironment(context, backgroundColor);
            this.mWinEnvironment.setFocusableInTouchMode(true);
            if (Build.VERSION.SDK_INT >= 28) {
                this.mWinEnvironment.setFocusable(true);
                this.mWinEnvironment.requestFocus();
            }
        }
        ((Activity)context).setContentView((View)this.mWinEnvironment);
        DefaultWindow.addGlobalMonitor(new DefaultWindow.IGlobalWindowMonitor(){

            @Override
            public void onWindowCreate(DefaultWindow window) {
            }

            @Override
            public void onShown(DefaultWindow window) {
            }

            @Override
            public void onHidden(DefaultWindow window) {
            }

            @Override
            public void onLayout(boolean changed, int left, int top, int right, int bottom) {
            }

            @Override
            public void onDetach(DefaultWindow window) {
                ACWindowManager.this.checkRootWindowFinish();
            }
        });
    }

    @Override
    public void addStatusBarPaddingIfUsingTransparentStatusBar() {
    }

    @Override
    public boolean isReachMaxWindowStackCount() {
        return super.isReachMaxWindowStackCount();
    }

    @Override
    public boolean isWinInStack(AbstractWindow window) {
        if (window == null) {
            return false;
        }
        if (this.mWinEnvironment != null) {
            return this.mWinEnvironment.isWinInStack(window);
        }
        return false;
    }

    private boolean isWindowInStack(ACWindowStack stack, AbstractWindow window) {
        if (stack != null && window != null) {
            int size = stack.getChildCount();
            for (int i = 0; i < size; ++i) {
                AbstractWindow w = (AbstractWindow)stack.getChildAt(i);
                if (w != window) continue;
                return true;
            }
        }
        return false;
    }

    private boolean handlePushWindow(ACWindowStack windowStack, AbstractWindow window) {
        if (window != null && window.getParent() != null) {
            if (this.isWindowInStack(windowStack, window)) {
                windowStack.removeView((View)window);
                windowStack.removeStackView(window);
                return true;
            }
            int stackSize = this.mWinEnvironment.getWindowStackCount();
            for (int stackIndex = 0; stackIndex < stackSize; ++stackIndex) {
                ACWindowStack stack = this.mWinEnvironment.getWindowStackAt(stackIndex);
                if (stack == windowStack) continue;
                int size = stack.getChildCount();
                for (int wi = 0; wi < size; ++wi) {
                    AbstractWindow absWindow = (AbstractWindow)stack.getChildAt(wi);
                    if (window != absWindow) continue;
                    stack.removeView((View)window);
                    stack.removeStackView(window);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void pushWindow(AbstractWindow window, boolean animated) {
        if (this.mWinEnvironment.getCurrentWindowStack() != null) {
            boolean removeSuccess = this.handlePushWindow(this.mWinEnvironment.getCurrentWindowStack(), window);
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckFinishTask);
            this.mWinEnvironment.getCurrentWindowStack().pushWindow(window, animated, true, !removeSuccess, true);
            this.checkStatusBarAndOrientation(window);
        }
    }

    @Override
    public void insertWindowAfter(AbstractWindow windowToInsert, AbstractWindow windowUp) {
        if (this.mWinEnvironment.getCurrentWindowStack() != null) {
            this.handlePushWindow(this.mWinEnvironment.getCurrentWindowStack(), windowToInsert);
            this.mWinEnvironment.getCurrentWindowStack().insertWindowAfter(windowToInsert, windowUp);
        }
    }

    @Override
    public void pushWindow(AbstractWindow window, boolean animated, boolean isBackWindowVisible) {
        if (this.mWinEnvironment.getCurrentWindowStack() != null) {
            boolean removeSuccess = this.handlePushWindow(this.mWinEnvironment.getCurrentWindowStack(), window);
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckFinishTask);
            this.mWinEnvironment.getCurrentWindowStack().pushWindow(window, animated, true, !removeSuccess, true, isBackWindowVisible);
            this.checkStatusBarAndOrientation(window);
        }
    }

    @Override
    public void pushWindow(int windowStackIndex, AbstractWindow window, boolean animated) {
        ACWindowStack stack = this.mWinEnvironment.getWindowStackAt(windowStackIndex);
        if (stack != null) {
            boolean removeSuccess = this.handlePushWindow(stack, window);
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckFinishTask);
            stack.pushWindow(window, animated, true, !removeSuccess, true);
            this.checkStatusBarAndOrientation(window);
        }
    }

    @Override
    public void pushSingleTopWindow(AbstractWindow window, boolean animated) {
        if (this.mWinEnvironment.getCurrentWindowStack() != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckFinishTask);
            this.mWinEnvironment.getCurrentWindowStack().pushSingleTopWindow(window, animated);
            this.checkStatusBarAndOrientation(this.getCurrentWindow());
        }
    }

    @Override
    public void popWindow(boolean animated) {
        if (this.mWinEnvironment.getCurrentWindowStack() != null) {
            this.mWinEnvironment.getCurrentWindowStack().popWindow(animated);
            this.checkStatusBarAndOrientation(this.getCurrentWindow());
        }
    }

    @Override
    public boolean popToWindow(AbstractWindow w, boolean animated) {
        if (this.mWinEnvironment.getCurrentWindowStack() != null) {
            boolean result = this.mWinEnvironment.getCurrentWindowStack().popToWindow(w, animated);
            this.checkStatusBarAndOrientation(this.getCurrentWindow());
            return result;
        }
        return false;
    }

    @Override
    public void popWindow(boolean animated, AbstractWindow window) {
        if (window != null) {
            if (window == this.getCurrentWindow()) {
                this.popWindow(animated);
            } else {
                this.removeWindow(window, true);
            }
        }
        this.checkStatusBarAndOrientation(this.getCurrentWindow());
    }

    @Override
    public boolean removeWindow(AbstractWindow delWindow, boolean onlyCurStack) {
        if (onlyCurStack) {
            boolean result = false;
            ACWindowStack stack = this.mWinEnvironment.getCurrentWindowStack();
            if (stack != null) {
                stack.removeView((View)delWindow);
                result = stack.removeStackView(delWindow);
                if (result && delWindow != null) {
                    delWindow.onWindowStateChange((byte)13);
                }
            }
            if (result) {
                this.checkStatusBarAndOrientation(this.getCurrentWindow());
            }
            return result;
        }
        boolean exist = false;
        for (int i = 0; i < this.mWinEnvironment.getWindowStackCount(); ++i) {
            ACWindowStack stack = this.mWinEnvironment.getWindowStackAt(i);
            if (stack == null) continue;
            stack.removeView((View)delWindow);
            exist |= stack.removeStackView(delWindow);
        }
        if (exist) {
            this.checkStatusBarAndOrientation(this.getCurrentWindow());
        }
        return exist;
    }

    @Override
    public void popToRootWindow(boolean animated) {
        if (this.mWinEnvironment.getCurrentWindowStack() != null) {
            this.mWinEnvironment.getCurrentWindowStack().popToRootWindow(animated);
            this.checkStatusBarAndOrientation(this.getCurrentWindow());
        }
    }

    @Override
    public void popToRootWindow(int index, boolean animated) {
        if (this.mWinEnvironment.getWindowStackAt(index) != null) {
            this.mWinEnvironment.getWindowStackAt(index).popToRootWindow(animated);
            this.checkStatusBarAndOrientation(this.getCurrentWindow());
        }
    }

    @Override
    public boolean replaceRootWindow(AbstractWindow rootWindow) {
        this.mWinEnvironment.getCurrentWindowStack().replaceRootWindow(rootWindow);
        return true;
    }

    @Override
    public AbstractWindow getCurrentWindow() {
        if (this.mWinEnvironment == null) {
            return null;
        }
        if (this.mWinEnvironment.getCurrentWindowStack() == null) {
            return null;
        }
        return this.mWinEnvironment.getCurrentWindowStack().getStackTopWindow();
    }

    private AbstractWindow getWindowBehindFromStack(ACWindowStack stack, AbstractWindow currentWindow) {
        int stackSize = stack.getWindowCount();
        for (int i = stackSize - 1; i > 0; --i) {
            if (stack.getWindow(i) != currentWindow) continue;
            return stack.getWindow(i - 1);
        }
        return null;
    }

    private AbstractWindow getWindowAfterFromStack(ACWindowStack stack, AbstractWindow currentWindow) {
        int stackSize = stack.getWindowCount();
        for (int i = stackSize - 1; i > 0; --i) {
            if (stack.getWindow(i) != currentWindow) continue;
            if (i == stackSize - 1) {
                return null;
            }
            return stack.getWindow(i + 1);
        }
        return null;
    }

    @Override
    public AbstractWindow getWindowTop(int index, AbstractWindow currentWindow) {
        ACWindowStack stack = this.getWindowStack(index);
        int stackSize = stack.getWindowCount();
        for (int i = 0; i < stackSize - 1; ++i) {
            if (stack.getWindow(i) != currentWindow) continue;
            return stack.getWindow(i + 1);
        }
        return null;
    }

    @Override
    public AbstractWindow getWindowBehind(AbstractWindow currentWindow) {
        if (this.mWinEnvironment.getCurrentWindowStack() == null) {
            return null;
        }
        return this.getWindowBehindFromStack(this.mWinEnvironment.getCurrentWindowStack(), currentWindow);
    }

    @Override
    public AbstractWindow getWindowAfter(AbstractWindow currentWindow) {
        if (this.mWinEnvironment.getCurrentWindowStack() == null) {
            return null;
        }
        return this.getWindowAfterFromStack(this.mWinEnvironment.getCurrentWindowStack(), currentWindow);
    }

    @Override
    public AbstractWindow getWindowBehind(int index, AbstractWindow currentWindow) {
        ACWindowStack stack = this.getWindowStack(index);
        if (stack == null) {
            return null;
        }
        return this.getWindowBehindFromStack(stack, currentWindow);
    }

    @Override
    public AbstractWindow getCurrentRootWindow() {
        if (this.mWinEnvironment.getCurrentWindowStack() == null) {
            return null;
        }
        return this.mWinEnvironment.getCurrentWindowStack().getRootWindow();
    }

    @Override
    public int getRootWindowIndex(AbstractWindow rootWindow) {
        int stackCount = this.getWindowStackCount();
        AbstractWindow tempRootWin = null;
        for (int i = 0; i < stackCount; ++i) {
            tempRootWin = this.getRootWindowAt(i);
            if (tempRootWin != rootWindow) continue;
            return i;
        }
        return -1;
    }

    public ACWindowStack getWindowStack(int index) {
        return this.mWinEnvironment.getWindowStackAt(index);
    }

    @Override
    public int getWindowStackCount() {
        return this.mWinEnvironment.getWindowStackCount();
    }

    @Override
    public int getCurrentWindowStatckIndex() {
        return this.mWinEnvironment.getCurrentWindowStatckIndex();
    }

    @Override
    public boolean createWindowStack(AbstractWindow rootWindow) {
        return this.createWindowStack(rootWindow, -1);
    }

    @Override
    public boolean createWindowStack(AbstractWindow rootWindow, int index) {
        if (null == this.mWinEnvironment.getCurrentWindowStack()) {
            this.mWinEnvironment.createWindowStack(new ACWindowStack(this.mContext, rootWindow), index, true);
        } else {
            this.mWinEnvironment.createWindowStack(new ACWindowStack(this.mContext, rootWindow), index, false);
        }
        return true;
    }

    @Override
    public boolean createAndSwitchToWindowStack(AbstractWindow rootWindow, int index) {
        this.mWinEnvironment.createWindowStack(new ACWindowStack(this.mContext, rootWindow), index, true);
        return true;
    }

    @Override
    public void switchToWindowStack(int index) {
        this.mWinEnvironment.switchWindowStack(index);
    }

    @Override
    public boolean destroyWindowStack(int index) {
        return this.mWinEnvironment.destroyWindowStack(index);
    }

    @Override
    public void setBlockWindowLayerDispatchDraw(boolean block) {
        this.mWinEnvironment.setBlockWindowLayerDispatchDraw(block);
    }

    @Override
    public void setBlockWallpaperDisplay(boolean block) {
        this.mWinEnvironment.setBlockWallpaperDisplay(block);
    }

    @Override
    public void setOnWindowTouchInterceptor(OnTouchEventInterceptor interceptor) {
        this.mWinEnvironment.setOnTouchEventInterceptor(interceptor);
        this.setOnTouchEventInterceptor(interceptor);
    }

    @Override
    public AbstractWindow getRootWindowAt(int index) {
        if (this.mWinEnvironment.getWindowStackAt(index) == null) {
            return null;
        }
        return this.mWinEnvironment.getWindowStackAt(index).getRootWindow();
    }

    @Override
    public AbstractWindow getTopWindowAt(int index) {
        if (this.mWinEnvironment.getWindowStackAt(index) == null) {
            return null;
        }
        return this.mWinEnvironment.getWindowStackAt(index).getStackTopWindow();
    }

    @Override
    public void invalidateBackgroundLayerContent() {
        if (this.mWinEnvironment != null) {
            this.mWinEnvironment.invalidateWallpaper();
        }
    }

    @Override
    public void addBackgroundLayerContent(View v) {
        this.mWinEnvironment.attachWallpaper(v);
    }

    @Override
    public void removeBackgroundLayerContent(View v) {
        this.mWinEnvironment.detachWallpaper();
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = false;
        int action = event.getAction();
        if (!this.mTouchEventIntercepted && this.onInterceptTouchEvent(event)) {
            this.mTouchEventIntercepted = true;
        }
        if (action == 0) {
            if (this.mTargetView != null) {
                this.mTargetView = null;
            }
            if (!this.mTouchEventIntercepted && this.mWinEnvironment.getCurrentWindowStack() != null) {
                if (this.mWinEnvironment.getCurrentWindowStack().isWindowAnimating()) {
                    return true;
                }
                AbstractWindow topWindow = this.mWinEnvironment.getCurrentWindowStack().getStackTopWindow();
                if (topWindow != null) {
                    Rect hitRect = new Rect();
                    int realX = (int)event.getX();
                    int realY = (int)event.getY();
                    topWindow.getHitRect(hitRect);
                    if (hitRect.contains(realX, realY)) {
                        this.mTargetView = topWindow;
                    }
                }
            }
        }
        if (this.mTouchEventIntercepted) {
            if (this.mTargetView != null) {
                event.setAction(3);
                this.mTargetView.dispatchTouchEvent(event);
                this.mTargetView = null;
                event.setAction(action);
            }
            result = this.onTouchEvent(event);
        } else {
            result = this.mTargetView != null ? this.mTargetView.dispatchTouchEvent(event) : false;
        }
        if (action == 1 || action == 3) {
            this.mTargetView = null;
            this.mTouchEventIntercepted = false;
        }
        return result;
    }

    private boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mOnTouchEventInterceptor != null && this.mOnTouchEventInterceptor.onInterceptTouchEvent(ev);
    }

    private boolean onTouchEvent(MotionEvent event) {
        return this.mOnTouchEventInterceptor != null && this.mOnTouchEventInterceptor.onTouchEvent(event);
    }

    @Override
    public void hideWallpaper() {
        this.mWinEnvironment.hideWallpaper();
    }

    @Override
    public void showWallpaper() {
        this.mWinEnvironment.showWallpaper();
    }

    @Override
    public void addExtLayerContent(View v) {
        this.mWinEnvironment.addExtLayerContent(v);
    }

    @Override
    public void removeExtLayerContent(View v) {
        if (this.isWindowValid()) {
            this.mWinEnvironment.removeExtLayerContent(v);
        }
    }

    @Override
    public void blockAllRequestLayoutTemporary() {
        this.mWinEnvironment.blockRequestLayoutTemporary();
    }

    @Override
    public void showWindowLayer() {
        this.mWinEnvironment.showWindowLayer();
    }

    @Override
    public void hideWindowLayer() {
        this.mWinEnvironment.hideWindowLayer();
    }

    @Override
    public void disableWindowAnimation(AbstractWindow absWin) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setFullScreen(boolean fullScreen) {
    }

    @Override
    public AbstractWindow getCurStackTopWindow() {
        return this.mWinEnvironment.getCurrentWindowStack().getStackTopWindow();
    }

    private void setOnTouchEventInterceptor(OnTouchEventInterceptor interceptor) {
        this.mOnTouchEventInterceptor = interceptor;
    }

    @Override
    public void forceHandleTransparentStatusBarBgColor(AbstractWindow aWindow) {
        this.mForceHandleTransparentStatusBarBgColorAbsWindow = aWindow;
    }

    @Override
    public void clearHandleTransparentStatusBarBgColor() {
        this.forceHandleTransparentStatusBarBgColor(null);
    }

    private void initialWindowStatusBar(Activity activity) {
        if (SystemUtils.checkTransparentStatusBar((Context)activity)) {
            SystemUtils.configTransparentStatusBar((Window)activity.getWindow());
        }
        SystemUtils.checkChangeStatusBarColorEnable();
    }

    @Override
    public void notifyCurrentWindowForegroundChanged() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractWindow window = ACWindowManager.this.getCurrentWindow();
                if (window != null) {
                    window.invalidateWindowStatusBar();
                }
            }
        }, (long)200L);
    }

    @Override
    public boolean isWindowValid() {
        return this.mActivity != null && this.mWinEnvironment != null;
    }

    private void checkRootWindowFinish() {
        if (this.mCheckFinishTask == null) {
            this.mCheckFinishTask = this::checkFinishDelay;
        } else {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckFinishTask);
        }
        YYTaskExecutor.postToMainThread((Runnable)this.mCheckFinishTask, (long)50L);
    }

    private void checkFinishDelay() {
        AbstractWindow cur;
        if (this.mActivity == null || this.mActivity.isFinishing()) {
            return;
        }
        ACWindowStack stack = null;
        if (this.mWinEnvironment != null && this.mWinEnvironment.getWindowStackCount() == 1 && (stack = this.mWinEnvironment.getCurrentWindowStack()) != null && stack.getWindowCount() == 1 && (cur = this.getCurrentWindow()) != null && cur.isRootWindowNeedFinish()) {
            this.mActivity.finish();
        }
    }

    private boolean isNeedFinishRootWindow() {
        ACWindowStack stack = null;
        if (this.mWinEnvironment != null && this.mWinEnvironment.getWindowStackCount() == 1 && (stack = this.mWinEnvironment.getCurrentWindowStack()) != null && stack.getWindowCount() == 1) {
            AbstractWindow cur = this.getCurrentWindow();
            return cur != null && cur.isRootWindowNeedFinish();
        }
        return false;
    }

    private void checkStatusBarAndOrientation(AbstractWindow window) {
        ACWindowManager.adjustStatusBar(this.mActivity, this.mDeviceManager, window);
        ACWindowManager.adjustOrientation(this.mActivity, this.mDeviceManager, window);
    }

    public static void adjustStatusBar(Activity activity, DeviceManager deviceManager, AbstractWindow curWindow) {
        if (activity == null || deviceManager == null) {
            return;
        }
        if (curWindow != null) {
            curWindow.adjustStatusBar(activity, deviceManager);
        }
    }

    private static void adjustOrientation(Activity activity, DeviceManager deviceManager, AbstractWindow curWindow) {
        if (activity == null || deviceManager == null) {
            return;
        }
        if (curWindow != null && curWindow.getScreenOrientationType() != ScreenUtils.getTransformScreenOrientation((Activity)activity)) {
            ScreenUtils.lockScreen((Activity)activity, (int)curWindow.getScreenOrientationType(), (boolean)true);
        }
    }
}

