/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.framework.core.ui.ACWindowStack;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.OnTouchEventInterceptor;

final class ACWindowEnvironment
extends YYFrameLayout {
    private static final String TAG = "ACWindowEnvironment";
    private static final String TAG_WINLAYER = "WindowLayer";
    private static final boolean DEBUG_MEASURE_LAYOUT_EFFICIENCY = false;
    private FrameLayout.LayoutParams mMatchParentLP;
    private WindowLayer mWindowLayer;
    private ExtendedLayer mExtendedLayer;
    private View mWallpaper;
    private boolean mBlockWallpaperDisplay;
    private int mLastRequestedWallpaperVisibility;
    private ACWindowStack mCurrentStack;

    public ACWindowEnvironment(Context context) {
        this(context, -1);
    }

    public ACWindowEnvironment(Context context, int backgroundColor) {
        super(context);
        this.setBackgroundColor(backgroundColor);
        this.mMatchParentLP = new FrameLayout.LayoutParams(-1, -1);
        this.mWindowLayer = new WindowLayer(context);
        this.addView((View)this.mWindowLayer, (ViewGroup.LayoutParams)this.mMatchParentLP);
        this.mExtendedLayer = new ExtendedLayer(context);
        this.addView((View)this.mExtendedLayer, (ViewGroup.LayoutParams)this.mMatchParentLP);
    }

    void createWindowStack(ACWindowStack winStack, int index, boolean switchTo) {
        winStack.getRootWindow().onWindowStateChange((byte)14);
        if (switchTo) {
            this.mWindowLayer.addView((View)winStack, index);
            this.switchWindowStack(winStack);
        } else {
            winStack.setVisibility(4);
            this.mWindowLayer.addView((View)winStack, index);
        }
    }

    private boolean ensureIndexLegal(int index) {
        if (index < 0 || index > this.mWindowLayer.getChildCount() - 1) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG_WINLAYER, (String)("index illegal " + index), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    boolean destroyWindowStack(int index) {
        if (this.ensureIndexLegal(index)) {
            this.getWindowStackAt(index).popToRootWindow(false);
            if (this.mWindowLayer.getChildCount() == 1) {
                return false;
            }
            this.getWindowStackAt(index).getRootWindow().onWindowStateChange((byte)15);
            if (this.mCurrentStack == this.getWindowStackAt(index)) {
                int fallbackCurrentStackIndex = index > 0 ? index - 1 : index;
                this.mWindowLayer.removeViewAt(index);
                this.switchWindowStack(fallbackCurrentStackIndex);
            } else {
                this.mWindowLayer.removeViewAt(index);
            }
            return true;
        }
        return false;
    }

    int getWindowStackCount() {
        return this.mWindowLayer.getChildCount();
    }

    void switchWindowStack(int index) {
        if (index == this.getStackIndex(this.mCurrentStack)) {
            return;
        }
        if (this.ensureIndexLegal(index)) {
            int i;
            int count = this.mWindowLayer.getChildCount();
            for (i = 0; i < count; ++i) {
                if (i != index) continue;
                this.mCurrentStack.getRootWindow().clearAnimation();
                this.mCurrentStack.getRootWindow().onWindowStateChange((byte)11);
                if (this.mCurrentStack.getRootWindow() != this.mCurrentStack.getStackTopWindow()) {
                    this.mCurrentStack.getStackTopWindow().clearAnimation();
                    this.mCurrentStack.getStackTopWindow().onWindowStateChange((byte)11);
                }
                this.mCurrentStack = this.getWindowStackAt(index);
                this.mCurrentStack.getRootWindow().onWindowStateChange((byte)8);
                if (this.mCurrentStack.getRootWindow() != this.mCurrentStack.getStackTopWindow()) {
                    this.mCurrentStack.getStackTopWindow().onWindowStateChange((byte)8);
                }
                this.mCurrentStack.setVisibility(0);
                this.mCurrentStack.requestLayout();
                View topView = this.mCurrentStack.getChildAt(this.mCurrentStack.getChildCount() - 1);
                if (topView == null) continue;
                topView.setVisibility(0);
            }
            for (i = 0; i < count; ++i) {
                if (i == index) continue;
                this.mWindowLayer.getChildAt(i).setVisibility(4);
            }
        }
    }

    void switchWindowStack(ACWindowStack winStack) {
        int i;
        int count = this.mWindowLayer.getChildCount();
        View child = null;
        for (i = 0; i < count; ++i) {
            child = this.mWindowLayer.getChildAt(i);
            if (winStack != child) continue;
            if (null != this.mCurrentStack) {
                this.mCurrentStack.getRootWindow().clearAnimation();
                this.mCurrentStack.getRootWindow().onWindowStateChange((byte)11);
                if (this.mCurrentStack.getStackTopWindow() != this.mCurrentStack.getRootWindow()) {
                    this.mCurrentStack.getStackTopWindow().clearAnimation();
                    this.mCurrentStack.getStackTopWindow().onWindowStateChange((byte)11);
                }
            }
            this.mCurrentStack = winStack;
            this.mCurrentStack.getRootWindow().onWindowStateChange((byte)8);
            if (this.mCurrentStack.getRootWindow() != this.mCurrentStack.getStackTopWindow()) {
                this.mCurrentStack.getStackTopWindow().onWindowStateChange((byte)8);
            }
            this.mCurrentStack.setVisibility(0);
        }
        for (i = 0; i < count; ++i) {
            child = this.mWindowLayer.getChildAt(i);
            if (null == child || winStack == child) continue;
            child.setVisibility(4);
        }
    }

    ACWindowStack getWindowStackAt(int index) {
        if (this.ensureIndexLegal(index)) {
            return (ACWindowStack)this.mWindowLayer.getChildAt(index);
        }
        return null;
    }

    int getStackIndex(ACWindowStack stack) {
        for (int i = 0; i < this.getWindowStackCount(); ++i) {
            if (stack != this.getWindowStackAt(i)) continue;
            return i;
        }
        return -1;
    }

    ACWindowStack getCurrentWindowStack() {
        return this.mCurrentStack;
    }

    int getCurrentWindowStatckIndex() {
        return this.getStackIndex(this.mCurrentStack);
    }

    void attachWallpaper(View wallpaper) {
        if (wallpaper != null) {
            if (wallpaper.getParent() != null) {
                ((ViewGroup)wallpaper.getParent()).removeView(wallpaper);
            }
            this.addView(wallpaper, 0, (ViewGroup.LayoutParams)this.mMatchParentLP);
            this.mWallpaper = wallpaper;
        }
    }

    void invalidateWallpaper() {
        if (this.mWallpaper != null) {
            this.mWallpaper.invalidate();
        }
    }

    void detachWallpaper() {
        if (this.mWallpaper != null) {
            if (this.mWallpaper.getParent() != null && this.mWallpaper.getParent() == this) {
                this.removeView(this.mWallpaper);
            }
            this.mWallpaper = null;
        }
    }

    private void setWallpaperVisibility(int visibility) {
        if (this.mWallpaper != null && this.mWallpaper.getVisibility() != visibility) {
            this.mWallpaper.setVisibility(visibility);
        }
    }

    void hideWallpaper() {
        if (this.mBlockWallpaperDisplay) {
            this.mLastRequestedWallpaperVisibility = 4;
        } else {
            this.setWallpaperVisibility(4);
        }
    }

    void showWallpaper() {
        if (this.mBlockWallpaperDisplay) {
            this.mLastRequestedWallpaperVisibility = 0;
        } else {
            this.setWallpaperVisibility(0);
        }
    }

    void showWindowLayer() {
        this.mWindowLayer.setVisibility(0);
    }

    void hideWindowLayer() {
        this.mWindowLayer.setVisibility(8);
    }

    void addExtLayerContent(View v) {
        if (v != null) {
            if (v.getParent() != null) {
                ((ViewGroup)v.getParent()).removeView(v);
            }
            this.mExtendedLayer.addView(v);
        }
    }

    void removeExtLayerContent(View v) {
        if (v != null && v.getParent() != null && v.getParent() == this.mExtendedLayer) {
            this.mExtendedLayer.removeView(v);
        }
    }

    void addLayer(View layer) {
        this.addView(layer, (ViewGroup.LayoutParams)this.mMatchParentLP);
    }

    void removeLayer(View layer) {
        this.removeView(layer);
    }

    public boolean dispatchKeyEvent(KeyEvent ev) {
        if (this.mCurrentStack != null && this.mCurrentStack.getStackTopWindow() != null) {
            return this.mCurrentStack.getStackTopWindow().dispatchKeyEvent(ev);
        }
        return super.dispatchKeyEvent(ev);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            AbstractWindow.sWindowWidth = right - left;
            AbstractWindow.sWindowHeight = bottom - top;
        }
    }

    void blockRequestLayoutTemporary() {
        if (this.isLayoutRequested()) {
            ViewParent parent = this.getParent();
            if (parent != null && !parent.isLayoutRequested()) {
                parent.requestLayout();
            }
        } else {
            this.forceLayout();
        }
    }

    public void requestLayout() {
        super.requestLayout();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
    }

    void setBlockWindowLayerDispatchDraw(boolean block) {
        this.mWindowLayer.setBlockDispatchDraw(block);
    }

    void setBlockWallpaperDisplay(boolean block) {
        if (this.mBlockWallpaperDisplay != block) {
            this.mBlockWallpaperDisplay = block;
            if (this.mWallpaper != null) {
                if (block) {
                    this.mLastRequestedWallpaperVisibility = this.mWallpaper.getVisibility();
                    this.setWallpaperVisibility(4);
                } else {
                    this.setWallpaperVisibility(this.mLastRequestedWallpaperVisibility);
                }
            } else {
                this.mLastRequestedWallpaperVisibility = 0;
            }
        }
    }

    void setOnTouchEventInterceptor(OnTouchEventInterceptor interceptor) {
        this.mWindowLayer.setOnTouchEventInterceptor(interceptor);
    }

    public boolean isWinInStack(AbstractWindow window) {
        if (this.mCurrentStack != null) {
            return this.mCurrentStack.isWinInStack(window);
        }
        return false;
    }

    private static class WindowLayer
    extends YYFrameLayout {
        private boolean mBlockDispatchDraw;
        private OnTouchEventInterceptor mTouchInterceptor;

        public WindowLayer(Context context) {
            super(context);
        }

        public void setBlockDispatchDraw(boolean block) {
            if (this.mBlockDispatchDraw != block) {
                this.mBlockDispatchDraw = block;
                this.invalidate();
            }
        }

        public void setOnTouchEventInterceptor(OnTouchEventInterceptor interceptor) {
            this.mTouchInterceptor = interceptor;
        }

        protected void dispatchDraw(Canvas canvas) {
            if (!this.mBlockDispatchDraw) {
                super.dispatchDraw(canvas);
            }
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            if (this.mTouchInterceptor != null && this.mTouchInterceptor.onInterceptTouchEvent(ev)) {
                return true;
            }
            return super.onInterceptTouchEvent(ev);
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (this.mTouchInterceptor != null && this.mTouchInterceptor.onTouchEvent(event)) {
                return true;
            }
            return super.onTouchEvent(event);
        }
    }

    private static class ExtendedLayer
    extends YYFrameLayout {
        public ExtendedLayer(Context aContext) {
            super(aContext);
            this.setClipChildren(false);
        }
    }
}

