/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;

public class YYAsyncLayoutInflater {
    private static final String TAG = "AsyncLayoutInflater";
    LayoutInflater mInflater;
    Handler mHandler;
    InflateThread mInflateThread;
    InflateRequest mRequest;
    private Handler.Callback mHandlerCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            InflateRequest request = (InflateRequest)msg.obj;
            if (request.view == null) {
                if (request.resid == 0) {
                    Log.w((String)YYAsyncLayoutInflater.TAG, (String)"request \u88ab\u624b\u52a8\u91ca\u653e\u4e86\uff0c\u5e94\u8be5\u662f\u9000\u51fa\u4e86\u5f53\u524d\u9875\u9762 ");
                    YYAsyncLayoutInflater.this.mInflateThread.releaseRequest(request);
                    return true;
                }
                request.view = YYAsyncLayoutInflater.this.mInflater.inflate(request.resid, request.parent, false);
            }
            request.callback.onInflateFinished(request.view, request.resid, request.parent);
            YYAsyncLayoutInflater.this.mInflateThread.releaseRequest(request);
            return true;
        }
    };

    public YYAsyncLayoutInflater(@NonNull Context context) {
        this.mInflater = new BasicInflater(context);
        this.mHandler = new Handler(this.mHandlerCallback);
        this.mInflateThread = new InflateThread();
    }

    @UiThread
    public void inflate(@LayoutRes int resid, @Nullable ViewGroup parent, @NonNull OnInflateFinishedListener callback) {
        if (callback == null) {
            throw new NullPointerException("callback argument may not be null!");
        }
        this.mRequest = new InflateRequest();
        this.mRequest.inflater = this;
        this.mRequest.resid = resid;
        this.mRequest.parent = parent;
        this.mRequest.callback = callback;
        this.mInflateThread.enqueue(this.mRequest);
    }

    @SuppressLint(value={"LogUsage"})
    public void release() {
        try {
            this.mInflateThread.releaseRequest(this.mRequest);
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)"Failed to release ", (Throwable)e);
        }
    }

    @SuppressLint(value={"ThreadUsage"})
    private static class InflateThread
    extends Thread {
        private InflateRequest request;

        private InflateThread() {
        }

        @SuppressLint(value={"LogUsage"})
        public void runInner() {
            try {
                if (this.request != null && this.request.inflater != null) {
                    this.request.view = this.request.inflater.mInflater.inflate(this.request.resid, this.request.parent, false);
                }
            }
            catch (RuntimeException ex) {
                Log.w((String)YYAsyncLayoutInflater.TAG, (String)"Failed to inflate resource in the background! Retrying on the UI thread", (Throwable)ex);
            }
            if (this.request != null && this.request.inflater != null && this.request.inflater.mHandler != null) {
                Message.obtain((Handler)this.request.inflater.mHandler, (int)0, (Object)this.request).sendToTarget();
            }
        }

        @Override
        public void run() {
            this.runInner();
        }

        @SuppressLint(value={"LogUsage"})
        public void releaseRequest(InflateRequest obj) {
            try {
                obj.callback = null;
                obj.inflater = null;
                obj.parent = null;
                obj.resid = 0;
                obj.view = null;
            }
            catch (Throwable e) {
                Log.e((String)YYAsyncLayoutInflater.TAG, (String)"Failed to release ", (Throwable)e);
            }
        }

        public void enqueue(InflateRequest request) {
            try {
                this.request = request;
                this.start();
            }
            catch (Exception e) {
                Log.e((String)YYAsyncLayoutInflater.TAG, (String)"Failed to enqueue ", (Throwable)e);
            }
        }
    }

    private static class BasicInflater
    extends LayoutInflater {
        private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.app."};

        BasicInflater(Context context) {
            super(context);
        }

        public LayoutInflater cloneInContext(Context newContext) {
            return new BasicInflater(newContext);
        }

        @SuppressLint(value={"LoopUsage"})
        protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
            for (String prefix : sClassPrefixList) {
                try {
                    View view = this.createView(name, prefix, attrs);
                    if (view == null) continue;
                    return view;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.onCreateView(name, attrs);
        }
    }

    private static class InflateRequest {
        YYAsyncLayoutInflater inflater;
        ViewGroup parent;
        int resid;
        View view;
        OnInflateFinishedListener callback;

        InflateRequest() {
        }
    }

    public static interface OnInflateFinishedListener {
        public void onInflateFinished(@NonNull View var1, @LayoutRes int var2, @Nullable ViewGroup var3);
    }
}

