/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import java.util.Collection;

public class Should {
    private static final String TAG = "Should";
    private static boolean sShouldThrowError = RuntimeContext.sIsDebuggable;

    public static void setThrowAssertionError(boolean enable2) {
        sShouldThrowError = enable2;
    }

    public static void notNull(Object obj) {
        Should.notNull(obj, "notNull assert fail");
    }

    public static void notNull(Object obj, String msg) {
        Should.notNullIf(obj, true, msg);
    }

    public static void notNullIf(Object obj, boolean ifCondition) {
        Should.notNullIf(obj, ifCondition, "notNullIf assert fail");
    }

    public static void notNullIf(Object obj, boolean ifCondition, String msg) {
        if (ifCondition && obj == null) {
            Should.throwAssertionError(msg);
        }
    }

    private static void throwAssertionError(String msg) {
        Should.throwAssertionError(msg, null);
    }

    private static void throwAssertionError(String msg, Throwable t) {
        if (sShouldThrowError) {
            if (t != null) {
                throw new AssertionError((Object)t);
            }
            throw new AssertionError((Object)msg);
        }
        MLog.error((Object)msg, (Throwable)(t != null ? t : new Throwable()));
    }

    public static void beNullIf(Object obj, boolean ifCondition) {
        Should.beNullIf(obj, ifCondition, "beNullIf assert fail");
    }

    public static void beNullIf(Object obj, boolean ifCondition, String msg) {
        if (ifCondition && obj != null) {
            Should.throwAssertionError(msg);
        }
    }

    public static void notEmpty(CharSequence str) {
        Should.notEmptyIf(str, true, "notEmpty assert fail");
    }

    public static void notEmptyIf(CharSequence str, boolean ifCondition) {
        Should.notEmptyIf(str, ifCondition, "notEmptyIf assert fail");
    }

    public static void notEmptyIf(CharSequence str, boolean ifCondition, String msg) {
        if (ifCondition && TextUtils.isEmpty((CharSequence)str)) {
            Should.throwAssertionError(msg);
        }
    }

    public static void notEmpty(Collection c) {
        Should.notEmptyIf(c, true, "notEmpty assert fail");
    }

    public static void notEmptyIf(Collection c, boolean ifCondition, String msg) {
        if (ifCondition && (c == null || c.isEmpty())) {
            Should.throwAssertionError(msg);
        }
    }

    public static void beTrue(boolean b) {
        Should.beTrueIf(b, true);
    }

    public static void beTrue(boolean b, String msg) {
        Should.beTrueIf(b, true, msg);
    }

    public static void beTrueIf(boolean b, boolean ifCondition) {
        Should.beTrueIf(b, ifCondition, "beTrueIf assert fail");
    }

    public static void beTrueIf(boolean b, boolean ifCondition, String msg) {
        if (ifCondition && !b) {
            Should.throwAssertionError(msg);
        }
    }

    public static void beFalse(boolean b, String msg) {
        Should.beFalseIf(b, true, msg);
    }

    public static void beFalse(boolean b) {
        Should.beFalseIf(b, true);
    }

    public static void beFalseIf(boolean b, boolean ifCondition) {
        Should.beFalseIf(b, ifCondition, "beFalseIf assert fail");
    }

    public static void beFalseIf(boolean b, boolean ifCondition, String msg) {
        if (ifCondition && b) {
            Should.throwAssertionError(msg);
        }
    }

    public static void fail() {
        Should.fail("assert fail");
    }

    public static void fail(String msg) {
        Should.throwAssertionError(msg);
    }

    public static void fail(String msg, Throwable t) {
        Should.throwAssertionError(msg, t);
    }

    public static void beEqual(int origin, int expect) {
        if (sShouldThrowError && origin != expect) {
            Should.throwAssertionError("" + origin + " not equal to " + expect);
        }
    }
}

