/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ThrowUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.HandlEx;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class NotificationCenter {
    public static final int TAG_GLOBLE = 0;
    public static final int TAG_VIDEO = 1;
    public static final int TAG_FILEMGR = 2;
    public static final int TAG_BOOKMARK = 3;
    public static final int TAG_HISTORY = 4;
    private static final int PRIVATE_MSG_REGISTER = 2;
    private static final int PRIVATE_MSG_UNREGISTER = 3;
    private static final int PRIVATE_MSG_NOTIFY_ON_MAINTHREAD = 4;
    private static final String TAG = "NotificationCenter";
    public static SparseArray<NotificationCenter> sInstanceArray = new SparseArray();
    private int[] mNotificationHandlerCountCheckList = new int[0];
    private ArrayList<WeakReference<INotify>>[] mArray;
    private ArrayList<WeakReference<INotify>>[] mClearArray;
    private IStaticNotificationProxy mStaticNotificationProxy;
    private boolean mNotifyingLocked;
    private ArrayList<Integer> mNotifyingIds;
    private ArrayList<Integer> mRecursiveCallIds;
    private HandlEx mHandler = null;
    private boolean mIsInited = false;

    private NotificationCenter() {
    }

    public static synchronized NotificationCenter getGlobalInstance() {
        NotificationCenter instance = NotificationCenter.obtain(0);
        if (!instance.isInited()) {
            instance.init(Looper.getMainLooper(), NotificationDef.getIDCount());
            int[] notificationHandlerCountCheckWhiteList = new int[]{};
            instance.setHandlerCountCheckWhiteListForDebug(notificationHandlerCountCheckWhiteList);
        }
        return instance;
    }

    public static synchronized NotificationCenter obtain(int tag) {
        NotificationCenter instance = (NotificationCenter)sInstanceArray.get(tag);
        if (instance == null) {
            instance = new NotificationCenter();
            sInstanceArray.append(tag, (Object)instance);
        }
        return instance;
    }

    public static synchronized void destroy() {
        sInstanceArray.clear();
    }

    public void init(Looper looper, int idCount) {
        int i;
        if (this.mIsInited) {
            throw new IllegalStateException("NotificationCenter instance has been inited!!!");
        }
        this.mHandler = new HandlEx(NotificationCenter.class.getName(), looper){

            public void handleMessage(Message msg) {
                if (msg.what == 2) {
                    NotificationCenter.this.registerInner((INotify)msg.obj, msg.arg1);
                } else if (msg.what == 3) {
                    NotificationCenter.this.unregisterInner((INotify)msg.obj, msg.arg1);
                } else if (msg.what == 4) {
                    NotificationCenter.this.notifyInner((Notification)msg.obj);
                }
            }
        };
        this.mArray = new ArrayList[idCount];
        for (i = 0; i < idCount; ++i) {
            this.mArray[i] = new ArrayList();
        }
        this.mClearArray = new ArrayList[idCount];
        for (i = 0; i < idCount; ++i) {
            this.mClearArray[i] = new ArrayList();
        }
        this.mNotifyingIds = new ArrayList(10);
        this.mRecursiveCallIds = new ArrayList(10);
        this.mIsInited = true;
    }

    public void setHandlerCountCheckWhiteListForDebug(int[] handlerCountCheckWhiteList) {
        this.mNotificationHandlerCountCheckList = handlerCountCheckWhiteList == null && this.mNotificationHandlerCountCheckList.length > 0 ? new int[0] : handlerCountCheckWhiteList;
    }

    public void setStaticNotificationProxy(IStaticNotificationProxy proxy) {
        this.mStaticNotificationProxy = proxy;
    }

    public void register(int notificationID, INotify notify) {
        this.checkThread();
        if (YYTaskExecutor.isMainThread() && this.checkNotifyingLocked("reg", notificationID)) {
            this.registerInner(notify, notificationID);
        } else {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, notificationID, 0, notify));
        }
    }

    public void unregister(int notificationID, INotify notify) {
        this.checkThread();
        if (YYTaskExecutor.isMainThread() && this.checkNotifyingLocked("unreg", notificationID)) {
            this.unregisterInner(notify, notificationID);
        } else {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, notificationID, 0, notify));
        }
    }

    public void notify(Notification notification) {
        if (YYTaskExecutor.isMainThread()) {
            this.notifyInner(notification);
        } else {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, notification));
        }
    }

    public void notify(Notification notification, long delay) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(4, notification), delay);
    }

    public boolean isInited() {
        return this.mIsInited;
    }

    public Notification obtainNotification(int id2, Object extObj) {
        return new Notification(id2, extObj);
    }

    public Notification obtainNotification(int id2) {
        return new Notification(id2);
    }

    private boolean checkNotifyingLocked(String cause, int notificationID) {
        if (this.mNotifyingLocked && this.mNotifyingIds.contains(notificationID)) {
            if (!RuntimeContext.sIsDebuggable) {
                this.statsNotifyingLocked(cause, notificationID);
            }
            return false;
        }
        return true;
    }

    private boolean checkRecursiveNotifyingLocked(int notificationID) {
        if (this.mNotifyingLocked && this.mNotifyingIds.contains(notificationID)) {
            if (RuntimeContext.sIsDebuggable) {
                this.tellOwner("Trying to notify the SAME NOTIFICATION while notifying! nid: " + notificationID + " Array: " + this.mNotifyingIds.toString());
            } else {
                this.statsNotifyingLocked("notify", notificationID);
            }
            return false;
        }
        return true;
    }

    private void statsNotifyingLocked(String cause, int notificationID) {
    }

    private void checkThread() {
    }

    private boolean checkDuplicateRegister(INotify notify, int notificationID) {
        boolean result = false;
        int size = this.mArray[notificationID].size();
        for (int i = 0; i < size; ++i) {
            INotify arrayMember;
            WeakReference<INotify> weakObject = this.mArray[notificationID].get(i);
            if (null == weakObject || (arrayMember = (INotify)weakObject.get()) == null || arrayMember != notify) continue;
            result = true;
            break;
        }
        return result;
    }

    private void checkNotificationHandlerCount(int notificationId, int handlerCount) {
        if (RuntimeContext.sIsDebuggable && handlerCount == 0) {
            for (int i = 0; i < this.mNotificationHandlerCountCheckList.length; ++i) {
                if (this.mNotificationHandlerCountCheckList[i] != notificationId) continue;
                return;
            }
            Error error = new Error("notify: " + notificationId + " has NO handler.");
            MLog.error((Object)TAG, (String)error.toString(), (Object[])new Object[0]);
        }
    }

    private void tellOwner(String message) {
        Error error = new Error("\u8bf7\u5c06\u4ee5\u4e0b\u95ee\u9898\u544a\u77e5\u5362\u9f99\uff1a" + message);
        MLog.error((Object)TAG, (Throwable)error);
    }

    private void registerInner(INotify notify, int notificationID) {
        if (!this.checkDuplicateRegister(notify, notificationID)) {
            this.mArray[notificationID].add(new WeakReference<INotify>(notify));
        }
    }

    private void unregisterInner(INotify notify, int notificationID) {
        int size = this.mArray[notificationID].size();
        for (int i = 0; i < size; ++i) {
            INotify arrayMember;
            WeakReference<INotify> weakObject = this.mArray[notificationID].get(i);
            if (null == weakObject || (arrayMember = (INotify)weakObject.get()) == null || arrayMember != notify) continue;
            this.mArray[notificationID].remove(weakObject);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInner(Notification notification) {
        this.checkOrRegisterStaticDeclareReceviers(notification);
        this.checkRecursiveNotifyingLocked(notification.id);
        boolean isTopLevelCall = !this.mNotifyingLocked;
        this.mNotifyingLocked = true;
        this.mNotifyingIds.add(notification.id);
        this.mRecursiveCallIds.add(notification.id);
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("notifyInner, id: " + notification.id + " isTopLevelCall: " + isTopLevelCall), (Object[])new Object[0]);
        }
        try {
            int count = this.mArray[notification.id].size();
            this.checkNotificationHandlerCount(notification.id, count);
            for (int i = 0; i < count; ++i) {
                WeakReference<INotify> weakObject = this.mArray[notification.id].get(i);
                INotify notify = (INotify)weakObject.get();
                if (notify != null) {
                    try {
                        notify.notify(notification);
                    }
                    catch (Throwable t) {
                        if (!RuntimeContext.sIsDebuggable) continue;
                        StringWriter errors = new StringWriter();
                        t.printStackTrace(new PrintWriter(errors));
                        ThrowUtils.throwException((String)("NotificationCenter.notify assert fail at " + notify + ", " + notification), (Throwable)t);
                    }
                    continue;
                }
                this.mClearArray[notification.id].add(weakObject);
            }
        }
        catch (Exception e) {
            if (RuntimeContext.sIsDebuggable) {
                ThrowUtils.throwException((Throwable)e);
            } else {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        finally {
            this.mNotifyingIds.remove((Object)notification.id);
            if (isTopLevelCall) {
                if (RuntimeContext.sIsDebuggable) {
                    Log.d((String)TAG, (String)("notifyInner, top level call return, ids: " + this.mRecursiveCallIds.toString()));
                }
                for (int i = 0; i < this.mRecursiveCallIds.size(); ++i) {
                    int notificationId = this.mRecursiveCallIds.get(i);
                    for (int k = 0; k < this.mClearArray[notificationId].size(); ++k) {
                        this.mArray[notification.id].remove(this.mClearArray[notificationId].get(k));
                    }
                    this.mClearArray[notificationId].clear();
                }
                this.mNotifyingLocked = false;
                this.mRecursiveCallIds.clear();
                this.mNotifyingIds.clear();
            }
        }
    }

    private void checkOrRegisterStaticDeclareReceviers(Notification notification) {
        if (this.mStaticNotificationProxy != null) {
            this.mStaticNotificationProxy.checkOrRegisterStaticDeclareReceviers(this, notification);
        }
    }

    public static interface IStaticNotificationProxy {
        public void checkOrRegisterStaticDeclareReceviers(NotificationCenter var1, Notification var2);
    }
}

