/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.app.ActivityOptionsCompat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.PackageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.R;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;

public class NavigationUtils {
    private static final String TAG = "NavigationUtils";
    private static final String FALLBACK_KEY = "browser_fallback_url";

    public static void slideStartActivity(Context context, Intent intent) {
        ActivityOptionsCompat options = ActivityOptionsCompat.makeCustomAnimation((Context)context, (int)R.anim.activity_slide_in_from_right, (int)R.anim.activity_slide_out_from_left);
        try {
            ActivityCompat.startActivity((Context)((Activity)context), (Intent)intent, (Bundle)options.toBundle());
        }
        catch (Throwable e) {
            MLog.error((Object)context, (String)"[kaede][start activity exception] parcel data too large!", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static void slideStartActivityForResult(Context context, Intent intent, int requestCode) {
        ActivityOptionsCompat options = ActivityOptionsCompat.makeCustomAnimation((Context)context, (int)R.anim.activity_slide_in_from_right, (int)R.anim.activity_slide_out_from_left);
        try {
            ActivityCompat.startActivityForResult((Activity)((Activity)context), (Intent)intent, (int)requestCode, (Bundle)options.toBundle());
        }
        catch (Throwable e) {
            MLog.error((Object)context, (String)"[kaede][start activity exception] parcel data too large!", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static void fadeStartActivity(Context context, Intent intent) {
        ActivityOptionsCompat options = ActivityOptionsCompat.makeCustomAnimation((Context)context, (int)R.anim.activity_fade_in, (int)R.anim.activity_fade_out);
        try {
            ActivityCompat.startActivity((Context)((Activity)context), (Intent)intent, (Bundle)options.toBundle());
        }
        catch (Throwable e) {
            MLog.error((Object)context, (String)"[kaede][start activity exception] parcel data too large!", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static void navToBrower(Context context, String url) {
        Intent it = new Intent("android.intent.action.VIEW");
        it.setData(Uri.parse((String)url));
        it = Intent.createChooser((Intent)it, null);
        NavigationUtils.slideStartActivity(context, it);
    }

    public static boolean openGooglePlay(Context context) {
        if (context == null) {
            return false;
        }
        String appId = context.getPackageName();
        String scheme = "market://details?id=" + appId;
        return NavigationUtils.openGooglePlayWithScheme(context, scheme);
    }

    public static boolean openGooglePlayHome(Context context) {
        return NavigationUtils.openGooglePlayWithScheme(context, "https://play.google.com/store");
    }

    public static boolean openGooglePlayWithScheme(Context context, String scheme) {
        return NavigationUtils.openAppWithScheme(context, "com.android.vending", scheme);
    }

    public static boolean openAppWithScheme(Context context, String packageName, String scheme) {
        if (context == null || TextUtils.isEmpty((CharSequence)scheme)) {
            return false;
        }
        Uri uri = null;
        try {
            uri = Uri.parse((String)scheme);
            Intent rateIntent = new Intent("android.intent.action.VIEW", uri);
            rateIntent.addFlags(0x10000000);
            rateIntent.addFlags(0x200000);
            rateIntent.addFlags(0x4000000);
            ResolveInfo otherApp = NavigationUtils.findAppInfo(context, packageName, rateIntent);
            if (otherApp != null) {
                ActivityInfo otherAppActivity = otherApp.activityInfo;
                ComponentName componentName = new ComponentName(otherAppActivity.applicationInfo.packageName, otherAppActivity.name);
                rateIntent.setComponent(componentName);
                context.startActivity(rateIntent);
                return true;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                rateIntent.setPackage(packageName);
                context.startActivity(rateIntent);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return false;
    }

    public static boolean openAppWithScheme(Context context, String uri) {
        return NavigationUtils.openAppWithScheme(null, context, uri);
    }

    public static boolean openAppWithScheme(IWebView webView, Context context, String uri) {
        if (context == null || TextUtils.isEmpty((CharSequence)uri)) {
            return false;
        }
        Intent rateIntent = null;
        if (uri.startsWith("intent://")) {
            try {
                rateIntent = Intent.parseUri((String)uri, (int)1);
            }
            catch (URISyntaxException e) {
                MLog.error((Object)TAG, (Throwable)e);
                rateIntent = NavigationUtils.createNewTaskIntent(uri);
            }
        } else {
            rateIntent = NavigationUtils.createNewTaskIntent(uri);
        }
        if (Build.VERSION.SDK_INT < 30 ? !NavigationUtils.startIntentBelow11(context, uri, rateIntent) : !NavigationUtils.startIntentAbove11(context, rateIntent)) {
            return NavigationUtils.tryFallbackUrl(webView, context, rateIntent, uri);
        }
        return true;
    }

    private static boolean startIntentBelow11(Context context, String uri, Intent rateIntent) {
        try {
            String packageName = rateIntent.getPackage();
            if (!TextUtils.isEmpty((CharSequence)packageName) && !PackageUtils.isAppInstalled((Context)context, (String)packageName)) {
                MLog.error((Object)TAG, (String)"no install app %s", (Object[])new Object[]{packageName});
                return false;
            }
            if (FP.empty(NavigationUtils.getResolveInfos(context, rateIntent))) {
                MLog.error((Object)TAG, (String)"no app handle scheme %s", (Object[])new Object[]{uri});
                return false;
            }
            context.startActivity(rateIntent);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean startIntentAbove11(Context context, Intent rateIntent) {
        try {
            context.startActivity(rateIntent);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean tryFallbackUrl(IWebView webView, Context context, Intent intent, String uri) {
        block6: {
            try {
                String fallbackUrl = intent.getStringExtra(FALLBACK_KEY);
                if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
                    fallbackUrl = NavigationUtils.parseFallback(uri);
                }
                if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
                    return false;
                }
                if (fallbackUrl.startsWith("http://") || fallbackUrl.startsWith("https://")) {
                    if (webView != null) {
                        webView.loadUrl(fallbackUrl);
                        return true;
                    }
                    break block6;
                }
                return NavigationUtils.openAppWithScheme(webView, context, fallbackUrl);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"tryFallbackUrl", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return false;
    }

    private static String parseFallback(String uri) {
        int end;
        String fallback = "";
        int start = uri.indexOf(FALLBACK_KEY);
        if (start >= 0 && (end = uri.indexOf(";", start)) > 0 && end < uri.length()) {
            fallback = uri.substring(start, end);
        }
        return fallback;
    }

    @Nullable
    private static ResolveInfo findAppInfo(Context context, String packageName, Intent rateIntent) {
        try {
            List<ResolveInfo> otherApps = NavigationUtils.getResolveInfos(context, rateIntent);
            for (ResolveInfo otherApp : otherApps) {
                if (!packageName.equals(otherApp.activityInfo.applicationInfo.packageName)) continue;
                return otherApp;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return null;
    }

    private static List<ResolveInfo> getResolveInfos(Context context, Intent rateIntent) {
        return context.getPackageManager().queryIntentActivities(rateIntent, 0);
    }

    private static Intent createNewTaskIntent(String uri) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.addFlags(0x200000);
        intent.addFlags(0x4000000);
        try {
            intent.setData(Uri.parse((String)uri));
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return intent;
    }

    public static void startDownload(Activity context, String url) {
        if (StringUtils.isEmpty((String)url) || context == null) {
            return;
        }
        Uri uri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (intent.resolveActivity(RuntimeContext.sApplicationContext.getPackageManager()) != null) {
            if (context instanceof Activity) {
                context.startActivity(intent);
            }
        } else {
            MLog.info((Object)"startDownload", (String)("can not found activity by this intent:" + intent), (Object[])new Object[0]);
            ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.download_game_fail), (int)0);
        }
    }

    public static boolean isInstallApp(Context context, String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        List pinfo = packageManager.getInstalledPackages(0);
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); ++i) {
                String pn = ((PackageInfo)pinfo.get((int)i)).packageName.toLowerCase(Locale.ENGLISH);
                if (!pn.equals(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface IWebView {
        public void loadUrl(String var1);
    }
}

