/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.AbstractMsgDispatcher;
import com.yy.framework.core.ICompatibilityAutoRegister;
import com.yy.framework.core.IMsgProcessor;
import com.yy.framework.core.Should;
import java.lang.ref.WeakReference;

public class MsgDispatcher
extends AbstractMsgDispatcher {
    private static final String TAG = "MsgDispatcher";
    private WeakReference<IMsgProcessor> mMsgProcessorRef;
    private WeakReference<ICompatibilityAutoRegister> mICompatibilityAutoRegister;

    public static void init(IMsgProcessor handler, ICompatibilityAutoRegister iCompatibilityAutoRegister) {
        Holder.INSTANCE.setMsgProcessorRef(handler, iCompatibilityAutoRegister);
    }

    public static MsgDispatcher getInstance() {
        Should.notNull(Holder.INSTANCE.getMsgProcessorRef(), "msg handler is null");
        return Holder.INSTANCE;
    }

    private MsgDispatcher() {
        this.mHandler = new MyHandler(this);
    }

    private void setMsgProcessorRef(IMsgProcessor processor, ICompatibilityAutoRegister iCompatibilityAutoRegister) {
        this.mMsgProcessorRef = new WeakReference<IMsgProcessor>(processor);
        this.mICompatibilityAutoRegister = new WeakReference<ICompatibilityAutoRegister>(iCompatibilityAutoRegister);
    }

    private IMsgProcessor getMsgProcessorRef() {
        return this.mMsgProcessorRef != null ? (IMsgProcessor)this.mMsgProcessorRef.get() : null;
    }

    protected void registerICompatibilityAutoMessage(int message, AbstractController abstractController) {
        ICompatibilityAutoRegister iCompatibilityAutoRegister;
        if (this.mICompatibilityAutoRegister != null && (iCompatibilityAutoRegister = (ICompatibilityAutoRegister)this.mICompatibilityAutoRegister.get()) != null) {
            iCompatibilityAutoRegister.registerMessageController(message, abstractController);
        }
    }

    protected void unRegisterICompatibilityAutoMessage(int message, AbstractController abstractController) {
        ICompatibilityAutoRegister iCompatibilityAutoRegister;
        if (this.mICompatibilityAutoRegister != null && (iCompatibilityAutoRegister = (ICompatibilityAutoRegister)this.mICompatibilityAutoRegister.get()) != null) {
            iCompatibilityAutoRegister.unRegisterMessageController(message, abstractController);
        }
    }

    private void checkMsgHandler(int msgId) {
        IMsgProcessor processor;
        if (SystemUtils.isShowEnvSetting() && (processor = this.getMsgProcessorRef()) != null && !processor.hasMsgHandler(msgId)) {
            processor.callNotMsgHandler(msgId);
            MLog.error((Object)TAG, (Throwable)new RuntimeException(msgId + " not find handler!"));
        }
    }

    public boolean hasMsgHandler(int msgId) {
        IMsgProcessor processor = this.getMsgProcessorRef();
        if (processor != null) {
            return processor.hasMsgHandler(msgId);
        }
        return false;
    }

    @Override
    public void sendMessage(int what, int arg1, int arg2, Object obj) {
        this.checkMsgHandler(what);
        this.mHandler.sendMessage(this.buildPostMessage(what, arg1, arg2, obj));
    }

    @Override
    public void sendMessageDelayed(int what, int arg1, int arg2, Object object, long delay) {
        this.checkMsgHandler(what);
        this.mHandler.sendMessageDelayed(this.buildPostMessage(what, arg1, arg2, object), delay);
    }

    @Override
    public Object sendMessageSync(Message msg) {
        if (!YYTaskExecutor.isMainThread()) {
            MLog.error((Object)"sendMessageSync", (String)"non-ui thread, \u6ce8\u610f\u7ebf\u7a0b\u5b89\u5168", (Object[])new Object[0]);
        }
        Should.notNull(this.mMsgProcessorRef);
        if (this.mMsgProcessorRef != null) {
            Should.notNull(this.mMsgProcessorRef.get());
        }
        if (this.getMsgProcessorRef() != null) {
            return this.getMsgProcessorRef().dispatchMessage(msg, true);
        }
        return null;
    }

    @Override
    public void sendMessage(Message message) {
        if (message != null) {
            this.sendMessage(message.what, message.arg1, message.arg2, message);
        }
    }

    @Override
    public void sendMessageDelayed(Message message, long delay) {
        if (message != null) {
            this.sendMessageDelayed(message.what, message.arg1, message.arg2, message, delay);
        }
    }

    private Message buildPostMessage(int what, int arg1, int arg2, Object obj) {
        Message real;
        if (obj instanceof Message) {
            real = (Message)obj;
        } else {
            real = Message.obtain();
            real.what = what;
            real.arg1 = arg1;
            real.arg2 = arg2;
            real.obj = obj;
        }
        Message wrap = Message.obtain();
        wrap.what = 1;
        wrap.obj = real;
        return wrap;
    }

    private static class MyHandler
    extends Handler {
        public static final int MSG_SEND_MSG = 1;
        private WeakReference<MsgDispatcher> mRef;

        public MyHandler(MsgDispatcher dispatcher) {
            super(Looper.getMainLooper());
            this.mRef = new WeakReference<MsgDispatcher>(dispatcher);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    IMsgProcessor iMsgProcessor;
                    if (this.mRef.get() == null) break;
                    Message real = (Message)msg.obj;
                    if (!YYTaskExecutor.isMainThread()) break;
                    Should.notNull(this.mRef.get());
                    if (this.mRef.get() == null || (iMsgProcessor = ((MsgDispatcher)this.mRef.get()).getMsgProcessorRef()) == null) break;
                    if (SystemUtils.isShowEnvSetting()) {
                        PerfActionLog.add((String)("MsgHandler_" + msg.what), (Object[])new Object[0]);
                    }
                    iMsgProcessor.dispatchMessage(real, false);
                    break;
                }
            }
        }
    }

    private static class Holder {
        private static MsgDispatcher INSTANCE = new MsgDispatcher();

        private Holder() {
        }
    }
}

