/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.AbstractMsgDispatcher;
import com.yy.framework.core.IMessageHandler;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Should;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ModuleMsgDispatcher
extends AbstractMsgDispatcher
implements Handler.Callback {
    public static final String TAG = "ModuleMsgDispatcher";
    private ConcurrentLinkedQueue<IMessageHandler> mHandlers = new ConcurrentLinkedQueue();

    public ModuleMsgDispatcher() {
        if (null == this.mHandler) {
            this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        }
    }

    private void checkDuplicateRegister(IMessageHandler handler) {
        if (RuntimeContext.sIsDebuggable) {
            ArrayList<Integer> msgsToRegister = handler.messages();
            if (msgsToRegister == null) {
                return;
            }
            for (Integer integer : msgsToRegister) {
                for (IMessageHandler c : this.mHandlers) {
                    ArrayList<Integer> msgs;
                    if (c == handler || null == (msgs = c.messages()) || !msgs.contains(integer)) continue;
                    Error error = new Error("msg: " + integer + " already registered by " + c);
                    throw new IllegalStateException(error);
                }
            }
        }
    }

    @Override
    public void register(IMessageHandler handler) {
        this.checkDuplicateRegister(handler);
        this.mHandlers.add(handler);
    }

    @Override
    public void unregister(IMessageHandler handler) {
        this.mHandlers.remove(handler);
    }

    @Override
    public void sendMessage(int what, int arg1, int arg2, Object obj) {
        this.sendMessageDelayed(what, arg1, arg2, obj, 0L);
    }

    @Override
    public void sendMessageDelayed(int what, int arg1, int arg2, Object obj, long delay) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(what, arg1, arg2, obj), delay);
    }

    public void removeMessages(int what) {
        this.mHandler.removeMessages(what);
    }

    private IMessageHandler findHandler(Message msg) {
        if (msg == null) {
            return null;
        }
        for (IMessageHandler c : this.mHandlers) {
            ArrayList<Integer> msgs = c.messages();
            if (null == msgs || !msgs.contains(msg.what)) continue;
            return c;
        }
        return null;
    }

    public boolean handleMessage(Message msg) {
        IMessageHandler c = this.findHandler(msg);
        if (c != null) {
            c.handleMessage(msg);
            return true;
        }
        MsgDispatcher.getInstance().sendMessage(Message.obtain((Message)msg));
        return true;
    }

    @Override
    public Object sendMessageSync(Message msg) {
        Should.beTrue(YYTaskExecutor.isMainThread(), "non-ui thread");
        if (YYTaskExecutor.isMainThread()) {
            IMessageHandler c = this.findHandler(msg);
            if (c != null) {
                return c.handleMessageSync(msg);
            }
            return MsgDispatcher.getInstance().sendMessageSync(msg);
        }
        this.sendMessage(msg.what, msg.arg1, msg.arg2, msg.obj);
        return null;
    }

    @Override
    public void sendMessage(Message message) {
        if (message != null) {
            this.sendMessage(message.what, message.arg1, message.arg2, message.obj);
        }
    }

    @Override
    public void sendMessageDelayed(Message message, long delay) {
        if (message != null) {
            this.sendMessageDelayed(message.what, message.arg1, message.arg2, message.obj, delay);
        }
    }
}

