/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.base.logger.MLog;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class DialogManager
implements INotify {
    private static final String TAG = "DialogManager";
    private static final ArrayList<IDialogMgntObserver> mObservers = new ArrayList();
    private static final List<DialogRecord> sWaitingDialogs = new LinkedList<DialogRecord>();
    private static final Handler mHandler = new DialogManagerHandler();
    private static ArrayList<IDialogMgntObserver> observersState;
    private static boolean sAllowToShow;

    public DialogManager() {
        if (Build.VERSION.SDK_INT >= 17) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, this);
        }
    }

    public static void register(IDialogMgntObserver observer) {
        boolean ret = mObservers.add(observer);
        if (ret && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("register a Dialog:" + observer), (Object[])new Object[0]);
        }
    }

    public static void unRegister(IDialogMgntObserver observer) {
        boolean ret = mObservers.remove(observer);
        if (ret && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"unRegister a Dialog", (Object[])new Object[0]);
        }
    }

    public static void dismissAll() {
        ArrayList observers;
        observersState = observers = (ArrayList)mObservers.clone();
        for (IDialogMgntObserver o : observers) {
            o.notifyToDismiss();
        }
        if (mObservers.size() > 0) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"some dialogs are not dismissed!", (Object[])new Object[0]);
            }
            mObservers.removeAll(mObservers);
        } else if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"dismiss All Dialogs", (Object[])new Object[0]);
        }
    }

    public static void resotreAll() {
        if (observersState == null) {
            return;
        }
        for (IDialogMgntObserver o : observersState) {
            o.show();
        }
    }

    public static boolean isAnyDialogShowing() {
        return !mObservers.isEmpty();
    }

    public static void allowToShow() {
        sAllowToShow = true;
        mHandler.sendEmptyMessageDelayed(4096, 2000L);
    }

    public static void disallowToShow() {
        sAllowToShow = false;
        mHandler.removeMessages(4096);
    }

    public static void onDialogStop() {
        if (sAllowToShow) {
            mHandler.sendEmptyMessageDelayed(4096, 100L);
        }
    }

    public static void requestToShow(IDelayableDialog dialog) {
        if (!sAllowToShow || DialogManager.isAnyDialogShowing()) {
            DialogManager.addToWaitingList(dialog);
        } else {
            dialog.doShow();
        }
    }

    public static void requestToDismiss(IDelayableDialog dialog) {
        if (DialogManager.isDialogInWaitingList(dialog)) {
            DialogManager.removeFromWaitingList(dialog);
        } else {
            dialog.doDismiss();
        }
    }

    private static boolean isDialogInWaitingList(IDelayableDialog dialog) {
        if (sWaitingDialogs.isEmpty()) {
            return false;
        }
        for (DialogRecord record : sWaitingDialogs) {
            if (record.dialog != dialog) continue;
            return true;
        }
        return false;
    }

    private static void addToWaitingList(IDelayableDialog dialog) {
        if (!DialogManager.isDialogInWaitingList(dialog)) {
            DialogRecord record = new DialogRecord();
            record.dialog = dialog;
            sWaitingDialogs.add(record);
        }
    }

    private static void removeFromWaitingList(IDelayableDialog dialog) {
        DialogRecord target = null;
        for (DialogRecord record : sWaitingDialogs) {
            if (record.dialog != dialog) continue;
            target = record;
            break;
        }
        if (target != null) {
            sWaitingDialogs.remove(target);
        }
    }

    private static void showFirstWaitingDialog() {
        if (!sWaitingDialogs.isEmpty()) {
            DialogRecord target = sWaitingDialogs.remove(0);
            target.dialog.doShow();
        }
    }

    @Override
    public void notify(Notification notification) {
        boolean foreground;
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && !(foreground = ((Boolean)notification.extObj).booleanValue())) {
            DialogManager.dismissAll();
        }
    }

    static {
        sAllowToShow = true;
    }

    private static class DialogManagerHandler
    extends Handler {
        private static final int MSG_SHOW_FIRST_WAITING_DIALOG = 4096;

        public DialogManagerHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 4096: {
                    DialogManager.showFirstWaitingDialog();
                    break;
                }
            }
        }
    }

    private static class DialogRecord {
        private IDelayableDialog dialog;

        private DialogRecord() {
        }
    }

    public static interface IDelayableDialog {
        public void doShow();

        public void doDismiss();
    }

    public static interface IDialogMgntObserver {
        public void notifyToDismiss();

        public void hide();

        public void show();
    }
}

