/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.os.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ThrowUtils;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ICompatibilityAutoRegister;
import com.yy.framework.core.IControllerCreator;
import com.yy.framework.core.IControllerFactory;
import com.yy.framework.core.IControllerRegister;
import com.yy.framework.core.IMsgProcessor;
import com.yy.framework.core.INotificationProcessor;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.Should;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ControllerCenter
implements IControllerRegister,
IMsgProcessor,
INotificationProcessor,
ICompatibilityAutoRegister,
NotificationCenter.IStaticNotificationProxy {
    private static final String TAG = "ControllerCenter";
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;
    static final int MODE_DEFALUT = 0;
    static final int MODE_DEPENDS_CONTROLLER_CREATED = 0x40000000;
    private Environment mEnv;
    private final ConcurrentHashMap<Class<? extends AbstractController>, Dual> mClazzHashMap;
    private final ConcurrentHashMap<Class<? extends AbstractController>, AbstractController> mMap;
    private IControllerFactory mControllerFactory;
    private IControllerRegister.IControllerCenterCallback mCallback;
    private static final int TYPE_MESSAGE = 1;
    private static final int TYPE_NOTIFICATION = 2;

    public static int maskRealId(int notiIdMsgId) {
        return notiIdMsgId & 0x3FFFFFFF;
    }

    public ControllerCenter(Environment env, IControllerFactory controllerFactory) {
        Should.notNull(env);
        this.mEnv = env;
        this.mClazzHashMap = new ConcurrentHashMap();
        this.mMap = new ConcurrentHashMap();
        this.mControllerFactory = controllerFactory;
    }

    public void setCallback(IControllerRegister.IControllerCenterCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public <T extends AbstractController> void registerController(int[] msgIds, int[] notificationIds, Class<T> controllerClass, IControllerCreator<T> creator) {
        this.mControllerFactory.addCreator(controllerClass, creator);
        if (msgIds != null && msgIds.length > 0) {
            this.registerController(msgIds, controllerClass);
        }
        if (notificationIds != null && notificationIds.length > 0) {
            this.registerNotification(notificationIds, controllerClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AbstractController> void unregisterController(List<Class<T>> controllerClassList) {
        Iterator<Class<T>> iterator = controllerClassList.iterator();
        while (iterator.hasNext()) {
            Class<T> c;
            Class<T> clazz = c = iterator.next();
            synchronized (clazz) {
                this.mClazzHashMap.remove(c);
                this.mMap.remove(c);
            }
        }
    }

    @Override
    public boolean hasMsgHandlerRegister(int msgId) {
        return this.hasMsgHandler(msgId);
    }

    @Override
    public void callNotMsgHandler(int msgId) {
        if (this.mCallback != null) {
            this.mCallback.onMsgHanderNotFind(msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessageController(int messages, AbstractController abstractController) {
        if (abstractController == null) {
            return;
        }
        Class<?> clazz = abstractController.getClass();
        synchronized (clazz) {
            this.checkMessage(messages, abstractController.getClass());
            if (this.mClazzHashMap.containsKey(abstractController.getClass())) {
                Dual dual = this.mClazzHashMap.get(abstractController.getClass());
                int id2 = messages & 0x3FFFFFFF;
                int flag = messages & 0xC0000000;
                if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)TAG, (String)("registerMessageController id = " + id2 + "  flag = " + flag), (Object[])new Object[0]);
                }
                Dual.IdFlag idFlag = new Dual.IdFlag(id2, flag);
                dual.messageList.add(idFlag);
            } else {
                Dual dual = new Dual();
                dual.messageList = ControllerCenter.asList(new int[]{messages});
                this.mClazzHashMap.put(abstractController.getClass(), dual);
            }
            this.mMap.put(abstractController.getClass(), abstractController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterMessageController(int messages, AbstractController abstractController) {
        if (abstractController == null) {
            return;
        }
        Class<?> clazz = abstractController.getClass();
        synchronized (clazz) {
            if (this.mClazzHashMap.containsKey(abstractController.getClass())) {
                Dual dual = this.mClazzHashMap.get(abstractController.getClass());
                ControllerCenter.removeMessage(dual.messageList, messages);
            }
        }
    }

    private static void removeMessage(List<Dual.IdFlag> messageList, int id2) {
        if (messageList != null) {
            for (Dual.IdFlag idFlag : messageList) {
                if (idFlag.id != id2) continue;
                messageList.remove(idFlag);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerController(int[] messages, Class<? extends AbstractController> clazz) {
        Class<? extends AbstractController> clazz2 = clazz;
        synchronized (clazz2) {
            Should.notNull(messages);
            Should.beTrue(messages.length > 0);
            this.checkMessage(messages, clazz);
            if (!this.mClazzHashMap.containsKey(clazz)) {
                Dual dual = new Dual();
                dual.messageList = ControllerCenter.asList(messages);
                this.mClazzHashMap.put(clazz, dual);
            } else {
                Dual dual = this.mClazzHashMap.get(clazz);
                if (dual.messageList != null) {
                    Should.fail("double registration: " + clazz);
                } else {
                    Should.beTrue(dual.notificationList != null);
                    dual.messageList = ControllerCenter.asList(messages);
                }
            }
        }
    }

    private void checkMessage(int msg, Class<? extends AbstractController> clazz) {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        this.checkMessage(new int[]{msg}, clazz);
    }

    private void checkMessage(int[] messages, Class<? extends AbstractController> clazz) {
        if (messages == null || !RuntimeContext.sIsDebuggable) {
            return;
        }
        Iterator<Map.Entry<Class<? extends AbstractController>, Dual>> iterator = this.mClazzHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<? extends AbstractController>, Dual> o;
            Map.Entry<Class<? extends AbstractController>, Dual> entry = o = iterator.next();
            Dual val = entry.getValue();
            Class<? extends AbstractController> abstractController = entry.getKey();
            if (val != null && val.messageList != null) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotification(int[] messages, Class<? extends AbstractController> clazz) {
        Should.notNull(messages);
        Should.beTrue(messages.length > 0);
        Class<? extends AbstractController> clazz2 = clazz;
        synchronized (clazz2) {
            if (!this.mClazzHashMap.containsKey(clazz)) {
                Dual dual = new Dual();
                dual.notificationList = ControllerCenter.asList(messages);
                this.mClazzHashMap.put(clazz, dual);
            } else {
                Dual dual = this.mClazzHashMap.get(clazz);
                if (dual.notificationList != null) {
                    Should.fail("double registration: " + clazz);
                } else {
                    Should.beTrue(dual.messageList != null);
                    dual.notificationList = ControllerCenter.asList(messages);
                }
            }
        }
    }

    @Override
    public void checkOrRegisterStaticDeclareReceviers(NotificationCenter center, Notification notification) {
        ArrayList<AbstractController> controllerList = this.findOrCreateControllerByNotificationId(notification.id, true);
        for (AbstractController abstractController : controllerList) {
            NotificationCenter.getGlobalInstance().register(notification.id, abstractController);
        }
    }

    private static List<Dual.IdFlag> asList(int[] ints) {
        ArrayList<Dual.IdFlag> idFlags = new ArrayList<Dual.IdFlag>();
        for (int messages : ints) {
            int id2 = messages & 0x3FFFFFFF;
            int flag = messages & 0xC0000000;
            Dual.IdFlag idFlag = new Dual.IdFlag(id2, flag);
            idFlags.add(idFlag);
        }
        return idFlags;
    }

    @Override
    public void dispatchBroadcast(Message msg, boolean autoCreate) {
        int notificationId = msg.what;
        ArrayList<AbstractController> controllerList = this.findOrCreateControllerByNotificationId(notificationId, autoCreate);
        if (controllerList.size() > 0) {
            for (AbstractController controller : controllerList) {
                controller.onNotification(notificationId, msg);
            }
        }
    }

    private static Dual.IdFlag isContainsId(List<Dual.IdFlag> idList, int id2) {
        if (idList == null) {
            return null;
        }
        for (Dual.IdFlag idFlag : idList) {
            if (idFlag.id != id2) continue;
            return idFlag;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AbstractController> findOrCreateControllerByNotificationId(int notificationId, boolean autoCreate) {
        ArrayList<AbstractController> controllers = new ArrayList<AbstractController>();
        for (Map.Entry<Class<? extends AbstractController>, Dual> entry : this.mClazzHashMap.entrySet()) {
            List idList = entry.getValue().notificationList;
            Dual.IdFlag idFlag = ControllerCenter.isContainsId(idList, notificationId);
            if (idFlag == null || idFlag.id != notificationId) continue;
            Class<? extends AbstractController> clazz = entry.getKey();
            AbstractController controller = this.mMap.get(clazz);
            if (controller == null && autoCreate && idFlag.flag == 0) {
                Class<? extends AbstractController> clazz2 = clazz;
                synchronized (clazz2) {
                    controller = this.mMap.get(clazz);
                    if (controller == null) {
                        try {
                            long time = -1L;
                            if (RuntimeContext.sIsDebuggable) {
                                time = System.currentTimeMillis();
                            }
                            if (this.mControllerFactory != null) {
                                controller = this.mControllerFactory.createController(clazz, this.mEnv);
                            }
                            if (controller == null) {
                                if (RuntimeContext.isLocalBuild()) {
                                    throw new IllegalStateException("\u672a\u9759\u6001\u6ce8\u518c\u521b\u5efaController\uff0c\u907f\u514d\u53cd\u5c04 ANR\uff0c " + clazz.getName());
                                }
                                Class[] parTypes = new Class[]{Environment.class};
                                Object[] pars = new Object[]{this.mEnv};
                                Constructor<? extends AbstractController> constructor = clazz.getConstructor(parTypes);
                                controller = constructor.newInstance(pars);
                            }
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.info((Object)TAG, (String)("create controller time = " + (System.currentTimeMillis() - time) + " clazz = " + clazz + " startupFinished:" + RuntimeContext.sIsAppStartFinished), (Object[])new Object[0]);
                            }
                            this.mMap.put(clazz, controller);
                        }
                        catch (Exception e) {
                            Should.fail("fail to construct controller " + clazz, e);
                        }
                    }
                }
            }
            if (controller == null) continue;
            controllers.add(controller);
        }
        return controllers;
    }

    @Override
    public Object dispatchMessage(Message msg, boolean isSync) {
        int msgId = msg.what;
        AbstractController controller = this.findOrCreateController(msgId, 1);
        if (controller != null) {
            return controller.onMessage(msgId, msg, isSync);
        }
        if (this.mCallback != null) {
            this.mCallback.onMsgHanderNotFind(msgId);
        }
        if ((controller = this.findOrCreateController(msgId, 1)) != null) {
            return controller.onMessage(msgId, msg, isSync);
        }
        return null;
    }

    @Override
    public boolean hasMsgHandler(int msgId) {
        return this.findOrCreateController(msgId, 1) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractController findOrCreateController(int msgId, int type) {
        AbstractController controller = null;
        for (Map.Entry<Class<? extends AbstractController>, Dual> entry : this.mClazzHashMap.entrySet()) {
            List idList = null;
            idList = type == 1 ? entry.getValue().messageList : entry.getValue().notificationList;
            Dual.IdFlag idFlag = ControllerCenter.isContainsId(idList, msgId);
            if (idFlag == null || idFlag.id != msgId) continue;
            Class<? extends AbstractController> clazz = entry.getKey();
            controller = this.mMap.get(clazz);
            if (controller != null || idFlag.flag != 0) break;
            Class<? extends AbstractController> clazz2 = clazz;
            synchronized (clazz2) {
                block11: {
                    controller = this.mMap.get(clazz);
                    if (controller == null) {
                        try {
                            long time = -1L;
                            if (RuntimeContext.sIsDebuggable) {
                                time = System.currentTimeMillis();
                            }
                            if (this.mControllerFactory != null) {
                                controller = this.mControllerFactory.createController(clazz, this.mEnv);
                            }
                            if (controller == null) {
                                Class[] parTypes = new Class[]{Environment.class};
                                Object[] pars = new Object[]{this.mEnv};
                                Constructor<? extends AbstractController> constructor = clazz.getConstructor(parTypes);
                                controller = constructor.newInstance(pars);
                            }
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.info((Object)TAG, (String)("create controller time = " + (System.currentTimeMillis() - time) + " clazz = " + clazz + " startupFinished:" + RuntimeContext.sIsAppStartFinished), (Object[])new Object[0]);
                            }
                            this.onControllerCreated(controller);
                            this.mMap.put(clazz, controller);
                        }
                        catch (Exception e) {
                            MLog.error((Object)TAG, (String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
                            if (!RuntimeContext.sIsDebuggable) break block11;
                            ThrowUtils.throwException((Throwable)e);
                        }
                    }
                }
                break;
            }
        }
        return controller;
    }

    private void onControllerCreated(AbstractController controller) {
        controller.onCreate(this.mEnv);
    }

    private static class Dual {
        private List<IdFlag> messageList;
        private List<IdFlag> notificationList;

        private Dual() {
        }

        public static class IdFlag {
            public int id;
            public int flag = 0;

            private IdFlag(int id2, int flag) {
                this.id = id2;
                this.flag = flag;
            }
        }
    }
}

