/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class ConstCache {
    private HashMap<Object, CLinkedList.CEntry<CacheObject>> container = new HashMap();
    private CLinkedList<CacheObject> lru = new CLinkedList();
    public String cacheName;
    public CacheControl cacheControl;
    public boolean autoNewObject = true;
    public Object lock = new Object();
    public long flags = 0L;
    public int maxEntries = 0;
    public int hits;
    public int gets;
    public static ConcurrentHashMap<String, ConstCache> allCaches = new ConcurrentHashMap();

    public CacheResult cacheResultForKey(Object id2, boolean autoCreate) {
        return this.cacheResultForKeyWithBackup(id2, null, autoCreate);
    }

    public Object objectForKey(Object id2) {
        return this.objectForKey(id2, this.autoNewObject);
    }

    public Object objectForKey(Object id2, boolean autoCreate) {
        return this.cacheResultForKey((Object)id2, (boolean)autoCreate).value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object id2) {
        Object object = this.lock;
        synchronized (object) {
            return this.container.containsKey(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.container.clear();
        }
    }

    public CacheResult smartRefreshCache(Object id2, Object value) {
        CacheResult result = this.cacheResultForKeyWithBackup(id2, value, true);
        if (result.value != value) {
            this.cacheControl.refreshValues(value, result.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheResult cacheResultForKeyWithBackup(Object id2, Object backup, boolean autoCreate) {
        Object object = this.lock;
        synchronized (object) {
            this.cacheControl.cacheKWB();
            ++this.gets;
            CacheResult result = new CacheResult();
            result.isNew = false;
            CLinkedList.CEntry<CacheObject> entry = this.container.get(id2);
            if (entry != null) {
                ++this.hits;
                this.cacheControl.onHit(id2, ((CacheObject)entry.data).value, entry);
            }
            if (entry == null && autoCreate) {
                entry = CLinkedList.allocEntry(new CacheObject());
                ((CacheObject)entry.data).key = id2;
                ((CacheObject)entry.data).value = backup != null ? backup : this.cacheControl.newObject(id2);
                this.container.put(id2, entry);
                CLinkedList.CEntry<CacheObject> last = CLinkedList.addLruWithMax(this.lru, entry, this.maxEntries);
                if (last != null) {
                    this.cacheControl.onEvicted(((CacheObject)last.data).key, ((CacheObject)last.data).value);
                }
                result.isNew = true;
            }
            if (entry != null) {
                result.cacheObj = (CacheObject)entry.data;
                result.value = ((CacheObject)entry.data).value;
                if (!result.isNew) {
                    CLinkedList.updateLru(this.lru, entry);
                }
            }
            return result;
        }
    }

    public static ConstCache constCacheWithNameAndControl(String name, long flags, int maxEntries, CacheControl control) {
        ConstCache cache = new ConstCache();
        cache.cacheName = name;
        cache.cacheControl = control;
        cache.flags = flags;
        cache.maxEntries = maxEntries;
        allCaches.put(name, cache);
        return cache;
    }

    public static ConstCache constCacheWithNameAndControl(String name, long flags, CacheControl control) {
        return ConstCache.constCacheWithNameAndControl(name, flags, 0, control);
    }

    public static ConstCache constCacheWithNameAndControl(String name, int maxEntries, CacheControl control) {
        return ConstCache.constCacheWithNameAndControl(name, 0L, maxEntries, control);
    }

    public static ConstCache constCacheWithNameAndControl(String name, CacheControl control) {
        return ConstCache.constCacheWithNameAndControl(name, 0, control);
    }

    private static long setFlag(long value, long flag) {
        return value | flag;
    }

    private static long clearFlag(long value, long flag) {
        return value & (flag ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static boolean isFlag(long value, long flag) {
        return (value & flag) == flag;
    }

    public static class CLinkedList<T> {
        public int size = 0;
        public CEntry<T> link = new CEntry();

        public CLinkedList() {
            this.link.data = null;
            this.link.previous = this.link;
            this.link.next = this.link;
        }

        public int size() {
            return this.size;
        }

        public static <T> CEntry<T> allocEntry(T value) {
            CEntry entry = new CEntry();
            entry.data = value;
            return entry;
        }

        public CEntry<T> addFirst(T value) {
            CEntry<T> entry = CLinkedList.allocEntry(value);
            this.addFirst(entry);
            return entry;
        }

        public void addFirst(CEntry<T> entry) {
            CLinkedList.addAfter(this.link, entry);
            ++this.size;
        }

        public CEntry<T> addLast(T value) {
            CEntry entry = new CEntry();
            entry.data = value;
            this.addLast(entry);
            return null;
        }

        public void addLast(CEntry<T> entry) {
            CLinkedList.addBefore(this.link, entry);
            ++this.size;
        }

        public void remove(CEntry<T> entry) {
            if (entry == this.link) {
                return;
            }
            entry.previous.next = entry.next;
            entry.next.previous = entry.previous;
            --this.size;
        }

        public CEntry<T> last() {
            if (this.size == 0) {
                return null;
            }
            return this.link.previous;
        }

        public CEntry<T> first() {
            if (this.size == 0) {
                return null;
            }
            return this.link.next;
        }

        public static <T> CEntry<T> addLruWithMax(CLinkedList<T> lru, CEntry<T> entry, int maxEntries) {
            lru.addFirst(entry);
            if (lru.size() > maxEntries && maxEntries > 0) {
                CEntry<T> last = lru.last();
                lru.remove(last);
                return last;
            }
            return null;
        }

        public static <T> void updateLru(CLinkedList<T> lru, CEntry<T> entry) {
            lru.remove(entry);
            lru.addFirst(entry);
        }

        private static <T> void addBefore(CEntry<T> take, CEntry<T> before) {
            before.next = take;
            before.previous = take.previous;
            take.previous.next = before;
            take.previous = before;
        }

        private static <T> void addAfter(CEntry<T> take, CEntry<T> after) {
            after.previous = take;
            after.next = take.next;
            take.next.previous = after;
            take.next = after;
        }

        public static class CEntry<ET> {
            public ET data;
            public CEntry<ET> previous;
            public CEntry<ET> next;
        }
    }

    public static abstract class CacheControl {
        public abstract Object newObject(Object var1);

        public void refreshValues(Object src, Object dst) {
        }

        public void cacheKWB() {
        }

        public void onEvicted(Object key, Object value) {
        }

        public void onHit(Object key, Object value, CLinkedList.CEntry<CacheObject> entry) {
        }
    }

    public static class CacheObject {
        public Object key;
        public Object value;
        public int flag;
    }

    public static class CacheResult {
        public Object value;
        public boolean isNew;
        public CacheObject cacheObj;

        public <T> T valueOf(Class<T> clazz) {
            return clazz.cast(this.value);
        }

        public boolean isFlag(int flag) {
            return ConstCache.isFlag(this.cacheObj.flag, flag);
        }

        public void setFlag(int flag) {
            this.cacheObj.flag = (int)ConstCache.setFlag(this.cacheObj.flag, flag);
        }

        public void clearFlag(int flag) {
            this.cacheObj.flag = (int)ConstCache.clearFlag(this.cacheObj.flag, flag);
        }
    }
}

