/*
 * Decompiled with CFR 0.152.
 */
package com.yy.framework.core;

import android.content.Context;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class AbstractController
implements UICallBacks,
INotify {
    private static final String TAG = "AbstractController";
    protected Context mContext;
    protected DeviceManager mDeviceMgr;
    protected AbstractWindowManager mWindowMgr;
    protected DialogLinkManager mDialogLinkManager;
    protected Environment mEnvironment = null;
    private ArrayList<Integer> mMessages;
    private int mHashCode = 0;
    private static RestartNotify mRestartHandler = new RestartNotify();

    protected Object onMessage(int what, Message msg, boolean isSync) {
        if (isSync) {
            return this.handleMessageSync(msg);
        }
        this.handleMessage(msg);
        return null;
    }

    protected void onNotification(int what, Message msg) {
    }

    void attachEnvironment(Environment env) {
        this.onInit(env);
    }

    protected void onCreate(Environment env) {
    }

    private void onInit(Environment env) {
        if (env != null) {
            this.mEnvironment = env;
            this.mContext = env.getContext();
            this.mDeviceMgr = env.getDeviceManager();
            this.mWindowMgr = env.getWindowManager();
            if (this.mDialogLinkManager != null) {
                this.mDialogLinkManager.dismissDialog();
            }
            this.mDialogLinkManager = new DialogLinkManager(this.mContext);
        }
        AbstractController.mRestartHandler.add(this);
    }

    public AbstractController() {
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add((String)("ControllerCreate_" + this), (Object[])new Object[0]);
        }
    }

    public AbstractController(Environment baseEnv) {
        this.onInit(baseEnv);
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add((String)("ControllerCreate_" + this), (Object[])new Object[0]);
        }
    }

    @Override
    public void handleMessage(Message msg) {
    }

    @Override
    public Object handleMessageSync(Message msg) {
        return null;
    }

    @Override
    public ArrayList<Integer> messages() {
        return this.mMessages;
    }

    public DialogLinkManager getDialogLinkManager() {
        return this.mDialogLinkManager;
    }

    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    public void setEnvironment(Environment baseEnv) {
        if (baseEnv == null) {
            return;
        }
        this.mEnvironment = baseEnv;
        this.mContext = baseEnv.getContext();
        this.mDeviceMgr = baseEnv.getDeviceManager();
        this.mWindowMgr = baseEnv.getWindowManager();
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = new DialogLinkManager(this.mContext);
    }

    @Override
    public void registerMessage(int message) {
        if (this.mMessages == null) {
            this.mMessages = new ArrayList();
        }
        this.mMessages.add(message);
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("class = " + this.getClass() + "  Abs = " + this), (Object[])new Object[0]);
        }
        MsgDispatcher.getInstance().registerICompatibilityAutoMessage(message, this);
    }

    public void unregisterFromMsgDispatcher() {
        if (this.mMessages != null) {
            for (int message : this.mMessages) {
                MsgDispatcher.getInstance().unRegisterICompatibilityAutoMessage(message, this);
            }
            this.mMessages.clear();
            this.mMessages = null;
        }
    }

    public void blockAllRequestLayoutTemporary() {
        if (null != this.mWindowMgr) {
            this.mWindowMgr.blockAllRequestLayoutTemporary();
        }
    }

    public AbstractWindow getCurrentWindow() {
        return this.mWindowMgr.getCurrentWindow();
    }

    @Override
    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        boolean retVal = false;
        if (keyCode == 4 && event.getAction() == 1) {
            if (AbstractWindow.isHaveKeyDownEvent() && !this.onWindowBackKeyEvent()) {
                this.onWindowExitEvent(true);
            }
            retVal = true;
        }
        return retVal;
    }

    protected boolean onWindowBackKeyEvent() {
        return false;
    }

    @Override
    public void onWindowExitEvent(boolean withAnimation) {
        this.mWindowMgr.popWindow(withAnimation);
    }

    @Override
    public void beforeWindowShow(AbstractWindow abstractWindow) {
    }

    @Override
    public void onWindowShown(AbstractWindow abstractWindow) {
    }

    @Override
    public void beforeWindowHide(AbstractWindow abstractWindow) {
    }

    @Override
    public void onWindowHidden(AbstractWindow abstractWindow) {
    }

    @Override
    public void onWindowAttach(AbstractWindow abstractWindow) {
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
    }

    @Override
    public View onGetViewBehind(View view) {
        if (view instanceof AbstractWindow) {
            return this.mWindowMgr.getWindowBehind((AbstractWindow)view);
        }
        return null;
    }

    @Override
    public void onDrag(int deltaX) {
    }

    @Override
    public void dealWithNewPage(float deltaX, int velocity) {
    }

    @Override
    public void notify(Notification notification) {
    }

    public boolean sendMessage(Message message) {
        MsgDispatcher.getInstance().sendMessage(message);
        return true;
    }

    public void sendMessage(Message message, long delay) {
        MsgDispatcher.getInstance().sendMessageDelayed(message, delay);
    }

    public boolean sendMessage(int what) {
        MsgDispatcher.getInstance().sendMessage(what);
        return true;
    }

    public boolean sendMessage(int what, int arg1, int arg2, Object obj) {
        MsgDispatcher.getInstance().sendMessage(what, arg1, arg2, obj);
        return true;
    }

    public boolean sendMessage(int what, int arg1, int arg2) {
        MsgDispatcher.getInstance().sendMessage(what, arg1, arg2);
        return true;
    }

    public Object sendMessageSync(int what) {
        return MsgDispatcher.getInstance().sendMessageSync(what);
    }

    public Object sendMessageSync(int what, Object obj) {
        return MsgDispatcher.getInstance().sendMessageSync(what, obj);
    }

    public Object sendMessageSync(int what, int arg1, int arg2) {
        return MsgDispatcher.getInstance().sendMessageSync(what, arg1, arg2);
    }

    public Object sendMessageSync(Message message) {
        return MsgDispatcher.getInstance().sendMessageSync(message);
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            this.mHashCode = super.hashCode();
        }
        return this.mHashCode;
    }

    public void destroy() {
        AbstractController.mRestartHandler.remove(this);
    }

    private static class RestartNotify
    implements INotify {
        private final ArrayList<WeakReference<AbstractController>> mControllers = new ArrayList();

        private RestartNotify() {
            if (!RuntimeContext.isHagoPartySdk()) {
                return;
            }
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_APP_RESTART, this);
        }

        @Override
        public void notify(Notification notification) {
            if (!RuntimeContext.isHagoPartySdk()) {
                return;
            }
            if (notification != null && notification.id == NotificationDef.N_APP_RESTART && notification.extObj instanceof Environment) {
                AbstractController controller = null;
                for (WeakReference<AbstractController> item : this.mControllers) {
                    controller = (AbstractController)item.get();
                    if (controller == null) continue;
                    controller.setEnvironment((Environment)notification.extObj);
                }
            }
        }

        private synchronized void add(AbstractController controller) {
            if (!RuntimeContext.isHagoPartySdk()) {
                return;
            }
            this.mControllers.add(new WeakReference<AbstractController>(controller));
        }

        private synchronized void remove(AbstractController controller) {
            if (!RuntimeContext.isHagoPartySdk()) {
                return;
            }
            for (WeakReference<AbstractController> item : this.mControllers) {
                if (item.get() != controller) continue;
                this.mControllers.remove(item);
                break;
            }
        }
    }
}

