/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.rclayout.helper;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import com.yy.appbase.ui.widget.rclayout.helper.RCAttrs;
import com.yy.framework.R;
import java.util.ArrayList;

public class RCHelper {
    public float[] radii = new float[8];
    public Path mClipPath;
    public Paint mPaint;
    public boolean mRoundAsCircle = false;
    public int mDefaultStrokeColor;
    public int mStrokeColor;
    public ColorStateList mStrokeColorStateList;
    public int mStrokeWidth;
    public boolean mClipBackground;
    public Region mAreaRegion;
    public RectF mLayer;
    public boolean mChecked;
    public OnCheckedChangeListener mOnCheckedChangeListener;

    public void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RCAttrs);
        this.mRoundAsCircle = ta.getBoolean(R.styleable.RCAttrs_round_as_circle, false);
        this.mStrokeColorStateList = ta.getColorStateList(R.styleable.RCAttrs_stroke_color);
        if (null != this.mStrokeColorStateList) {
            this.mStrokeColor = this.mStrokeColorStateList.getDefaultColor();
            this.mDefaultStrokeColor = this.mStrokeColorStateList.getDefaultColor();
        } else {
            this.mStrokeColor = -1;
            this.mDefaultStrokeColor = -1;
        }
        this.mStrokeWidth = ta.getDimensionPixelSize(R.styleable.RCAttrs_stroke_width, 0);
        this.mClipBackground = ta.getBoolean(R.styleable.RCAttrs_clip_background, false);
        int roundCorner = ta.getDimensionPixelSize(R.styleable.RCAttrs_round_corner, 0);
        int roundCornerTopLeft = ta.getDimensionPixelSize(R.styleable.RCAttrs_round_corner_top_left, roundCorner);
        int roundCornerTopRight = ta.getDimensionPixelSize(R.styleable.RCAttrs_round_corner_top_right, roundCorner);
        int roundCornerBottomLeft = ta.getDimensionPixelSize(R.styleable.RCAttrs_round_corner_bottom_left, roundCorner);
        int roundCornerBottomRight = ta.getDimensionPixelSize(R.styleable.RCAttrs_round_corner_bottom_right, roundCorner);
        ta.recycle();
        this.radii[0] = roundCornerTopLeft;
        this.radii[1] = roundCornerTopLeft;
        this.radii[2] = roundCornerTopRight;
        this.radii[3] = roundCornerTopRight;
        this.radii[4] = roundCornerBottomRight;
        this.radii[5] = roundCornerBottomRight;
        this.radii[6] = roundCornerBottomLeft;
        this.radii[7] = roundCornerBottomLeft;
        this.mLayer = new RectF();
        this.mClipPath = new Path();
        this.mAreaRegion = new Region();
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setAntiAlias(true);
    }

    public void onSizeChanged(View view, int w, int h) {
        this.mLayer.set(0.0f, 0.0f, (float)w, (float)h);
        this.refreshRegion(view);
    }

    public void refreshRegion(View view) {
        int w = (int)this.mLayer.width();
        int h = (int)this.mLayer.height();
        RectF areas = new RectF();
        areas.left = view.getPaddingLeft();
        areas.top = view.getPaddingTop();
        areas.right = w - view.getPaddingRight();
        areas.bottom = h - view.getPaddingBottom();
        this.mClipPath.reset();
        if (this.mRoundAsCircle) {
            float d = areas.width() >= areas.height() ? areas.height() : areas.width();
            float r = d / 2.0f;
            PointF center = new PointF((float)(w / 2), (float)(h / 2));
            if (Build.VERSION.SDK_INT <= 27) {
                this.mClipPath.addCircle(center.x, center.y, r, Path.Direction.CW);
                this.mClipPath.moveTo(0.0f, 0.0f);
                this.mClipPath.moveTo((float)w, (float)h);
            } else {
                float y = (float)(h / 2) - r;
                this.mClipPath.moveTo(areas.left, y);
                this.mClipPath.addCircle(center.x, y + r, r, Path.Direction.CW);
            }
        } else {
            this.mClipPath.addRoundRect(areas, this.radii, Path.Direction.CW);
        }
        Region clip = new Region((int)areas.left, (int)areas.top, (int)areas.right, (int)areas.bottom);
        this.mAreaRegion.setPath(this.mClipPath, clip);
    }

    public void onClipDraw(Canvas canvas) {
        if (this.mStrokeWidth > 0) {
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.mPaint.setColor(-1);
            this.mPaint.setStrokeWidth((float)(this.mStrokeWidth * 2));
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawPath(this.mClipPath, this.mPaint);
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
            this.mPaint.setColor(this.mStrokeColor);
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawPath(this.mClipPath, this.mPaint);
        }
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        if (Build.VERSION.SDK_INT <= 27) {
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            canvas.drawPath(this.mClipPath, this.mPaint);
        } else {
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            Path path = new Path();
            path.addRect(0.0f, 0.0f, (float)((int)this.mLayer.width()), (float)((int)this.mLayer.height()), Path.Direction.CW);
            path.op(this.mClipPath, Path.Op.DIFFERENCE);
            canvas.drawPath(path, this.mPaint);
        }
    }

    public void drawableStateChanged(View view) {
        if (view instanceof RCAttrs) {
            ArrayList<Integer> stateListArray = new ArrayList<Integer>();
            if (view instanceof Checkable) {
                stateListArray.add(16842911);
                if (((Checkable)view).isChecked()) {
                    stateListArray.add(0x10100A0);
                }
            }
            if (view.isEnabled()) {
                stateListArray.add(16842910);
            }
            if (view.isFocused()) {
                stateListArray.add(16842908);
            }
            if (view.isPressed()) {
                stateListArray.add(16842919);
            }
            if (view.isHovered()) {
                stateListArray.add(16843623);
            }
            if (view.isSelected()) {
                stateListArray.add(0x10100A1);
            }
            if (view.isActivated()) {
                stateListArray.add(16843518);
            }
            if (view.hasWindowFocus()) {
                stateListArray.add(16842909);
            }
            if (this.mStrokeColorStateList != null && this.mStrokeColorStateList.isStateful()) {
                int[] stateList = new int[stateListArray.size()];
                for (int i = 0; i < stateListArray.size(); ++i) {
                    stateList[i] = (Integer)stateListArray.get(i);
                }
                int stateColor = this.mStrokeColorStateList.getColorForState(stateList, this.mDefaultStrokeColor);
                ((RCAttrs)view).setStrokeColor(stateColor);
            }
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(View var1, boolean var2);
    }
}

