/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.rclayout;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Checkable;
import com.yy.appbase.ui.widget.rclayout.helper.RCAttrs;
import com.yy.appbase.ui.widget.rclayout.helper.RCHelper;
import com.yy.base.memoryrecycle.views.YYLinearLayout;

public class RCLinearLayout
extends YYLinearLayout
implements Checkable,
RCAttrs {
    RCHelper mRCHelper = new RCHelper();

    public RCLinearLayout(Context context) {
        this(context, null);
    }

    public RCLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RCLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mRCHelper.initAttrs(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRCHelper.onSizeChanged((View)this, w, h);
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.saveLayer(this.mRCHelper.mLayer, null, 31);
        super.dispatchDraw(canvas);
        this.mRCHelper.onClipDraw(canvas);
        canvas.restore();
    }

    public void draw(Canvas canvas) {
        if (this.mRCHelper.mClipBackground) {
            canvas.save();
            canvas.clipPath(this.mRCHelper.mClipPath);
            super.draw(canvas);
            canvas.restore();
        } else {
            super.draw(canvas);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 0 && !this.mRCHelper.mAreaRegion.contains((int)ev.getX(), (int)ev.getY())) {
            return false;
        }
        if (action == 0 || action == 1) {
            this.refreshDrawableState();
        } else if (action == 3) {
            this.setPressed(false);
            this.refreshDrawableState();
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void setClipBackground(boolean clipBackground) {
        this.mRCHelper.mClipBackground = clipBackground;
        this.invalidate();
    }

    @Override
    public void setRoundAsCircle(boolean roundAsCircle) {
        this.mRCHelper.mRoundAsCircle = roundAsCircle;
        this.invalidate();
    }

    @Override
    public void setRadius(int radius) {
        for (int i = 0; i < this.mRCHelper.radii.length; ++i) {
            this.mRCHelper.radii[i] = radius;
        }
        this.invalidate();
    }

    @Override
    public void setTopLeftRadius(int topLeftRadius) {
        this.mRCHelper.radii[0] = topLeftRadius;
        this.mRCHelper.radii[1] = topLeftRadius;
        this.invalidate();
    }

    @Override
    public void setTopRightRadius(int topRightRadius) {
        this.mRCHelper.radii[2] = topRightRadius;
        this.mRCHelper.radii[3] = topRightRadius;
        this.invalidate();
    }

    @Override
    public void setBottomLeftRadius(int bottomLeftRadius) {
        this.mRCHelper.radii[6] = bottomLeftRadius;
        this.mRCHelper.radii[7] = bottomLeftRadius;
        this.invalidate();
    }

    @Override
    public void setBottomRightRadius(int bottomRightRadius) {
        this.mRCHelper.radii[4] = bottomRightRadius;
        this.mRCHelper.radii[5] = bottomRightRadius;
        this.invalidate();
    }

    @Override
    public void setStrokeWidth(int strokeWidth) {
        this.mRCHelper.mStrokeWidth = strokeWidth;
        this.invalidate();
    }

    @Override
    public void setStrokeColor(int strokeColor) {
        this.mRCHelper.mStrokeColor = strokeColor;
        this.invalidate();
    }

    public void invalidate() {
        if (null != this.mRCHelper) {
            this.mRCHelper.refreshRegion((View)this);
        }
        super.invalidate();
    }

    @Override
    public boolean isClipBackground() {
        return this.mRCHelper.mClipBackground;
    }

    @Override
    public boolean isRoundAsCircle() {
        return this.mRCHelper.mRoundAsCircle;
    }

    @Override
    public float getTopLeftRadius() {
        return this.mRCHelper.radii[0];
    }

    @Override
    public float getTopRightRadius() {
        return this.mRCHelper.radii[2];
    }

    @Override
    public float getBottomLeftRadius() {
        return this.mRCHelper.radii[4];
    }

    @Override
    public float getBottomRightRadius() {
        return this.mRCHelper.radii[6];
    }

    @Override
    public int getStrokeWidth() {
        return this.mRCHelper.mStrokeWidth;
    }

    @Override
    public int getStrokeColor() {
        return this.mRCHelper.mStrokeColor;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.mRCHelper.drawableStateChanged((View)this);
    }

    public void setChecked(boolean checked) {
        if (this.mRCHelper.mChecked != checked) {
            this.mRCHelper.mChecked = checked;
            this.refreshDrawableState();
            if (this.mRCHelper.mOnCheckedChangeListener != null) {
                this.mRCHelper.mOnCheckedChangeListener.onCheckedChanged((View)this, this.mRCHelper.mChecked);
            }
        }
    }

    public boolean isChecked() {
        return this.mRCHelper.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.mRCHelper.mChecked);
    }

    public void setOnCheckedChangeListener(RCHelper.OnCheckedChangeListener listener) {
        this.mRCHelper.mOnCheckedChangeListener = listener;
    }
}

