/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hago.xlog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.yy.base.env.MyApplication;
import com.yy.base.logger.LogHandlerThread;
import com.yy.base.logger.MLog;
import com.yy.base.logger.memorycachelog.MemoryCacheLogManager;
import com.yy.base.taskexecutor.util.PriorityHelper;
import com.yy.base.utils.SystemUtils;
import com.yy.hago.xlog.BaseLog;
import com.yy.hago.xlog.IFlushCallback;
import com.yy.hago.xlog.IKLog;
import com.yy.hago.xlog.KLogImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tv.athena.core.axis.Axis;
import tv.athena.klog.api.IKLogFlush;
import tv.athena.klog.api.ILogConfig;
import tv.athena.klog.api.ILogService;
import tv.athena.klog.api.LogLevel;
import tv.athena.util.RuntimeInfo;

@SuppressLint(value={"LogUsage"})
public class KLogUtils {
    private static final String TAG = "KLogUtils";
    private static IKLog K_LOG = new BaseLog();
    private static final int CRASH_LOG_COUNT = SystemUtils.isShowEnvSetting() ? 6 : 2;
    private static final long DEBUG_CACHE_SIZE = 0x6400000L;
    private static final long INFO_CACHE_SIZE = 0x3200000L;
    private static final int SINGLE_LOG_SIZE = 0x100000;
    private static String mProcessName;
    private static ILogConfig mLogConfig;
    private static volatile boolean isInitialized;
    private static volatile boolean isIniting;
    private static int mCurLogLevel;
    private static int sNotMainThread;

    public static void init(Context context, String packageName, String processName, boolean isDebug, String logPath) {
        if (isInitialized) {
            Log.i((String)TAG, (String)"KLog isInitialized ");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)packageName) || TextUtils.isEmpty((CharSequence)processName)) {
            sNotMainThread = 1;
            Log.i((String)TAG, (String)"packageName or processName is empty");
            return;
        }
        if (!packageName.equals(processName)) {
            sNotMainThread = 1;
            Log.i((String)TAG, (String)"is not mainProcess");
            return;
        }
        if (isIniting) {
            return;
        }
        isIniting = true;
        sNotMainThread = 0;
        mProcessName = processName;
        Log.i((String)TAG, (String)("mProcessName: " + processName + " packageName: " + packageName + " isDebug: " + String.valueOf(isDebug) + " logPath: " + logPath));
        RuntimeInfo.INSTANCE.appContext(context).processName(mProcessName).packageName(packageName).isMainProcess(packageName.equals(processName)).isDebuggable(isDebug);
        if (Axis.Companion.getService(ILogService.class) != null && ((ILogService)Axis.Companion.getService(ILogService.class)).config() != null) {
            mLogConfig = ((ILogService)Axis.Companion.getService(ILogService.class)).config();
            mCurLogLevel = KLogUtils.getInitLevel(isDebug);
            long mCacheMaxSize = isDebug ? 0x6400000L : 0x3200000L;
            mLogConfig.setPriority(PriorityHelper.getAdjustPriority(-2)).singleLogMaxSize(0x100000);
            mLogConfig.processTag(mProcessName).logLevel(mCurLogLevel).logCacheMaxSiz(mCacheMaxSize).logPath(logPath).isCrypt(false).apply();
            K_LOG = new KLogImpl();
            Log.i((String)TAG, (String)"create KLogImpl");
        }
        isIniting = false;
        isInitialized = true;
    }

    public static void resetLogCacheMaxSize(long maxSize) {
        if (mLogConfig != null) {
            mLogConfig.logCacheMaxSiz(maxSize);
        }
    }

    public static void updateLogLevel(int level) {
        if (!KLogUtils.isInitialized()) {
            return;
        }
        if (mLogConfig == null || level < LogLevel.INSTANCE.getLEVEL_VERBOSE()) {
            return;
        }
        if (level == mCurLogLevel) {
            return;
        }
        mCurLogLevel = level;
        mLogConfig.logLevel(mCurLogLevel).apply();
    }

    public static int getLogCurLevel() {
        return mCurLogLevel;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    private static int getInitLevel(boolean isDebug) {
        if (!isDebug) {
            return LogLevel.INSTANCE.getLEVEL_INFO();
        }
        return LogLevel.INSTANCE.getLEVEL_VERBOSE();
    }

    public static List<String> getNewFileToCrash() {
        if (KLogUtils.isInitialized() && K_LOG instanceof KLogImpl && Axis.Companion.getService(ILogService.class) != null) {
            File[] logList = ((ILogService)Axis.Companion.getService(ILogService.class)).fileLogList(mProcessName);
            ArrayList<String> mCrashList = new ArrayList<String>();
            if (logList != null && logList.length > 0) {
                for (int i = 0; i < logList.length; ++i) {
                    mCrashList.add(logList[i].getPath());
                    if (mCrashList.size() >= CRASH_LOG_COUNT) break;
                }
            }
            return mCrashList;
        }
        return null;
    }

    public static File[] getLogFileList() {
        if (KLogUtils.isInitialized() && K_LOG instanceof KLogImpl && Axis.Companion.getService(ILogService.class) != null) {
            File[] logList = ((ILogService)Axis.Companion.getService(ILogService.class)).fileLogList(mProcessName);
            return logList;
        }
        return null;
    }

    public static void flush() {
        if (!KLogUtils.isInitialized()) {
            return;
        }
        try {
            if (Axis.Companion.getService(ILogService.class) != null) {
                K_LOG.logI(TAG, "start flush", new Object[0]);
                ((ILogService)Axis.Companion.getService(ILogService.class)).flush();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean flush(@NonNull IFlushCallback callback) {
        return KLogUtils.flush(callback, false);
    }

    public static boolean flush(final @NonNull IFlushCallback callback, boolean isCrash) {
        if (!KLogUtils.isInitialized()) {
            callback.onFlush(false);
            return false;
        }
        MemoryCacheLogManager.flush(isCrash);
        try {
            if (Axis.Companion.getService(ILogService.class) != null) {
                final long time = System.currentTimeMillis();
                LogHandlerThread.getInstance().flush(new IFlushCallback(){

                    @Override
                    public void onFlush(boolean finish) {
                        K_LOG.logI(KLogUtils.TAG, "LogHandlerThread flush end!!, start flush", new Object[0]);
                        ((ILogService)Axis.Companion.getService(ILogService.class)).flush(new IKLogFlush(){

                            public void callback(boolean b) {
                                MLog.info(KLogUtils.TAG, "KLogUtils.flush cost time: %s", System.currentTimeMillis() - time);
                                callback.onFlush(b);
                            }
                        });
                    }
                });
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        callback.onFlush(false);
        return false;
    }

    public static void verbose(String tag, String format, Object ... args) {
        if (sNotMainThread == 1) {
            return;
        }
        if (!isInitialized) {
            MyApplication.initLogging();
        }
        K_LOG.logV(tag, format, args);
    }

    public static void debug(String tag, String format, Object ... args) {
        if (sNotMainThread == 1) {
            return;
        }
        if (!isInitialized) {
            MyApplication.initLogging();
        }
        K_LOG.logD(tag, format, args);
    }

    public static void info(String tag, String format, Object ... args) {
        if (sNotMainThread == 1) {
            return;
        }
        if (!isInitialized) {
            MyApplication.initLogging();
        }
        K_LOG.logI(tag, format, args);
    }

    public static void warn(String tag, String format, Object ... args) {
        if (sNotMainThread == 1) {
            return;
        }
        if (!isInitialized) {
            MyApplication.initLogging();
        }
        K_LOG.logW(tag, format, args);
    }

    public static void error(String tag, String format, Object ... args) {
        if (sNotMainThread == 1) {
            return;
        }
        if (!isInitialized) {
            MyApplication.initLogging();
        }
        K_LOG.logE(tag, format, args);
    }

    public static void error(String tag, String format, Throwable t, Object ... args) {
        if (sNotMainThread == 1) {
            return;
        }
        if (!isInitialized) {
            MyApplication.initLogging();
        }
        K_LOG.logE(tag, format, t, args);
    }

    static {
        isInitialized = false;
        isIniting = false;
        mCurLogLevel = LogLevel.INSTANCE.getLEVEL_INFO();
        sNotMainThread = 1;
    }
}

