/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils.usagestat;

import android.annotation.SuppressLint;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.os.Build;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.usagestat.UsageStatsBean;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/yy/base/utils/usagestat/UsageStatHelper;", "", "()V", "TAG", "", "intervalTime", "", "checkAppUsagePermission", "", "getCurrentTopApplicationPkg", "getUsageStat", "pkgFilter", "", "requestAppUsagePermission", "", "framework-base_debug"})
public final class UsageStatHelper {
    private static final String TAG = "UsageStatHelper";
    private static final long intervalTime = 62208000000L;
    public static final UsageStatHelper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NewApi"})
    @Nullable
    public final String getUsageStat(@NotNull List<String> pkgFilter) {
        Intrinsics.checkParameterIsNotNull(pkgFilter, (String)"pkgFilter");
        if (this.checkAppUsagePermission()) {
            try {
                Object object = RuntimeContext.sApplicationContext.getSystemService("usagestats");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.usage.UsageStatsManager");
                }
                UsageStatsManager usageStatsManager = (UsageStatsManager)object;
                if (usageStatsManager != null) {
                    void $this$filterTo$iv$iv;
                    UsageStatsManager usageStatsManager2 = usageStatsManager;
                    boolean bl = false;
                    boolean bl2 = false;
                    UsageStatsManager $this$apply = usageStatsManager2;
                    boolean bl3 = false;
                    long endTime = System.currentTimeMillis();
                    List usageStats = $this$apply.queryUsageStats(3, endTime - intervalTime, endTime);
                    Ref.ObjectRef bean = new Ref.ObjectRef();
                    boolean bl4 = false;
                    List list = new ArrayList();
                    List list2 = usageStats;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"usageStats");
                    Iterable $this$filter$iv = list2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        UsageStats it = (UsageStats)element$iv$iv;
                        boolean bl5 = false;
                        UsageStats usageStats2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)usageStats2, (String)"it");
                        if (!pkgFilter.contains(usageStats2.getPackageName())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        UsageStats it = (UsageStats)element$iv;
                        boolean bl6 = false;
                        bean.element = new UsageStatsBean();
                        UsageStatsBean usageStatsBean = (UsageStatsBean)bean.element;
                        UsageStats usageStats3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)usageStats3, (String)"it");
                        usageStatsBean.setPackageName(usageStats3.getPackageName());
                        ((UsageStatsBean)bean.element).setFirstTimeStamp(it.getFirstTimeStamp());
                        ((UsageStatsBean)bean.element).setLastTimeUsed(it.getLastTimeUsed());
                        ((UsageStatsBean)bean.element).setTotalTime(it.getTotalTimeInForeground());
                        list.add((UsageStatsBean)bean.element);
                    }
                    return JsonParser.toJson(list);
                }
            }
            catch (Exception e) {
                MLog.info(TAG, "getUsageStat error " + e.getMessage(), new Object[0]);
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public final String getCurrentTopApplicationPkg() {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        Object object = RuntimeContext.sApplicationContext.getSystemService("usagestats");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.usage.UsageStatsManager");
        }
        UsageStatsManager usageStatsManager = (UsageStatsManager)object;
        if (usageStatsManager != null) {
            Calendar calendar;
            UsageStatsManager usageStatsManager2 = usageStatsManager;
            boolean bl = false;
            boolean bl2 = false;
            UsageStatsManager $this$apply = usageStatsManager2;
            boolean bl3 = false;
            Calendar calendar2 = calendar = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
            long end = calendar2.getTimeInMillis();
            calendar.add(2, -1);
            long start = calendar.getTimeInMillis();
            List usageStats = $this$apply.queryUsageStats(4, start, end);
            if (usageStats == null || usageStats.isEmpty()) {
                return null;
            }
            UsageStats lastStats = null;
            Iterator iterator = usageStats.iterator();
            while (iterator.hasNext()) {
                UsageStats stats;
                UsageStats usageStats2 = stats = (UsageStats)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)usageStats2, (String)"stats");
                if (usageStats2.getPackageName() == null) continue;
                long lastTime = stats.getLastTimeUsed();
                if (lastStats != null && lastStats.getLastTimeUsed() >= lastTime) continue;
                lastStats = stats;
            }
            UsageStats usageStats3 = lastStats;
            return usageStats3 != null ? usageStats3.getPackageName() : null;
        }
        return null;
    }

    public final boolean checkAppUsagePermission() {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Object object = RuntimeContext.sApplicationContext.getSystemService("usagestats");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.usage.UsageStatsManager");
                }
                UsageStatsManager usageStatsManager = (UsageStatsManager)object;
                long currentTime = System.currentTimeMillis();
                Object object2 = usageStatsManager;
                if (object2 == null || (object2 = object2.queryUsageStats(0, currentTime - (long)60000, currentTime)) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object stats = object2;
                return stats.size() != 0;
            }
            catch (Exception e) {
                MLog.info(TAG, "checkAppUsePermission fail!", new Object[0]);
            }
        }
        return false;
    }

    public final void requestAppUsagePermission() {
        Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
        intent.addFlags(0x10000000);
        try {
            RuntimeContext.sApplicationContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            MLog.info(TAG, "Start usage access settings activity fail!", new Object[0]);
        }
    }

    private UsageStatHelper() {
    }

    static {
        UsageStatHelper usageStatHelper;
        INSTANCE = usageStatHelper = new UsageStatHelper();
        TAG = TAG;
        intervalTime = 62208000000L;
    }
}

