/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils.filestorage;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import androidx.annotation.RequiresApi;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.IOUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.MimeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJS\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000eJ*\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001d\u001a\u00020\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J \u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/yy/base/utils/filestorage/FileOperatorQ;", "", "()V", "MODE_READ_ONLY", "", "MODE_READ_WRITE_DATA", "MODE_READ_WRITE_FILE", "MODE_WRITE_ONLY_APPEND", "MODE_WRITE_ONLY_ERASING", "checkUriFileExit", "", "uri", "Landroid/net/Uri;", "createContentValues", "Landroid/content/ContentValues;", "displayName", "description", "mimeType", "title", "relativePath", "isPending", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Landroid/content/ContentValues;", "insertBitmap", "bitmap", "Landroid/graphics/Bitmap;", "values", "openFileDescriptor", "Landroid/os/ParcelFileDescriptor;", "mode", "cancellationSignal", "Landroid/os/CancellationSignal;", "saveMediaFile", "filePath", "isVideo", "fileName", "FileOpenMode", "framework-base_debug"})
public final class FileOperatorQ {
    @NotNull
    public static final String MODE_READ_ONLY = "r";
    @NotNull
    public static final String MODE_WRITE_ONLY_ERASING = "w";
    @NotNull
    public static final String MODE_WRITE_ONLY_APPEND = "wa";
    @NotNull
    public static final String MODE_READ_WRITE_DATA = "rw";
    @NotNull
    public static final String MODE_READ_WRITE_FILE = "rwt";
    public static final FileOperatorQ INSTANCE;

    @NotNull
    public final ContentValues createContentValues(@Nullable String displayName, @Nullable String description, @Nullable String mimeType, @Nullable String title, @Nullable String relativePath, @Nullable Integer isPending) {
        ContentValues contentValues = new ContentValues();
        boolean bl = false;
        boolean bl2 = false;
        ContentValues $this$apply = contentValues;
        boolean bl3 = false;
        $this$apply.put("_display_name", displayName);
        $this$apply.put("description", description);
        $this$apply.put("mime_type", mimeType);
        $this$apply.put("title", title);
        if (Build.VERSION.SDK_INT >= 29) {
            $this$apply.put("relative_path", relativePath);
            $this$apply.put("is_pending", isPending);
        }
        return contentValues;
    }

    public static /* synthetic */ ContentValues createContentValues$default(FileOperatorQ fileOperatorQ, String string2, String string3, String string4, String string5, String string6, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = null;
        }
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        if ((n2 & 4) != 0) {
            string4 = null;
        }
        if ((n2 & 8) != 0) {
            string5 = null;
        }
        if ((n2 & 0x10) != 0) {
            string6 = null;
        }
        if ((n2 & 0x20) != 0) {
            n = 1;
        }
        return fileOperatorQ.createContentValues(string2, string3, string4, string5, string6, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveMediaFile(@Nullable String filePath, boolean isVideo, @NotNull String fileName) {
        block27: {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            try {
                Uri fileUri;
                String string2 = filePath;
                if (string2 == null) break block27;
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                Context context = RuntimeContext.sApplicationContext;
                ContentValues contentValues = new ContentValues();
                boolean bl4 = false;
                boolean bl5 = false;
                ContentValues $this$apply = contentValues;
                boolean bl6 = false;
                String folderName = isVideo ? Environment.DIRECTORY_MOVIES : Environment.DIRECTORY_PICTURES;
                $this$apply.put("_display_name", fileName);
                $this$apply.put("mime_type", MimeUtils.guessMimeTypeFromExtension(YYFileUtils.getExtension(fileName)));
                $this$apply.put("relative_path", folderName + File.separator + context.getString(R.string.hago_app_name) + File.separator);
                $this$apply.put("is_pending", Integer.valueOf(1));
                ContentValues values = contentValues;
                Uri collection = isVideo ? MediaStore.Video.Media.getContentUri((String)"external_primary") : MediaStore.Images.Media.getContentUri((String)"external_primary");
                Context context2 = context;
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
                Uri uri = fileUri = context2.getContentResolver().insert(collection, values);
                if (uri != null) {
                    Uri uri2 = uri;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Uri it2 = uri2;
                    boolean bl9 = false;
                    if (isVideo) {
                        Closeable closeable = (Closeable)context.getContentResolver().openFileDescriptor(fileUri, MODE_WRITE_ONLY_ERASING);
                        boolean bl10 = false;
                        Throwable throwable = null;
                        try {
                            Unit unit;
                            ParcelFileDescriptor descriptor = (ParcelFileDescriptor)closeable;
                            boolean bl11 = false;
                            ParcelFileDescriptor parcelFileDescriptor = descriptor;
                            if (parcelFileDescriptor != null) {
                                ParcelFileDescriptor parcelFileDescriptor2 = parcelFileDescriptor;
                                boolean bl12 = false;
                                boolean bl13 = false;
                                ParcelFileDescriptor it3 = parcelFileDescriptor2;
                                boolean bl14 = false;
                                Closeable closeable2 = new FileOutputStream(descriptor.getFileDescriptor());
                                boolean bl15 = false;
                                Throwable throwable2 = null;
                                try {
                                    FileOutputStream out = (FileOutputStream)closeable2;
                                    boolean bl16 = false;
                                    File videoFile = new File(filePath);
                                    Closeable closeable3 = new FileInputStream(videoFile);
                                    boolean bl17 = false;
                                    Throwable throwable3 = null;
                                    try {
                                        int sz;
                                        FileInputStream inputStream = (FileInputStream)closeable3;
                                        boolean bl18 = false;
                                        byte[] buf = new byte[8192];
                                        while ((sz = inputStream.read(buf)) > 0) {
                                            out.write(buf, 0, sz);
                                        }
                                        Unit unit2 = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                                    }
                                    Unit unit3 = Unit.INSTANCE;
                                }
                                catch (Throwable throwable5) {
                                    throwable2 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                }
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            descriptor = unit;
                        }
                        catch (Throwable descriptor) {
                            throwable = descriptor;
                            throw descriptor;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    Closeable closeable = context.getContentResolver().openOutputStream(fileUri);
                    boolean bl19 = false;
                    Throwable throwable = null;
                    try {
                        OutputStream out = (OutputStream)closeable;
                        boolean bl20 = false;
                        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
                        Bitmap bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)bmOptions);
                        bmp.compress(Bitmap.CompressFormat.JPEG, 90, out);
                        bmp.recycle();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    values.clear();
                    values.put(isVideo ? "is_pending" : "is_pending", Integer.valueOf(0));
                    context.getContentResolver().update(fileUri, values, null, null);
                    return true;
                }
            }
            catch (Exception e) {
                MLog.error((Object)"FileOperatorQ", "Failed to save media file " + e.getMessage(), new Object[0]);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Uri insertBitmap(@Nullable Bitmap bitmap, @NotNull ContentValues values) {
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        Uri externalUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        Context context = RuntimeContext.sApplicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
        ContentResolver resolver = context.getContentResolver();
        Uri insertUri = resolver.insert(externalUri, values);
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("is_pending", Integer.valueOf(1));
        }
        OutputStream os = null;
        try {
            block10: {
                if (insertUri == null) break block10;
                if (bitmap == null) break;
                os = resolver.openOutputStream(insertUri);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, os);
                OutputStream outputStream = os;
                if (outputStream != null) {
                    outputStream.flush();
                }
                MLog.debug("FileOperatorQ", "\u521b\u5efaBitmap\u6210\u529f insertBitmap " + insertUri, new Object[0]);
                values.clear();
                if (Build.VERSION.SDK_INT >= 29) {
                    values.put("is_pending", Integer.valueOf(0));
                    resolver.update(insertUri, values, null, null);
                }
                break;
            }
        }
        catch (Exception e) {
            MLog.debug("FileOperatorQ", "\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage(), new Object[0]);
        }
        finally {
            Bitmap bitmap2 = bitmap;
            if (bitmap2 != null) {
                if (!bitmap2.isRecycled()) {
                    bitmap.recycle();
                }
            }
            IOUtils.safeClose(os);
            return insertUri;
        }
    }

    @RequiresApi(value=19)
    @Nullable
    public final ParcelFileDescriptor openFileDescriptor(@Nullable Uri uri, @NotNull String mode, @Nullable CancellationSignal cancellationSignal) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        if (!this.checkUriFileExit(uri)) {
            return null;
        }
        Context context = RuntimeContext.sApplicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
        Uri uri2 = uri;
        if (uri2 == null) {
            return null;
        }
        return context.getContentResolver().openFileDescriptor(uri2, mode, cancellationSignal);
    }

    public static /* synthetic */ ParcelFileDescriptor openFileDescriptor$default(FileOperatorQ fileOperatorQ, Uri uri, String string2, CancellationSignal cancellationSignal, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = MODE_READ_ONLY;
        }
        if ((n & 4) != 0) {
            cancellationSignal = null;
        }
        return fileOperatorQ.openFileDescriptor(uri, string2, cancellationSignal);
    }

    public final boolean checkUriFileExit(@Nullable Uri uri) {
        Context context = RuntimeContext.sApplicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
        Uri uri2 = uri;
        if (uri2 == null) {
            return false;
        }
        Cursor cursor = context.getContentResolver().query(uri2, null, null, null, null);
        if (cursor == null || !cursor.moveToFirst()) {
            MLog.error((Object)"FileOperatorQ", "\u68c0\u67e5\u5931\u8d25 -> 1.\u6ca1\u6709\u627e\u5230 Uri \u5bf9\u5e94\u7684\u6587\u4ef6 ; 2.\u76ee\u5f55\u4e3a\u7a7a ", new Object[0]);
            return false;
        }
        cursor.close();
        return true;
    }

    private FileOperatorQ() {
    }

    static {
        FileOperatorQ fileOperatorQ;
        INSTANCE = fileOperatorQ = new FileOperatorQ();
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/yy/base/utils/filestorage/FileOperatorQ$FileOpenMode;", "", "framework-base_debug"})
    public static @interface FileOpenMode {
    }
}

