/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.StringUtils;

public class ToastUtils {
    private static volatile ICustomToast sCustomToast;

    public static void showToast(Context context, String message, int length) {
        ToastUtils.showToast(context, message, length, -1);
    }

    public static void showToast(Context context, CharSequence message) {
        ToastUtils.showToast(context, message, 0, -1);
    }

    public static void showToast(Context context, CharSequence message, int length) {
        ToastUtils.showToast(context, message, length, -1);
    }

    public static void showToast(Context context, @StringRes int stringId) {
        ToastUtils.showToast(context, ResourceUtils.getString(stringId), 0, -1);
    }

    public static void showToast(Context context, @StringRes int stringId, int length) {
        ToastUtils.showToast(context, ResourceUtils.getString(stringId), length, -1);
    }

    @SuppressLint(value={"ToastUsage"})
    public static void showToast(final Context context, final CharSequence message, final int length, final int gravity) {
        if (context == null || FP.empty(message)) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && !RuntimeContext.isShowToast()) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                MLog.info("ToastUtils", "%s", message);
                if (ToastUtils.needToHack()) {
                    sCustomToast.showToast(message, length);
                } else if (ToastUtils.isCustomStyle() && !SdkVersionUtils.hasR()) {
                    Toast toast = new Toast(context);
                    ToastView toastView = ToastUtils.getToastView(context);
                    toastView.setText(message);
                    if (gravity > 0) {
                        toast.setGravity(gravity, 0, 0);
                    }
                    toast.setView((View)toastView);
                    toast.setMargin(0.0f, 0.05f);
                    toast.setDuration(length);
                    toast.show();
                } else {
                    Toast toast = Toast.makeText((Context)context, (CharSequence)message, (int)length);
                    if (gravity > 0) {
                        toast.setGravity(gravity, 0, 0);
                    }
                    toast.show();
                }
            }
        };
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(command);
        } else {
            command.run();
        }
    }

    @SuppressLint(value={"ToastUsage"})
    public static void showToast(final Activity context, final @StringRes int message, final int length) {
        if (context == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                MLog.info("ToastUtils", "%s", message);
                if (ToastUtils.needToHack()) {
                    sCustomToast.showToast(ResourceUtils.getString(message), length);
                } else if (ToastUtils.isCustomStyle() && !SdkVersionUtils.hasR()) {
                    Toast toast = new Toast((Context)context);
                    ToastView toastView = ToastUtils.getToastView((Context)context);
                    toastView.setText(message);
                    toast.setView((View)toastView);
                    toast.setMargin(0.0f, 0.05f);
                    toast.setDuration(length);
                    toast.show();
                } else {
                    Toast.makeText((Context)context, (int)message, (int)length).show();
                }
            }
        };
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(command);
        } else {
            command.run();
        }
    }

    public static boolean needToHack() {
        boolean result = Build.VERSION.SDK_INT == 25 || StringUtils.equal(Build.BRAND, "Meizu");
        return result && sCustomToast != null && sCustomToast.canHack();
    }

    private static ToastView getToastView(Context context) {
        return new ToastView(context);
    }

    private static boolean isCustomStyle() {
        return sCustomToast != null && sCustomToast.isCustomStyle();
    }

    public static void setCustomToast(ICustomToast customToast) {
        sCustomToast = customToast;
    }

    private static class ToastView
    extends YYFrameLayout {
        private TextView mToastText;

        public ToastView(@NonNull Context context) {
            this(context, null);
        }

        public ToastView(@NonNull Context context, @Nullable AttributeSet attrs) {
            super(context, attrs);
            View view = ToastView.inflate((Context)context, (int)R.layout.layout_custom_toast, null);
            this.addView(view);
            this.mToastText = (TextView)this.findViewById(R.id.toastText);
        }

        public void setText(CharSequence text) {
            this.mToastText.setText(text);
        }

        public void setText(@StringRes int text) {
            this.mToastText.setText(text);
        }
    }

    public static interface ICustomToast {
        public void showToast(CharSequence var1, int var2);

        public boolean isCustomStyle();

        public boolean canHack();
    }
}

